/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.formatter;

import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import com.github.wasiqb.coteafs.services.error.XmlFormatTransformerError;
import com.github.wasiqb.coteafs.services.formatter.PayloadLogger;
import com.github.wasiqb.coteafs.services.formatter.PayloadType;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

class XmlPayloadLogger
implements PayloadLogger {
    XmlPayloadLogger() {
    }

    @Override
    public String[] getPayload(PayloadType type, String body) {
        StreamSource input = new StreamSource(new StringReader(body));
        StringWriter writer = new StringWriter();
        StreamResult output = new StreamResult(writer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 4);
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(input, output);
            return output.getWriter().toString().split("\r\n");
        }
        catch (TransformerException e) {
            ErrorUtil.fail(XmlFormatTransformerError.class, (String)"Error while Xml Transformation.", (Throwable)e);
            return new String[0];
        }
    }
}

