/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.helper;

import com.github.wasiqb.coteafs.services.config.LoggingSetting;
import com.github.wasiqb.coteafs.services.config.MediaType;
import com.github.wasiqb.coteafs.services.config.ServiceSetting;
import com.github.wasiqb.coteafs.services.config.ServiceType;
import com.github.wasiqb.coteafs.services.error.ClientSideError;
import com.github.wasiqb.coteafs.services.error.RequestExecutionError;
import com.github.wasiqb.coteafs.services.error.RequestExecutionFailedError;
import com.github.wasiqb.coteafs.services.error.ServerSideError;
import com.github.wasiqb.coteafs.services.error.ServiceNotFoundError;
import com.github.wasiqb.coteafs.services.formatter.PayloadLoggerFactory;
import com.github.wasiqb.coteafs.services.formatter.PayloadType;
import com.github.wasiqb.coteafs.services.helper.ResponseHandler;
import com.github.wasiqb.coteafs.services.parser.RequestFactory;
import com.github.wasiqb.coteafs.services.parser.RequestParser;
import com.github.wasiqb.coteafs.services.requests.RequestElement;
import com.github.wasiqb.coteafs.services.utils.ErrorUtils;
import com.google.common.truth.Truth;
import io.restassured.RestAssured;
import io.restassured.http.Method;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RequestHandler {
    private static final String LINE;
    private static final Logger LOG;
    private String name;
    private RequestSpecification request;
    private String resource;
    private ResponseHandler response;
    private ServiceSetting setting;

    public static RequestHandler build() {
        LOG.info(LINE);
        LOG.info("Preparing to execute request:");
        LOG.info(LINE);
        return new RequestHandler();
    }

    private static void logMap(String mapName, Map<String, Object> map) {
        if (!map.isEmpty()) {
            LOG.info(LINE);
            LOG.info(String.format("Following %s is used", mapName));
            LOG.info(LINE);
            for (Map.Entry<String, Object> key : map.entrySet()) {
                LOG.info(String.format("%s: %s", key.getKey(), key.getValue()));
            }
        }
    }

    private static void logStatusDetails(Response res) {
        LOG.info(LINE);
        LOG.info("Response Status:");
        LOG.info(LINE);
        LOG.info(String.format("Status Code: [%d]...", res.statusCode()));
        LOG.info(String.format("Status Message: [%s]...", res.statusLine()));
    }

    private static void validateResponse(Response res) {
        int status = res.statusCode();
        if (status == 404) {
            ErrorUtils.fail(ServiceNotFoundError.class, "Service Not found.");
        } else if (status >= 400 && status < 500) {
            ErrorUtils.fail(ClientSideError.class, "Client side error.");
        } else if (status >= 500) {
            ErrorUtils.fail(ServerSideError.class, "Server side error,");
        }
    }

    public RequestHandler execute(Method method, boolean shouldWork) {
        LOG.info(String.format("Executing request on [%s] with method [%s]...", this.url(), method));
        try {
            this.setSoapHeaders();
            Response res = (Response)this.request.request(method);
            RequestHandler.logStatusDetails(res);
            RequestHandler.validateResponse(res);
            this.response = new ResponseHandler(this.name, res, this.setting);
            if (shouldWork) {
                Truth.assertThat((Integer)res.statusCode()).isGreaterThan((Comparable)Integer.valueOf(199));
                Truth.assertThat((Integer)res.statusCode()).isLessThan((Comparable)Integer.valueOf(300));
            }
        }
        catch (RequestExecutionFailedError e) {
            ErrorUtils.fail(RequestExecutionError.class, "Execution failed", (Throwable)((Object)e));
        }
        catch (Exception e) {
            ErrorUtils.fail(ServiceNotFoundError.class, "Service not found.", e);
        }
        return this;
    }

    public RequestHandler formParams(Map<String, Object> parameters) {
        if (parameters != null && parameters.size() > 0) {
            RequestHandler.logMap("Form Params", parameters);
            this.request = this.request.formParams(parameters);
        }
        return this;
    }

    public RequestHandler headers(Map<String, Object> headers) {
        if (headers != null && headers.size() > 0) {
            RequestHandler.logMap("Request Headers", headers);
            this.request = this.request.headers(headers);
        }
        return this;
    }

    public RequestHandler multiPart(List<String> files) {
        LOG.info(LINE);
        LOG.info("Following files is used");
        LOG.info(LINE);
        for (String file : files) {
            LOG.info(String.format("File: %s", file));
            this.request = this.request.multiPart(new File(file));
        }
        return this;
    }

    public RequestHandler params(Map<String, Object> parameters) {
        if (parameters != null && parameters.size() > 0) {
            RequestHandler.logMap("Params", parameters);
            this.request = this.request.params(parameters);
        }
        return this;
    }

    public RequestHandler pathParams(Map<String, Object> parameters) {
        if (parameters != null && parameters.size() > 0) {
            RequestHandler.logMap("Path Params", parameters);
            this.request = this.request.pathParams(parameters);
        }
        return this;
    }

    public RequestHandler queryParams(Map<String, Object> parameters) {
        if (parameters != null && parameters.size() > 0) {
            RequestHandler.logMap("Query Params", parameters);
            this.request = this.request.queryParams(parameters);
        }
        return this;
    }

    public RequestHandler resource(String path) {
        this.resource = path;
        if (!StringUtils.isEmpty((CharSequence)this.resource)) {
            this.request = this.request.basePath(this.resource);
        }
        return this;
    }

    public ResponseHandler response() {
        return this.response;
    }

    public RequestHandler setting(ServiceSetting setting) {
        this.setting = setting;
        return this;
    }

    public String url() {
        int port = this.setting.getPort();
        StringBuilder path = new StringBuilder(this.setting.getEndPoint());
        if (port > 0) {
            path.append(":").append(port);
        }
        path.append(this.setting.getEndPointSuffix()).append(this.resource);
        return path.toString();
    }

    public RequestHandler using() {
        String endPoint = this.setting.getEndPoint();
        String suffix = this.setting.getEndPointSuffix();
        MediaType type = this.setting.getContentType();
        this.request = RestAssured.given().baseUri(endPoint + suffix);
        if (type != null) {
            LOG.info(String.format("End-point content-type: %s", new Object[]{type}));
            this.request = this.request.contentType(type.toString());
        }
        return this;
    }

    public RequestHandler with(RequestElement requestElement) {
        if (requestElement != null) {
            this.name = requestElement.name();
            RequestParser builder = RequestFactory.getParser(this.setting).build(requestElement);
            String body = builder.body();
            return this.with(body, this.setting.getLogging());
        }
        return this;
    }

    private void setSoapHeaders() {
        if (this.setting.getType() == ServiceType.SOAP) {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Keep-Alive", "timeout=10, max=127");
            this.headers(headers);
        }
    }

    private RequestHandler with(String requestBody, LoggingSetting logging) {
        if (logging.isLogOnlyRequests()) {
            PayloadLoggerFactory.log(this.setting.getType(), PayloadType.REQUEST, requestBody);
        }
        this.request = this.request.body(requestBody).when();
        return this;
    }

    static {
        LOG = LogManager.getLogger(RequestHandler.class);
        LINE = StringUtils.repeat((String)"=", (int)80);
    }
}

