/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.parser;

import com.github.wasiqb.coteafs.services.error.JsonParseError;
import com.github.wasiqb.coteafs.services.parser.RequestParser;
import com.github.wasiqb.coteafs.services.requests.RequestElement;
import com.github.wasiqb.coteafs.services.utils.ErrorUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class RestRequestParser
implements RequestParser {
    private JSONStreamAware obj;

    public static RequestParser create() {
        return new RestRequestParser();
    }

    @Override
    public String body() {
        StringWriter out = new StringWriter();
        try {
            this.obj.writeJSONString((Writer)out);
        }
        catch (IOException e) {
            ErrorUtils.fail(JsonParseError.class, "Failed to parse JSON string", e);
        }
        return out.toString();
    }

    @Override
    public RequestParser build(RequestElement element) {
        if (element.name() == null && !element.list().isEmpty()) {
            this.obj = new JSONArray();
            for (int j = 0; j < element.list().size(); ++j) {
                RequestElement v = element.list().get(j);
                JSONObject arrObj = new JSONObject();
                this.build(arrObj, v);
                ((JSONArray)this.obj).add((Object)arrObj);
            }
        } else {
            this.obj = new JSONObject();
            this.build((JSONObject)this.obj, element);
        }
        return this;
    }

    private void addList(JSONObject parent, RequestElement currentElement) {
        if (!currentElement.list().isEmpty()) {
            JSONArray list = new JSONArray();
            for (int j = 0; j < currentElement.list().size(); ++j) {
                RequestElement v = currentElement.list().get(j);
                JSONObject arrObj = new JSONObject();
                this.build(arrObj, v);
                list.add((Object)arrObj);
            }
            parent.put((Object)currentElement.name(), (Object)list);
        }
    }

    private void build(JSONObject parent, RequestElement element) {
        List<RequestElement> elementList = element.childs();
        for (int i = 0; i < elementList.size(); ++i) {
            RequestElement currentElement = elementList.get(i);
            if (currentElement.display()) {
                Object value = currentElement.value();
                if (null != value) {
                    parent.put((Object)currentElement.name(), value);
                } else {
                    JSONObject child = new JSONObject();
                    this.build(child, currentElement);
                    parent.put((Object)currentElement.name(), (Object)child);
                }
            }
            this.addList(parent, currentElement);
        }
    }
}

