/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.parser;

import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import com.github.wasiqb.coteafs.services.config.SoapProtocol;
import com.github.wasiqb.coteafs.services.error.SoapParserInitError;
import com.github.wasiqb.coteafs.services.error.SoapRequestParsingFailedError;
import com.github.wasiqb.coteafs.services.parser.RequestParser;
import com.github.wasiqb.coteafs.services.requests.RequestAttribute;
import com.github.wasiqb.coteafs.services.requests.RequestElement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;

public class SoapRequestParser
implements RequestParser {
    private SOAPBodyElement body;
    private SOAPBody soapBody;
    private SOAPEnvelope soapEnv;
    private SOAPMessage soapMessage;

    public static RequestParser create(SoapProtocol soapProtocol) {
        return new SoapRequestParser(soapProtocol);
    }

    private static <T extends SOAPElement> void addAttributes(T parent, RequestElement e) throws SOAPException {
        if (!e.attributes().isEmpty()) {
            for (RequestAttribute attr : e.attributes()) {
                if (null == attr.value()) continue;
                QName qName = parent.createQName(attr.name(), attr.prefix());
                String value = (String)attr.value();
                parent.addAttribute(qName, value);
            }
        }
    }

    private static <T extends SOAPElement> void addNamespaces(T parent, RequestElement element) throws SOAPException {
        if (!element.namespaces().isEmpty()) {
            for (String prefix : element.namespaces().keySet()) {
                String uri = element.namespaces().get(prefix);
                parent.addNamespaceDeclaration(prefix, uri);
            }
        }
    }

    private SoapRequestParser(SoapProtocol soapProtocol) {
        try {
            this.init(soapProtocol);
        }
        catch (SOAPException e) {
            ErrorUtil.fail(SoapParserInitError.class, (String)"Soap Parser Init failed.", (Throwable)e);
        }
    }

    @Override
    public String body() {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            this.soapMessage.writeTo((OutputStream)bs);
            return new String(bs.toByteArray());
        }
        catch (IOException | SOAPException e) {
            ErrorUtil.fail(SoapRequestParsingFailedError.class, (String)"Soap Request Body Parsing failed:", (Throwable)e);
            return null;
        }
    }

    @Override
    public RequestParser build(RequestElement element) {
        if (element != null && this.body == null) {
            try {
                SoapRequestParser.addNamespaces(this.soapEnv, element);
                QName qName = this.soapBody.createQName(element.name(), element.prefix());
                this.body = this.soapBody.addBodyElement(qName);
                SoapRequestParser.addAttributes(this.body, element);
                this.addElement(this.body, element);
            }
            catch (SOAPException e) {
                ErrorUtil.fail(SoapRequestParsingFailedError.class, (String)"Soap Request Parsing failed:", (Throwable)e);
            }
        }
        return this;
    }

    private <T extends SOAPElement> void addElement(T parent, RequestElement element) throws SOAPException {
        List<RequestElement> elementList = element.childs();
        for (int i = 0; i < elementList.size(); ++i) {
            T currentParent = parent;
            RequestElement currentElement = elementList.get(i);
            SOAPElement child = null;
            if (!currentElement.display()) continue;
            child = currentElement.prefix() != null ? currentParent.addChildElement(currentElement.name(), currentElement.prefix()) : currentParent.addChildElement(currentElement.name());
            SoapRequestParser.addNamespaces(child, currentElement);
            SoapRequestParser.addAttributes(child, currentElement);
            Object value = currentElement.value();
            if (null != value) {
                child.addTextNode(value.toString());
            }
            this.addElement(child, currentElement);
        }
    }

    private void init(SoapProtocol soapProtocol) throws SOAPException {
        MessageFactory factory = MessageFactory.newInstance((String)soapProtocol.toString());
        this.soapMessage = factory.createMessage();
        SOAPPart soapPart = this.soapMessage.getSOAPPart();
        this.soapEnv = soapPart.getEnvelope();
        this.soapBody = this.soapEnv.getBody();
        this.soapEnv.removeNamespaceDeclaration(this.soapEnv.getPrefix());
        String prefix = "soapenv";
        this.soapEnv.setPrefix("soapenv");
        this.soapMessage.getSOAPHeader().setPrefix("soapenv");
        this.soapMessage.getSOAPBody().setPrefix("soapenv");
    }
}

