/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.requests;

import com.github.wasiqb.coteafs.config.loader.ConfigLoader;
import com.github.wasiqb.coteafs.services.config.RequestMethod;
import com.github.wasiqb.coteafs.services.config.ServiceSetting;
import com.github.wasiqb.coteafs.services.config.ServicesSetting;
import com.github.wasiqb.coteafs.services.helper.RequestHandler;
import com.github.wasiqb.coteafs.services.helper.ResponseHandler;
import com.github.wasiqb.coteafs.services.requests.RequestElement;
import com.github.wasiqb.coteafs.services.requests.ResponseVerify;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractRequest {
    private static ServicesSetting settings = (ServicesSetting)ConfigLoader.settings().withKey("coteafs.services.config").withDefault("/services-config.yaml").load(ServicesSetting.class);
    private final List<String> files;
    private final Map<String, Object> formParams;
    private final Map<String, Object> headers;
    private final Map<String, Object> params;
    private final Map<String, Object> pathParams;
    private final Map<String, Object> queryParams;
    private final String resourcePath;
    private ResponseHandler response;
    private final ServiceSetting setting;
    private final Map<String, Object> values;

    public AbstractRequest(String serviceName) {
        this(serviceName, null);
    }

    public AbstractRequest(String serviceName, String resourcePath) {
        this.setting = settings.getService(serviceName);
        this.headers = new HashMap<String, Object>();
        this.params = new HashMap<String, Object>();
        this.pathParams = new HashMap<String, Object>();
        this.formParams = new HashMap<String, Object>();
        this.queryParams = new HashMap<String, Object>();
        this.values = new HashMap<String, Object>();
        this.files = new ArrayList<String>();
        this.resourcePath = resourcePath == null ? "" : resourcePath;
    }

    public AbstractRequest delete(boolean shouldWork) {
        this.response = this.execute(RequestMethod.DELETE, shouldWork);
        return this;
    }

    public AbstractRequest get(boolean shouldWork) {
        this.response = this.execute(RequestMethod.GET, shouldWork);
        return this;
    }

    public AbstractRequest head(boolean shouldWork) {
        this.response = this.execute(RequestMethod.HEAD, shouldWork);
        return this;
    }

    public AbstractRequest options(boolean shouldWork) {
        this.response = this.execute(RequestMethod.OPTIONS, shouldWork);
        return this;
    }

    public AbstractRequest patch(boolean shouldWork) {
        this.response = this.execute(RequestMethod.PATCH, shouldWork);
        return this;
    }

    public AbstractRequest post(boolean shouldWork) {
        this.response = this.execute(RequestMethod.POST, shouldWork);
        return this;
    }

    public abstract RequestElement prepare();

    public AbstractRequest put(boolean shouldWork) {
        this.response = this.execute(RequestMethod.PUT, shouldWork);
        return this;
    }

    public AbstractRequest trace(boolean shouldWork) {
        this.response = this.execute(RequestMethod.TRACE, shouldWork);
        return this;
    }

    public ResponseVerify verifyThat(String expression) {
        return new ResponseVerify(this.response, expression);
    }

    public AbstractRequest withFile(String filePath) {
        this.files.add(filePath);
        return this;
    }

    public AbstractRequest withFormParameter(String name, Object value) {
        this.formParams.put(name, value);
        return this;
    }

    public AbstractRequest withHeader(String name, Object value) {
        this.headers.put(name, value);
        return this;
    }

    public AbstractRequest withParameter(String name, Object value) {
        this.params.put(name, value);
        return this;
    }

    public AbstractRequest withPathParameter(String name, Object value) {
        this.pathParams.put(name, value);
        return this;
    }

    public AbstractRequest withQueryParameter(String name, Object value) {
        this.queryParams.put(name, value);
        return this;
    }

    public AbstractRequest withValue(String fieldName, Object value) {
        this.values.put(fieldName, value);
        return this;
    }

    protected <V> V get(String fieldName) {
        return (V)this.values.get(fieldName);
    }

    private ResponseHandler execute(RequestMethod method, boolean shouldWork) {
        RequestHandler handler = RequestHandler.build().setting(this.setting).using().resource(this.resourcePath);
        if (method != RequestMethod.GET) {
            handler = handler.with(this.prepare());
        }
        this.setHeaders(handler);
        this.setParams(handler);
        this.setFormParams(handler);
        this.setQueryParams(handler);
        this.setPathParams(handler);
        this.setFiles(handler);
        return handler.execute(method.getMethod(), shouldWork).response();
    }

    private void setFiles(RequestHandler handler) {
        handler.multiPart(this.files);
    }

    private void setFormParams(RequestHandler handler) {
        handler.formParams(this.params);
    }

    private void setHeaders(RequestHandler handler) {
        handler.headers(this.headers);
    }

    private void setParams(RequestHandler handler) {
        handler.params(this.params);
    }

    private void setPathParams(RequestHandler handler) {
        handler.pathParams(this.pathParams);
    }

    private void setQueryParams(RequestHandler handler) {
        handler.queryParams(this.queryParams);
    }
}

