/*
 * Decompiled with CFR 0.152.
 */
package com.github.wasiqb.coteafs.services.response;

import com.github.wasiqb.coteafs.error.util.ErrorUtil;
import com.github.wasiqb.coteafs.services.error.SoapResponseParsingFailedError;
import com.github.wasiqb.coteafs.services.response.ResponseValueParser;
import io.restassured.path.xml.XmlPath;
import io.restassured.path.xml.element.Node;
import io.restassured.response.Response;
import java.util.Optional;

public class SoapResponseValueParser
implements ResponseValueParser {
    private final Response response;

    public SoapResponseValueParser(Response response) {
        this.response = response;
    }

    @Override
    public <T> Optional<T> valueOf(String name, String path) {
        XmlPath xmlPath = XmlPath.with((String)this.response.asString());
        String root = "Envelope.Body.'**'[0]";
        Node first = (Node)xmlPath.get("Envelope.Body.'**'[0]");
        String child = first.children().get(0).name();
        StringBuilder pathBuilder = new StringBuilder("Envelope.Body.");
        pathBuilder.append(child).append(".").append(path);
        try {
            return Optional.of(xmlPath.get(pathBuilder.toString()));
        }
        catch (Exception e) {
            String message = "Soap Response value parsing failed for [%s] expression.";
            ErrorUtil.fail(SoapResponseParsingFailedError.class, (String)String.format("Soap Response value parsing failed for [%s] expression.", path), (Throwable)e);
            return Optional.empty();
        }
    }
}

