package com.google.android.horologist.media.data.database;

import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomOpenHelper;
import androidx.room.RoomOpenHelper.Delegate;
import androidx.room.RoomOpenHelper.ValidationResult;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.room.util.TableInfo.Column;
import androidx.room.util.TableInfo.ForeignKey;
import androidx.room.util.TableInfo.Index;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteOpenHelper.Callback;
import androidx.sqlite.db.SupportSQLiteOpenHelper.Configuration;
import com.google.android.horologist.media.data.database.dao.MediaDao;
import com.google.android.horologist.media.data.database.dao.MediaDao_Impl;
import com.google.android.horologist.media.data.database.dao.MediaDownloadDao;
import com.google.android.horologist.media.data.database.dao.MediaDownloadDao_Impl;
import com.google.android.horologist.media.data.database.dao.PlaylistDao;
import com.google.android.horologist.media.data.database.dao.PlaylistDao_Impl;
import com.google.android.horologist.media.data.database.dao.PlaylistMediaDao;
import com.google.android.horologist.media.data.database.dao.PlaylistMediaDao_Impl;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SuppressWarnings({"unchecked", "deprecation"})
public final class MediaDatabase_Impl extends MediaDatabase {
  private volatile MediaDownloadDao _mediaDownloadDao;

  private volatile PlaylistDao _playlistDao;

  private volatile PlaylistMediaDao _playlistMediaDao;

  private volatile MediaDao _mediaDao;

  @Override
  protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
    final SupportSQLiteOpenHelper.Callback _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1) {
      @Override
      public void createAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("CREATE TABLE IF NOT EXISTS `MediaDownloadEntity` (`mediaId` TEXT NOT NULL, `status` TEXT NOT NULL, `progress` REAL NOT NULL, `size` INTEGER NOT NULL, PRIMARY KEY(`mediaId`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `MediaEntity` (`mediaId` TEXT NOT NULL, `mediaUrl` TEXT NOT NULL, `artworkUrl` TEXT NOT NULL, `title` TEXT, `artist` TEXT, PRIMARY KEY(`mediaId`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PlaylistEntity` (`playlistId` TEXT NOT NULL, `name` TEXT NOT NULL, `artworkUri` TEXT, PRIMARY KEY(`playlistId`))");
        _db.execSQL("CREATE TABLE IF NOT EXISTS `PlaylistMediaEntity` (`playlistId` TEXT NOT NULL, `mediaId` TEXT NOT NULL, PRIMARY KEY(`playlistId`, `mediaId`))");
        _db.execSQL("CREATE INDEX IF NOT EXISTS `index_PlaylistMediaEntity_mediaId` ON `PlaylistMediaEntity` (`mediaId`)");
        _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
        _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '8c6a986de0292dc2dfd2a81b702a721b')");
      }

      @Override
      public void dropAllTables(SupportSQLiteDatabase _db) {
        _db.execSQL("DROP TABLE IF EXISTS `MediaDownloadEntity`");
        _db.execSQL("DROP TABLE IF EXISTS `MediaEntity`");
        _db.execSQL("DROP TABLE IF EXISTS `PlaylistEntity`");
        _db.execSQL("DROP TABLE IF EXISTS `PlaylistMediaEntity`");
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onDestructiveMigration(_db);
          }
        }
      }

      @Override
      protected void onCreate(SupportSQLiteDatabase _db) {
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onCreate(_db);
          }
        }
      }

      @Override
      public void onOpen(SupportSQLiteDatabase _db) {
        mDatabase = _db;
        internalInitInvalidationTracker(_db);
        if (mCallbacks != null) {
          for (int _i = 0, _size = mCallbacks.size(); _i < _size; _i++) {
            mCallbacks.get(_i).onOpen(_db);
          }
        }
      }

      @Override
      public void onPreMigrate(SupportSQLiteDatabase _db) {
        DBUtil.dropFtsSyncTriggers(_db);
      }

      @Override
      public void onPostMigrate(SupportSQLiteDatabase _db) {
      }

      @Override
      protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
        final HashMap<String, TableInfo.Column> _columnsMediaDownloadEntity = new HashMap<String, TableInfo.Column>(4);
        _columnsMediaDownloadEntity.put("mediaId", new TableInfo.Column("mediaId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMediaDownloadEntity.put("status", new TableInfo.Column("status", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMediaDownloadEntity.put("progress", new TableInfo.Column("progress", "REAL", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMediaDownloadEntity.put("size", new TableInfo.Column("size", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysMediaDownloadEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesMediaDownloadEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoMediaDownloadEntity = new TableInfo("MediaDownloadEntity", _columnsMediaDownloadEntity, _foreignKeysMediaDownloadEntity, _indicesMediaDownloadEntity);
        final TableInfo _existingMediaDownloadEntity = TableInfo.read(_db, "MediaDownloadEntity");
        if (! _infoMediaDownloadEntity.equals(_existingMediaDownloadEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "MediaDownloadEntity(com.google.android.horologist.media.data.database.model.MediaDownloadEntity).\n"
                  + " Expected:\n" + _infoMediaDownloadEntity + "\n"
                  + " Found:\n" + _existingMediaDownloadEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsMediaEntity = new HashMap<String, TableInfo.Column>(5);
        _columnsMediaEntity.put("mediaId", new TableInfo.Column("mediaId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMediaEntity.put("mediaUrl", new TableInfo.Column("mediaUrl", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMediaEntity.put("artworkUrl", new TableInfo.Column("artworkUrl", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMediaEntity.put("title", new TableInfo.Column("title", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsMediaEntity.put("artist", new TableInfo.Column("artist", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysMediaEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesMediaEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoMediaEntity = new TableInfo("MediaEntity", _columnsMediaEntity, _foreignKeysMediaEntity, _indicesMediaEntity);
        final TableInfo _existingMediaEntity = TableInfo.read(_db, "MediaEntity");
        if (! _infoMediaEntity.equals(_existingMediaEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "MediaEntity(com.google.android.horologist.media.data.database.model.MediaEntity).\n"
                  + " Expected:\n" + _infoMediaEntity + "\n"
                  + " Found:\n" + _existingMediaEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsPlaylistEntity = new HashMap<String, TableInfo.Column>(3);
        _columnsPlaylistEntity.put("playlistId", new TableInfo.Column("playlistId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPlaylistEntity.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPlaylistEntity.put("artworkUri", new TableInfo.Column("artworkUri", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPlaylistEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPlaylistEntity = new HashSet<TableInfo.Index>(0);
        final TableInfo _infoPlaylistEntity = new TableInfo("PlaylistEntity", _columnsPlaylistEntity, _foreignKeysPlaylistEntity, _indicesPlaylistEntity);
        final TableInfo _existingPlaylistEntity = TableInfo.read(_db, "PlaylistEntity");
        if (! _infoPlaylistEntity.equals(_existingPlaylistEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "PlaylistEntity(com.google.android.horologist.media.data.database.model.PlaylistEntity).\n"
                  + " Expected:\n" + _infoPlaylistEntity + "\n"
                  + " Found:\n" + _existingPlaylistEntity);
        }
        final HashMap<String, TableInfo.Column> _columnsPlaylistMediaEntity = new HashMap<String, TableInfo.Column>(2);
        _columnsPlaylistMediaEntity.put("playlistId", new TableInfo.Column("playlistId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY));
        _columnsPlaylistMediaEntity.put("mediaId", new TableInfo.Column("mediaId", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY));
        final HashSet<TableInfo.ForeignKey> _foreignKeysPlaylistMediaEntity = new HashSet<TableInfo.ForeignKey>(0);
        final HashSet<TableInfo.Index> _indicesPlaylistMediaEntity = new HashSet<TableInfo.Index>(1);
        _indicesPlaylistMediaEntity.add(new TableInfo.Index("index_PlaylistMediaEntity_mediaId", false, Arrays.asList("mediaId"), Arrays.asList("ASC")));
        final TableInfo _infoPlaylistMediaEntity = new TableInfo("PlaylistMediaEntity", _columnsPlaylistMediaEntity, _foreignKeysPlaylistMediaEntity, _indicesPlaylistMediaEntity);
        final TableInfo _existingPlaylistMediaEntity = TableInfo.read(_db, "PlaylistMediaEntity");
        if (! _infoPlaylistMediaEntity.equals(_existingPlaylistMediaEntity)) {
          return new RoomOpenHelper.ValidationResult(false, "PlaylistMediaEntity(com.google.android.horologist.media.data.database.model.PlaylistMediaEntity).\n"
                  + " Expected:\n" + _infoPlaylistMediaEntity + "\n"
                  + " Found:\n" + _existingPlaylistMediaEntity);
        }
        return new RoomOpenHelper.ValidationResult(true, null);
      }
    }, "8c6a986de0292dc2dfd2a81b702a721b", "bb07ba61d96e2905a699f4fab1b9980b");
    final SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder(configuration.context)
        .name(configuration.name)
        .callback(_openCallback)
        .build();
    final SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
    return _helper;
  }

  @Override
  protected InvalidationTracker createInvalidationTracker() {
    final HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(0);
    HashMap<String, Set<String>> _viewTables = new HashMap<String, Set<String>>(0);
    return new InvalidationTracker(this, _shadowTablesMap, _viewTables, "MediaDownloadEntity","MediaEntity","PlaylistEntity","PlaylistMediaEntity");
  }

  @Override
  public void clearAllTables() {
    super.assertNotMainThread();
    final SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
    try {
      super.beginTransaction();
      _db.execSQL("DELETE FROM `MediaDownloadEntity`");
      _db.execSQL("DELETE FROM `MediaEntity`");
      _db.execSQL("DELETE FROM `PlaylistEntity`");
      _db.execSQL("DELETE FROM `PlaylistMediaEntity`");
      super.setTransactionSuccessful();
    } finally {
      super.endTransaction();
      _db.query("PRAGMA wal_checkpoint(FULL)").close();
      if (!_db.inTransaction()) {
        _db.execSQL("VACUUM");
      }
    }
  }

  @Override
  protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
    final HashMap<Class<?>, List<Class<?>>> _typeConvertersMap = new HashMap<Class<?>, List<Class<?>>>();
    _typeConvertersMap.put(MediaDownloadDao.class, MediaDownloadDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PlaylistDao.class, PlaylistDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(PlaylistMediaDao.class, PlaylistMediaDao_Impl.getRequiredConverters());
    _typeConvertersMap.put(MediaDao.class, MediaDao_Impl.getRequiredConverters());
    return _typeConvertersMap;
  }

  @Override
  public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
    final HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
    return _autoMigrationSpecsSet;
  }

  @Override
  public List<Migration> getAutoMigrations(
      @NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
    return Arrays.asList();
  }

  @Override
  public MediaDownloadDao mediaDownloadDao() {
    if (_mediaDownloadDao != null) {
      return _mediaDownloadDao;
    } else {
      synchronized(this) {
        if(_mediaDownloadDao == null) {
          _mediaDownloadDao = new MediaDownloadDao_Impl(this);
        }
        return _mediaDownloadDao;
      }
    }
  }

  @Override
  public PlaylistDao playlistDao() {
    if (_playlistDao != null) {
      return _playlistDao;
    } else {
      synchronized(this) {
        if(_playlistDao == null) {
          _playlistDao = new PlaylistDao_Impl(this);
        }
        return _playlistDao;
      }
    }
  }

  @Override
  public PlaylistMediaDao playlistMediaDao() {
    if (_playlistMediaDao != null) {
      return _playlistMediaDao;
    } else {
      synchronized(this) {
        if(_playlistMediaDao == null) {
          _playlistMediaDao = new PlaylistMediaDao_Impl(this);
        }
        return _playlistMediaDao;
      }
    }
  }

  @Override
  public MediaDao mediaDao() {
    if (_mediaDao != null) {
      return _mediaDao;
    } else {
      synchronized(this) {
        if(_mediaDao == null) {
          _mediaDao = new MediaDao_Impl(this);
        }
        return _mediaDao;
      }
    }
  }
}
