package com.google.android.horologist.media.data.database.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.google.android.horologist.media.data.database.model.MediaDownloadEntity;
import com.google.android.horologist.media.data.database.model.MediaDownloadEntityStatus;
import java.lang.Class;
import java.lang.Exception;
import java.lang.IllegalArgumentException;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class MediaDownloadDao_Impl implements MediaDownloadDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<MediaDownloadEntity> __insertionAdapterOfMediaDownloadEntity;

  private final EntityDeletionOrUpdateAdapter<MediaDownloadDao.StatusAndProgress> __updateAdapterOfStatusAndProgressAsMediaDownloadEntity;

  private final SharedSQLiteStatement __preparedStmtOfUpdateStatus;

  private final SharedSQLiteStatement __preparedStmtOfUpdateProgress;

  private final SharedSQLiteStatement __preparedStmtOfDelete;

  public MediaDownloadDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfMediaDownloadEntity = new EntityInsertionAdapter<MediaDownloadEntity>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR IGNORE INTO `MediaDownloadEntity` (`mediaId`,`status`,`progress`,`size`) VALUES (?,?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, MediaDownloadEntity value) {
        if (value.getMediaId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getMediaId());
        }
        if (value.getStatus() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, __MediaDownloadEntityStatus_enumToString(value.getStatus()));
        }
        stmt.bindDouble(3, value.getProgress());
        stmt.bindLong(4, value.getSize());
      }
    };
    this.__updateAdapterOfStatusAndProgressAsMediaDownloadEntity = new EntityDeletionOrUpdateAdapter<MediaDownloadDao.StatusAndProgress>(__db) {
      @Override
      public String createQuery() {
        return "UPDATE OR ABORT `MediaDownloadEntity` SET `mediaId` = ?,`status` = ?,`progress` = ? WHERE `mediaId` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, MediaDownloadDao.StatusAndProgress value) {
        if (value.getMediaId() == null) {
          stmt.bindNull(1);
        } else {
          stmt.bindString(1, value.getMediaId());
        }
        if (value.getStatus() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, __MediaDownloadEntityStatus_enumToString(value.getStatus()));
        }
        stmt.bindDouble(3, value.getProgress());
        if (value.getMediaId() == null) {
          stmt.bindNull(4);
        } else {
          stmt.bindString(4, value.getMediaId());
        }
      }
    };
    this.__preparedStmtOfUpdateStatus = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE MediaDownloadEntity\n"
                + "        SET status = ?\n"
                + "        WHERE mediaId = ?\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfUpdateProgress = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        UPDATE MediaDownloadEntity\n"
                + "        SET progress = ?,\n"
                + "        size = ?\n"
                + "        WHERE mediaId = ?\n"
                + "    ";
        return _query;
      }
    };
    this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "\n"
                + "        DELETE FROM MediaDownloadEntity\n"
                + "        WHERE mediaId = ?\n"
                + "    ";
        return _query;
      }
    };
  }

  @Override
  public Object insert(final MediaDownloadEntity mediaDownloadEntity,
      final Continuation<? super Long> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Long>() {
      @Override
      public Long call() throws Exception {
        __db.beginTransaction();
        try {
          long _result = __insertionAdapterOfMediaDownloadEntity.insertAndReturnId(mediaDownloadEntity);
          __db.setTransactionSuccessful();
          return _result;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateStatusAndProgress(final MediaDownloadDao.StatusAndProgress statusAndProgress,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __updateAdapterOfStatusAndProgressAsMediaDownloadEntity.handle(statusAndProgress);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  @Override
  public Object updateStatus(final String mediaId, final MediaDownloadEntityStatus status,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateStatus.acquire();
        int _argIndex = 1;
        if (status == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, __MediaDownloadEntityStatus_enumToString(status));
        }
        _argIndex = 2;
        if (mediaId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, mediaId);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateStatus.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object updateProgress(final String mediaId, final float progress, final long size,
      final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfUpdateProgress.acquire();
        int _argIndex = 1;
        _stmt.bindDouble(_argIndex, progress);
        _argIndex = 2;
        _stmt.bindLong(_argIndex, size);
        _argIndex = 3;
        if (mediaId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, mediaId);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfUpdateProgress.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Object delete(final String mediaId, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        final SupportSQLiteStatement _stmt = __preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        if (mediaId == null) {
          _stmt.bindNull(_argIndex);
        } else {
          _stmt.bindString(_argIndex, mediaId);
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
          __preparedStmtOfDelete.release(_stmt);
        }
      }
    }, continuation);
  }

  @Override
  public Flow<List<MediaDownloadEntity>> getList(final List<String> mediaIds) {
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        SELECT * FROM MediaDownloadEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("        WHERE mediaId in (");
    final int _inputSize = mediaIds.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : mediaIds) {
      if (_item == null) {
        _statement.bindNull(_argIndex);
      } else {
        _statement.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    return CoroutinesRoom.createFlow(__db, false, new String[]{"MediaDownloadEntity"}, new Callable<List<MediaDownloadEntity>>() {
      @Override
      public List<MediaDownloadEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfMediaId = CursorUtil.getColumnIndexOrThrow(_cursor, "mediaId");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "progress");
          final int _cursorIndexOfSize = CursorUtil.getColumnIndexOrThrow(_cursor, "size");
          final List<MediaDownloadEntity> _result = new ArrayList<MediaDownloadEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final MediaDownloadEntity _item_1;
            final String _tmpMediaId;
            if (_cursor.isNull(_cursorIndexOfMediaId)) {
              _tmpMediaId = null;
            } else {
              _tmpMediaId = _cursor.getString(_cursorIndexOfMediaId);
            }
            final MediaDownloadEntityStatus _tmpStatus;
            _tmpStatus = __MediaDownloadEntityStatus_stringToEnum(_cursor.getString(_cursorIndexOfStatus));
            final float _tmpProgress;
            _tmpProgress = _cursor.getFloat(_cursorIndexOfProgress);
            final long _tmpSize;
            _tmpSize = _cursor.getLong(_cursorIndexOfSize);
            _item_1 = new MediaDownloadEntity(_tmpMediaId,_tmpStatus,_tmpProgress,_tmpSize);
            _result.add(_item_1);
          }
          return _result;
        } finally {
          _cursor.close();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Object getAllByStatus(final MediaDownloadEntityStatus status,
      final Continuation<? super List<MediaDownloadEntity>> continuation) {
    final String _sql = "\n"
            + "        SELECT * FROM MediaDownloadEntity\n"
            + "        WHERE status = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    if (status == null) {
      _statement.bindNull(_argIndex);
    } else {
      _statement.bindString(_argIndex, __MediaDownloadEntityStatus_enumToString(status));
    }
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, false, _cancellationSignal, new Callable<List<MediaDownloadEntity>>() {
      @Override
      public List<MediaDownloadEntity> call() throws Exception {
        final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
        try {
          final int _cursorIndexOfMediaId = CursorUtil.getColumnIndexOrThrow(_cursor, "mediaId");
          final int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow(_cursor, "status");
          final int _cursorIndexOfProgress = CursorUtil.getColumnIndexOrThrow(_cursor, "progress");
          final int _cursorIndexOfSize = CursorUtil.getColumnIndexOrThrow(_cursor, "size");
          final List<MediaDownloadEntity> _result = new ArrayList<MediaDownloadEntity>(_cursor.getCount());
          while(_cursor.moveToNext()) {
            final MediaDownloadEntity _item;
            final String _tmpMediaId;
            if (_cursor.isNull(_cursorIndexOfMediaId)) {
              _tmpMediaId = null;
            } else {
              _tmpMediaId = _cursor.getString(_cursorIndexOfMediaId);
            }
            final MediaDownloadEntityStatus _tmpStatus;
            _tmpStatus = __MediaDownloadEntityStatus_stringToEnum(_cursor.getString(_cursorIndexOfStatus));
            final float _tmpProgress;
            _tmpProgress = _cursor.getFloat(_cursorIndexOfProgress);
            final long _tmpSize;
            _tmpSize = _cursor.getLong(_cursorIndexOfSize);
            _item = new MediaDownloadEntity(_tmpMediaId,_tmpStatus,_tmpProgress,_tmpSize);
            _result.add(_item);
          }
          return _result;
        } finally {
          _cursor.close();
          _statement.release();
        }
      }
    }, continuation);
  }

  @Override
  public Object delete(final List<String> mediaIds, final Continuation<? super Unit> continuation) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      public Unit call() throws Exception {
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("\n");
        _stringBuilder.append("        DELETE FROM MediaDownloadEntity");
        _stringBuilder.append("\n");
        _stringBuilder.append("        WHERE mediaId in (");
        final int _inputSize = mediaIds.size();
        StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
        _stringBuilder.append(")");
        _stringBuilder.append("\n");
        _stringBuilder.append("    ");
        final String _sql = _stringBuilder.toString();
        final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
        int _argIndex = 1;
        for (String _item : mediaIds) {
          if (_item == null) {
            _stmt.bindNull(_argIndex);
          } else {
            _stmt.bindString(_argIndex, _item);
          }
          _argIndex ++;
        }
        __db.beginTransaction();
        try {
          _stmt.executeUpdateDelete();
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, continuation);
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private String __MediaDownloadEntityStatus_enumToString(final MediaDownloadEntityStatus _value) {
    if (_value == null) {
      return null;
    } switch (_value) {
      case NotDownloaded: return "NotDownloaded";
      case Downloading: return "Downloading";
      case Downloaded: return "Downloaded";
      case Failed: return "Failed";
      default: throw new IllegalArgumentException("Can't convert enum to string, unknown enum value: " + _value);
    }
  }

  private MediaDownloadEntityStatus __MediaDownloadEntityStatus_stringToEnum(final String _value) {
    if (_value == null) {
      return null;
    } switch (_value) {
      case "NotDownloaded": return MediaDownloadEntityStatus.NotDownloaded;
      case "Downloading": return MediaDownloadEntityStatus.Downloading;
      case "Downloaded": return MediaDownloadEntityStatus.Downloaded;
      case "Failed": return MediaDownloadEntityStatus.Failed;
      default: throw new IllegalArgumentException("Can't convert value to enum, unknown value: " + _value);
    }
  }
}
