package com.google.android.horologist.media.data.database.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.RelationUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.google.android.horologist.media.data.database.model.MediaEntity;
import com.google.android.horologist.media.data.database.model.PlaylistEntity;
import com.google.android.horologist.media.data.database.model.PlaylistMediaEntity;
import com.google.android.horologist.media.data.database.model.PopulatedPlaylist;
import java.lang.Class;
import java.lang.Exception;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.processing.Generated;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.flow.Flow;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class PlaylistDao_Impl implements PlaylistDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<PlaylistEntity> __insertionAdapterOfPlaylistEntity;

  private final EntityInsertionAdapter<MediaEntity> __insertionAdapterOfMediaEntity;

  private final EntityInsertionAdapter<PlaylistMediaEntity> __insertionAdapterOfPlaylistMediaEntity;

  public PlaylistDao_Impl(@NonNull final RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfPlaylistEntity = new EntityInsertionAdapter<PlaylistEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `PlaylistEntity` (`playlistId`,`name`,`artworkUri`) VALUES (?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PlaylistEntity entity) {
        statement.bindString(1, entity.getPlaylistId());
        statement.bindString(2, entity.getName());
        if (entity.getArtworkUri() == null) {
          statement.bindNull(3);
        } else {
          statement.bindString(3, entity.getArtworkUri());
        }
      }
    };
    this.__insertionAdapterOfMediaEntity = new EntityInsertionAdapter<MediaEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `MediaEntity` (`mediaId`,`mediaUrl`,`artworkUrl`,`title`,`artist`) VALUES (?,?,?,?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final MediaEntity entity) {
        statement.bindString(1, entity.getMediaId());
        statement.bindString(2, entity.getMediaUrl());
        statement.bindString(3, entity.getArtworkUrl());
        if (entity.getTitle() == null) {
          statement.bindNull(4);
        } else {
          statement.bindString(4, entity.getTitle());
        }
        if (entity.getArtist() == null) {
          statement.bindNull(5);
        } else {
          statement.bindString(5, entity.getArtist());
        }
      }
    };
    this.__insertionAdapterOfPlaylistMediaEntity = new EntityInsertionAdapter<PlaylistMediaEntity>(__db) {
      @Override
      @NonNull
      protected String createQuery() {
        return "INSERT OR REPLACE INTO `PlaylistMediaEntity` (`playlistId`,`mediaId`) VALUES (?,?)";
      }

      @Override
      protected void bind(@NonNull final SupportSQLiteStatement statement,
          @NonNull final PlaylistMediaEntity entity) {
        statement.bindString(1, entity.getPlaylistId());
        statement.bindString(2, entity.getMediaId());
      }
    };
  }

  @Override
  public Object upsert(final PlaylistEntity playlistEntity, final List<MediaEntity> mediaEntityList,
      final List<PlaylistMediaEntity> playlistMediaEntityList,
      final Continuation<? super Unit> $completion) {
    return CoroutinesRoom.execute(__db, true, new Callable<Unit>() {
      @Override
      @NonNull
      public Unit call() throws Exception {
        __db.beginTransaction();
        try {
          __insertionAdapterOfPlaylistEntity.insert(playlistEntity);
          __insertionAdapterOfMediaEntity.insert(mediaEntityList);
          __insertionAdapterOfPlaylistMediaEntity.insert(playlistMediaEntityList);
          __db.setTransactionSuccessful();
          return Unit.INSTANCE;
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Object getPopulated(final String playlistId,
      final Continuation<? super PopulatedPlaylist> $completion) {
    final String _sql = "\n"
            + "        SELECT * FROM PlaylistEntity\n"
            + "        WHERE playlistId = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, playlistId);
    final CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
    return CoroutinesRoom.execute(__db, true, _cancellationSignal, new Callable<PopulatedPlaylist>() {
      @Override
      @Nullable
      public PopulatedPlaylist call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfPlaylistId = CursorUtil.getColumnIndexOrThrow(_cursor, "playlistId");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfArtworkUri = CursorUtil.getColumnIndexOrThrow(_cursor, "artworkUri");
            final ArrayMap<String, ArrayList<MediaEntity>> _collectionMediaList = new ArrayMap<String, ArrayList<MediaEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey;
              _tmpKey = _cursor.getString(_cursorIndexOfPlaylistId);
              if (!_collectionMediaList.containsKey(_tmpKey)) {
                _collectionMediaList.put(_tmpKey, new ArrayList<MediaEntity>());
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipMediaEntityAscomGoogleAndroidHorologistMediaDataDatabaseModelMediaEntity(_collectionMediaList);
            final PopulatedPlaylist _result;
            if (_cursor.moveToFirst()) {
              final PlaylistEntity _tmpPlaylist;
              final String _tmpPlaylistId;
              _tmpPlaylistId = _cursor.getString(_cursorIndexOfPlaylistId);
              final String _tmpName;
              _tmpName = _cursor.getString(_cursorIndexOfName);
              final String _tmpArtworkUri;
              if (_cursor.isNull(_cursorIndexOfArtworkUri)) {
                _tmpArtworkUri = null;
              } else {
                _tmpArtworkUri = _cursor.getString(_cursorIndexOfArtworkUri);
              }
              _tmpPlaylist = new PlaylistEntity(_tmpPlaylistId,_tmpName,_tmpArtworkUri);
              final ArrayList<MediaEntity> _tmpMediaListCollection;
              final String _tmpKey_1;
              _tmpKey_1 = _cursor.getString(_cursorIndexOfPlaylistId);
              _tmpMediaListCollection = _collectionMediaList.get(_tmpKey_1);
              _result = new PopulatedPlaylist(_tmpPlaylist,_tmpMediaListCollection);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
            _statement.release();
          }
        } finally {
          __db.endTransaction();
        }
      }
    }, $completion);
  }

  @Override
  public Flow<PopulatedPlaylist> getPopulatedStream(final String playlistId) {
    final String _sql = "\n"
            + "        SELECT * FROM playlistentity\n"
            + "        WHERE playlistId = ?\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindString(_argIndex, playlistId);
    return CoroutinesRoom.createFlow(__db, true, new String[] {"PlaylistMediaEntity", "MediaEntity",
        "playlistentity"}, new Callable<PopulatedPlaylist>() {
      @Override
      @Nullable
      public PopulatedPlaylist call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfPlaylistId = CursorUtil.getColumnIndexOrThrow(_cursor, "playlistId");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfArtworkUri = CursorUtil.getColumnIndexOrThrow(_cursor, "artworkUri");
            final ArrayMap<String, ArrayList<MediaEntity>> _collectionMediaList = new ArrayMap<String, ArrayList<MediaEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey;
              _tmpKey = _cursor.getString(_cursorIndexOfPlaylistId);
              if (!_collectionMediaList.containsKey(_tmpKey)) {
                _collectionMediaList.put(_tmpKey, new ArrayList<MediaEntity>());
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipMediaEntityAscomGoogleAndroidHorologistMediaDataDatabaseModelMediaEntity(_collectionMediaList);
            final PopulatedPlaylist _result;
            if (_cursor.moveToFirst()) {
              final PlaylistEntity _tmpPlaylist;
              final String _tmpPlaylistId;
              _tmpPlaylistId = _cursor.getString(_cursorIndexOfPlaylistId);
              final String _tmpName;
              _tmpName = _cursor.getString(_cursorIndexOfName);
              final String _tmpArtworkUri;
              if (_cursor.isNull(_cursorIndexOfArtworkUri)) {
                _tmpArtworkUri = null;
              } else {
                _tmpArtworkUri = _cursor.getString(_cursorIndexOfArtworkUri);
              }
              _tmpPlaylist = new PlaylistEntity(_tmpPlaylistId,_tmpName,_tmpArtworkUri);
              final ArrayList<MediaEntity> _tmpMediaListCollection;
              final String _tmpKey_1;
              _tmpKey_1 = _cursor.getString(_cursorIndexOfPlaylistId);
              _tmpMediaListCollection = _collectionMediaList.get(_tmpKey_1);
              _result = new PopulatedPlaylist(_tmpPlaylist,_tmpMediaListCollection);
            } else {
              _result = null;
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<PopulatedPlaylist>> getAllPopulated() {
    final String _sql = "\n"
            + "        SELECT * FROM PlaylistEntity\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, true, new String[] {"PlaylistMediaEntity", "MediaEntity",
        "PlaylistEntity"}, new Callable<List<PopulatedPlaylist>>() {
      @Override
      @NonNull
      public List<PopulatedPlaylist> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfPlaylistId = CursorUtil.getColumnIndexOrThrow(_cursor, "playlistId");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfArtworkUri = CursorUtil.getColumnIndexOrThrow(_cursor, "artworkUri");
            final ArrayMap<String, ArrayList<MediaEntity>> _collectionMediaList = new ArrayMap<String, ArrayList<MediaEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey;
              _tmpKey = _cursor.getString(_cursorIndexOfPlaylistId);
              if (!_collectionMediaList.containsKey(_tmpKey)) {
                _collectionMediaList.put(_tmpKey, new ArrayList<MediaEntity>());
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipMediaEntityAscomGoogleAndroidHorologistMediaDataDatabaseModelMediaEntity(_collectionMediaList);
            final List<PopulatedPlaylist> _result = new ArrayList<PopulatedPlaylist>(_cursor.getCount());
            while (_cursor.moveToNext()) {
              final PopulatedPlaylist _item;
              final PlaylistEntity _tmpPlaylist;
              final String _tmpPlaylistId;
              _tmpPlaylistId = _cursor.getString(_cursorIndexOfPlaylistId);
              final String _tmpName;
              _tmpName = _cursor.getString(_cursorIndexOfName);
              final String _tmpArtworkUri;
              if (_cursor.isNull(_cursorIndexOfArtworkUri)) {
                _tmpArtworkUri = null;
              } else {
                _tmpArtworkUri = _cursor.getString(_cursorIndexOfArtworkUri);
              }
              _tmpPlaylist = new PlaylistEntity(_tmpPlaylistId,_tmpName,_tmpArtworkUri);
              final ArrayList<MediaEntity> _tmpMediaListCollection;
              final String _tmpKey_1;
              _tmpKey_1 = _cursor.getString(_cursorIndexOfPlaylistId);
              _tmpMediaListCollection = _collectionMediaList.get(_tmpKey_1);
              _item = new PopulatedPlaylist(_tmpPlaylist,_tmpMediaListCollection);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public Flow<List<PopulatedPlaylist>> getAllDownloaded() {
    final String _sql = "\n"
            + "        SELECT * FROM PlaylistEntity\n"
            + "        WHERE EXISTS (\n"
            + "            SELECT 1 FROM PlaylistMediaEntity\n"
            + "            WHERE PlaylistMediaEntity.playlistId = PlaylistEntity.playlistId\n"
            + "            AND EXISTS (\n"
            + "                SELECT 1 FROM MediaDownloadEntity\n"
            + "                WHERE MediaDownloadEntity.mediaId = PlaylistMediaEntity.mediaId\n"
            + "            )\n"
            + "        )\n"
            + "    ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    return CoroutinesRoom.createFlow(__db, true, new String[] {"PlaylistMediaEntity", "MediaEntity",
        "PlaylistEntity", "MediaDownloadEntity"}, new Callable<List<PopulatedPlaylist>>() {
      @Override
      @NonNull
      public List<PopulatedPlaylist> call() throws Exception {
        __db.beginTransaction();
        try {
          final Cursor _cursor = DBUtil.query(__db, _statement, true, null);
          try {
            final int _cursorIndexOfPlaylistId = CursorUtil.getColumnIndexOrThrow(_cursor, "playlistId");
            final int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow(_cursor, "name");
            final int _cursorIndexOfArtworkUri = CursorUtil.getColumnIndexOrThrow(_cursor, "artworkUri");
            final ArrayMap<String, ArrayList<MediaEntity>> _collectionMediaList = new ArrayMap<String, ArrayList<MediaEntity>>();
            while (_cursor.moveToNext()) {
              final String _tmpKey;
              _tmpKey = _cursor.getString(_cursorIndexOfPlaylistId);
              if (!_collectionMediaList.containsKey(_tmpKey)) {
                _collectionMediaList.put(_tmpKey, new ArrayList<MediaEntity>());
              }
            }
            _cursor.moveToPosition(-1);
            __fetchRelationshipMediaEntityAscomGoogleAndroidHorologistMediaDataDatabaseModelMediaEntity(_collectionMediaList);
            final List<PopulatedPlaylist> _result = new ArrayList<PopulatedPlaylist>(_cursor.getCount());
            while (_cursor.moveToNext()) {
              final PopulatedPlaylist _item;
              final PlaylistEntity _tmpPlaylist;
              final String _tmpPlaylistId;
              _tmpPlaylistId = _cursor.getString(_cursorIndexOfPlaylistId);
              final String _tmpName;
              _tmpName = _cursor.getString(_cursorIndexOfName);
              final String _tmpArtworkUri;
              if (_cursor.isNull(_cursorIndexOfArtworkUri)) {
                _tmpArtworkUri = null;
              } else {
                _tmpArtworkUri = _cursor.getString(_cursorIndexOfArtworkUri);
              }
              _tmpPlaylist = new PlaylistEntity(_tmpPlaylistId,_tmpName,_tmpArtworkUri);
              final ArrayList<MediaEntity> _tmpMediaListCollection;
              final String _tmpKey_1;
              _tmpKey_1 = _cursor.getString(_cursorIndexOfPlaylistId);
              _tmpMediaListCollection = _collectionMediaList.get(_tmpKey_1);
              _item = new PopulatedPlaylist(_tmpPlaylist,_tmpMediaListCollection);
              _result.add(_item);
            }
            __db.setTransactionSuccessful();
            return _result;
          } finally {
            _cursor.close();
          }
        } finally {
          __db.endTransaction();
        }
      }

      @Override
      protected void finalize() {
        _statement.release();
      }
    });
  }

  @Override
  public void delete(final List<String> playlistIds) {
    __db.assertNotSuspendingTransaction();
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("\n");
    _stringBuilder.append("        DELETE FROM PlaylistEntity");
    _stringBuilder.append("\n");
    _stringBuilder.append("        WHERE playlistId in (");
    final int _inputSize = playlistIds.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    _stringBuilder.append("\n");
    _stringBuilder.append("    ");
    final String _sql = _stringBuilder.toString();
    final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
    int _argIndex = 1;
    for (String _item : playlistIds) {
      _stmt.bindString(_argIndex, _item);
      _argIndex++;
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @NonNull
  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }

  private void __fetchRelationshipMediaEntityAscomGoogleAndroidHorologistMediaDataDatabaseModelMediaEntity(
      @NonNull final ArrayMap<String, ArrayList<MediaEntity>> _map) {
    final Set<String> __mapKeySet = _map.keySet();
    if (__mapKeySet.isEmpty()) {
      return;
    }
    if (_map.size() > RoomDatabase.MAX_BIND_PARAMETER_CNT) {
      RelationUtil.recursiveFetchArrayMap(_map, true, (map) -> {
        __fetchRelationshipMediaEntityAscomGoogleAndroidHorologistMediaDataDatabaseModelMediaEntity(map);
        return Unit.INSTANCE;
      });
      return;
    }
    final StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("SELECT `MediaEntity`.`mediaId` AS `mediaId`,`MediaEntity`.`mediaUrl` AS `mediaUrl`,`MediaEntity`.`artworkUrl` AS `artworkUrl`,`MediaEntity`.`title` AS `title`,`MediaEntity`.`artist` AS `artist`,_junction.`playlistId` FROM `PlaylistMediaEntity` AS _junction INNER JOIN `MediaEntity` ON (_junction.`mediaId` = `MediaEntity`.`mediaId`) WHERE _junction.`playlistId` IN (");
    final int _inputSize = __mapKeySet.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(")");
    final String _sql = _stringBuilder.toString();
    final int _argCount = 0 + _inputSize;
    final RoomSQLiteQuery _stmt = RoomSQLiteQuery.acquire(_sql, _argCount);
    int _argIndex = 1;
    for (String _item : __mapKeySet) {
      _stmt.bindString(_argIndex, _item);
      _argIndex++;
    }
    final Cursor _cursor = DBUtil.query(__db, _stmt, false, null);
    try {
      // _junction.playlistId;
      final int _itemKeyIndex = 5;
      if (_itemKeyIndex == -1) {
        return;
      }
      final int _cursorIndexOfMediaId = 0;
      final int _cursorIndexOfMediaUrl = 1;
      final int _cursorIndexOfArtworkUrl = 2;
      final int _cursorIndexOfTitle = 3;
      final int _cursorIndexOfArtist = 4;
      while (_cursor.moveToNext()) {
        final String _tmpKey;
        _tmpKey = _cursor.getString(_itemKeyIndex);
        final ArrayList<MediaEntity> _tmpRelation = _map.get(_tmpKey);
        if (_tmpRelation != null) {
          final MediaEntity _item_1;
          final String _tmpMediaId;
          _tmpMediaId = _cursor.getString(_cursorIndexOfMediaId);
          final String _tmpMediaUrl;
          _tmpMediaUrl = _cursor.getString(_cursorIndexOfMediaUrl);
          final String _tmpArtworkUrl;
          _tmpArtworkUrl = _cursor.getString(_cursorIndexOfArtworkUrl);
          final String _tmpTitle;
          if (_cursor.isNull(_cursorIndexOfTitle)) {
            _tmpTitle = null;
          } else {
            _tmpTitle = _cursor.getString(_cursorIndexOfTitle);
          }
          final String _tmpArtist;
          if (_cursor.isNull(_cursorIndexOfArtist)) {
            _tmpArtist = null;
          } else {
            _tmpArtist = _cursor.getString(_cursorIndexOfArtist);
          }
          _item_1 = new MediaEntity(_tmpMediaId,_tmpMediaUrl,_tmpArtworkUrl,_tmpTitle,_tmpArtist);
          _tmpRelation.add(_item_1);
        }
      }
    } finally {
      _cursor.close();
    }
  }
}
