/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.android.horologist.media.ui.animation

import androidx.compose.animation.core.Spring
import androidx.compose.animation.core.SpringSpec

internal object PlaybackProgressAnimation {
    val PLAYBACK_PROGRESS_ANIMATION_SPEC =
        SpringSpec(
            dampingRatio = Spring.DampingRatioNoBouncy,
            stiffness = 100f,
            // The default threshold is 0.01, or 1% of the overall progress range, which is quite
            // large and noticeable.
            visibilityThreshold = 1 / 1000f
        )
}
