/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.factory.AutoFactory;
import com.google.auto.factory.Provided;
import com.google.auto.factory.processor.AutoFactoryDeclaration;
import com.google.auto.factory.processor.Elements2;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.Mirrors;
import com.google.auto.factory.processor.Parameter;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

final class FactoryDescriptorGenerator {
    private final Messager messager;
    private final Elements elements;
    private final AutoFactoryDeclaration.Factory declarationFactory;

    FactoryDescriptorGenerator(Messager messager, Elements elements, AutoFactoryDeclaration.Factory declarationFactory) {
        this.messager = messager;
        this.elements = elements;
        this.declarationFactory = declarationFactory;
    }

    ImmutableSet<FactoryMethodDescriptor> generateDescriptor(Element element) {
        final AnnotationMirror mirror = (AnnotationMirror)Mirrors.getAnnotationMirror(element, AutoFactory.class).get();
        final Optional<AutoFactoryDeclaration> declaration = this.declarationFactory.createIfValid(element);
        if (!declaration.isPresent()) {
            return ImmutableSet.of();
        }
        return element.accept(new ElementKindVisitor6<ImmutableSet<FactoryMethodDescriptor>, Void>(){

            @Override
            protected ImmutableSet<FactoryMethodDescriptor> defaultAction(Element e, Void p) {
                throw new AssertionError((Object)"@AutoFactory applied to an impossible element");
            }

            @Override
            public ImmutableSet<FactoryMethodDescriptor> visitTypeAsClass(TypeElement type, Void p) {
                if (type.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    FactoryDescriptorGenerator.this.messager.printMessage(Diagnostic.Kind.ERROR, "Auto-factory doesn't support being applied to abstract classes.", type, mirror);
                    return ImmutableSet.of();
                }
                ImmutableSet<ExecutableElement> constructors = Elements2.getConstructors(type);
                if (constructors.isEmpty()) {
                    return FactoryDescriptorGenerator.this.generateDescriptorForDefaultConstructor((AutoFactoryDeclaration)declaration.get(), type);
                }
                return FluentIterable.from(constructors).transform((Function)new Function<ExecutableElement, FactoryMethodDescriptor>(){

                    public FactoryMethodDescriptor apply(ExecutableElement constructor) {
                        return FactoryDescriptorGenerator.this.generateDescriptorForConstructor((AutoFactoryDeclaration)declaration.get(), constructor);
                    }
                }).toSet();
            }

            @Override
            public ImmutableSet<FactoryMethodDescriptor> visitTypeAsInterface(TypeElement type, Void p) {
                FactoryDescriptorGenerator.this.messager.printMessage(Diagnostic.Kind.ERROR, "Auto-factory doesn't support being applied to interfaces.", type, mirror);
                return ImmutableSet.of();
            }

            @Override
            public ImmutableSet<FactoryMethodDescriptor> visitExecutableAsConstructor(ExecutableElement e, Void p) {
                return ImmutableSet.of((Object)FactoryDescriptorGenerator.this.generateDescriptorForConstructor((AutoFactoryDeclaration)declaration.get(), e));
            }
        }, null);
    }

    FactoryMethodDescriptor generateDescriptorForConstructor(AutoFactoryDeclaration declaration, ExecutableElement constructor) {
        Preconditions.checkNotNull((Object)constructor);
        Preconditions.checkArgument((constructor.getKind() == ElementKind.CONSTRUCTOR ? 1 : 0) != 0);
        Element classElement = constructor.getEnclosingElement();
        Name returnType = classElement.accept(new ElementKindVisitor6<Name, Void>(){

            @Override
            protected Name defaultAction(Element e, Void p) {
                throw new AssertionError();
            }

            @Override
            public Name visitTypeAsClass(TypeElement e, Void p) {
                if (!e.getTypeParameters().isEmpty()) {
                    FactoryDescriptorGenerator.this.messager.printMessage(Diagnostic.Kind.ERROR, "AutoFactory does not support generic types", e);
                }
                return e.getQualifiedName();
            }
        }, null);
        ImmutableListMultimap parameterMap = Multimaps.index(constructor.getParameters(), (Function)Functions.forPredicate((Predicate)new Predicate<VariableElement>(){

            public boolean apply(VariableElement parameter) {
                return parameter.getAnnotation(Provided.class) != null;
            }
        }));
        ImmutableSet<Parameter> providedParameters = Parameter.forParameterList((List<? extends VariableElement>)parameterMap.get((Object)true));
        ImmutableSet<Parameter> passedParameters = Parameter.forParameterList((List<? extends VariableElement>)parameterMap.get((Object)false));
        return new FactoryMethodDescriptor.Builder(declaration).factoryName(declaration.getFactoryName(this.elements.getPackageOf(constructor).getQualifiedName(), classElement.getSimpleName())).name("create").returnType(returnType.toString()).publicMethod(constructor.getEnclosingElement().getModifiers().contains((Object)Modifier.PUBLIC)).providedParameters((Iterable<Parameter>)providedParameters).passedParameters((Iterable<Parameter>)passedParameters).creationParameters((Iterable<Parameter>)Parameter.forParameterList(constructor.getParameters())).build();
    }

    private ImmutableSet<FactoryMethodDescriptor> generateDescriptorForDefaultConstructor(AutoFactoryDeclaration declaration, TypeElement type) {
        return ImmutableSet.of((Object)new FactoryMethodDescriptor.Builder(declaration).factoryName(declaration.getFactoryName(this.elements.getPackageOf(type).getQualifiedName(), type.getSimpleName())).name("create").returnType(type.getQualifiedName().toString()).publicMethod(type.getModifiers().contains((Object)Modifier.PUBLIC)).passedParameters((Iterable<Parameter>)ImmutableSet.of()).creationParameters((Iterable<Parameter>)ImmutableSet.of()).providedParameters((Iterable<Parameter>)ImmutableSet.of()).build());
    }
}

