/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.factory.processor.AutoFactoryDeclaration;
import com.google.auto.factory.processor.Parameter;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

final class FactoryMethodDescriptor {
    private final AutoFactoryDeclaration declaration;
    private final String factoryName;
    private final String name;
    private final String returnType;
    private final boolean publicMethod;
    private final boolean override;
    private final ImmutableSet<Parameter> passedParameters;
    private final ImmutableSet<Parameter> providedParameters;
    private final ImmutableSet<Parameter> creationParameters;

    private FactoryMethodDescriptor(Builder builder) {
        this.declaration = builder.declaration;
        this.factoryName = (String)builder.factoryName.get();
        this.name = (String)builder.name.get();
        this.returnType = (String)builder.returnType.get();
        this.publicMethod = builder.publicMethod;
        this.override = builder.override;
        this.passedParameters = ImmutableSet.copyOf((Collection)builder.passedParameters);
        this.providedParameters = ImmutableSet.copyOf((Collection)builder.providedParameters);
        this.creationParameters = ImmutableSet.copyOf((Collection)builder.creationParameters);
        Preconditions.checkState((boolean)this.creationParameters.equals((Object)Sets.union(this.passedParameters, this.providedParameters)));
    }

    AutoFactoryDeclaration declaration() {
        return this.declaration;
    }

    String factoryName() {
        return this.factoryName;
    }

    String name() {
        return this.name;
    }

    String returnType() {
        return this.returnType;
    }

    public boolean publicMethod() {
        return this.publicMethod;
    }

    public boolean override() {
        return this.override;
    }

    ImmutableSet<Parameter> passedParameters() {
        return this.passedParameters;
    }

    ImmutableSet<Parameter> providedParameters() {
        return this.providedParameters;
    }

    ImmutableSet<Parameter> creationParameters() {
        return this.creationParameters;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("factoryName", (Object)this.factoryName).add("name", (Object)this.name).add("returnType", (Object)this.returnType).add("passed", this.passedParameters).add("provided", this.providedParameters).toString();
    }

    static final class Builder {
        private final AutoFactoryDeclaration declaration;
        private Optional<String> factoryName = Optional.absent();
        private Optional<String> name = Optional.absent();
        private Optional<String> returnType = Optional.absent();
        private boolean publicMethod = false;
        private boolean override = false;
        private final Set<Parameter> passedParameters = Sets.newLinkedHashSet();
        private final Set<Parameter> providedParameters = Sets.newLinkedHashSet();
        private final Set<Parameter> creationParameters = Sets.newLinkedHashSet();

        Builder(AutoFactoryDeclaration declaration) {
            this.declaration = (AutoFactoryDeclaration)Preconditions.checkNotNull((Object)declaration);
        }

        Builder factoryName(String factoryName) {
            this.factoryName = Optional.of((Object)factoryName);
            return this;
        }

        Builder name(String name) {
            this.name = Optional.of((Object)name);
            return this;
        }

        Builder returnType(String returnType) {
            this.returnType = Optional.of((Object)returnType);
            return this;
        }

        Builder publicMethod() {
            return this.publicMethod(true);
        }

        Builder publicMethod(boolean publicMethod) {
            this.publicMethod = publicMethod;
            return this;
        }

        Builder override() {
            this.override = true;
            return this;
        }

        Builder passedParameters(Iterable<Parameter> passedParameters) {
            Iterables.addAll(this.passedParameters, passedParameters);
            return this;
        }

        Builder providedParameters(Iterable<Parameter> providedParameters) {
            Iterables.addAll(this.providedParameters, providedParameters);
            return this;
        }

        Builder creationParameters(Iterable<Parameter> creationParameters) {
            Iterables.addAll(this.creationParameters, creationParameters);
            return this;
        }

        FactoryMethodDescriptor build() {
            return new FactoryMethodDescriptor(this);
        }
    }
}

