/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.factory.processor.AutoFactoryProcessor;
import com.google.auto.factory.processor.FactoryDescriptor;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.ImplementationMethodDescriptor;
import com.google.auto.factory.processor.Key;
import com.google.auto.factory.processor.Parameter;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.squareup.javawriter.JavaWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;

final class FactoryWriter {
    private final Filer filer;
    private static final Joiner argumentJoiner = Joiner.on((String)", ");

    FactoryWriter(Filer filer) {
        this.filer = filer;
    }

    void writeFactory(FactoryDescriptor descriptor) throws IOException {
        FluentIterable creationParameterNames;
        JavaFileObject sourceFile = this.filer.createSourceFile(descriptor.name(), new Element[0]);
        JavaWriter writer = new JavaWriter(sourceFile.openWriter());
        String packageName = FactoryWriter.getPackage(descriptor.name()).toString();
        writer.emitPackage(packageName).emitImports(new String[]{"javax.annotation.Generated"});
        writer.emitImports(new String[]{"javax.inject.Inject"});
        if (!descriptor.providerNames().isEmpty()) {
            writer.emitImports(new String[]{"javax.inject.Provider"});
        }
        for (String implementingType : descriptor.implementingTypes()) {
            String implementingPackageName = FactoryWriter.getPackage(implementingType).toString();
            if ("java.lang".equals(implementingPackageName) || packageName.equals(implementingPackageName)) continue;
            writer.emitImports(new String[]{implementingType});
        }
        String[] implementedClasses = (String[])FluentIterable.from(descriptor.implementingTypes()).transform((Function)new Function<String, String>(){

            public String apply(String implemetingClass) {
                return FactoryWriter.getSimpleName(implemetingClass).toString();
            }
        }).toSortedSet((Comparator)Ordering.natural()).toArray((Object[])new String[0]);
        String factoryName = FactoryWriter.getSimpleName(descriptor.name()).toString();
        writer.emitAnnotation(Generated.class, (Map)ImmutableMap.of((Object)"value", (Object)("\"" + AutoFactoryProcessor.class.getName() + "\"")));
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        if (!descriptor.allowSubclasses()) {
            modifiers.add(Modifier.FINAL);
        }
        if (descriptor.publicType()) {
            modifiers.add(Modifier.PUBLIC);
        }
        writer.beginType(factoryName, "class", modifiers, Object.class.getName().equals(descriptor.extendingType()) ? null : descriptor.extendingType(), implementedClasses);
        ImmutableList.Builder constructorTokens = ImmutableList.builder();
        for (Map.Entry entry : descriptor.providerNames().entrySet()) {
            Key key = (Key)entry.getKey();
            String providerName = (String)entry.getValue();
            writer.emitField("Provider<" + key.getType() + ">", providerName, EnumSet.of(Modifier.PRIVATE, Modifier.FINAL));
            Optional<String> qualifier = key.getQualifier();
            String qualifierPrefix = qualifier.isPresent() ? "@" + (String)qualifier.get() + " " : "";
            constructorTokens.add((Object)(qualifierPrefix + "Provider<" + key.getType() + ">")).add((Object)providerName);
        }
        writer.emitAnnotation("Inject");
        writer.beginMethod(null, factoryName, descriptor.publicType() ? EnumSet.of(Modifier.PUBLIC) : EnumSet.noneOf(Modifier.class), (String[])constructorTokens.build().toArray((Object[])new String[0]));
        for (String providerName : descriptor.providerNames().values()) {
            writer.emitStatement("this.%1$s = %1$s", new Object[]{providerName});
        }
        writer.endMethod();
        for (Object methodDescriptor : descriptor.methodDescriptors()) {
            writer.beginMethod(((FactoryMethodDescriptor)methodDescriptor).returnType(), ((FactoryMethodDescriptor)methodDescriptor).name(), ((FactoryMethodDescriptor)methodDescriptor).publicMethod() ? EnumSet.of(Modifier.PUBLIC) : EnumSet.noneOf(Modifier.class), FactoryWriter.parameterTokens(((FactoryMethodDescriptor)methodDescriptor).passedParameters()));
            creationParameterNames = FluentIterable.from(((FactoryMethodDescriptor)methodDescriptor).creationParameters()).transform((Function)new Function<Parameter, String>((FactoryMethodDescriptor)methodDescriptor, descriptor){
                final /* synthetic */ FactoryMethodDescriptor val$methodDescriptor;
                final /* synthetic */ FactoryDescriptor val$descriptor;
                {
                    this.val$methodDescriptor = factoryMethodDescriptor;
                    this.val$descriptor = factoryDescriptor;
                }

                public String apply(Parameter parameter) {
                    return this.val$methodDescriptor.passedParameters().contains((Object)parameter) ? parameter.name() : (String)this.val$descriptor.providerNames().get((Object)parameter.asKey()) + ".get()";
                }
            });
            writer.emitStatement("return new %s(%s)", new Object[]{writer.compressType(((FactoryMethodDescriptor)methodDescriptor).returnType()), argumentJoiner.join((Iterable)creationParameterNames)});
            writer.endMethod();
        }
        for (Object methodDescriptor : descriptor.implementationMethodDescriptors()) {
            writer.emitAnnotation(Override.class);
            writer.beginMethod(((ImplementationMethodDescriptor)methodDescriptor).returnType(), ((ImplementationMethodDescriptor)methodDescriptor).name(), ((ImplementationMethodDescriptor)methodDescriptor).publicMethod() ? EnumSet.of(Modifier.PUBLIC) : EnumSet.noneOf(Modifier.class), FactoryWriter.parameterTokens(((ImplementationMethodDescriptor)methodDescriptor).passedParameters()));
            creationParameterNames = FluentIterable.from(((ImplementationMethodDescriptor)methodDescriptor).passedParameters()).transform((Function)new Function<Parameter, String>(){

                public String apply(Parameter parameter) {
                    return parameter.name();
                }
            });
            writer.emitStatement("return create(%s)", new Object[]{argumentJoiner.join((Iterable)creationParameterNames)});
            writer.endMethod();
        }
        writer.endType();
        writer.close();
    }

    private static String[] parameterTokens(Collection<Parameter> parameters) {
        ArrayList parameterTokens = Lists.newArrayListWithCapacity((int)parameters.size());
        for (Parameter parameter : parameters) {
            parameterTokens.add(parameter.type());
            parameterTokens.add(parameter.name());
        }
        return parameterTokens.toArray(new String[0]);
    }

    private static CharSequence getSimpleName(CharSequence fullyQualifiedName) {
        int lastDot = FactoryWriter.lastIndexOf(fullyQualifiedName, '.');
        return fullyQualifiedName.subSequence(lastDot + 1, fullyQualifiedName.length());
    }

    private static CharSequence getPackage(CharSequence fullyQualifiedName) {
        int lastDot = FactoryWriter.lastIndexOf(fullyQualifiedName, '.');
        return fullyQualifiedName.subSequence(0, lastDot);
    }

    private static int lastIndexOf(CharSequence charSequence, char c) {
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            if (charSequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

