/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.factory.processor.Key;
import com.google.auto.factory.processor.Mirrors;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class Parameter {
    private final Optional<String> qualifier;
    private final String type;
    private final String name;

    private Parameter(Optional<String> qualifier, String type, String name) {
        this.qualifier = (Optional)Preconditions.checkNotNull(qualifier);
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    Optional<String> qualifier() {
        return this.qualifier;
    }

    String type() {
        return this.type;
    }

    Key asKey() {
        return new Key(this.qualifier, this.type);
    }

    String name() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Parameter) {
            Parameter that = (Parameter)obj;
            return this.type.equals(that.type) && this.name.equals(that.name) && this.qualifier.equals(that.qualifier);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.name, this.qualifier});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append('\'');
        if (this.qualifier.isPresent()) {
            builder.append((String)this.qualifier.get()).append(' ');
        }
        builder.append(this.type).append(' ').append(this.name).append('\'');
        return builder.toString();
    }

    static Parameter forVariableElement(VariableElement variable, TypeMirror type) {
        ImmutableSet.Builder qualifiers = ImmutableSet.builder();
        for (AnnotationMirror annotationMirror : variable.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (annotationType.asElement().getAnnotation(Qualifier.class) == null) continue;
            qualifiers.add((Object)Mirrors.getQualifiedName(annotationType).toString());
        }
        return new Parameter((Optional<String>)FluentIterable.from((Iterable)qualifiers.build()).first(), type.toString(), variable.getSimpleName().toString());
    }

    static ImmutableSet<Parameter> forParameterList(List<? extends VariableElement> variables, List<? extends TypeMirror> variableTypes) {
        Preconditions.checkArgument((variables.size() == variableTypes.size() ? 1 : 0) != 0);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        HashSet names = Sets.newHashSetWithExpectedSize((int)variables.size());
        for (int i = 0; i < variables.size(); ++i) {
            Parameter parameter = Parameter.forVariableElement(variables.get(i), variableTypes.get(i));
            Preconditions.checkArgument((boolean)names.add(parameter.name));
            builder.add((Object)parameter);
        }
        ImmutableSet parameters = builder.build();
        Preconditions.checkArgument((variables.size() == parameters.size() ? 1 : 0) != 0);
        return parameters;
    }

    static ImmutableSet<Parameter> forParameterList(List<? extends VariableElement> variables) {
        ArrayList variableTypes = Lists.newArrayListWithExpectedSize((int)variables.size());
        for (VariableElement variableElement : variables) {
            variableTypes.add(variableElement.asType());
        }
        return Parameter.forParameterList(variables, variableTypes);
    }
}

