/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.factory.AutoFactory;
import com.google.auto.factory.Provided;
import com.google.auto.factory.processor.AutoFactoryDeclaration;
import com.google.auto.factory.processor.Elements2;
import com.google.auto.factory.processor.FactoryDescriptor;
import com.google.auto.factory.processor.FactoryDescriptorGenerator;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.FactoryWriter;
import com.google.auto.factory.processor.ImplementationMethodDescriptor;
import com.google.auto.factory.processor.Parameter;
import com.google.auto.factory.processor.ProvidedChecker;
import com.google.auto.service.AutoService;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public final class AutoFactoryProcessor
extends AbstractProcessor {
    private FactoryDescriptorGenerator factoryDescriptorGenerator;
    private AutoFactoryDeclaration.Factory declarationFactory;
    private ProvidedChecker providedChecker;
    private Messager messager;
    private Elements elements;
    private Types types;
    private FactoryWriter factoryWriter;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        this.factoryWriter = new FactoryWriter(processingEnv.getFiler());
        this.providedChecker = new ProvidedChecker(this.messager);
        this.declarationFactory = new AutoFactoryDeclaration.Factory(this.elements, this.messager);
        this.factoryDescriptorGenerator = new FactoryDescriptorGenerator(this.messager, this.types, this.declarationFactory);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.doProcess(roundEnv);
        }
        catch (Throwable e) {
            String string = String.valueOf(Throwables.getStackTraceAsString((Throwable)e));
            this.messager.printMessage(Diagnostic.Kind.ERROR, string.length() != 0 ? "Failed to process @AutoFactory annotations:\n".concat(string) : new String("Failed to process @AutoFactory annotations:\n"));
        }
        return false;
    }

    private void doProcess(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Provided.class)) {
            this.providedChecker.checkProvidedParameter(element);
        }
        ImmutableListMultimap.Builder indexedMethods = ImmutableListMultimap.builder();
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Element element : roundEnv.getElementsAnnotatedWith(AutoFactory.class)) {
            Optional<AutoFactoryDeclaration> declaration = this.declarationFactory.createIfValid(element);
            if (declaration.isPresent()) {
                Iterator passedParameters;
                String factoryName = ((AutoFactoryDeclaration)declaration.get()).getFactoryName();
                TypeElement extendingType = ((AutoFactoryDeclaration)declaration.get()).extendingType();
                List<ExecutableElement> supertypeMethods = ElementFilter.methodsIn(this.elements.getAllMembers(extendingType));
                for (ExecutableElement supertypeMethod : supertypeMethods) {
                    if (!supertypeMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                    ExecutableType methodType = Elements2.getExecutableElementAsMemberOf(this.types, supertypeMethod, extendingType);
                    passedParameters = Parameter.forParameterList(supertypeMethod.getParameters(), methodType.getParameterTypes(), this.types);
                    builder.put((Object)factoryName, (Object)new ImplementationMethodDescriptor.Builder().name(supertypeMethod.getSimpleName().toString()).returnType(this.getAnnotatedType(element).getQualifiedName().toString()).publicMethod().passedParameters((Iterable<Parameter>)((Object)passedParameters)).build());
                }
                for (TypeElement implementingType : ((AutoFactoryDeclaration)declaration.get()).implementingTypes()) {
                    List<ExecutableElement> interfaceMethods = ElementFilter.methodsIn(this.elements.getAllMembers(implementingType));
                    passedParameters = interfaceMethods.iterator();
                    while (passedParameters.hasNext()) {
                        ExecutableElement interfaceMethod = (ExecutableElement)passedParameters.next();
                        if (!interfaceMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                        ExecutableType methodType = Elements2.getExecutableElementAsMemberOf(this.types, interfaceMethod, implementingType);
                        ImmutableSet<Parameter> passedParameters2 = Parameter.forParameterList(interfaceMethod.getParameters(), methodType.getParameterTypes(), this.types);
                        builder.put((Object)factoryName, (Object)new ImplementationMethodDescriptor.Builder().name(interfaceMethod.getSimpleName().toString()).returnType(this.getAnnotatedType(element).getQualifiedName().toString()).publicMethod().passedParameters((Iterable<Parameter>)passedParameters2).build());
                    }
                }
            }
            ImmutableSet<FactoryMethodDescriptor> descriptors = this.factoryDescriptorGenerator.generateDescriptor(element);
            indexedMethods.putAll((Multimap)Multimaps.index(descriptors, (Function)new Function<FactoryMethodDescriptor, String>(){

                public String apply(FactoryMethodDescriptor descriptor) {
                    return descriptor.factoryName();
                }
            }));
        }
        ImmutableSetMultimap implementationMethodDescriptors = builder.build();
        for (Map.Entry entry : indexedMethods.build().asMap().entrySet()) {
            ImmutableSet.Builder extending = ImmutableSet.builder();
            ImmutableSortedSet.Builder implementing = ImmutableSortedSet.naturalOrder();
            boolean publicType = false;
            Boolean allowSubclasses = null;
            boolean skipCreation = false;
            for (FactoryMethodDescriptor methodDescriptor : (Collection)entry.getValue()) {
                extending.add((Object)methodDescriptor.declaration().extendingType().getQualifiedName().toString());
                for (TypeElement implementingType : methodDescriptor.declaration().implementingTypes()) {
                    implementing.add((Object)implementingType.getQualifiedName().toString());
                }
                publicType |= methodDescriptor.publicMethod();
                if (allowSubclasses == null) {
                    allowSubclasses = methodDescriptor.declaration().allowSubclasses();
                    continue;
                }
                if (allowSubclasses.equals(methodDescriptor.declaration().allowSubclasses())) continue;
                skipCreation = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Cannot mix allowSubclasses=true and allowSubclasses=false in one factory.", methodDescriptor.declaration().target(), methodDescriptor.declaration().mirror(), (AnnotationValue)methodDescriptor.declaration().valuesMap().get((Object)"allowSubclasses"));
            }
            if (skipCreation) continue;
            try {
                this.factoryWriter.writeFactory(new FactoryDescriptor((String)entry.getKey(), (String)Iterables.getOnlyElement((Iterable)extending.build()), (ImmutableSortedSet<String>)implementing.build(), publicType, (ImmutableSet<FactoryMethodDescriptor>)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())), (ImmutableSet<ImplementationMethodDescriptor>)implementationMethodDescriptors.get(entry.getKey()), allowSubclasses));
            }
            catch (IOException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "failed");
            }
        }
    }

    private TypeElement getAnnotatedType(Element element) {
        Object types = ImmutableList.of();
        while (types.isEmpty()) {
            types = ElementFilter.typesIn(Arrays.asList(element));
            element = element.getEnclosingElement();
        }
        return (TypeElement)Iterables.getOnlyElement((Iterable)types);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AutoFactory.class.getName(), (Object)Provided.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

