/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;

final class Elements2 {
    private Elements2() {
    }

    static ImmutableSet<ExecutableElement> getConstructors(TypeElement type) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkArgument((type.getKind() == ElementKind.CLASS ? 1 : 0) != 0);
        return ImmutableSet.copyOf(ElementFilter.constructorsIn(type.getEnclosedElements()));
    }

    static boolean isValidSupertypeForClass(TypeElement type) {
        if (!type.getKind().equals((Object)ElementKind.CLASS)) {
            return false;
        }
        if (type.getModifiers().contains((Object)Modifier.FINAL)) {
            return false;
        }
        if (!type.getEnclosingElement().getKind().equals((Object)ElementKind.PACKAGE) && !type.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        return type.getSimpleName().length() != 0;
    }

    static ExecutableType getExecutableElementAsMemberOf(Types types, ExecutableElement executableElement, TypeElement subTypeElement) {
        Preconditions.checkNotNull((Object)types);
        Preconditions.checkNotNull((Object)executableElement);
        Preconditions.checkNotNull((Object)subTypeElement);
        TypeMirror subTypeMirror = subTypeElement.asType();
        if (!subTypeMirror.getKind().equals((Object)TypeKind.DECLARED)) {
            throw new IllegalStateException("Expected subTypeElement.asType() to return a class/interface type.");
        }
        TypeMirror subExecutableTypeMirror = types.asMemberOf((DeclaredType)subTypeMirror, executableElement);
        if (!subExecutableTypeMirror.getKind().equals((Object)TypeKind.EXECUTABLE)) {
            throw new IllegalStateException("Expected subExecutableTypeMirror to be an executable type.");
        }
        return (ExecutableType)subExecutableTypeMirror;
    }
}

