/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.factory.processor.Parameter;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

final class ImplementationMethodDescriptor {
    private final String name;
    private final String returnType;
    private final boolean publicMethod;
    private final ImmutableSet<Parameter> passedParameters;

    private ImplementationMethodDescriptor(Builder builder) {
        this.name = (String)builder.name.get();
        this.returnType = (String)builder.returnType.get();
        this.publicMethod = builder.publicMethod;
        this.passedParameters = ImmutableSet.copyOf((Collection)builder.passedParameters);
    }

    String name() {
        return this.name;
    }

    String returnType() {
        return this.returnType;
    }

    boolean publicMethod() {
        return this.publicMethod;
    }

    ImmutableSet<Parameter> passedParameters() {
        return this.passedParameters;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("returnType", (Object)this.returnType).add("publicMethod", this.publicMethod).add("passedParameters", this.passedParameters).toString();
    }

    static final class Builder {
        private Optional<String> name = Optional.absent();
        private Optional<String> returnType = Optional.absent();
        private boolean publicMethod = false;
        private final Set<Parameter> passedParameters = Sets.newLinkedHashSet();

        Builder() {
        }

        Builder name(String name) {
            this.name = Optional.of((Object)name);
            return this;
        }

        Builder returnType(String returnType) {
            this.returnType = Optional.of((Object)returnType);
            return this;
        }

        Builder publicMethod() {
            return this.publicMethod(true);
        }

        Builder publicMethod(boolean publicMethod) {
            this.publicMethod = publicMethod;
            return this;
        }

        Builder passedParameters(Iterable<Parameter> passedParameters) {
            Iterables.addAll(this.passedParameters, passedParameters);
            return this;
        }

        ImplementationMethodDescriptor build() {
            return new ImplementationMethodDescriptor(this);
        }
    }
}

