/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.SimpleElementVisitor6;

final class Mirrors {
    private Mirrors() {
    }

    static Name getQualifiedName(DeclaredType type) {
        return type.asElement().accept(new SimpleElementVisitor6<Name, Void>(){

            @Override
            protected Name defaultAction(Element e, Void p) {
                throw new AssertionError((Object)"DeclaredTypes should be TypeElements");
            }

            @Override
            public Name visitType(TypeElement e, Void p) {
                return e.getQualifiedName();
            }
        }, null);
    }

    static ImmutableMap<String, AnnotationValue> simplifyAnnotationValueMap(Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValueMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationValueMap.entrySet()) {
            builder.put((Object)entry.getKey().getSimpleName().toString(), (Object)entry.getValue());
        }
        return builder.build();
    }

    static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationType) {
        String annotationName = annotationType.getName();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!Mirrors.getQualifiedName(annotationMirror.getAnnotationType()).contentEquals(annotationName)) continue;
            return Optional.of((Object)annotationMirror);
        }
        return Optional.absent();
    }
}

