/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.google.auto.factory.processor.Key;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Provider;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

final class Parameter {
    private final String type;
    private final String name;
    private final boolean providerOfType;
    private final Key key;

    private Parameter(String type, Key key, String name, boolean providerOfType) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.key = (Key)Preconditions.checkNotNull((Object)key);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.providerOfType = providerOfType;
    }

    String type() {
        return this.type;
    }

    Key key() {
        return this.key;
    }

    String name() {
        return this.name;
    }

    boolean providerOfType() {
        return this.providerOfType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Parameter) {
            Parameter that = (Parameter)obj;
            return this.type.equals(that.type) && this.key.equals(that.key) && this.name.equals(that.name) && this.providerOfType == that.providerOfType;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.key, this.name, this.providerOfType});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append('\'');
        if (this.key.getQualifier().isPresent()) {
            builder.append(this.key.getQualifier().get()).append(' ');
        }
        if (this.providerOfType) {
            builder.append("Provider<");
        }
        builder.append(this.type);
        if (this.providerOfType) {
            builder.append('>');
        }
        builder.append(' ').append(this.name).append('\'');
        return builder.toString();
    }

    static Parameter forVariableElement(VariableElement variable, TypeMirror type, Types types) {
        ImmutableSet.Builder qualifiers = ImmutableSet.builder();
        for (AnnotationMirror annotationMirror : variable.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!MoreElements.isAnnotationPresent((Element)annotationType.asElement(), Qualifier.class)) continue;
            qualifiers.add((Object)annotationMirror);
        }
        boolean provider = MoreTypes.isType((TypeMirror)type) && MoreTypes.isTypeOf(Provider.class, (TypeMirror)type);
        TypeMirror typeMirror = provider ? MoreTypes.asDeclared((TypeMirror)type).getTypeArguments().get(0) : type;
        Optional qualifier = FluentIterable.from((Iterable)qualifiers.build()).first();
        Key key = new Key((Optional<AnnotationMirror>)qualifier, Parameter.boxedType(typeMirror, types).toString());
        return new Parameter(typeMirror.toString(), key, variable.getSimpleName().toString(), provider);
    }

    private static TypeMirror boxedType(TypeMirror type, Types types) {
        return type.getKind().isPrimitive() ? types.boxedClass(MoreTypes.asPrimitiveType((TypeMirror)type)).asType() : type;
    }

    static ImmutableSet<Parameter> forParameterList(List<? extends VariableElement> variables, List<? extends TypeMirror> variableTypes, Types types) {
        Preconditions.checkArgument((variables.size() == variableTypes.size() ? 1 : 0) != 0);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        HashSet names = Sets.newHashSetWithExpectedSize((int)variables.size());
        for (int i = 0; i < variables.size(); ++i) {
            Parameter parameter = Parameter.forVariableElement(variables.get(i), variableTypes.get(i), types);
            Preconditions.checkArgument((boolean)names.add(parameter.name));
            builder.add((Object)parameter);
        }
        ImmutableSet parameters = builder.build();
        Preconditions.checkArgument((variables.size() == parameters.size() ? 1 : 0) != 0);
        return parameters;
    }

    static ImmutableSet<Parameter> forParameterList(List<? extends VariableElement> variables, Types types) {
        ArrayList variableTypes = Lists.newArrayListWithExpectedSize((int)variables.size());
        for (VariableElement variableElement : variables) {
            variableTypes.add(variableElement.asType());
        }
        return Parameter.forParameterList(variables, variableTypes, types);
    }
}

