/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.factory.processor.AutoValue_Parameter;
import com.google.auto.factory.processor.Key;
import com.google.auto.factory.processor.Mirrors;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

abstract class Parameter {
    static final Function<Parameter, TypeMirror> TYPE = new Function<Parameter, TypeMirror>(){

        public TypeMirror apply(Parameter parameter) {
            return parameter.type();
        }
    };

    Parameter() {
    }

    abstract TypeMirror type();

    abstract String name();

    abstract Key key();

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> nullableWrapper();

    Optional<AnnotationMirror> nullable() {
        return Mirrors.unwrapOptionalEquivalence(this.nullableWrapper());
    }

    static Parameter forVariableElement(VariableElement variable, TypeMirror type, Types types) {
        Optional nullable = Optional.absent();
        List<? extends AnnotationMirror> annotations = variable.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")) continue;
            nullable = Optional.of((Object)annotationMirror);
            break;
        }
        Key key = Key.create(type, annotations, types);
        return new AutoValue_Parameter(type, variable.getSimpleName().toString(), key, Mirrors.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), nullable));
    }

    static ImmutableSet<Parameter> forParameterList(List<? extends VariableElement> variables, List<? extends TypeMirror> variableTypes, Types types) {
        Preconditions.checkArgument((variables.size() == variableTypes.size() ? 1 : 0) != 0);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        HashSet names = Sets.newHashSetWithExpectedSize((int)variables.size());
        for (int i = 0; i < variables.size(); ++i) {
            Parameter parameter = Parameter.forVariableElement(variables.get(i), variableTypes.get(i), types);
            Preconditions.checkArgument((boolean)names.add(parameter.name()));
            builder.add((Object)parameter);
        }
        ImmutableSet parameters = builder.build();
        Preconditions.checkArgument((variables.size() == parameters.size() ? 1 : 0) != 0);
        return parameters;
    }

    static ImmutableSet<Parameter> forParameterList(List<? extends VariableElement> variables, Types types) {
        ArrayList variableTypes = Lists.newArrayListWithExpectedSize((int)variables.size());
        for (VariableElement variableElement : variables) {
            variableTypes.add(variableElement.asType());
        }
        return Parameter.forParameterList(variables, variableTypes, types);
    }
}

