/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.MoreTypes;
import com.google.auto.factory.AutoFactory;
import com.google.auto.factory.Provided;
import com.google.auto.factory.processor.AutoFactoryDeclaration;
import com.google.auto.factory.processor.Elements2;
import com.google.auto.factory.processor.FactoryDescriptor;
import com.google.auto.factory.processor.FactoryDescriptorGenerator;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.FactoryWriter;
import com.google.auto.factory.processor.ImplementationMethodDescriptor;
import com.google.auto.factory.processor.Parameter;
import com.google.auto.factory.processor.ProvidedChecker;
import com.google.auto.service.AutoService;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.googlejavaformat.java.filer.FormattingFiler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public final class AutoFactoryProcessor
extends AbstractProcessor {
    private FactoryDescriptorGenerator factoryDescriptorGenerator;
    private AutoFactoryDeclaration.Factory declarationFactory;
    private ProvidedChecker providedChecker;
    private Messager messager;
    private Elements elements;
    private Types types;
    private FactoryWriter factoryWriter;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        this.factoryWriter = new FactoryWriter((Filer)new FormattingFiler(processingEnv.getFiler()));
        this.providedChecker = new ProvidedChecker(this.messager);
        this.declarationFactory = new AutoFactoryDeclaration.Factory(this.elements, this.messager);
        this.factoryDescriptorGenerator = new FactoryDescriptorGenerator(this.messager, this.types, this.declarationFactory);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.doProcess(roundEnv);
        }
        catch (Throwable e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to process @AutoFactory annotations:\n" + Throwables.getStackTraceAsString((Throwable)e));
        }
        return false;
    }

    private void doProcess(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Provided.class)) {
            this.providedChecker.checkProvidedParameter(element);
        }
        ImmutableListMultimap.Builder indexedMethods = ImmutableListMultimap.builder();
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Element element : roundEnv.getElementsAnnotatedWith(AutoFactory.class)) {
            Optional<AutoFactoryDeclaration> declaration = this.declarationFactory.createIfValid(element);
            if (declaration.isPresent()) {
                String factoryName = ((AutoFactoryDeclaration)declaration.get()).getFactoryName();
                TypeElement extendingType = ((AutoFactoryDeclaration)declaration.get()).extendingType();
                builder.putAll((Object)factoryName, this.implementationMethods(extendingType, element));
                for (TypeElement implementingType : ((AutoFactoryDeclaration)declaration.get()).implementingTypes()) {
                    builder.putAll((Object)factoryName, this.implementationMethods(implementingType, element));
                }
            }
            ImmutableSet<FactoryMethodDescriptor> descriptors = this.factoryDescriptorGenerator.generateDescriptor(element);
            for (FactoryMethodDescriptor descriptor : descriptors) {
                indexedMethods.put((Object)descriptor.factoryName(), (Object)descriptor);
            }
        }
        ImmutableSetMultimap implementationMethodDescriptors = builder.build();
        for (Map.Entry entry : indexedMethods.build().asMap().entrySet()) {
            ImmutableSet.Builder extending = ImmutableSet.builder();
            ImmutableSortedSet.Builder implementing = ImmutableSortedSet.orderedBy((Comparator)new Comparator<TypeMirror>(){

                @Override
                public int compare(TypeMirror first, TypeMirror second) {
                    String firstName = MoreTypes.asTypeElement((TypeMirror)first).getQualifiedName().toString();
                    String secondName = MoreTypes.asTypeElement((TypeMirror)second).getQualifiedName().toString();
                    return firstName.compareTo(secondName);
                }
            });
            boolean publicType = false;
            Boolean allowSubclasses = null;
            boolean skipCreation = false;
            for (FactoryMethodDescriptor methodDescriptor : (Collection)entry.getValue()) {
                extending.add((Object)methodDescriptor.declaration().extendingType().asType());
                for (TypeElement implementingType : methodDescriptor.declaration().implementingTypes()) {
                    implementing.add((Object)implementingType.asType());
                }
                publicType |= methodDescriptor.publicMethod();
                if (allowSubclasses == null) {
                    allowSubclasses = methodDescriptor.declaration().allowSubclasses();
                    continue;
                }
                if (allowSubclasses.equals(methodDescriptor.declaration().allowSubclasses())) continue;
                skipCreation = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Cannot mix allowSubclasses=true and allowSubclasses=false in one factory.", methodDescriptor.declaration().target(), methodDescriptor.declaration().mirror(), (AnnotationValue)methodDescriptor.declaration().valuesMap().get((Object)"allowSubclasses"));
            }
            if (skipCreation) continue;
            try {
                this.factoryWriter.writeFactory(FactoryDescriptor.create((String)entry.getKey(), (TypeMirror)Iterables.getOnlyElement((Iterable)extending.build()), (ImmutableSet<TypeMirror>)implementing.build(), publicType, (ImmutableSet<FactoryMethodDescriptor>)ImmutableSet.copyOf((Collection)((Collection)entry.getValue())), (ImmutableSet<ImplementationMethodDescriptor>)implementationMethodDescriptors.get(entry.getKey()), allowSubclasses));
            }
            catch (IOException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "failed");
            }
        }
    }

    private ImmutableSet<ImplementationMethodDescriptor> implementationMethods(TypeElement supertype, Element autoFactoryElement) {
        ImmutableSet.Builder implementationMethodsBuilder = ImmutableSet.builder();
        for (ExecutableElement implementationMethod : ElementFilter.methodsIn(this.elements.getAllMembers(supertype))) {
            if (!implementationMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            ExecutableType methodType = Elements2.getExecutableElementAsMemberOf(this.types, implementationMethod, supertype);
            ImmutableSet<Parameter> passedParameters = Parameter.forParameterList(implementationMethod.getParameters(), methodType.getParameterTypes(), this.types);
            implementationMethodsBuilder.add((Object)ImplementationMethodDescriptor.builder().name(implementationMethod.getSimpleName().toString()).returnType(this.getAnnotatedType(autoFactoryElement)).publicMethod().passedParameters((Iterable<Parameter>)passedParameters).isVarArgs(implementationMethod.isVarArgs()).build());
        }
        return implementationMethodsBuilder.build();
    }

    private TypeMirror getAnnotatedType(Element element) {
        Object types = ImmutableList.of();
        while (types.isEmpty()) {
            types = ElementFilter.typesIn(Arrays.asList(element));
            element = element.getEnclosingElement();
        }
        return ((TypeElement)Iterables.getOnlyElement((Iterable)types)).asType();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AutoFactory.class.getName(), (Object)Provided.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

