/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.factory.processor.AutoFactoryProcessor;
import com.google.auto.factory.processor.FactoryDescriptor;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.ImplementationMethodDescriptor;
import com.google.auto.factory.processor.Mirrors;
import com.google.auto.factory.processor.Parameter;
import com.google.auto.factory.processor.ProviderField;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

final class FactoryWriter {
    private final Filer filer;
    private static final Joiner ARGUMENT_JOINER = Joiner.on((String)", ");

    FactoryWriter(Filer filer) {
        this.filer = filer;
    }

    void writeFactory(FactoryDescriptor descriptor) throws IOException {
        String factoryName = FactoryWriter.getSimpleName(descriptor.name()).toString();
        TypeSpec.Builder factory = TypeSpec.classBuilder((String)factoryName);
        factory.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{AutoFactoryProcessor.class.getName()}).addMember("comments", "$S", new Object[]{"https://github.com/google/auto/tree/master/factory"}).build());
        if (!descriptor.allowSubclasses()) {
            factory.addModifiers(new Modifier[]{Modifier.FINAL});
        }
        if (descriptor.publicType()) {
            factory.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        factory.superclass(TypeName.get((TypeMirror)descriptor.extendingType()));
        for (TypeMirror implementingType : descriptor.implementingTypes()) {
            factory.addSuperinterface(TypeName.get((TypeMirror)implementingType));
        }
        this.addConstructorAndProviderFields(factory, descriptor);
        this.addFactoryMethods(factory, descriptor);
        this.addImplementationMethods(factory, descriptor);
        FactoryWriter.addCheckNotNullMethod(factory, descriptor);
        JavaFile.builder((String)FactoryWriter.getPackage(descriptor.name()), (TypeSpec)factory.build()).skipJavaLangImports(true).build().writeTo(this.filer);
    }

    private void addConstructorAndProviderFields(TypeSpec.Builder factory, FactoryDescriptor descriptor) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addAnnotation(Inject.class);
        if (descriptor.publicType()) {
            constructor.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
        UnmodifiableIterator providerFields = descriptor.providers().values().iterator();
        int argumentIndex = 1;
        while (providerFields.hasNext()) {
            ProviderField provider = (ProviderField)providerFields.next();
            TypeName typeName = TypeName.get((TypeMirror)provider.key().type()).box();
            ParameterizedTypeName providerType = ParameterizedTypeName.get((ClassName)ClassName.get(Provider.class), (TypeName[])new TypeName[]{typeName});
            factory.addField((TypeName)providerType, provider.name(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            if (provider.key().qualifier().isPresent()) {
                providerType = providerType.annotated(new AnnotationSpec[]{AnnotationSpec.get((AnnotationMirror)((AnnotationMirror)provider.key().qualifier().get()))});
            }
            constructor.addParameter((TypeName)providerType, provider.name(), new Modifier[0]);
            constructor.addStatement("this.$1L = checkNotNull($1L, $2L)", new Object[]{provider.name(), argumentIndex});
            ++argumentIndex;
        }
        factory.addMethod(constructor.build());
    }

    private void addFactoryMethods(TypeSpec.Builder factory, FactoryDescriptor descriptor) {
        for (FactoryMethodDescriptor methodDescriptor : descriptor.methodDescriptors()) {
            MethodSpec.Builder method = MethodSpec.methodBuilder((String)methodDescriptor.name()).returns(TypeName.get((TypeMirror)methodDescriptor.returnType())).varargs(methodDescriptor.isVarArgs());
            if (methodDescriptor.overridingMethod()) {
                method.addAnnotation(Override.class);
            }
            if (methodDescriptor.publicMethod()) {
                method.addModifiers(new Modifier[]{Modifier.PUBLIC});
            }
            CodeBlock.Builder args = CodeBlock.builder();
            method.addParameters(FactoryWriter.parameters(methodDescriptor.passedParameters()));
            UnmodifiableIterator parameters = methodDescriptor.creationParameters().iterator();
            int argumentIndex = 1;
            while (parameters.hasNext()) {
                CodeBlock argument;
                boolean checkNotNull;
                Parameter parameter = (Parameter)parameters.next();
                boolean bl = checkNotNull = !parameter.nullable().isPresent();
                if (methodDescriptor.passedParameters().contains((Object)parameter)) {
                    argument = CodeBlock.of((String)parameter.name(), (Object[])new Object[0]);
                    if (parameter.type().getKind().isPrimitive()) {
                        checkNotNull = false;
                    }
                } else {
                    ProviderField provider = (ProviderField)descriptor.providers().get((Object)parameter.key());
                    argument = CodeBlock.of((String)provider.name(), (Object[])new Object[0]);
                    if (Mirrors.isProvider(parameter.type())) {
                        checkNotNull = false;
                    } else {
                        argument = CodeBlock.of((String)"$L.get()", (Object[])new Object[]{argument});
                    }
                }
                if (checkNotNull) {
                    argument = CodeBlock.of((String)"checkNotNull($L, $L)", (Object[])new Object[]{argument, argumentIndex});
                }
                args.add(argument);
                if (parameters.hasNext()) {
                    args.add(", ", new Object[0]);
                }
                ++argumentIndex;
            }
            method.addStatement("return new $T($L)", new Object[]{methodDescriptor.returnType(), args.build()});
            factory.addMethod(method.build());
        }
    }

    private void addImplementationMethods(TypeSpec.Builder factory, FactoryDescriptor descriptor) {
        for (ImplementationMethodDescriptor methodDescriptor : descriptor.implementationMethodDescriptors()) {
            MethodSpec.Builder implementationMethod = MethodSpec.methodBuilder((String)methodDescriptor.name()).addAnnotation(Override.class).returns(TypeName.get((TypeMirror)methodDescriptor.returnType())).varargs(methodDescriptor.isVarArgs());
            if (methodDescriptor.publicMethod()) {
                implementationMethod.addModifiers(new Modifier[]{Modifier.PUBLIC});
            }
            implementationMethod.addParameters(FactoryWriter.parameters(methodDescriptor.passedParameters()));
            implementationMethod.addStatement("return create($L)", new Object[]{FluentIterable.from(methodDescriptor.passedParameters()).transform((Function)new Function<Parameter, String>(){

                public String apply(Parameter parameter) {
                    return parameter.name();
                }
            }).join(ARGUMENT_JOINER)});
            factory.addMethod(implementationMethod.build());
        }
    }

    private static Iterable<ParameterSpec> parameters(Iterable<Parameter> parameters) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : parameters) {
            ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)parameter.type()), (String)parameter.name(), (Modifier[])new Modifier[0]);
            for (AnnotationMirror annotation : Iterables.concat((Iterable)parameter.nullable().asSet(), (Iterable)parameter.key().qualifier().asSet())) {
                parameterBuilder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotation));
            }
            builder.add((Object)parameterBuilder.build());
        }
        return builder.build();
    }

    private static void addCheckNotNullMethod(TypeSpec.Builder factory, FactoryDescriptor descriptor) {
        if (FactoryWriter.shouldGenerateCheckNotNull(descriptor)) {
            TypeVariableName typeVariable = TypeVariableName.get((String)"T");
            factory.addMethod(MethodSpec.methodBuilder((String)"checkNotNull").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addTypeVariable(typeVariable).returns((TypeName)typeVariable).addParameter((TypeName)typeVariable, "reference", new Modifier[0]).addParameter(TypeName.INT, "argumentIndex", new Modifier[0]).beginControlFlow("if (reference == null)", new Object[0]).addStatement("throw new $T($S + argumentIndex)", new Object[]{NullPointerException.class, "@AutoFactory method argument is null but is not marked @Nullable. Argument index: "}).endControlFlow().addStatement("return reference", new Object[0]).build());
        }
    }

    private static boolean shouldGenerateCheckNotNull(FactoryDescriptor descriptor) {
        if (!descriptor.providers().isEmpty()) {
            return true;
        }
        for (FactoryMethodDescriptor method : descriptor.methodDescriptors()) {
            for (Parameter parameter : method.creationParameters()) {
                if (parameter.nullable().isPresent() || parameter.type().getKind().isPrimitive()) continue;
                return true;
            }
        }
        return false;
    }

    private static CharSequence getSimpleName(CharSequence fullyQualifiedName) {
        int lastDot = FactoryWriter.lastIndexOf(fullyQualifiedName, '.');
        return fullyQualifiedName.subSequence(lastDot + 1, fullyQualifiedName.length());
    }

    private static String getPackage(CharSequence fullyQualifiedName) {
        int lastDot = FactoryWriter.lastIndexOf(fullyQualifiedName, '.');
        return fullyQualifiedName.subSequence(0, lastDot).toString();
    }

    private static int lastIndexOf(CharSequence charSequence, char c) {
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            if (charSequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

