/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.MoreElements;
import com.google.auto.factory.AutoFactory;
import com.google.auto.factory.Provided;
import com.google.auto.factory.processor.Mirrors;
import com.google.common.base.Preconditions;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementKindVisitor6;
import javax.tools.Diagnostic;

final class ProvidedChecker {
    private final Messager messager;

    ProvidedChecker(Messager messager) {
        this.messager = messager;
    }

    void checkProvidedParameter(Element element) {
        Preconditions.checkArgument((boolean)MoreElements.isAnnotationPresent((Element)element, Provided.class), (String)"%s not annoated with @Provided", (Object)element);
        element.accept(new ElementKindVisitor6<Void, Void>(){

            @Override
            protected Void defaultAction(Element e, Void p) {
                throw new AssertionError((Object)"Provided can only be applied to parameters");
            }

            @Override
            public Void visitVariableAsParameter(final VariableElement providedParameter, Void p) {
                providedParameter.getEnclosingElement().accept(new ElementKindVisitor6<Void, Void>(){

                    @Override
                    protected Void defaultAction(Element e, Void p) {
                        ProvidedChecker.this.raiseError(providedParameter, "@%s may only be applied to constructor parameters");
                        return null;
                    }

                    @Override
                    public Void visitExecutableAsConstructor(ExecutableElement constructor, Void p) {
                        if (!ProvidedChecker.annotatedWithAutoFactory(constructor) && !ProvidedChecker.annotatedWithAutoFactory(constructor.getEnclosingElement())) {
                            ProvidedChecker.this.raiseError(providedParameter, "@%s may only be applied to constructors requesting an auto-factory");
                        }
                        return null;
                    }
                }, p);
                return null;
            }
        }, null);
    }

    private void raiseError(VariableElement providedParameter, String messageFormat) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(messageFormat, Provided.class.getSimpleName()), providedParameter, (AnnotationMirror)Mirrors.getAnnotationMirror(providedParameter, Provided.class).get());
    }

    private static boolean annotatedWithAutoFactory(Element e) {
        return MoreElements.isAnnotationPresent((Element)e, AutoFactory.class);
    }
}

