/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.MoreTypes;
import com.google.auto.factory.AutoFactory;
import com.google.auto.factory.Provided;
import com.google.auto.factory.processor.AutoFactoryDeclaration;
import com.google.auto.factory.processor.Elements2;
import com.google.auto.factory.processor.FactoryDescriptor;
import com.google.auto.factory.processor.FactoryDescriptorGenerator;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.FactoryWriter;
import com.google.auto.factory.processor.ImplementationMethodDescriptor;
import com.google.auto.factory.processor.PackageAndClass;
import com.google.auto.factory.processor.Parameter;
import com.google.auto.factory.processor.ProvidedChecker;
import com.google.auto.service.AutoService;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;

@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.ISOLATING)
@AutoService(value={Processor.class})
public final class AutoFactoryProcessor
extends AbstractProcessor {
    private FactoryDescriptorGenerator factoryDescriptorGenerator;
    private AutoFactoryDeclaration.Factory declarationFactory;
    private ProvidedChecker providedChecker;
    private Messager messager;
    private Elements elements;
    private Types types;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.messager = processingEnv.getMessager();
        this.providedChecker = new ProvidedChecker(this.messager);
        this.declarationFactory = new AutoFactoryDeclaration.Factory(this.elements, this.messager);
        this.factoryDescriptorGenerator = new FactoryDescriptorGenerator(this.messager, this.types, this.declarationFactory);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.doProcess(roundEnv);
        }
        catch (Throwable e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to process @AutoFactory annotations:\n" + Throwables.getStackTraceAsString((Throwable)e));
        }
        return false;
    }

    private void doProcess(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Provided.class)) {
            this.providedChecker.checkProvidedParameter(element);
        }
        ImmutableListMultimap.Builder indexedMethodsBuilder = ImmutableListMultimap.builder();
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (Element element : roundEnv.getElementsAnnotatedWith(AutoFactory.class)) {
            Optional<AutoFactoryDeclaration> declaration = this.declarationFactory.createIfValid(element);
            if (declaration.isPresent()) {
                PackageAndClass factoryName2 = declaration.get().getFactoryName();
                TypeElement extendingType = declaration.get().extendingType();
                builder.putAll((Object)factoryName2, this.implementationMethods(extendingType, element));
                for (TypeElement implementingType : declaration.get().implementingTypes()) {
                    builder.putAll((Object)factoryName2, this.implementationMethods(implementingType, element));
                }
            }
            ImmutableSet<FactoryMethodDescriptor> descriptors = this.factoryDescriptorGenerator.generateDescriptor(element);
            for (FactoryMethodDescriptor descriptor : descriptors) {
                indexedMethodsBuilder.put((Object)descriptor.factoryName(), (Object)descriptor);
            }
        }
        ImmutableSetMultimap implementationMethodDescriptors = builder.build();
        ImmutableListMultimap immutableListMultimap = indexedMethodsBuilder.build();
        ImmutableSetMultimap<String, PackageAndClass> factoriesBeingCreated = AutoFactoryProcessor.simpleNamesToNames((ImmutableSet<PackageAndClass>)immutableListMultimap.keySet());
        FactoryWriter factoryWriter = new FactoryWriter(this.processingEnv, factoriesBeingCreated);
        immutableListMultimap.asMap().forEach((factoryName, methodDescriptors) -> {
            ImmutableSortedSet.Builder<TypeMirror> extending = AutoFactoryProcessor.newTypeSetBuilder();
            ImmutableSortedSet.Builder<TypeMirror> implementing = AutoFactoryProcessor.newTypeSetBuilder();
            boolean publicType = false;
            Boolean allowSubclasses = null;
            boolean skipCreation = false;
            for (FactoryMethodDescriptor methodDescriptor : methodDescriptors) {
                extending.add((Object)methodDescriptor.declaration().extendingType().asType());
                for (TypeElement implementingType : methodDescriptor.declaration().implementingTypes()) {
                    implementing.add((Object)implementingType.asType());
                }
                publicType |= methodDescriptor.publicMethod();
                if (allowSubclasses == null) {
                    allowSubclasses = methodDescriptor.declaration().allowSubclasses();
                    continue;
                }
                if (allowSubclasses.equals(methodDescriptor.declaration().allowSubclasses())) continue;
                skipCreation = true;
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Cannot mix allowSubclasses=true and allowSubclasses=false in one factory.", methodDescriptor.declaration().target(), methodDescriptor.declaration().mirror(), (AnnotationValue)methodDescriptor.declaration().valuesMap().get((Object)"allowSubclasses"));
            }
            if (!skipCreation) {
                try {
                    factoryWriter.writeFactory(FactoryDescriptor.create(factoryName, (TypeMirror)Iterables.getOnlyElement((Iterable)extending.build()), (ImmutableSet<TypeMirror>)implementing.build(), publicType, (ImmutableSet<FactoryMethodDescriptor>)ImmutableSet.copyOf((Collection)methodDescriptors), (ImmutableSet<ImplementationMethodDescriptor>)implementationMethodDescriptors.get(factoryName), allowSubclasses));
                }
                catch (IOException e) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "failed: " + e);
                }
            }
        });
    }

    private ImmutableSet<ImplementationMethodDescriptor> implementationMethods(TypeElement supertype, Element autoFactoryElement) {
        ImmutableSet.Builder implementationMethodsBuilder = ImmutableSet.builder();
        for (ExecutableElement implementationMethod : ElementFilter.methodsIn(this.elements.getAllMembers(supertype))) {
            if (!implementationMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            ExecutableType methodType = Elements2.getExecutableElementAsMemberOf(this.types, implementationMethod, supertype);
            ImmutableSet<Parameter> passedParameters = Parameter.forParameterList(implementationMethod.getParameters(), methodType.getParameterTypes(), this.types);
            implementationMethodsBuilder.add((Object)ImplementationMethodDescriptor.builder().name(implementationMethod.getSimpleName().toString()).returnType(this.getAnnotatedType(autoFactoryElement)).publicMethod().passedParameters((Iterable<Parameter>)passedParameters).isVarArgs(implementationMethod.isVarArgs()).exceptions(implementationMethod.getThrownTypes()).build());
        }
        return implementationMethodsBuilder.build();
    }

    private TypeMirror getAnnotatedType(Element element) {
        Object types = ImmutableList.of();
        while (types.isEmpty()) {
            types = ElementFilter.typesIn(Arrays.asList(element));
            element = element.getEnclosingElement();
        }
        return ((TypeElement)Iterables.getOnlyElement((Iterable)types)).asType();
    }

    private static ImmutableSetMultimap<String, PackageAndClass> simpleNamesToNames(ImmutableSet<PackageAndClass> names) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (PackageAndClass name : names) {
            builder.put((Object)name.className(), (Object)name);
        }
        return builder.build();
    }

    private static ImmutableSortedSet.Builder<TypeMirror> newTypeSetBuilder() {
        return ImmutableSortedSet.orderedBy(Comparator.comparing(t -> MoreTypes.asTypeElement((TypeMirror)t).getQualifiedName().toString()));
    }

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AutoFactory.class.getName(), (Object)Provided.class.getName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

