/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.google.auto.factory.processor.AutoValue_Key;
import com.google.auto.factory.processor.Mirrors;
import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

@AutoValue
abstract class Key {
    Key() {
    }

    abstract Equivalence.Wrapper<TypeMirror> type();

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> qualifierWrapper();

    Optional<AnnotationMirror> qualifier() {
        return Mirrors.unwrapOptionalEquivalence(this.qualifierWrapper());
    }

    static Key create(TypeMirror type, Collection<AnnotationMirror> annotations, Types types) {
        Optional<AnnotationMirror> qualifier = annotations.stream().filter(annotation -> MoreElements.isAnnotationPresent((Element)annotation.getAnnotationType().asElement(), Qualifier.class)).findFirst();
        TypeMirror keyType = Mirrors.isProvider(type) ? MoreTypes.asDeclared((TypeMirror)type).getTypeArguments().get(0) : Key.boxedType(type, types);
        return new AutoValue_Key((Equivalence.Wrapper<TypeMirror>)MoreTypes.equivalence().wrap((Object)keyType), Mirrors.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), qualifier));
    }

    private static TypeMirror boxedType(TypeMirror type, Types types) {
        return type.getKind().isPrimitive() ? types.boxedClass(MoreTypes.asPrimitiveType((TypeMirror)type)).asType() : type;
    }

    public final String toString() {
        String typeQualifiedName = MoreTypes.asTypeElement((TypeMirror)((TypeMirror)this.type().get())).toString();
        return this.qualifier().isPresent() ? this.qualifier().get() + "/" + typeQualifiedName : typeQualifiedName;
    }
}

