/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.MoreStreams;
import com.google.auto.common.MoreTypes;
import com.google.auto.factory.processor.AutoValue_InjectApi;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
abstract class InjectApi {
    private static final ImmutableList<String> PREFIXES_IN_ORDER = ImmutableList.of((Object)"jakarta.inject.", (Object)"javax.inject.");
    private static final ImmutableSet<String> API_CLASSES = ImmutableSet.of((Object)"Inject", (Object)"Provider", (Object)"Qualifier");

    InjectApi() {
    }

    abstract TypeElement inject();

    abstract TypeElement provider();

    abstract TypeElement qualifier();

    static InjectApi from(Elements elementUtils, @Nullable String apiPrefix) {
        ImmutableList apiPackages = apiPrefix == null ? PREFIXES_IN_ORDER : ImmutableList.of((Object)(apiPrefix + ".inject."));
        for (String apiPackage : apiPackages) {
            ImmutableMap<String, TypeElement> apiMap = InjectApi.apiMap(elementUtils, apiPackage);
            TypeElement inject = (TypeElement)apiMap.get((Object)"Inject");
            TypeElement provider = (TypeElement)apiMap.get((Object)"Provider");
            TypeElement qualifier = (TypeElement)apiMap.get((Object)"Qualifier");
            if (inject == null || provider == null || qualifier == null) continue;
            return new AutoValue_InjectApi(inject, provider, qualifier);
        }
        String classes = "{" + String.join((CharSequence)",", API_CLASSES) + "}";
        String missing = apiPackages.stream().sorted().map(s -> s + classes).collect(Collectors.joining(" or "));
        throw new IllegalStateException("Class path for AutoFactory class must include " + missing);
    }

    boolean isProvider(TypeMirror type) {
        return type.getKind().equals((Object)TypeKind.DECLARED) && MoreTypes.asTypeElement((TypeMirror)type).equals(this.provider());
    }

    private static ImmutableMap<String, TypeElement> apiMap(Elements elementUtils, String apiPackage) {
        return (ImmutableMap)API_CLASSES.stream().map(name -> new AbstractMap.SimpleEntry<String, TypeElement>((String)name, elementUtils.getTypeElement(apiPackage + name))).filter(entry -> entry.getValue() != null).collect(MoreStreams.toImmutableMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }
}

