/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.biglake.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.biglake.v1.Catalog;
import com.google.cloud.bigquery.biglake.v1.CatalogName;
import com.google.cloud.bigquery.biglake.v1.CreateCatalogRequest;
import com.google.cloud.bigquery.biglake.v1.CreateDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.CreateTableRequest;
import com.google.cloud.bigquery.biglake.v1.Database;
import com.google.cloud.bigquery.biglake.v1.DatabaseName;
import com.google.cloud.bigquery.biglake.v1.DeleteCatalogRequest;
import com.google.cloud.bigquery.biglake.v1.DeleteDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.DeleteTableRequest;
import com.google.cloud.bigquery.biglake.v1.GetCatalogRequest;
import com.google.cloud.bigquery.biglake.v1.GetDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.GetTableRequest;
import com.google.cloud.bigquery.biglake.v1.ListCatalogsRequest;
import com.google.cloud.bigquery.biglake.v1.ListCatalogsResponse;
import com.google.cloud.bigquery.biglake.v1.ListDatabasesRequest;
import com.google.cloud.bigquery.biglake.v1.ListDatabasesResponse;
import com.google.cloud.bigquery.biglake.v1.ListTablesRequest;
import com.google.cloud.bigquery.biglake.v1.ListTablesResponse;
import com.google.cloud.bigquery.biglake.v1.LocationName;
import com.google.cloud.bigquery.biglake.v1.MetastoreServiceClient;
import com.google.cloud.bigquery.biglake.v1.MetastoreServiceSettings;
import com.google.cloud.bigquery.biglake.v1.MockMetastoreService;
import com.google.cloud.bigquery.biglake.v1.RenameTableRequest;
import com.google.cloud.bigquery.biglake.v1.Table;
import com.google.cloud.bigquery.biglake.v1.TableName;
import com.google.cloud.bigquery.biglake.v1.UpdateDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.UpdateTableRequest;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MetastoreServiceClientTest {
    private static MockMetastoreService mockMetastoreService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private MetastoreServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockMetastoreService = new MockMetastoreService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockMetastoreService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        MetastoreServiceSettings settings = ((MetastoreServiceSettings.Builder)((MetastoreServiceSettings.Builder)MetastoreServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = MetastoreServiceClient.create((MetastoreServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void createCatalogTest() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Catalog catalog = Catalog.newBuilder().build();
        String catalogId = "catalogId1455933204";
        Catalog actualResponse = this.client.createCatalog(parent, catalog, catalogId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateCatalogRequest actualRequest = (CreateCatalogRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)catalog, (Object)actualRequest.getCatalog());
        Assert.assertEquals((Object)catalogId, (Object)actualRequest.getCatalogId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createCatalogExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Catalog catalog = Catalog.newBuilder().build();
            String catalogId = "catalogId1455933204";
            this.client.createCatalog(parent, catalog, catalogId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createCatalogTest2() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Catalog catalog = Catalog.newBuilder().build();
        String catalogId = "catalogId1455933204";
        Catalog actualResponse = this.client.createCatalog(parent, catalog, catalogId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateCatalogRequest actualRequest = (CreateCatalogRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)catalog, (Object)actualRequest.getCatalog());
        Assert.assertEquals((Object)catalogId, (Object)actualRequest.getCatalogId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createCatalogExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Catalog catalog = Catalog.newBuilder().build();
            String catalogId = "catalogId1455933204";
            this.client.createCatalog(parent, catalog, catalogId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCatalogTest() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        CatalogName name = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
        Catalog actualResponse = this.client.deleteCatalog(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteCatalogRequest actualRequest = (DeleteCatalogRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteCatalogExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            CatalogName name = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
            this.client.deleteCatalog(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCatalogTest2() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Catalog actualResponse = this.client.deleteCatalog(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteCatalogRequest actualRequest = (DeleteCatalogRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteCatalogExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteCatalog(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCatalogTest() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        CatalogName name = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
        Catalog actualResponse = this.client.getCatalog(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetCatalogRequest actualRequest = (GetCatalogRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getCatalogExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            CatalogName name = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
            this.client.getCatalog(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCatalogTest2() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Catalog actualResponse = this.client.getCatalog(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetCatalogRequest actualRequest = (GetCatalogRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getCatalogExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getCatalog(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCatalogsTest() throws Exception {
        Catalog responsesElement = Catalog.newBuilder().build();
        ListCatalogsResponse expectedResponse = ListCatalogsResponse.newBuilder().setNextPageToken("").addAllCatalogs(Arrays.asList(responsesElement)).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        MetastoreServiceClient.ListCatalogsPagedResponse pagedListResponse = this.client.listCatalogs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCatalogsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListCatalogsRequest actualRequest = (ListCatalogsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listCatalogsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listCatalogs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCatalogsTest2() throws Exception {
        Catalog responsesElement = Catalog.newBuilder().build();
        ListCatalogsResponse expectedResponse = ListCatalogsResponse.newBuilder().setNextPageToken("").addAllCatalogs(Arrays.asList(responsesElement)).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        MetastoreServiceClient.ListCatalogsPagedResponse pagedListResponse = this.client.listCatalogs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCatalogsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListCatalogsRequest actualRequest = (ListCatalogsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listCatalogsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listCatalogs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        CatalogName parent = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
        Database database = Database.newBuilder().build();
        String databaseId = "databaseId1688905718";
        Database actualResponse = this.client.createDatabase(parent, database, databaseId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatabaseRequest actualRequest = (CreateDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertEquals((Object)databaseId, (Object)actualRequest.getDatabaseId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            CatalogName parent = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
            Database database = Database.newBuilder().build();
            String databaseId = "databaseId1688905718";
            this.client.createDatabase(parent, database, databaseId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Database database = Database.newBuilder().build();
        String databaseId = "databaseId1688905718";
        Database actualResponse = this.client.createDatabase(parent, database, databaseId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateDatabaseRequest actualRequest = (CreateDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertEquals((Object)databaseId, (Object)actualRequest.getDatabaseId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createDatabaseExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Database database = Database.newBuilder().build();
            String databaseId = "databaseId1688905718";
            this.client.createDatabase(parent, database, databaseId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
        Database actualResponse = this.client.deleteDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDatabaseRequest actualRequest = (DeleteDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
            this.client.deleteDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Database actualResponse = this.client.deleteDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteDatabaseRequest actualRequest = (DeleteDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteDatabaseExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        Database database = Database.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Database actualResponse = this.client.updateDatabase(database, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateDatabaseRequest actualRequest = (UpdateDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)database, (Object)actualRequest.getDatabase());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            Database database = Database.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateDatabase(database, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
        Database actualResponse = this.client.getDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatabaseRequest actualRequest = (GetDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatabaseExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
            this.client.getDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Database actualResponse = this.client.getDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDatabaseRequest actualRequest = (GetDatabaseRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDatabaseExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabasesTest() throws Exception {
        Database responsesElement = Database.newBuilder().build();
        ListDatabasesResponse expectedResponse = ListDatabasesResponse.newBuilder().setNextPageToken("").addAllDatabases(Arrays.asList(responsesElement)).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        CatalogName parent = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
        MetastoreServiceClient.ListDatabasesPagedResponse pagedListResponse = this.client.listDatabases(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabasesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatabasesRequest actualRequest = (ListDatabasesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatabasesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            CatalogName parent = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
            this.client.listDatabases(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabasesTest2() throws Exception {
        Database responsesElement = Database.newBuilder().build();
        ListDatabasesResponse expectedResponse = ListDatabasesResponse.newBuilder().setNextPageToken("").addAllDatabases(Arrays.asList(responsesElement)).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        MetastoreServiceClient.ListDatabasesPagedResponse pagedListResponse = this.client.listDatabases(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabasesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListDatabasesRequest actualRequest = (ListDatabasesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listDatabasesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listDatabases(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
        Table table = Table.newBuilder().build();
        String tableId = "tableId-1552905847";
        Table actualResponse = this.client.createTable(parent, table, tableId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTableRequest actualRequest = (CreateTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)table, (Object)actualRequest.getTable());
        Assert.assertEquals((Object)tableId, (Object)actualRequest.getTableId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
            Table table = Table.newBuilder().build();
            String tableId = "tableId-1552905847";
            this.client.createTable(parent, table, tableId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Table table = Table.newBuilder().build();
        String tableId = "tableId-1552905847";
        Table actualResponse = this.client.createTable(parent, table, tableId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateTableRequest actualRequest = (CreateTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)table, (Object)actualRequest.getTable());
        Assert.assertEquals((Object)tableId, (Object)actualRequest.getTableId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createTableExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Table table = Table.newBuilder().build();
            String tableId = "tableId-1552905847";
            this.client.createTable(parent, table, tableId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        Table actualResponse = this.client.deleteTable(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTableRequest actualRequest = (DeleteTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            this.client.deleteTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Table actualResponse = this.client.deleteTable(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteTableRequest actualRequest = (DeleteTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteTableExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        Table table = Table.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Table actualResponse = this.client.updateTable(table, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateTableRequest actualRequest = (UpdateTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)table, (Object)actualRequest.getTable());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            Table table = Table.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateTable(table, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renameTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        TableName newName = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        Table actualResponse = this.client.renameTable(name, newName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RenameTableRequest actualRequest = (RenameTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)newName.toString(), (Object)actualRequest.getNewName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void renameTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            TableName newName = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            this.client.renameTable(name, newName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renameTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        String newName = "newName1845020747";
        Table actualResponse = this.client.renameTable(name, newName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RenameTableRequest actualRequest = (RenameTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)newName, (Object)actualRequest.getNewName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void renameTableExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            String newName = "newName1845020747";
            this.client.renameTable(name, newName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renameTableTest3() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        TableName newName = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        Table actualResponse = this.client.renameTable(name, newName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RenameTableRequest actualRequest = (RenameTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)newName.toString(), (Object)actualRequest.getNewName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void renameTableExceptionTest3() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String name = "name3373707";
            TableName newName = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            this.client.renameTable(name, newName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renameTableTest4() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        String newName = "newName1845020747";
        Table actualResponse = this.client.renameTable(name, newName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RenameTableRequest actualRequest = (RenameTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)newName, (Object)actualRequest.getNewName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void renameTableExceptionTest4() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String name = "name3373707";
            String newName = "newName1845020747";
            this.client.renameTable(name, newName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        Table actualResponse = this.client.getTable(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTableRequest actualRequest = (GetTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTableExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            this.client.getTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Table actualResponse = this.client.getTable(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetTableRequest actualRequest = (GetTableRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getTableExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTablesTest() throws Exception {
        Table responsesElement = Table.newBuilder().build();
        ListTablesResponse expectedResponse = ListTablesResponse.newBuilder().setNextPageToken("").addAllTables(Arrays.asList(responsesElement)).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
        MetastoreServiceClient.ListTablesPagedResponse pagedListResponse = this.client.listTables(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTablesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTablesRequest actualRequest = (ListTablesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTablesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
            this.client.listTables(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTablesTest2() throws Exception {
        Table responsesElement = Table.newBuilder().build();
        ListTablesResponse expectedResponse = ListTablesResponse.newBuilder().setNextPageToken("").addAllTables(Arrays.asList(responsesElement)).build();
        mockMetastoreService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        MetastoreServiceClient.ListTablesPagedResponse pagedListResponse = this.client.listTables(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTablesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockMetastoreService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListTablesRequest actualRequest = (ListTablesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listTablesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockMetastoreService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listTables(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

