/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.biglake.v1alpha1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.bigquery.biglake.v1alpha1.Catalog;
import com.google.cloud.bigquery.biglake.v1alpha1.CatalogName;
import com.google.cloud.bigquery.biglake.v1alpha1.Database;
import com.google.cloud.bigquery.biglake.v1alpha1.DatabaseName;
import com.google.cloud.bigquery.biglake.v1alpha1.ListCatalogsResponse;
import com.google.cloud.bigquery.biglake.v1alpha1.ListDatabasesResponse;
import com.google.cloud.bigquery.biglake.v1alpha1.ListLocksResponse;
import com.google.cloud.bigquery.biglake.v1alpha1.ListTablesResponse;
import com.google.cloud.bigquery.biglake.v1alpha1.LocationName;
import com.google.cloud.bigquery.biglake.v1alpha1.Lock;
import com.google.cloud.bigquery.biglake.v1alpha1.LockName;
import com.google.cloud.bigquery.biglake.v1alpha1.MetastoreServiceClient;
import com.google.cloud.bigquery.biglake.v1alpha1.MetastoreServiceSettings;
import com.google.cloud.bigquery.biglake.v1alpha1.Table;
import com.google.cloud.bigquery.biglake.v1alpha1.TableName;
import com.google.cloud.bigquery.biglake.v1alpha1.stub.HttpJsonMetastoreServiceStub;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class MetastoreServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static MetastoreServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonMetastoreServiceStub.getMethodDescriptors(), MetastoreServiceSettings.getDefaultEndpoint());
        MetastoreServiceSettings settings = ((MetastoreServiceSettings.Builder)((MetastoreServiceSettings.Builder)MetastoreServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)MetastoreServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = MetastoreServiceClient.create((MetastoreServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void createCatalogTest() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Catalog catalog = Catalog.newBuilder().build();
        String catalogId = "catalogId1455933204";
        Catalog actualResponse = client.createCatalog(parent, catalog, catalogId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createCatalogExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Catalog catalog = Catalog.newBuilder().build();
            String catalogId = "catalogId1455933204";
            client.createCatalog(parent, catalog, catalogId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createCatalogTest2() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        Catalog catalog = Catalog.newBuilder().build();
        String catalogId = "catalogId1455933204";
        Catalog actualResponse = client.createCatalog(parent, catalog, catalogId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createCatalogExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Catalog catalog = Catalog.newBuilder().build();
            String catalogId = "catalogId1455933204";
            client.createCatalog(parent, catalog, catalogId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCatalogTest() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        CatalogName name = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
        Catalog actualResponse = client.deleteCatalog(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteCatalogExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CatalogName name = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
            client.deleteCatalog(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteCatalogTest2() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3958/locations/location-3958/catalogs/catalog-3958";
        Catalog actualResponse = client.deleteCatalog(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteCatalogExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3958/locations/location-3958/catalogs/catalog-3958";
            client.deleteCatalog(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCatalogTest() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        CatalogName name = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
        Catalog actualResponse = client.getCatalog(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getCatalogExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CatalogName name = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
            client.getCatalog(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getCatalogTest2() throws Exception {
        Catalog expectedResponse = Catalog.newBuilder().setName(CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3958/locations/location-3958/catalogs/catalog-3958";
        Catalog actualResponse = client.getCatalog(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getCatalogExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3958/locations/location-3958/catalogs/catalog-3958";
            client.getCatalog(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCatalogsTest() throws Exception {
        Catalog responsesElement = Catalog.newBuilder().build();
        ListCatalogsResponse expectedResponse = ListCatalogsResponse.newBuilder().setNextPageToken("").addAllCatalogs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        MetastoreServiceClient.ListCatalogsPagedResponse pagedListResponse = client.listCatalogs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCatalogsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listCatalogsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listCatalogs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listCatalogsTest2() throws Exception {
        Catalog responsesElement = Catalog.newBuilder().build();
        ListCatalogsResponse expectedResponse = ListCatalogsResponse.newBuilder().setNextPageToken("").addAllCatalogs(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        MetastoreServiceClient.ListCatalogsPagedResponse pagedListResponse = client.listCatalogs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getCatalogsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listCatalogsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listCatalogs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        CatalogName parent = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
        Database database = Database.newBuilder().build();
        String databaseId = "databaseId1688905718";
        Database actualResponse = client.createDatabase(parent, database, databaseId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDatabaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CatalogName parent = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
            Database database = Database.newBuilder().build();
            String databaseId = "databaseId1688905718";
            client.createDatabase(parent, database, databaseId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-6267/locations/location-6267/catalogs/catalog-6267";
        Database database = Database.newBuilder().build();
        String databaseId = "databaseId1688905718";
        Database actualResponse = client.createDatabase(parent, database, databaseId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createDatabaseExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-6267/locations/location-6267/catalogs/catalog-6267";
            Database database = Database.newBuilder().build();
            String databaseId = "databaseId1688905718";
            client.createDatabase(parent, database, databaseId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
        Database actualResponse = client.deleteDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDatabaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
            client.deleteDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3426/locations/location-3426/catalogs/catalog-3426/databases/database-3426";
        Database actualResponse = client.deleteDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteDatabaseExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3426/locations/location-3426/catalogs/catalog-3426/databases/database-3426";
            client.deleteDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        Database database = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Database actualResponse = client.updateDatabase(database, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateDatabaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Database database = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateDatabase(database, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseTest() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
        Database actualResponse = client.getDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDatabaseExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName name = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
            client.getDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getDatabaseTest2() throws Exception {
        Database expectedResponse = Database.newBuilder().setName(DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3426/locations/location-3426/catalogs/catalog-3426/databases/database-3426";
        Database actualResponse = client.getDatabase(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getDatabaseExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3426/locations/location-3426/catalogs/catalog-3426/databases/database-3426";
            client.getDatabase(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabasesTest() throws Exception {
        Database responsesElement = Database.newBuilder().build();
        ListDatabasesResponse expectedResponse = ListDatabasesResponse.newBuilder().setNextPageToken("").addAllDatabases(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        CatalogName parent = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
        MetastoreServiceClient.ListDatabasesPagedResponse pagedListResponse = client.listDatabases(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabasesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDatabasesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            CatalogName parent = CatalogName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]");
            client.listDatabases(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listDatabasesTest2() throws Exception {
        Database responsesElement = Database.newBuilder().build();
        ListDatabasesResponse expectedResponse = ListDatabasesResponse.newBuilder().setNextPageToken("").addAllDatabases(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-6267/locations/location-6267/catalogs/catalog-6267";
        MetastoreServiceClient.ListDatabasesPagedResponse pagedListResponse = client.listDatabases(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabasesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listDatabasesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-6267/locations/location-6267/catalogs/catalog-6267";
            client.listDatabases(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
        Table table = Table.newBuilder().build();
        String tableId = "tableId-1552905847";
        Table actualResponse = client.createTable(parent, table, tableId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createTableExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
            Table table = Table.newBuilder().build();
            String tableId = "tableId-1552905847";
            client.createTable(parent, table, tableId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-6081/locations/location-6081/catalogs/catalog-6081/databases/database-6081";
        Table table = Table.newBuilder().build();
        String tableId = "tableId-1552905847";
        Table actualResponse = client.createTable(parent, table, tableId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createTableExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-6081/locations/location-6081/catalogs/catalog-6081/databases/database-6081";
            Table table = Table.newBuilder().build();
            String tableId = "tableId-1552905847";
            client.createTable(parent, table, tableId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        Table actualResponse = client.deleteTable(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteTableExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            client.deleteTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3983/locations/location-3983/catalogs/catalog-3983/databases/database-3983/tables/table-3983";
        Table actualResponse = client.deleteTable(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteTableExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3983/locations/location-3983/catalogs/catalog-3983/databases/database-3983/tables/table-3983";
            client.deleteTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        Table table = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Table actualResponse = client.updateTable(table, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateTableExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Table table = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateTable(table, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renameTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        TableName newName = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        Table actualResponse = client.renameTable(name, newName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void renameTableExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            TableName newName = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            client.renameTable(name, newName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renameTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        String newName = "newName1845020747";
        Table actualResponse = client.renameTable(name, newName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void renameTableExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            String newName = "newName1845020747";
            client.renameTable(name, newName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renameTableTest3() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3983/locations/location-3983/catalogs/catalog-3983/databases/database-3983/tables/table-3983";
        TableName newName = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        Table actualResponse = client.renameTable(name, newName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void renameTableExceptionTest3() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3983/locations/location-3983/catalogs/catalog-3983/databases/database-3983/tables/table-3983";
            TableName newName = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            client.renameTable(name, newName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void renameTableTest4() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3983/locations/location-3983/catalogs/catalog-3983/databases/database-3983/tables/table-3983";
        String newName = "newName1845020747";
        Table actualResponse = client.renameTable(name, newName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void renameTableExceptionTest4() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3983/locations/location-3983/catalogs/catalog-3983/databases/database-3983/tables/table-3983";
            String newName = "newName1845020747";
            client.renameTable(name, newName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTableTest() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
        Table actualResponse = client.getTable(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getTableExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            TableName name = TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]");
            client.getTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getTableTest2() throws Exception {
        Table expectedResponse = Table.newBuilder().setName(TableName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[TABLE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDeleteTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).setEtag("etag3123477").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3983/locations/location-3983/catalogs/catalog-3983/databases/database-3983/tables/table-3983";
        Table actualResponse = client.getTable(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getTableExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3983/locations/location-3983/catalogs/catalog-3983/databases/database-3983/tables/table-3983";
            client.getTable(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTablesTest() throws Exception {
        Table responsesElement = Table.newBuilder().build();
        ListTablesResponse expectedResponse = ListTablesResponse.newBuilder().setNextPageToken("").addAllTables(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
        MetastoreServiceClient.ListTablesPagedResponse pagedListResponse = client.listTables(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTablesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listTablesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
            client.listTables(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listTablesTest2() throws Exception {
        Table responsesElement = Table.newBuilder().build();
        ListTablesResponse expectedResponse = ListTablesResponse.newBuilder().setNextPageToken("").addAllTables(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-6081/locations/location-6081/catalogs/catalog-6081/databases/database-6081";
        MetastoreServiceClient.ListTablesPagedResponse pagedListResponse = client.listTables(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getTablesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listTablesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-6081/locations/location-6081/catalogs/catalog-6081/databases/database-6081";
            client.listTables(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createLockTest() throws Exception {
        Lock expectedResponse = Lock.newBuilder().setName(LockName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[LOCK]").toString()).setCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
        Lock lock = Lock.newBuilder().build();
        Lock actualResponse = client.createLock(parent, lock);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createLockExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
            Lock lock = Lock.newBuilder().build();
            client.createLock(parent, lock);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createLockTest2() throws Exception {
        Lock expectedResponse = Lock.newBuilder().setName(LockName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[LOCK]").toString()).setCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-6081/locations/location-6081/catalogs/catalog-6081/databases/database-6081";
        Lock lock = Lock.newBuilder().build();
        Lock actualResponse = client.createLock(parent, lock);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createLockExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-6081/locations/location-6081/catalogs/catalog-6081/databases/database-6081";
            Lock lock = Lock.newBuilder().build();
            client.createLock(parent, lock);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteLockTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        LockName name = LockName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[LOCK]");
        client.deleteLock(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteLockExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LockName name = LockName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[LOCK]");
            client.deleteLock(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteLockTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-1582/locations/location-1582/catalogs/catalog-1582/databases/database-1582/locks/lock-1582";
        client.deleteLock(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteLockExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1582/locations/location-1582/catalogs/catalog-1582/databases/database-1582/locks/lock-1582";
            client.deleteLock(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkLockTest() throws Exception {
        Lock expectedResponse = Lock.newBuilder().setName(LockName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[LOCK]").toString()).setCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        LockName name = LockName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[LOCK]");
        Lock actualResponse = client.checkLock(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void checkLockExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LockName name = LockName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[LOCK]");
            client.checkLock(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkLockTest2() throws Exception {
        Lock expectedResponse = Lock.newBuilder().setName(LockName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]", (String)"[LOCK]").toString()).setCreateTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-1582/locations/location-1582/catalogs/catalog-1582/databases/database-1582/locks/lock-1582";
        Lock actualResponse = client.checkLock(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void checkLockExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1582/locations/location-1582/catalogs/catalog-1582/databases/database-1582/locks/lock-1582";
            client.checkLock(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLocksTest() throws Exception {
        Lock responsesElement = Lock.newBuilder().build();
        ListLocksResponse expectedResponse = ListLocksResponse.newBuilder().setNextPageToken("").addAllLocks(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
        MetastoreServiceClient.ListLocksPagedResponse pagedListResponse = client.listLocks(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocksList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listLocksExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            DatabaseName parent = DatabaseName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CATALOG]", (String)"[DATABASE]");
            client.listLocks(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLocksTest2() throws Exception {
        Lock responsesElement = Lock.newBuilder().build();
        ListLocksResponse expectedResponse = ListLocksResponse.newBuilder().setNextPageToken("").addAllLocks(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-6081/locations/location-6081/catalogs/catalog-6081/databases/database-6081";
        MetastoreServiceClient.ListLocksPagedResponse pagedListResponse = client.listLocks(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocksList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listLocksExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-6081/locations/location-6081/catalogs/catalog-6081/databases/database-6081";
            client.listLocks(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

