/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.biglake.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.biglake.v1.Catalog;
import com.google.cloud.bigquery.biglake.v1.CreateCatalogRequest;
import com.google.cloud.bigquery.biglake.v1.CreateDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.CreateTableRequest;
import com.google.cloud.bigquery.biglake.v1.Database;
import com.google.cloud.bigquery.biglake.v1.DeleteCatalogRequest;
import com.google.cloud.bigquery.biglake.v1.DeleteDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.DeleteTableRequest;
import com.google.cloud.bigquery.biglake.v1.GetCatalogRequest;
import com.google.cloud.bigquery.biglake.v1.GetDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.GetTableRequest;
import com.google.cloud.bigquery.biglake.v1.ListCatalogsRequest;
import com.google.cloud.bigquery.biglake.v1.ListCatalogsResponse;
import com.google.cloud.bigquery.biglake.v1.ListDatabasesRequest;
import com.google.cloud.bigquery.biglake.v1.ListDatabasesResponse;
import com.google.cloud.bigquery.biglake.v1.ListTablesRequest;
import com.google.cloud.bigquery.biglake.v1.ListTablesResponse;
import com.google.cloud.bigquery.biglake.v1.MetastoreServiceClient;
import com.google.cloud.bigquery.biglake.v1.RenameTableRequest;
import com.google.cloud.bigquery.biglake.v1.Table;
import com.google.cloud.bigquery.biglake.v1.UpdateDatabaseRequest;
import com.google.cloud.bigquery.biglake.v1.UpdateTableRequest;
import com.google.cloud.bigquery.biglake.v1.stub.GrpcMetastoreServiceStub;
import com.google.cloud.bigquery.biglake.v1.stub.HttpJsonMetastoreServiceStub;
import com.google.cloud.bigquery.biglake.v1.stub.MetastoreServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MetastoreServiceStubSettings
extends StubSettings<MetastoreServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigquery").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateCatalogRequest, Catalog> createCatalogSettings;
    private final UnaryCallSettings<DeleteCatalogRequest, Catalog> deleteCatalogSettings;
    private final UnaryCallSettings<GetCatalogRequest, Catalog> getCatalogSettings;
    private final PagedCallSettings<ListCatalogsRequest, ListCatalogsResponse, MetastoreServiceClient.ListCatalogsPagedResponse> listCatalogsSettings;
    private final UnaryCallSettings<CreateDatabaseRequest, Database> createDatabaseSettings;
    private final UnaryCallSettings<DeleteDatabaseRequest, Database> deleteDatabaseSettings;
    private final UnaryCallSettings<UpdateDatabaseRequest, Database> updateDatabaseSettings;
    private final UnaryCallSettings<GetDatabaseRequest, Database> getDatabaseSettings;
    private final PagedCallSettings<ListDatabasesRequest, ListDatabasesResponse, MetastoreServiceClient.ListDatabasesPagedResponse> listDatabasesSettings;
    private final UnaryCallSettings<CreateTableRequest, Table> createTableSettings;
    private final UnaryCallSettings<DeleteTableRequest, Table> deleteTableSettings;
    private final UnaryCallSettings<UpdateTableRequest, Table> updateTableSettings;
    private final UnaryCallSettings<RenameTableRequest, Table> renameTableSettings;
    private final UnaryCallSettings<GetTableRequest, Table> getTableSettings;
    private final PagedCallSettings<ListTablesRequest, ListTablesResponse, MetastoreServiceClient.ListTablesPagedResponse> listTablesSettings;
    private static final PagedListDescriptor<ListCatalogsRequest, ListCatalogsResponse, Catalog> LIST_CATALOGS_PAGE_STR_DESC = new PagedListDescriptor<ListCatalogsRequest, ListCatalogsResponse, Catalog>(){

        public String emptyToken() {
            return "";
        }

        public ListCatalogsRequest injectToken(ListCatalogsRequest payload, String token) {
            return ListCatalogsRequest.newBuilder((ListCatalogsRequest)payload).setPageToken(token).build();
        }

        public ListCatalogsRequest injectPageSize(ListCatalogsRequest payload, int pageSize) {
            return ListCatalogsRequest.newBuilder((ListCatalogsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCatalogsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCatalogsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Catalog> extractResources(ListCatalogsResponse payload) {
            return payload.getCatalogsList();
        }
    };
    private static final PagedListDescriptor<ListDatabasesRequest, ListDatabasesResponse, Database> LIST_DATABASES_PAGE_STR_DESC = new PagedListDescriptor<ListDatabasesRequest, ListDatabasesResponse, Database>(){

        public String emptyToken() {
            return "";
        }

        public ListDatabasesRequest injectToken(ListDatabasesRequest payload, String token) {
            return ListDatabasesRequest.newBuilder((ListDatabasesRequest)payload).setPageToken(token).build();
        }

        public ListDatabasesRequest injectPageSize(ListDatabasesRequest payload, int pageSize) {
            return ListDatabasesRequest.newBuilder((ListDatabasesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDatabasesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDatabasesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Database> extractResources(ListDatabasesResponse payload) {
            return payload.getDatabasesList();
        }
    };
    private static final PagedListDescriptor<ListTablesRequest, ListTablesResponse, Table> LIST_TABLES_PAGE_STR_DESC = new PagedListDescriptor<ListTablesRequest, ListTablesResponse, Table>(){

        public String emptyToken() {
            return "";
        }

        public ListTablesRequest injectToken(ListTablesRequest payload, String token) {
            return ListTablesRequest.newBuilder((ListTablesRequest)payload).setPageToken(token).build();
        }

        public ListTablesRequest injectPageSize(ListTablesRequest payload, int pageSize) {
            return ListTablesRequest.newBuilder((ListTablesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTablesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTablesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Table> extractResources(ListTablesResponse payload) {
            return payload.getTablesList();
        }
    };
    private static final PagedListResponseFactory<ListCatalogsRequest, ListCatalogsResponse, MetastoreServiceClient.ListCatalogsPagedResponse> LIST_CATALOGS_PAGE_STR_FACT = new PagedListResponseFactory<ListCatalogsRequest, ListCatalogsResponse, MetastoreServiceClient.ListCatalogsPagedResponse>(){

        public ApiFuture<MetastoreServiceClient.ListCatalogsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCatalogsRequest, ListCatalogsResponse> callable, ListCatalogsRequest request, ApiCallContext context, ApiFuture<ListCatalogsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CATALOGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MetastoreServiceClient.ListCatalogsPagedResponse.createAsync((PageContext<ListCatalogsRequest, ListCatalogsResponse, Catalog>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDatabasesRequest, ListDatabasesResponse, MetastoreServiceClient.ListDatabasesPagedResponse> LIST_DATABASES_PAGE_STR_FACT = new PagedListResponseFactory<ListDatabasesRequest, ListDatabasesResponse, MetastoreServiceClient.ListDatabasesPagedResponse>(){

        public ApiFuture<MetastoreServiceClient.ListDatabasesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDatabasesRequest, ListDatabasesResponse> callable, ListDatabasesRequest request, ApiCallContext context, ApiFuture<ListDatabasesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATABASES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MetastoreServiceClient.ListDatabasesPagedResponse.createAsync((PageContext<ListDatabasesRequest, ListDatabasesResponse, Database>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTablesRequest, ListTablesResponse, MetastoreServiceClient.ListTablesPagedResponse> LIST_TABLES_PAGE_STR_FACT = new PagedListResponseFactory<ListTablesRequest, ListTablesResponse, MetastoreServiceClient.ListTablesPagedResponse>(){

        public ApiFuture<MetastoreServiceClient.ListTablesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTablesRequest, ListTablesResponse> callable, ListTablesRequest request, ApiCallContext context, ApiFuture<ListTablesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TABLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return MetastoreServiceClient.ListTablesPagedResponse.createAsync((PageContext<ListTablesRequest, ListTablesResponse, Table>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateCatalogRequest, Catalog> createCatalogSettings() {
        return this.createCatalogSettings;
    }

    public UnaryCallSettings<DeleteCatalogRequest, Catalog> deleteCatalogSettings() {
        return this.deleteCatalogSettings;
    }

    public UnaryCallSettings<GetCatalogRequest, Catalog> getCatalogSettings() {
        return this.getCatalogSettings;
    }

    public PagedCallSettings<ListCatalogsRequest, ListCatalogsResponse, MetastoreServiceClient.ListCatalogsPagedResponse> listCatalogsSettings() {
        return this.listCatalogsSettings;
    }

    public UnaryCallSettings<CreateDatabaseRequest, Database> createDatabaseSettings() {
        return this.createDatabaseSettings;
    }

    public UnaryCallSettings<DeleteDatabaseRequest, Database> deleteDatabaseSettings() {
        return this.deleteDatabaseSettings;
    }

    public UnaryCallSettings<UpdateDatabaseRequest, Database> updateDatabaseSettings() {
        return this.updateDatabaseSettings;
    }

    public UnaryCallSettings<GetDatabaseRequest, Database> getDatabaseSettings() {
        return this.getDatabaseSettings;
    }

    public PagedCallSettings<ListDatabasesRequest, ListDatabasesResponse, MetastoreServiceClient.ListDatabasesPagedResponse> listDatabasesSettings() {
        return this.listDatabasesSettings;
    }

    public UnaryCallSettings<CreateTableRequest, Table> createTableSettings() {
        return this.createTableSettings;
    }

    public UnaryCallSettings<DeleteTableRequest, Table> deleteTableSettings() {
        return this.deleteTableSettings;
    }

    public UnaryCallSettings<UpdateTableRequest, Table> updateTableSettings() {
        return this.updateTableSettings;
    }

    public UnaryCallSettings<RenameTableRequest, Table> renameTableSettings() {
        return this.renameTableSettings;
    }

    public UnaryCallSettings<GetTableRequest, Table> getTableSettings() {
        return this.getTableSettings;
    }

    public PagedCallSettings<ListTablesRequest, ListTablesResponse, MetastoreServiceClient.ListTablesPagedResponse> listTablesSettings() {
        return this.listTablesSettings;
    }

    public MetastoreServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMetastoreServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonMetastoreServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "biglake";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "biglake.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "biglake.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MetastoreServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MetastoreServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MetastoreServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return MetastoreServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MetastoreServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createCatalogSettings = settingsBuilder.createCatalogSettings().build();
        this.deleteCatalogSettings = settingsBuilder.deleteCatalogSettings().build();
        this.getCatalogSettings = settingsBuilder.getCatalogSettings().build();
        this.listCatalogsSettings = settingsBuilder.listCatalogsSettings().build();
        this.createDatabaseSettings = settingsBuilder.createDatabaseSettings().build();
        this.deleteDatabaseSettings = settingsBuilder.deleteDatabaseSettings().build();
        this.updateDatabaseSettings = settingsBuilder.updateDatabaseSettings().build();
        this.getDatabaseSettings = settingsBuilder.getDatabaseSettings().build();
        this.listDatabasesSettings = settingsBuilder.listDatabasesSettings().build();
        this.createTableSettings = settingsBuilder.createTableSettings().build();
        this.deleteTableSettings = settingsBuilder.deleteTableSettings().build();
        this.updateTableSettings = settingsBuilder.updateTableSettings().build();
        this.renameTableSettings = settingsBuilder.renameTableSettings().build();
        this.getTableSettings = settingsBuilder.getTableSettings().build();
        this.listTablesSettings = settingsBuilder.listTablesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MetastoreServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateCatalogRequest, Catalog> createCatalogSettings;
        private final UnaryCallSettings.Builder<DeleteCatalogRequest, Catalog> deleteCatalogSettings;
        private final UnaryCallSettings.Builder<GetCatalogRequest, Catalog> getCatalogSettings;
        private final PagedCallSettings.Builder<ListCatalogsRequest, ListCatalogsResponse, MetastoreServiceClient.ListCatalogsPagedResponse> listCatalogsSettings;
        private final UnaryCallSettings.Builder<CreateDatabaseRequest, Database> createDatabaseSettings;
        private final UnaryCallSettings.Builder<DeleteDatabaseRequest, Database> deleteDatabaseSettings;
        private final UnaryCallSettings.Builder<UpdateDatabaseRequest, Database> updateDatabaseSettings;
        private final UnaryCallSettings.Builder<GetDatabaseRequest, Database> getDatabaseSettings;
        private final PagedCallSettings.Builder<ListDatabasesRequest, ListDatabasesResponse, MetastoreServiceClient.ListDatabasesPagedResponse> listDatabasesSettings;
        private final UnaryCallSettings.Builder<CreateTableRequest, Table> createTableSettings;
        private final UnaryCallSettings.Builder<DeleteTableRequest, Table> deleteTableSettings;
        private final UnaryCallSettings.Builder<UpdateTableRequest, Table> updateTableSettings;
        private final UnaryCallSettings.Builder<RenameTableRequest, Table> renameTableSettings;
        private final UnaryCallSettings.Builder<GetTableRequest, Table> getTableSettings;
        private final PagedCallSettings.Builder<ListTablesRequest, ListTablesResponse, MetastoreServiceClient.ListTablesPagedResponse> listTablesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createCatalogSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCatalogSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getCatalogSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCatalogsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CATALOGS_PAGE_STR_FACT);
            this.createDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDatabaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDatabasesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATABASES_PAGE_STR_FACT);
            this.createTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.renameTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTableSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTablesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TABLES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCatalogSettings, this.deleteCatalogSettings, this.getCatalogSettings, this.listCatalogsSettings, this.createDatabaseSettings, this.deleteDatabaseSettings, this.updateDatabaseSettings, this.getDatabaseSettings, this.listDatabasesSettings, this.createTableSettings, this.deleteTableSettings, this.updateTableSettings, (Object[])new UnaryCallSettings.Builder[]{this.renameTableSettings, this.getTableSettings, this.listTablesSettings});
            Builder.initDefaults(this);
        }

        protected Builder(MetastoreServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createCatalogSettings = settings.createCatalogSettings.toBuilder();
            this.deleteCatalogSettings = settings.deleteCatalogSettings.toBuilder();
            this.getCatalogSettings = settings.getCatalogSettings.toBuilder();
            this.listCatalogsSettings = settings.listCatalogsSettings.toBuilder();
            this.createDatabaseSettings = settings.createDatabaseSettings.toBuilder();
            this.deleteDatabaseSettings = settings.deleteDatabaseSettings.toBuilder();
            this.updateDatabaseSettings = settings.updateDatabaseSettings.toBuilder();
            this.getDatabaseSettings = settings.getDatabaseSettings.toBuilder();
            this.listDatabasesSettings = settings.listDatabasesSettings.toBuilder();
            this.createTableSettings = settings.createTableSettings.toBuilder();
            this.deleteTableSettings = settings.deleteTableSettings.toBuilder();
            this.updateTableSettings = settings.updateTableSettings.toBuilder();
            this.renameTableSettings = settings.renameTableSettings.toBuilder();
            this.getTableSettings = settings.getTableSettings.toBuilder();
            this.listTablesSettings = settings.listTablesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCatalogSettings, this.deleteCatalogSettings, this.getCatalogSettings, this.listCatalogsSettings, this.createDatabaseSettings, this.deleteDatabaseSettings, this.updateDatabaseSettings, this.getDatabaseSettings, this.listDatabasesSettings, this.createTableSettings, this.deleteTableSettings, this.updateTableSettings, (Object[])new UnaryCallSettings.Builder[]{this.renameTableSettings, this.getTableSettings, this.listTablesSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MetastoreServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MetastoreServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MetastoreServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MetastoreServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)MetastoreServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)MetastoreServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MetastoreServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MetastoreServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createCatalogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteCatalogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCatalogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCatalogsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDatabaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDatabasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.renameTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTableSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTablesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateCatalogRequest, Catalog> createCatalogSettings() {
            return this.createCatalogSettings;
        }

        public UnaryCallSettings.Builder<DeleteCatalogRequest, Catalog> deleteCatalogSettings() {
            return this.deleteCatalogSettings;
        }

        public UnaryCallSettings.Builder<GetCatalogRequest, Catalog> getCatalogSettings() {
            return this.getCatalogSettings;
        }

        public PagedCallSettings.Builder<ListCatalogsRequest, ListCatalogsResponse, MetastoreServiceClient.ListCatalogsPagedResponse> listCatalogsSettings() {
            return this.listCatalogsSettings;
        }

        public UnaryCallSettings.Builder<CreateDatabaseRequest, Database> createDatabaseSettings() {
            return this.createDatabaseSettings;
        }

        public UnaryCallSettings.Builder<DeleteDatabaseRequest, Database> deleteDatabaseSettings() {
            return this.deleteDatabaseSettings;
        }

        public UnaryCallSettings.Builder<UpdateDatabaseRequest, Database> updateDatabaseSettings() {
            return this.updateDatabaseSettings;
        }

        public UnaryCallSettings.Builder<GetDatabaseRequest, Database> getDatabaseSettings() {
            return this.getDatabaseSettings;
        }

        public PagedCallSettings.Builder<ListDatabasesRequest, ListDatabasesResponse, MetastoreServiceClient.ListDatabasesPagedResponse> listDatabasesSettings() {
            return this.listDatabasesSettings;
        }

        public UnaryCallSettings.Builder<CreateTableRequest, Table> createTableSettings() {
            return this.createTableSettings;
        }

        public UnaryCallSettings.Builder<DeleteTableRequest, Table> deleteTableSettings() {
            return this.deleteTableSettings;
        }

        public UnaryCallSettings.Builder<UpdateTableRequest, Table> updateTableSettings() {
            return this.updateTableSettings;
        }

        public UnaryCallSettings.Builder<RenameTableRequest, Table> renameTableSettings() {
            return this.renameTableSettings;
        }

        public UnaryCallSettings.Builder<GetTableRequest, Table> getTableSettings() {
            return this.getTableSettings;
        }

        public PagedCallSettings.Builder<ListTablesRequest, ListTablesResponse, MetastoreServiceClient.ListTablesPagedResponse> listTablesSettings() {
            return this.listTablesSettings;
        }

        public MetastoreServiceStubSettings build() throws IOException {
            return new MetastoreServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

