/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.billing.v1.CloudCatalogClient;
import com.google.cloud.billing.v1.CloudCatalogSettings;
import com.google.cloud.billing.v1.ListServicesRequest;
import com.google.cloud.billing.v1.ListServicesResponse;
import com.google.cloud.billing.v1.ListSkusRequest;
import com.google.cloud.billing.v1.ListSkusResponse;
import com.google.cloud.billing.v1.MockCloudCatalog;
import com.google.cloud.billing.v1.Service;
import com.google.cloud.billing.v1.ServiceName;
import com.google.cloud.billing.v1.Sku;
import com.google.common.collect.Lists;
import com.google.protobuf.AbstractMessage;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CloudCatalogClientTest {
    private static MockCloudCatalog mockCloudCatalog;
    private static MockServiceHelper mockServiceHelper;
    private CloudCatalogClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockCloudCatalog = new MockCloudCatalog();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockCloudCatalog));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        CloudCatalogSettings settings = ((CloudCatalogSettings.Builder)((CloudCatalogSettings.Builder)CloudCatalogSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = CloudCatalogClient.create((CloudCatalogSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listServicesTest() throws Exception {
        Service responsesElement = Service.newBuilder().build();
        ListServicesResponse expectedResponse = ListServicesResponse.newBuilder().setNextPageToken("").addAllServices(Arrays.asList(responsesElement)).build();
        mockCloudCatalog.addResponse((AbstractMessage)expectedResponse);
        CloudCatalogClient.ListServicesPagedResponse pagedListResponse = this.client.listServices();
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getServicesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudCatalog.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListServicesRequest actualRequest = (ListServicesRequest)actualRequests.get(0);
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listServicesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudCatalog.addException((Exception)exception);
        try {
            ListServicesRequest request = ListServicesRequest.newBuilder().setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.listServices(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSkusTest() throws Exception {
        Sku responsesElement = Sku.newBuilder().build();
        ListSkusResponse expectedResponse = ListSkusResponse.newBuilder().setNextPageToken("").addAllSkus(Arrays.asList(responsesElement)).build();
        mockCloudCatalog.addResponse((AbstractMessage)expectedResponse);
        ServiceName parent = ServiceName.of((String)"[SERVICE]");
        CloudCatalogClient.ListSkusPagedResponse pagedListResponse = this.client.listSkus(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSkusList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudCatalog.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSkusRequest actualRequest = (ListSkusRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSkusExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudCatalog.addException((Exception)exception);
        try {
            ServiceName parent = ServiceName.of((String)"[SERVICE]");
            this.client.listSkus(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSkusTest2() throws Exception {
        Sku responsesElement = Sku.newBuilder().build();
        ListSkusResponse expectedResponse = ListSkusResponse.newBuilder().setNextPageToken("").addAllSkus(Arrays.asList(responsesElement)).build();
        mockCloudCatalog.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        CloudCatalogClient.ListSkusPagedResponse pagedListResponse = this.client.listSkus(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSkusList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudCatalog.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSkusRequest actualRequest = (ListSkusRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSkusExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudCatalog.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSkus(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

