/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.billing.v1.BillingAccount;
import com.google.cloud.billing.v1.BillingAccountName;
import com.google.cloud.billing.v1.CloudBillingClient;
import com.google.cloud.billing.v1.CloudBillingSettings;
import com.google.cloud.billing.v1.CreateBillingAccountRequest;
import com.google.cloud.billing.v1.GetBillingAccountRequest;
import com.google.cloud.billing.v1.GetProjectBillingInfoRequest;
import com.google.cloud.billing.v1.ListBillingAccountsRequest;
import com.google.cloud.billing.v1.ListBillingAccountsResponse;
import com.google.cloud.billing.v1.ListProjectBillingInfoRequest;
import com.google.cloud.billing.v1.ListProjectBillingInfoResponse;
import com.google.cloud.billing.v1.MockCloudBilling;
import com.google.cloud.billing.v1.ProjectBillingInfo;
import com.google.cloud.billing.v1.ProjectName;
import com.google.cloud.billing.v1.UpdateBillingAccountRequest;
import com.google.cloud.billing.v1.UpdateProjectBillingInfoRequest;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CloudBillingClientTest {
    private static MockCloudBilling mockCloudBilling;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private CloudBillingClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockCloudBilling = new MockCloudBilling();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockCloudBilling));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        CloudBillingSettings settings = ((CloudBillingSettings.Builder)((CloudBillingSettings.Builder)CloudBillingSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = CloudBillingClient.create((CloudBillingSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void getBillingAccountTest() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.of((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        BillingAccountName name = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
        BillingAccount actualResponse = this.client.getBillingAccount(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetBillingAccountRequest actualRequest = (GetBillingAccountRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getBillingAccountExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            BillingAccountName name = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
            this.client.getBillingAccount(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBillingAccountTest2() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.of((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        BillingAccount actualResponse = this.client.getBillingAccount(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetBillingAccountRequest actualRequest = (GetBillingAccountRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getBillingAccountExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getBillingAccount(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBillingAccountsTest() throws Exception {
        BillingAccount responsesElement = BillingAccount.newBuilder().build();
        ListBillingAccountsResponse expectedResponse = ListBillingAccountsResponse.newBuilder().setNextPageToken("").addAllBillingAccounts(Arrays.asList(responsesElement)).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        CloudBillingClient.ListBillingAccountsPagedResponse pagedListResponse = this.client.listBillingAccounts();
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBillingAccountsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBillingAccountsRequest actualRequest = (ListBillingAccountsRequest)actualRequests.get(0);
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBillingAccountsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            ListBillingAccountsRequest request = ListBillingAccountsRequest.newBuilder().setPageSize(883849137).setPageToken("pageToken873572522").setFilter("filter-1274492040").build();
            this.client.listBillingAccounts(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateBillingAccountTest() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.of((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        BillingAccountName name = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
        BillingAccount account = BillingAccount.newBuilder().build();
        BillingAccount actualResponse = this.client.updateBillingAccount(name, account);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateBillingAccountRequest actualRequest = (UpdateBillingAccountRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)account, (Object)actualRequest.getAccount());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateBillingAccountExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            BillingAccountName name = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
            BillingAccount account = BillingAccount.newBuilder().build();
            this.client.updateBillingAccount(name, account);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateBillingAccountTest2() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.of((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        BillingAccount account = BillingAccount.newBuilder().build();
        BillingAccount actualResponse = this.client.updateBillingAccount(name, account);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateBillingAccountRequest actualRequest = (UpdateBillingAccountRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)account, (Object)actualRequest.getAccount());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateBillingAccountExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            String name = "name3373707";
            BillingAccount account = BillingAccount.newBuilder().build();
            this.client.updateBillingAccount(name, account);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBillingAccountTest() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.of((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        BillingAccount billingAccount = BillingAccount.newBuilder().build();
        BillingAccount actualResponse = this.client.createBillingAccount(billingAccount);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBillingAccountRequest actualRequest = (CreateBillingAccountRequest)actualRequests.get(0);
        Assert.assertEquals((Object)billingAccount, (Object)actualRequest.getBillingAccount());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBillingAccountExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            BillingAccount billingAccount = BillingAccount.newBuilder().build();
            this.client.createBillingAccount(billingAccount);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProjectBillingInfoTest() throws Exception {
        ProjectBillingInfo responsesElement = ProjectBillingInfo.newBuilder().build();
        ListProjectBillingInfoResponse expectedResponse = ListProjectBillingInfoResponse.newBuilder().setNextPageToken("").addAllProjectBillingInfo(Arrays.asList(responsesElement)).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        BillingAccountName name = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
        CloudBillingClient.ListProjectBillingInfoPagedResponse pagedListResponse = this.client.listProjectBillingInfo(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProjectBillingInfoList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProjectBillingInfoRequest actualRequest = (ListProjectBillingInfoRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProjectBillingInfoExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            BillingAccountName name = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
            this.client.listProjectBillingInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProjectBillingInfoTest2() throws Exception {
        ProjectBillingInfo responsesElement = ProjectBillingInfo.newBuilder().build();
        ListProjectBillingInfoResponse expectedResponse = ListProjectBillingInfoResponse.newBuilder().setNextPageToken("").addAllProjectBillingInfo(Arrays.asList(responsesElement)).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        CloudBillingClient.ListProjectBillingInfoPagedResponse pagedListResponse = this.client.listProjectBillingInfo(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProjectBillingInfoList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProjectBillingInfoRequest actualRequest = (ListProjectBillingInfoRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProjectBillingInfoExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.listProjectBillingInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProjectBillingInfoTest() throws Exception {
        ProjectBillingInfo expectedResponse = ProjectBillingInfo.newBuilder().setName("name3373707").setProjectId("projectId-894832108").setBillingAccountName("billingAccountName929322205").setBillingEnabled(true).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        ProjectBillingInfo actualResponse = this.client.getProjectBillingInfo(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProjectBillingInfoRequest actualRequest = (GetProjectBillingInfoRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProjectBillingInfoExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            this.client.getProjectBillingInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProjectBillingInfoTest2() throws Exception {
        ProjectBillingInfo expectedResponse = ProjectBillingInfo.newBuilder().setName("name3373707").setProjectId("projectId-894832108").setBillingAccountName("billingAccountName929322205").setBillingEnabled(true).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ProjectBillingInfo actualResponse = this.client.getProjectBillingInfo(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProjectBillingInfoRequest actualRequest = (GetProjectBillingInfoRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProjectBillingInfoExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getProjectBillingInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProjectBillingInfoTest() throws Exception {
        ProjectBillingInfo expectedResponse = ProjectBillingInfo.newBuilder().setName("name3373707").setProjectId("projectId-894832108").setBillingAccountName("billingAccountName929322205").setBillingEnabled(true).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ProjectBillingInfo projectBillingInfo = ProjectBillingInfo.newBuilder().build();
        ProjectBillingInfo actualResponse = this.client.updateProjectBillingInfo(name, projectBillingInfo);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateProjectBillingInfoRequest actualRequest = (UpdateProjectBillingInfoRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertEquals((Object)projectBillingInfo, (Object)actualRequest.getProjectBillingInfo());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateProjectBillingInfoExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            String name = "name3373707";
            ProjectBillingInfo projectBillingInfo = ProjectBillingInfo.newBuilder().build();
            this.client.updateProjectBillingInfo(name, projectBillingInfo);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        BillingAccountName resource = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
        Policy actualResponse = this.client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            BillingAccountName resource = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
            this.client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy actualResponse = this.client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetIamPolicyRequest actualRequest = (GetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            this.client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        BillingAccountName resource = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            BillingAccountName resource = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = this.client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetIamPolicyRequest actualRequest = (SetIamPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals((Object)policy, (Object)actualRequest.getPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            Policy policy = Policy.newBuilder().build();
            this.client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        BillingAccountName resource = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource.toString(), (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            BillingAccountName resource = BillingAccountName.of((String)"[BILLING_ACCOUNT]");
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockCloudBilling.addResponse((AbstractMessage)expectedResponse);
        String resource = "resource-341064690";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = this.client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudBilling.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TestIamPermissionsRequest actualRequest = (TestIamPermissionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)resource, (Object)actualRequest.getResource());
        Assert.assertEquals(permissions, (Object)actualRequest.getPermissionsList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudBilling.addException((Exception)exception);
        try {
            String resource = "resource-341064690";
            ArrayList permissions = new ArrayList();
            this.client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

