/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.billing.v1.BillingAccount;
import com.google.cloud.billing.v1.BillingAccountName;
import com.google.cloud.billing.v1.CloudBillingSettings;
import com.google.cloud.billing.v1.CreateBillingAccountRequest;
import com.google.cloud.billing.v1.GetBillingAccountRequest;
import com.google.cloud.billing.v1.GetProjectBillingInfoRequest;
import com.google.cloud.billing.v1.ListBillingAccountsRequest;
import com.google.cloud.billing.v1.ListBillingAccountsResponse;
import com.google.cloud.billing.v1.ListProjectBillingInfoRequest;
import com.google.cloud.billing.v1.ListProjectBillingInfoResponse;
import com.google.cloud.billing.v1.ProjectBillingInfo;
import com.google.cloud.billing.v1.ProjectName;
import com.google.cloud.billing.v1.UpdateBillingAccountRequest;
import com.google.cloud.billing.v1.UpdateProjectBillingInfoRequest;
import com.google.cloud.billing.v1.stub.CloudBillingStub;
import com.google.cloud.billing.v1.stub.CloudBillingStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CloudBillingClient
implements BackgroundResource {
    private final CloudBillingSettings settings;
    private final CloudBillingStub stub;

    public static final CloudBillingClient create() throws IOException {
        return CloudBillingClient.create(CloudBillingSettings.newBuilder().build());
    }

    public static final CloudBillingClient create(CloudBillingSettings settings) throws IOException {
        return new CloudBillingClient(settings);
    }

    public static final CloudBillingClient create(CloudBillingStub stub) {
        return new CloudBillingClient(stub);
    }

    protected CloudBillingClient(CloudBillingSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudBillingStubSettings)settings.getStubSettings()).createStub();
    }

    protected CloudBillingClient(CloudBillingStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CloudBillingSettings getSettings() {
        return this.settings;
    }

    public CloudBillingStub getStub() {
        return this.stub;
    }

    public final BillingAccount getBillingAccount(BillingAccountName name) {
        GetBillingAccountRequest request = GetBillingAccountRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBillingAccount(request);
    }

    public final BillingAccount getBillingAccount(String name) {
        GetBillingAccountRequest request = GetBillingAccountRequest.newBuilder().setName(name).build();
        return this.getBillingAccount(request);
    }

    public final BillingAccount getBillingAccount(GetBillingAccountRequest request) {
        return (BillingAccount)this.getBillingAccountCallable().call((Object)request);
    }

    public final UnaryCallable<GetBillingAccountRequest, BillingAccount> getBillingAccountCallable() {
        return this.stub.getBillingAccountCallable();
    }

    public final ListBillingAccountsPagedResponse listBillingAccounts() {
        ListBillingAccountsRequest request = ListBillingAccountsRequest.newBuilder().build();
        return this.listBillingAccounts(request);
    }

    public final ListBillingAccountsPagedResponse listBillingAccounts(ListBillingAccountsRequest request) {
        return (ListBillingAccountsPagedResponse)((Object)this.listBillingAccountsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBillingAccountsRequest, ListBillingAccountsPagedResponse> listBillingAccountsPagedCallable() {
        return this.stub.listBillingAccountsPagedCallable();
    }

    public final UnaryCallable<ListBillingAccountsRequest, ListBillingAccountsResponse> listBillingAccountsCallable() {
        return this.stub.listBillingAccountsCallable();
    }

    public final BillingAccount updateBillingAccount(BillingAccountName name, BillingAccount account) {
        UpdateBillingAccountRequest request = UpdateBillingAccountRequest.newBuilder().setName(name == null ? null : name.toString()).setAccount(account).build();
        return this.updateBillingAccount(request);
    }

    public final BillingAccount updateBillingAccount(String name, BillingAccount account) {
        UpdateBillingAccountRequest request = UpdateBillingAccountRequest.newBuilder().setName(name).setAccount(account).build();
        return this.updateBillingAccount(request);
    }

    public final BillingAccount updateBillingAccount(UpdateBillingAccountRequest request) {
        return (BillingAccount)this.updateBillingAccountCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBillingAccountRequest, BillingAccount> updateBillingAccountCallable() {
        return this.stub.updateBillingAccountCallable();
    }

    public final BillingAccount createBillingAccount(BillingAccount billingAccount) {
        CreateBillingAccountRequest request = CreateBillingAccountRequest.newBuilder().setBillingAccount(billingAccount).build();
        return this.createBillingAccount(request);
    }

    public final BillingAccount createBillingAccount(CreateBillingAccountRequest request) {
        return (BillingAccount)this.createBillingAccountCallable().call((Object)request);
    }

    public final UnaryCallable<CreateBillingAccountRequest, BillingAccount> createBillingAccountCallable() {
        return this.stub.createBillingAccountCallable();
    }

    public final ListProjectBillingInfoPagedResponse listProjectBillingInfo(BillingAccountName name) {
        ListProjectBillingInfoRequest request = ListProjectBillingInfoRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.listProjectBillingInfo(request);
    }

    public final ListProjectBillingInfoPagedResponse listProjectBillingInfo(String name) {
        ListProjectBillingInfoRequest request = ListProjectBillingInfoRequest.newBuilder().setName(name).build();
        return this.listProjectBillingInfo(request);
    }

    public final ListProjectBillingInfoPagedResponse listProjectBillingInfo(ListProjectBillingInfoRequest request) {
        return (ListProjectBillingInfoPagedResponse)((Object)this.listProjectBillingInfoPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProjectBillingInfoRequest, ListProjectBillingInfoPagedResponse> listProjectBillingInfoPagedCallable() {
        return this.stub.listProjectBillingInfoPagedCallable();
    }

    public final UnaryCallable<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse> listProjectBillingInfoCallable() {
        return this.stub.listProjectBillingInfoCallable();
    }

    public final ProjectBillingInfo getProjectBillingInfo(ProjectName name) {
        GetProjectBillingInfoRequest request = GetProjectBillingInfoRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProjectBillingInfo(request);
    }

    public final ProjectBillingInfo getProjectBillingInfo(String name) {
        GetProjectBillingInfoRequest request = GetProjectBillingInfoRequest.newBuilder().setName(name).build();
        return this.getProjectBillingInfo(request);
    }

    public final ProjectBillingInfo getProjectBillingInfo(GetProjectBillingInfoRequest request) {
        return (ProjectBillingInfo)this.getProjectBillingInfoCallable().call((Object)request);
    }

    public final UnaryCallable<GetProjectBillingInfoRequest, ProjectBillingInfo> getProjectBillingInfoCallable() {
        return this.stub.getProjectBillingInfoCallable();
    }

    public final ProjectBillingInfo updateProjectBillingInfo(String name, ProjectBillingInfo projectBillingInfo) {
        UpdateProjectBillingInfoRequest request = UpdateProjectBillingInfoRequest.newBuilder().setName(name).setProjectBillingInfo(projectBillingInfo).build();
        return this.updateProjectBillingInfo(request);
    }

    public final ProjectBillingInfo updateProjectBillingInfo(UpdateProjectBillingInfoRequest request) {
        return (ProjectBillingInfo)this.updateProjectBillingInfoCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateProjectBillingInfoRequest, ProjectBillingInfo> updateProjectBillingInfoCallable() {
        return this.stub.updateProjectBillingInfoCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListProjectBillingInfoFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, ProjectBillingInfo, ListProjectBillingInfoPage, ListProjectBillingInfoFixedSizeCollection> {
        private ListProjectBillingInfoFixedSizeCollection(List<ListProjectBillingInfoPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProjectBillingInfoFixedSizeCollection createEmptyCollection() {
            return new ListProjectBillingInfoFixedSizeCollection(null, 0);
        }

        protected ListProjectBillingInfoFixedSizeCollection createCollection(List<ListProjectBillingInfoPage> pages, int collectionSize) {
            return new ListProjectBillingInfoFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProjectBillingInfoPage
    extends AbstractPage<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, ProjectBillingInfo, ListProjectBillingInfoPage> {
        private ListProjectBillingInfoPage(PageContext<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, ProjectBillingInfo> context, ListProjectBillingInfoResponse response) {
            super(context, (Object)response);
        }

        private static ListProjectBillingInfoPage createEmptyPage() {
            return new ListProjectBillingInfoPage(null, null);
        }

        protected ListProjectBillingInfoPage createPage(PageContext<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, ProjectBillingInfo> context, ListProjectBillingInfoResponse response) {
            return new ListProjectBillingInfoPage(context, response);
        }

        public ApiFuture<ListProjectBillingInfoPage> createPageAsync(PageContext<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, ProjectBillingInfo> context, ApiFuture<ListProjectBillingInfoResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProjectBillingInfoPagedResponse
    extends AbstractPagedListResponse<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, ProjectBillingInfo, ListProjectBillingInfoPage, ListProjectBillingInfoFixedSizeCollection> {
        public static ApiFuture<ListProjectBillingInfoPagedResponse> createAsync(PageContext<ListProjectBillingInfoRequest, ListProjectBillingInfoResponse, ProjectBillingInfo> context, ApiFuture<ListProjectBillingInfoResponse> futureResponse) {
            ApiFuture<ListProjectBillingInfoPage> futurePage = ListProjectBillingInfoPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProjectBillingInfoPagedResponse((ListProjectBillingInfoPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProjectBillingInfoPagedResponse(ListProjectBillingInfoPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProjectBillingInfoFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBillingAccountsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBillingAccountsRequest, ListBillingAccountsResponse, BillingAccount, ListBillingAccountsPage, ListBillingAccountsFixedSizeCollection> {
        private ListBillingAccountsFixedSizeCollection(List<ListBillingAccountsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBillingAccountsFixedSizeCollection createEmptyCollection() {
            return new ListBillingAccountsFixedSizeCollection(null, 0);
        }

        protected ListBillingAccountsFixedSizeCollection createCollection(List<ListBillingAccountsPage> pages, int collectionSize) {
            return new ListBillingAccountsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBillingAccountsPage
    extends AbstractPage<ListBillingAccountsRequest, ListBillingAccountsResponse, BillingAccount, ListBillingAccountsPage> {
        private ListBillingAccountsPage(PageContext<ListBillingAccountsRequest, ListBillingAccountsResponse, BillingAccount> context, ListBillingAccountsResponse response) {
            super(context, (Object)response);
        }

        private static ListBillingAccountsPage createEmptyPage() {
            return new ListBillingAccountsPage(null, null);
        }

        protected ListBillingAccountsPage createPage(PageContext<ListBillingAccountsRequest, ListBillingAccountsResponse, BillingAccount> context, ListBillingAccountsResponse response) {
            return new ListBillingAccountsPage(context, response);
        }

        public ApiFuture<ListBillingAccountsPage> createPageAsync(PageContext<ListBillingAccountsRequest, ListBillingAccountsResponse, BillingAccount> context, ApiFuture<ListBillingAccountsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBillingAccountsPagedResponse
    extends AbstractPagedListResponse<ListBillingAccountsRequest, ListBillingAccountsResponse, BillingAccount, ListBillingAccountsPage, ListBillingAccountsFixedSizeCollection> {
        public static ApiFuture<ListBillingAccountsPagedResponse> createAsync(PageContext<ListBillingAccountsRequest, ListBillingAccountsResponse, BillingAccount> context, ApiFuture<ListBillingAccountsResponse> futureResponse) {
            ApiFuture<ListBillingAccountsPage> futurePage = ListBillingAccountsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBillingAccountsPagedResponse((ListBillingAccountsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBillingAccountsPagedResponse(ListBillingAccountsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBillingAccountsFixedSizeCollection.createEmptyCollection());
        }
    }
}

