/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.billing.v1.BillingAccount;
import com.google.cloud.billing.v1.BillingAccountName;
import com.google.cloud.billing.v1.CloudBillingClient;
import com.google.cloud.billing.v1.CloudBillingSettings;
import com.google.cloud.billing.v1.ListBillingAccountsRequest;
import com.google.cloud.billing.v1.ListBillingAccountsResponse;
import com.google.cloud.billing.v1.ListProjectBillingInfoResponse;
import com.google.cloud.billing.v1.MoveBillingAccountRequest;
import com.google.cloud.billing.v1.OrganizationName;
import com.google.cloud.billing.v1.ProjectBillingInfo;
import com.google.cloud.billing.v1.ProjectName;
import com.google.cloud.billing.v1.stub.HttpJsonCloudBillingStub;
import com.google.common.collect.Lists;
import com.google.iam.v1.Policy;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CloudBillingClientHttpJsonTest {
    private static MockHttpService mockService;
    private static CloudBillingClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonCloudBillingStub.getMethodDescriptors(), CloudBillingSettings.getDefaultEndpoint());
        CloudBillingSettings settings = ((CloudBillingSettings.Builder)((CloudBillingSettings.Builder)CloudBillingSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)CloudBillingSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = CloudBillingClient.create((CloudBillingSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void getBillingAccountTest() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").setParent("parent-995424086").setCurrencyCode("currencyCode1004773790").build();
        mockService.addResponse((Object)expectedResponse);
        BillingAccountName name = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
        BillingAccount actualResponse = client.getBillingAccount(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getBillingAccountExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BillingAccountName name = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
            client.getBillingAccount(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBillingAccountTest2() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").setParent("parent-995424086").setCurrencyCode("currencyCode1004773790").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "billingAccounts/billingAccount-6593";
        BillingAccount actualResponse = client.getBillingAccount(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getBillingAccountExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "billingAccounts/billingAccount-6593";
            client.getBillingAccount(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBillingAccountsTest() throws Exception {
        BillingAccount responsesElement = BillingAccount.newBuilder().build();
        ListBillingAccountsResponse expectedResponse = ListBillingAccountsResponse.newBuilder().setNextPageToken("").addAllBillingAccounts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        CloudBillingClient.ListBillingAccountsPagedResponse pagedListResponse = client.listBillingAccounts();
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBillingAccountsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBillingAccountsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ListBillingAccountsRequest request = ListBillingAccountsRequest.newBuilder().setPageSize(883849137).setPageToken("pageToken873572522").setFilter("filter-1274492040").setParent("parent-995424086").build();
            client.listBillingAccounts(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBillingAccountsTest2() throws Exception {
        BillingAccount responsesElement = BillingAccount.newBuilder().build();
        ListBillingAccountsResponse expectedResponse = ListBillingAccountsResponse.newBuilder().setNextPageToken("").addAllBillingAccounts(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "parent-995424086";
        CloudBillingClient.ListBillingAccountsPagedResponse pagedListResponse = client.listBillingAccounts(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBillingAccountsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBillingAccountsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            client.listBillingAccounts(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateBillingAccountTest() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").setParent("parent-995424086").setCurrencyCode("currencyCode1004773790").build();
        mockService.addResponse((Object)expectedResponse);
        BillingAccountName name = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
        BillingAccount account = BillingAccount.newBuilder().build();
        BillingAccount actualResponse = client.updateBillingAccount(name, account);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateBillingAccountExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BillingAccountName name = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
            BillingAccount account = BillingAccount.newBuilder().build();
            client.updateBillingAccount(name, account);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateBillingAccountTest2() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").setParent("parent-995424086").setCurrencyCode("currencyCode1004773790").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "billingAccounts/billingAccount-6593";
        BillingAccount account = BillingAccount.newBuilder().build();
        BillingAccount actualResponse = client.updateBillingAccount(name, account);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateBillingAccountExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "billingAccounts/billingAccount-6593";
            BillingAccount account = BillingAccount.newBuilder().build();
            client.updateBillingAccount(name, account);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBillingAccountTest() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").setParent("parent-995424086").setCurrencyCode("currencyCode1004773790").build();
        mockService.addResponse((Object)expectedResponse);
        BillingAccount billingAccount = BillingAccount.newBuilder().build();
        BillingAccount actualResponse = client.createBillingAccount(billingAccount);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBillingAccountExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BillingAccount billingAccount = BillingAccount.newBuilder().build();
            client.createBillingAccount(billingAccount);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBillingAccountTest2() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").setParent("parent-995424086").setCurrencyCode("currencyCode1004773790").build();
        mockService.addResponse((Object)expectedResponse);
        BillingAccount billingAccount = BillingAccount.newBuilder().build();
        String parent = "parent-995424086";
        BillingAccount actualResponse = client.createBillingAccount(billingAccount, parent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBillingAccountExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BillingAccount billingAccount = BillingAccount.newBuilder().build();
            String parent = "parent-995424086";
            client.createBillingAccount(billingAccount, parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProjectBillingInfoTest() throws Exception {
        ProjectBillingInfo responsesElement = ProjectBillingInfo.newBuilder().build();
        ListProjectBillingInfoResponse expectedResponse = ListProjectBillingInfoResponse.newBuilder().setNextPageToken("").addAllProjectBillingInfo(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        BillingAccountName name = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
        CloudBillingClient.ListProjectBillingInfoPagedResponse pagedListResponse = client.listProjectBillingInfo(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProjectBillingInfoList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProjectBillingInfoExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BillingAccountName name = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
            client.listProjectBillingInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProjectBillingInfoTest2() throws Exception {
        ProjectBillingInfo responsesElement = ProjectBillingInfo.newBuilder().build();
        ListProjectBillingInfoResponse expectedResponse = ListProjectBillingInfoResponse.newBuilder().setNextPageToken("").addAllProjectBillingInfo(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "billingAccounts/billingAccount-6593";
        CloudBillingClient.ListProjectBillingInfoPagedResponse pagedListResponse = client.listProjectBillingInfo(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProjectBillingInfoList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProjectBillingInfoExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "billingAccounts/billingAccount-6593";
            client.listProjectBillingInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProjectBillingInfoTest() throws Exception {
        ProjectBillingInfo expectedResponse = ProjectBillingInfo.newBuilder().setName("name3373707").setProjectId("projectId-894832108").setBillingAccountName("billingAccountName929322205").setBillingEnabled(true).build();
        mockService.addResponse((Object)expectedResponse);
        ProjectName name = ProjectName.of((String)"[PROJECT]");
        ProjectBillingInfo actualResponse = client.getProjectBillingInfo(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProjectBillingInfoExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProjectName name = ProjectName.of((String)"[PROJECT]");
            client.getProjectBillingInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProjectBillingInfoTest2() throws Exception {
        ProjectBillingInfo expectedResponse = ProjectBillingInfo.newBuilder().setName("name3373707").setProjectId("projectId-894832108").setBillingAccountName("billingAccountName929322205").setBillingEnabled(true).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3664";
        ProjectBillingInfo actualResponse = client.getProjectBillingInfo(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProjectBillingInfoExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3664";
            client.getProjectBillingInfo(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProjectBillingInfoTest() throws Exception {
        ProjectBillingInfo expectedResponse = ProjectBillingInfo.newBuilder().setName("name3373707").setProjectId("projectId-894832108").setBillingAccountName("billingAccountName929322205").setBillingEnabled(true).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3664";
        ProjectBillingInfo projectBillingInfo = ProjectBillingInfo.newBuilder().build();
        ProjectBillingInfo actualResponse = client.updateProjectBillingInfo(name, projectBillingInfo);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateProjectBillingInfoExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3664";
            ProjectBillingInfo projectBillingInfo = ProjectBillingInfo.newBuilder().build();
            client.updateProjectBillingInfo(name, projectBillingInfo);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        BillingAccountName resource = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
        Policy actualResponse = client.getIamPolicy((ResourceName)resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BillingAccountName resource = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
            client.getIamPolicy((ResourceName)resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "billingAccounts/billingAccount-2850";
        Policy actualResponse = client.getIamPolicy(resource);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getIamPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "billingAccounts/billingAccount-2850";
            client.getIamPolicy(resource);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        BillingAccountName resource = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = client.setIamPolicy((ResourceName)resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BillingAccountName resource = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
            Policy policy = Policy.newBuilder().build();
            client.setIamPolicy((ResourceName)resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void setIamPolicyTest2() throws Exception {
        Policy expectedResponse = Policy.newBuilder().setVersion(351608024).addAllBindings(new ArrayList()).addAllAuditConfigs(new ArrayList()).setEtag(ByteString.EMPTY).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "billingAccounts/billingAccount-2850";
        Policy policy = Policy.newBuilder().build();
        Policy actualResponse = client.setIamPolicy(resource, policy);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void setIamPolicyExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "billingAccounts/billingAccount-2850";
            Policy policy = Policy.newBuilder().build();
            client.setIamPolicy(resource, policy);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        BillingAccountName resource = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions((ResourceName)resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BillingAccountName resource = BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]");
            ArrayList permissions = new ArrayList();
            client.testIamPermissions((ResourceName)resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIamPermissionsTest2() throws Exception {
        TestIamPermissionsResponse expectedResponse = TestIamPermissionsResponse.newBuilder().addAllPermissions(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String resource = "billingAccounts/billingAccount-2850";
        ArrayList permissions = new ArrayList();
        TestIamPermissionsResponse actualResponse = client.testIamPermissions(resource, permissions);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void testIamPermissionsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String resource = "billingAccounts/billingAccount-2850";
            ArrayList permissions = new ArrayList();
            client.testIamPermissions(resource, permissions);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void moveBillingAccountTest() throws Exception {
        BillingAccount expectedResponse = BillingAccount.newBuilder().setName(BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]").toString()).setOpen(true).setDisplayName("displayName1714148973").setMasterBillingAccount("masterBillingAccount1488941620").setParent("parent-995424086").setCurrencyCode("currencyCode1004773790").build();
        mockService.addResponse((Object)expectedResponse);
        MoveBillingAccountRequest request = MoveBillingAccountRequest.newBuilder().setName(BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]").toString()).setDestinationParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).build();
        BillingAccount actualResponse = client.moveBillingAccount(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void moveBillingAccountExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            MoveBillingAccountRequest request = MoveBillingAccountRequest.newBuilder().setName(BillingAccountName.ofBillingAccountName((String)"[BILLING_ACCOUNT]").toString()).setDestinationParent(OrganizationName.of((String)"[ORGANIZATION]").toString()).build();
            client.moveBillingAccount(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

