/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.lineage.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesRequest;
import com.google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesResponse;
import com.google.cloud.datacatalog.lineage.v1.LineageClient;
import com.google.cloud.datacatalog.lineage.v1.LineageEvent;
import com.google.cloud.datacatalog.lineage.v1.LineageEventName;
import com.google.cloud.datacatalog.lineage.v1.LineageSettings;
import com.google.cloud.datacatalog.lineage.v1.Link;
import com.google.cloud.datacatalog.lineage.v1.ListLineageEventsResponse;
import com.google.cloud.datacatalog.lineage.v1.ListProcessesResponse;
import com.google.cloud.datacatalog.lineage.v1.ListRunsResponse;
import com.google.cloud.datacatalog.lineage.v1.LocationName;
import com.google.cloud.datacatalog.lineage.v1.Origin;
import com.google.cloud.datacatalog.lineage.v1.Process;
import com.google.cloud.datacatalog.lineage.v1.ProcessLinks;
import com.google.cloud.datacatalog.lineage.v1.ProcessName;
import com.google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventResponse;
import com.google.cloud.datacatalog.lineage.v1.Run;
import com.google.cloud.datacatalog.lineage.v1.RunName;
import com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest;
import com.google.cloud.datacatalog.lineage.v1.SearchLinksResponse;
import com.google.cloud.datacatalog.lineage.v1.stub.HttpJsonLineageStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LineageClientHttpJsonTest {
    private static MockHttpService mockService;
    private static LineageClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonLineageStub.getMethodDescriptors(), LineageSettings.getDefaultEndpoint());
        LineageSettings settings = ((LineageSettings.Builder)((LineageSettings.Builder)LineageSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)LineageSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = LineageClient.create((LineageSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void processOpenLineageRunEventTest() throws Exception {
        ProcessOpenLineageRunEventResponse expectedResponse = ProcessOpenLineageRunEventResponse.newBuilder().setProcess(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setRun(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).addAllLineageEvents(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        Struct openLineage = Struct.newBuilder().build();
        ProcessOpenLineageRunEventResponse actualResponse = client.processOpenLineageRunEvent(parent, openLineage);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void processOpenLineageRunEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Struct openLineage = Struct.newBuilder().build();
            client.processOpenLineageRunEvent(parent, openLineage);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Process process = Process.newBuilder().build();
        Process actualResponse = client.createProcess(parent, process);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createProcessExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Process process = Process.newBuilder().build();
            client.createProcess(parent, process);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProcessTest2() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        Process process = Process.newBuilder().build();
        Process actualResponse = client.createProcess(parent, process);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createProcessExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Process process = Process.newBuilder().build();
            client.createProcess(parent, process);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        Process process = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Process actualResponse = client.updateProcess(process, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateProcessExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Process process = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateProcess(process, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
        Process actualResponse = client.getProcess(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProcessExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
            client.getProcess(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessTest2() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4077/locations/location-4077/processes/processe-4077";
        Process actualResponse = client.getProcess(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getProcessExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4077/locations/location-4077/processes/processe-4077";
            client.getProcess(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProcessesTest() throws Exception {
        Process responsesElement = Process.newBuilder().build();
        ListProcessesResponse expectedResponse = ListProcessesResponse.newBuilder().setNextPageToken("").addAllProcesses(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        LineageClient.ListProcessesPagedResponse pagedListResponse = client.listProcesses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProcessesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listProcesses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProcessesTest2() throws Exception {
        Process responsesElement = Process.newBuilder().build();
        ListProcessesResponse expectedResponse = ListProcessesResponse.newBuilder().setNextPageToken("").addAllProcesses(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        LineageClient.ListProcessesPagedResponse pagedListResponse = client.listProcesses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listProcessesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listProcesses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProcessTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
        client.deleteProcessAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteProcessExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
            client.deleteProcessAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProcessTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-4077/locations/location-4077/processes/processe-4077";
        client.deleteProcessAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteProcessExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4077/locations/location-4077/processes/processe-4077";
            client.deleteProcessAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createRunTest() throws Exception {
        Run expectedResponse = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        ProcessName parent = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
        Run run = Run.newBuilder().build();
        Run actualResponse = client.createRun(parent, run);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createRunExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProcessName parent = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
            Run run = Run.newBuilder().build();
            client.createRun(parent, run);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createRunTest2() throws Exception {
        Run expectedResponse = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8610/locations/location-8610/processes/processe-8610";
        Run run = Run.newBuilder().build();
        Run actualResponse = client.createRun(parent, run);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createRunExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8610/locations/location-8610/processes/processe-8610";
            Run run = Run.newBuilder().build();
            client.createRun(parent, run);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateRunTest() throws Exception {
        Run expectedResponse = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        Run run = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Run actualResponse = client.updateRun(run, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateRunExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Run run = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateRun(run, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRunTest() throws Exception {
        Run expectedResponse = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        RunName name = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
        Run actualResponse = client.getRun(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getRunExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RunName name = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
            client.getRun(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRunTest2() throws Exception {
        Run expectedResponse = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-2865/locations/location-2865/processes/processe-2865/runs/run-2865";
        Run actualResponse = client.getRun(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getRunExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2865/locations/location-2865/processes/processe-2865/runs/run-2865";
            client.getRun(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRunsTest() throws Exception {
        Run responsesElement = Run.newBuilder().build();
        ListRunsResponse expectedResponse = ListRunsResponse.newBuilder().setNextPageToken("").addAllRuns(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ProcessName parent = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
        LineageClient.ListRunsPagedResponse pagedListResponse = client.listRuns(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRunsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listRunsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ProcessName parent = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
            client.listRuns(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRunsTest2() throws Exception {
        Run responsesElement = Run.newBuilder().build();
        ListRunsResponse expectedResponse = ListRunsResponse.newBuilder().setNextPageToken("").addAllRuns(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-8610/locations/location-8610/processes/processe-8610";
        LineageClient.ListRunsPagedResponse pagedListResponse = client.listRuns(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRunsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listRunsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-8610/locations/location-8610/processes/processe-8610";
            client.listRuns(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteRunTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRunTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RunName name = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
        client.deleteRunAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteRunExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RunName name = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
            client.deleteRunAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteRunTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRunTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-2865/locations/location-2865/processes/processe-2865/runs/run-2865";
        client.deleteRunAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteRunExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2865/locations/location-2865/processes/processe-2865/runs/run-2865";
            client.deleteRunAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createLineageEventTest() throws Exception {
        LineageEvent expectedResponse = LineageEvent.newBuilder().setName(LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]").toString()).addAllLinks(new ArrayList()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        RunName parent = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
        LineageEvent lineageEvent = LineageEvent.newBuilder().build();
        LineageEvent actualResponse = client.createLineageEvent(parent, lineageEvent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createLineageEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RunName parent = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
            LineageEvent lineageEvent = LineageEvent.newBuilder().build();
            client.createLineageEvent(parent, lineageEvent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createLineageEventTest2() throws Exception {
        LineageEvent expectedResponse = LineageEvent.newBuilder().setName(LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]").toString()).addAllLinks(new ArrayList()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2464/locations/location-2464/processes/processe-2464/runs/run-2464";
        LineageEvent lineageEvent = LineageEvent.newBuilder().build();
        LineageEvent actualResponse = client.createLineageEvent(parent, lineageEvent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createLineageEventExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2464/locations/location-2464/processes/processe-2464/runs/run-2464";
            LineageEvent lineageEvent = LineageEvent.newBuilder().build();
            client.createLineageEvent(parent, lineageEvent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLineageEventTest() throws Exception {
        LineageEvent expectedResponse = LineageEvent.newBuilder().setName(LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]").toString()).addAllLinks(new ArrayList()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        LineageEventName name = LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]");
        LineageEvent actualResponse = client.getLineageEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getLineageEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LineageEventName name = LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]");
            client.getLineageEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLineageEventTest2() throws Exception {
        LineageEvent expectedResponse = LineageEvent.newBuilder().setName(LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]").toString()).addAllLinks(new ArrayList()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8417/locations/location-8417/processes/processe-8417/runs/run-8417/lineageEvents/lineageEvent-8417";
        LineageEvent actualResponse = client.getLineageEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getLineageEventExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8417/locations/location-8417/processes/processe-8417/runs/run-8417/lineageEvents/lineageEvent-8417";
            client.getLineageEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLineageEventsTest() throws Exception {
        LineageEvent responsesElement = LineageEvent.newBuilder().build();
        ListLineageEventsResponse expectedResponse = ListLineageEventsResponse.newBuilder().setNextPageToken("").addAllLineageEvents(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        RunName parent = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
        LineageClient.ListLineageEventsPagedResponse pagedListResponse = client.listLineageEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLineageEventsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listLineageEventsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RunName parent = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
            client.listLineageEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLineageEventsTest2() throws Exception {
        LineageEvent responsesElement = LineageEvent.newBuilder().build();
        ListLineageEventsResponse expectedResponse = ListLineageEventsResponse.newBuilder().setNextPageToken("").addAllLineageEvents(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-2464/locations/location-2464/processes/processe-2464/runs/run-2464";
        LineageClient.ListLineageEventsPagedResponse pagedListResponse = client.listLineageEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLineageEventsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listLineageEventsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-2464/locations/location-2464/processes/processe-2464/runs/run-2464";
            client.listLineageEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteLineageEventTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        LineageEventName name = LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]");
        client.deleteLineageEvent(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteLineageEventExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LineageEventName name = LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]");
            client.deleteLineageEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteLineageEventTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8417/locations/location-8417/processes/processe-8417/runs/run-8417/lineageEvents/lineageEvent-8417";
        client.deleteLineageEvent(name);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteLineageEventExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8417/locations/location-8417/processes/processe-8417/runs/run-8417/lineageEvents/lineageEvent-8417";
            client.deleteLineageEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchLinksTest() throws Exception {
        Link responsesElement = Link.newBuilder().build();
        SearchLinksResponse expectedResponse = SearchLinksResponse.newBuilder().setNextPageToken("").addAllLinks(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        SearchLinksRequest request = SearchLinksRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setPageSize(883849137).setPageToken("pageToken873572522").build();
        LineageClient.SearchLinksPagedResponse pagedListResponse = client.searchLinks(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLinksList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchLinksExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SearchLinksRequest request = SearchLinksRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setPageSize(883849137).setPageToken("pageToken873572522").build();
            client.searchLinks(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchSearchLinkProcessesTest() throws Exception {
        ProcessLinks responsesElement = ProcessLinks.newBuilder().build();
        BatchSearchLinkProcessesResponse expectedResponse = BatchSearchLinkProcessesResponse.newBuilder().setNextPageToken("").addAllProcessLinks(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        BatchSearchLinkProcessesRequest request = BatchSearchLinkProcessesRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).addAllLinks(new ArrayList()).setPageSize(883849137).setPageToken("pageToken873572522").build();
        LineageClient.BatchSearchLinkProcessesPagedResponse pagedListResponse = client.batchSearchLinkProcesses(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessLinksList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void batchSearchLinkProcessesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BatchSearchLinkProcessesRequest request = BatchSearchLinkProcessesRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).addAllLinks(new ArrayList()).setPageSize(883849137).setPageToken("pageToken873572522").build();
            client.batchSearchLinkProcesses(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

