/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.lineage.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesRequest;
import com.google.cloud.datacatalog.lineage.v1.BatchSearchLinkProcessesResponse;
import com.google.cloud.datacatalog.lineage.v1.CreateLineageEventRequest;
import com.google.cloud.datacatalog.lineage.v1.CreateProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.CreateRunRequest;
import com.google.cloud.datacatalog.lineage.v1.DeleteLineageEventRequest;
import com.google.cloud.datacatalog.lineage.v1.DeleteProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.DeleteRunRequest;
import com.google.cloud.datacatalog.lineage.v1.GetLineageEventRequest;
import com.google.cloud.datacatalog.lineage.v1.GetProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.GetRunRequest;
import com.google.cloud.datacatalog.lineage.v1.LineageClient;
import com.google.cloud.datacatalog.lineage.v1.LineageEvent;
import com.google.cloud.datacatalog.lineage.v1.LineageEventName;
import com.google.cloud.datacatalog.lineage.v1.LineageSettings;
import com.google.cloud.datacatalog.lineage.v1.Link;
import com.google.cloud.datacatalog.lineage.v1.ListLineageEventsRequest;
import com.google.cloud.datacatalog.lineage.v1.ListLineageEventsResponse;
import com.google.cloud.datacatalog.lineage.v1.ListProcessesRequest;
import com.google.cloud.datacatalog.lineage.v1.ListProcessesResponse;
import com.google.cloud.datacatalog.lineage.v1.ListRunsRequest;
import com.google.cloud.datacatalog.lineage.v1.ListRunsResponse;
import com.google.cloud.datacatalog.lineage.v1.LocationName;
import com.google.cloud.datacatalog.lineage.v1.MockLineage;
import com.google.cloud.datacatalog.lineage.v1.Origin;
import com.google.cloud.datacatalog.lineage.v1.Process;
import com.google.cloud.datacatalog.lineage.v1.ProcessLinks;
import com.google.cloud.datacatalog.lineage.v1.ProcessName;
import com.google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventRequest;
import com.google.cloud.datacatalog.lineage.v1.ProcessOpenLineageRunEventResponse;
import com.google.cloud.datacatalog.lineage.v1.Run;
import com.google.cloud.datacatalog.lineage.v1.RunName;
import com.google.cloud.datacatalog.lineage.v1.SearchLinksRequest;
import com.google.cloud.datacatalog.lineage.v1.SearchLinksResponse;
import com.google.cloud.datacatalog.lineage.v1.UpdateProcessRequest;
import com.google.cloud.datacatalog.lineage.v1.UpdateRunRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class LineageClientTest {
    private static MockLineage mockLineage;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private LineageClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockLineage = new MockLineage();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockLineage));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        LineageSettings settings = ((LineageSettings.Builder)((LineageSettings.Builder)LineageSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = LineageClient.create((LineageSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void processOpenLineageRunEventTest() throws Exception {
        ProcessOpenLineageRunEventResponse expectedResponse = ProcessOpenLineageRunEventResponse.newBuilder().setProcess(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setRun(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).addAllLineageEvents(new ArrayList()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Struct openLineage = Struct.newBuilder().build();
        ProcessOpenLineageRunEventResponse actualResponse = this.client.processOpenLineageRunEvent(parent, openLineage);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ProcessOpenLineageRunEventRequest actualRequest = (ProcessOpenLineageRunEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)openLineage, (Object)actualRequest.getOpenLineage());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void processOpenLineageRunEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Struct openLineage = Struct.newBuilder().build();
            this.client.processOpenLineageRunEvent(parent, openLineage);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Process process = Process.newBuilder().build();
        Process actualResponse = this.client.createProcess(parent, process);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProcessRequest actualRequest = (CreateProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)process, (Object)actualRequest.getProcess());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProcessExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Process process = Process.newBuilder().build();
            this.client.createProcess(parent, process);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createProcessTest2() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Process process = Process.newBuilder().build();
        Process actualResponse = this.client.createProcess(parent, process);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateProcessRequest actualRequest = (CreateProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)process, (Object)actualRequest.getProcess());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createProcessExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Process process = Process.newBuilder().build();
            this.client.createProcess(parent, process);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        Process process = Process.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Process actualResponse = this.client.updateProcess(process, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateProcessRequest actualRequest = (UpdateProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)process, (Object)actualRequest.getProcess());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateProcessExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            Process process = Process.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateProcess(process, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessTest() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
        Process actualResponse = this.client.getProcess(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProcessRequest actualRequest = (GetProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProcessExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
            this.client.getProcess(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getProcessTest2() throws Exception {
        Process expectedResponse = Process.newBuilder().setName(ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setOrigin(Origin.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Process actualResponse = this.client.getProcess(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetProcessRequest actualRequest = (GetProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getProcessExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getProcess(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProcessesTest() throws Exception {
        Process responsesElement = Process.newBuilder().build();
        ListProcessesResponse expectedResponse = ListProcessesResponse.newBuilder().setNextPageToken("").addAllProcesses(Arrays.asList(responsesElement)).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        LineageClient.ListProcessesPagedResponse pagedListResponse = this.client.listProcesses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProcessesRequest actualRequest = (ListProcessesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProcessesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listProcesses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listProcessesTest2() throws Exception {
        Process responsesElement = Process.newBuilder().build();
        ListProcessesResponse expectedResponse = ListProcessesResponse.newBuilder().setNextPageToken("").addAllProcesses(Arrays.asList(responsesElement)).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        LineageClient.ListProcessesPagedResponse pagedListResponse = this.client.listProcesses(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListProcessesRequest actualRequest = (ListProcessesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listProcessesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listProcesses(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteProcessTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLineage.addResponse((AbstractMessage)resultOperation);
        ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
        this.client.deleteProcessAsync(name).get();
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProcessRequest actualRequest = (DeleteProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProcessExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            ProcessName name = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
            this.client.deleteProcessAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteProcessTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteProcessTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLineage.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteProcessAsync(name).get();
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteProcessRequest actualRequest = (DeleteProcessRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteProcessExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteProcessAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createRunTest() throws Exception {
        Run expectedResponse = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        ProcessName parent = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
        Run run = Run.newBuilder().build();
        Run actualResponse = this.client.createRun(parent, run);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateRunRequest actualRequest = (CreateRunRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)run, (Object)actualRequest.getRun());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createRunExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            ProcessName parent = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
            Run run = Run.newBuilder().build();
            this.client.createRun(parent, run);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createRunTest2() throws Exception {
        Run expectedResponse = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        Run run = Run.newBuilder().build();
        Run actualResponse = this.client.createRun(parent, run);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateRunRequest actualRequest = (CreateRunRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)run, (Object)actualRequest.getRun());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createRunExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Run run = Run.newBuilder().build();
            this.client.createRun(parent, run);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateRunTest() throws Exception {
        Run expectedResponse = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        Run run = Run.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Run actualResponse = this.client.updateRun(run, updateMask);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateRunRequest actualRequest = (UpdateRunRequest)actualRequests.get(0);
        Assert.assertEquals((Object)run, (Object)actualRequest.getRun());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateRunExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            Run run = Run.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateRun(run, updateMask);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRunTest() throws Exception {
        Run expectedResponse = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        RunName name = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
        Run actualResponse = this.client.getRun(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRunRequest actualRequest = (GetRunRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRunExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            RunName name = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
            this.client.getRun(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRunTest2() throws Exception {
        Run expectedResponse = Run.newBuilder().setName(RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]").toString()).setDisplayName("displayName1714148973").putAllAttributes(new HashMap()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Run actualResponse = this.client.getRun(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRunRequest actualRequest = (GetRunRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRunExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getRun(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRunsTest() throws Exception {
        Run responsesElement = Run.newBuilder().build();
        ListRunsResponse expectedResponse = ListRunsResponse.newBuilder().setNextPageToken("").addAllRuns(Arrays.asList(responsesElement)).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        ProcessName parent = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
        LineageClient.ListRunsPagedResponse pagedListResponse = this.client.listRuns(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRunsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRunsRequest actualRequest = (ListRunsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRunsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            ProcessName parent = ProcessName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]");
            this.client.listRuns(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRunsTest2() throws Exception {
        Run responsesElement = Run.newBuilder().build();
        ListRunsResponse expectedResponse = ListRunsResponse.newBuilder().setNextPageToken("").addAllRuns(Arrays.asList(responsesElement)).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        LineageClient.ListRunsPagedResponse pagedListResponse = this.client.listRuns(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRunsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRunsRequest actualRequest = (ListRunsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRunsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listRuns(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteRunTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRunTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLineage.addResponse((AbstractMessage)resultOperation);
        RunName name = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
        this.client.deleteRunAsync(name).get();
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteRunRequest actualRequest = (DeleteRunRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteRunExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            RunName name = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
            this.client.deleteRunAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteRunTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRunTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockLineage.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteRunAsync(name).get();
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteRunRequest actualRequest = (DeleteRunRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteRunExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteRunAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createLineageEventTest() throws Exception {
        LineageEvent expectedResponse = LineageEvent.newBuilder().setName(LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]").toString()).addAllLinks(new ArrayList()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        RunName parent = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
        LineageEvent lineageEvent = LineageEvent.newBuilder().build();
        LineageEvent actualResponse = this.client.createLineageEvent(parent, lineageEvent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateLineageEventRequest actualRequest = (CreateLineageEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)lineageEvent, (Object)actualRequest.getLineageEvent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createLineageEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            RunName parent = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
            LineageEvent lineageEvent = LineageEvent.newBuilder().build();
            this.client.createLineageEvent(parent, lineageEvent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createLineageEventTest2() throws Exception {
        LineageEvent expectedResponse = LineageEvent.newBuilder().setName(LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]").toString()).addAllLinks(new ArrayList()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        LineageEvent lineageEvent = LineageEvent.newBuilder().build();
        LineageEvent actualResponse = this.client.createLineageEvent(parent, lineageEvent);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateLineageEventRequest actualRequest = (CreateLineageEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)lineageEvent, (Object)actualRequest.getLineageEvent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createLineageEventExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            LineageEvent lineageEvent = LineageEvent.newBuilder().build();
            this.client.createLineageEvent(parent, lineageEvent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLineageEventTest() throws Exception {
        LineageEvent expectedResponse = LineageEvent.newBuilder().setName(LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]").toString()).addAllLinks(new ArrayList()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        LineageEventName name = LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]");
        LineageEvent actualResponse = this.client.getLineageEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetLineageEventRequest actualRequest = (GetLineageEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getLineageEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            LineageEventName name = LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]");
            this.client.getLineageEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLineageEventTest2() throws Exception {
        LineageEvent expectedResponse = LineageEvent.newBuilder().setName(LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]").toString()).addAllLinks(new ArrayList()).setStartTime(Timestamp.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        LineageEvent actualResponse = this.client.getLineageEvent(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetLineageEventRequest actualRequest = (GetLineageEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getLineageEventExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getLineageEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLineageEventsTest() throws Exception {
        LineageEvent responsesElement = LineageEvent.newBuilder().build();
        ListLineageEventsResponse expectedResponse = ListLineageEventsResponse.newBuilder().setNextPageToken("").addAllLineageEvents(Arrays.asList(responsesElement)).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        RunName parent = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
        LineageClient.ListLineageEventsPagedResponse pagedListResponse = this.client.listLineageEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLineageEventsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListLineageEventsRequest actualRequest = (ListLineageEventsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listLineageEventsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            RunName parent = RunName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]");
            this.client.listLineageEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listLineageEventsTest2() throws Exception {
        LineageEvent responsesElement = LineageEvent.newBuilder().build();
        ListLineageEventsResponse expectedResponse = ListLineageEventsResponse.newBuilder().setNextPageToken("").addAllLineageEvents(Arrays.asList(responsesElement)).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        LineageClient.ListLineageEventsPagedResponse pagedListResponse = this.client.listLineageEvents(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLineageEventsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListLineageEventsRequest actualRequest = (ListLineageEventsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listLineageEventsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listLineageEvents(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteLineageEventTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        LineageEventName name = LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]");
        this.client.deleteLineageEvent(name);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteLineageEventRequest actualRequest = (DeleteLineageEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteLineageEventExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            LineageEventName name = LineageEventName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PROCESS]", (String)"[RUN]", (String)"[LINEAGE_EVENT]");
            this.client.deleteLineageEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteLineageEventTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteLineageEvent(name);
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteLineageEventRequest actualRequest = (DeleteLineageEventRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteLineageEventExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteLineageEvent(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchLinksTest() throws Exception {
        Link responsesElement = Link.newBuilder().build();
        SearchLinksResponse expectedResponse = SearchLinksResponse.newBuilder().setNextPageToken("").addAllLinks(Arrays.asList(responsesElement)).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        SearchLinksRequest request = SearchLinksRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setPageSize(883849137).setPageToken("pageToken873572522").build();
        LineageClient.SearchLinksPagedResponse pagedListResponse = this.client.searchLinks(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLinksList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchLinksRequest actualRequest = (SearchLinksRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getSource(), (Object)actualRequest.getSource());
        Assert.assertEquals((Object)request.getTarget(), (Object)actualRequest.getTarget());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchLinksExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            SearchLinksRequest request = SearchLinksRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.searchLinks(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void batchSearchLinkProcessesTest() throws Exception {
        ProcessLinks responsesElement = ProcessLinks.newBuilder().build();
        BatchSearchLinkProcessesResponse expectedResponse = BatchSearchLinkProcessesResponse.newBuilder().setNextPageToken("").addAllProcessLinks(Arrays.asList(responsesElement)).build();
        mockLineage.addResponse((AbstractMessage)expectedResponse);
        BatchSearchLinkProcessesRequest request = BatchSearchLinkProcessesRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).addAllLinks(new ArrayList()).setPageSize(883849137).setPageToken("pageToken873572522").build();
        LineageClient.BatchSearchLinkProcessesPagedResponse pagedListResponse = this.client.batchSearchLinkProcesses(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getProcessLinksList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLineage.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        BatchSearchLinkProcessesRequest actualRequest = (BatchSearchLinkProcessesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getLinksList(), (Object)actualRequest.getLinksList());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void batchSearchLinkProcessesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLineage.addException((Exception)exception);
        try {
            BatchSearchLinkProcessesRequest request = BatchSearchLinkProcessesRequest.newBuilder().setParent(LocationName.of((String)"[PROJECT]", (String)"[LOCATION]").toString()).addAllLinks(new ArrayList()).setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.batchSearchLinkProcesses(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

