/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.clouddms.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.clouddms.v1.ApplyConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.CommitConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.ConnectionProfile;
import com.google.cloud.clouddms.v1.ConnectionProfileName;
import com.google.cloud.clouddms.v1.ConversionWorkspace;
import com.google.cloud.clouddms.v1.ConversionWorkspaceInfo;
import com.google.cloud.clouddms.v1.ConversionWorkspaceName;
import com.google.cloud.clouddms.v1.ConvertConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.CreateConnectionProfileRequest;
import com.google.cloud.clouddms.v1.CreateConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.CreateMappingRuleRequest;
import com.google.cloud.clouddms.v1.CreateMigrationJobRequest;
import com.google.cloud.clouddms.v1.CreatePrivateConnectionRequest;
import com.google.cloud.clouddms.v1.DataMigrationServiceClient;
import com.google.cloud.clouddms.v1.DataMigrationServiceSettings;
import com.google.cloud.clouddms.v1.DatabaseEngineInfo;
import com.google.cloud.clouddms.v1.DatabaseEntity;
import com.google.cloud.clouddms.v1.DatabaseEntityType;
import com.google.cloud.clouddms.v1.DatabaseEntityView;
import com.google.cloud.clouddms.v1.DatabaseProvider;
import com.google.cloud.clouddms.v1.DatabaseType;
import com.google.cloud.clouddms.v1.DeleteConnectionProfileRequest;
import com.google.cloud.clouddms.v1.DeleteConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.DeleteMappingRuleRequest;
import com.google.cloud.clouddms.v1.DeleteMigrationJobRequest;
import com.google.cloud.clouddms.v1.DeletePrivateConnectionRequest;
import com.google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsRequest;
import com.google.cloud.clouddms.v1.DescribeConversionWorkspaceRevisionsResponse;
import com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesRequest;
import com.google.cloud.clouddms.v1.DescribeDatabaseEntitiesResponse;
import com.google.cloud.clouddms.v1.FetchStaticIpsRequest;
import com.google.cloud.clouddms.v1.FetchStaticIpsResponse;
import com.google.cloud.clouddms.v1.GenerateSshScriptRequest;
import com.google.cloud.clouddms.v1.GenerateTcpProxyScriptRequest;
import com.google.cloud.clouddms.v1.GetConnectionProfileRequest;
import com.google.cloud.clouddms.v1.GetConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.GetMappingRuleRequest;
import com.google.cloud.clouddms.v1.GetMigrationJobRequest;
import com.google.cloud.clouddms.v1.GetPrivateConnectionRequest;
import com.google.cloud.clouddms.v1.ImportMappingRulesRequest;
import com.google.cloud.clouddms.v1.ImportRulesFileFormat;
import com.google.cloud.clouddms.v1.ListConnectionProfilesRequest;
import com.google.cloud.clouddms.v1.ListConnectionProfilesResponse;
import com.google.cloud.clouddms.v1.ListConversionWorkspacesRequest;
import com.google.cloud.clouddms.v1.ListConversionWorkspacesResponse;
import com.google.cloud.clouddms.v1.ListMappingRulesRequest;
import com.google.cloud.clouddms.v1.ListMappingRulesResponse;
import com.google.cloud.clouddms.v1.ListMigrationJobsRequest;
import com.google.cloud.clouddms.v1.ListMigrationJobsResponse;
import com.google.cloud.clouddms.v1.ListPrivateConnectionsRequest;
import com.google.cloud.clouddms.v1.ListPrivateConnectionsResponse;
import com.google.cloud.clouddms.v1.LocationName;
import com.google.cloud.clouddms.v1.MappingRule;
import com.google.cloud.clouddms.v1.MappingRuleFilter;
import com.google.cloud.clouddms.v1.MappingRuleName;
import com.google.cloud.clouddms.v1.MigrationJob;
import com.google.cloud.clouddms.v1.MigrationJobName;
import com.google.cloud.clouddms.v1.MockDataMigrationService;
import com.google.cloud.clouddms.v1.PrivateConnection;
import com.google.cloud.clouddms.v1.PrivateConnectionName;
import com.google.cloud.clouddms.v1.PromoteMigrationJobRequest;
import com.google.cloud.clouddms.v1.RestartMigrationJobRequest;
import com.google.cloud.clouddms.v1.ResumeMigrationJobRequest;
import com.google.cloud.clouddms.v1.RollbackConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.SearchBackgroundJobsRequest;
import com.google.cloud.clouddms.v1.SearchBackgroundJobsResponse;
import com.google.cloud.clouddms.v1.SeedConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.SshScript;
import com.google.cloud.clouddms.v1.StartMigrationJobRequest;
import com.google.cloud.clouddms.v1.StopMigrationJobRequest;
import com.google.cloud.clouddms.v1.TcpProxyScript;
import com.google.cloud.clouddms.v1.UpdateConnectionProfileRequest;
import com.google.cloud.clouddms.v1.UpdateConversionWorkspaceRequest;
import com.google.cloud.clouddms.v1.UpdateMigrationJobRequest;
import com.google.cloud.clouddms.v1.VerifyMigrationJobRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DataMigrationServiceClientTest {
    private static MockDataMigrationService mockDataMigrationService;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private DataMigrationServiceClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockDataMigrationService = new MockDataMigrationService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockDataMigrationService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        DataMigrationServiceSettings settings = ((DataMigrationServiceSettings.Builder)((DataMigrationServiceSettings.Builder)DataMigrationServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = DataMigrationServiceClient.create((DataMigrationServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listMigrationJobsTest() throws Exception {
        MigrationJob responsesElement = MigrationJob.newBuilder().build();
        ListMigrationJobsResponse expectedResponse = ListMigrationJobsResponse.newBuilder().setNextPageToken("").addAllMigrationJobs(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        DataMigrationServiceClient.ListMigrationJobsPagedResponse pagedListResponse = this.client.listMigrationJobs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMigrationJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMigrationJobsRequest actualRequest = (ListMigrationJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMigrationJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listMigrationJobs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMigrationJobsTest2() throws Exception {
        MigrationJob responsesElement = MigrationJob.newBuilder().build();
        ListMigrationJobsResponse expectedResponse = ListMigrationJobsResponse.newBuilder().setNextPageToken("").addAllMigrationJobs(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DataMigrationServiceClient.ListMigrationJobsPagedResponse pagedListResponse = this.client.listMigrationJobs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMigrationJobsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMigrationJobsRequest actualRequest = (ListMigrationJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMigrationJobsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listMigrationJobs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMigrationJobTest() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        MigrationJobName name = MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]");
        MigrationJob actualResponse = this.client.getMigrationJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetMigrationJobRequest actualRequest = (GetMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getMigrationJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            MigrationJobName name = MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]");
            this.client.getMigrationJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMigrationJobTest2() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        MigrationJob actualResponse = this.client.getMigrationJob(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetMigrationJobRequest actualRequest = (GetMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getMigrationJobExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getMigrationJob(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMigrationJobTest() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        MigrationJob migrationJob = MigrationJob.newBuilder().build();
        String migrationJobId = "migrationJobId1870575242";
        MigrationJob actualResponse = (MigrationJob)this.client.createMigrationJobAsync(parent, migrationJob, migrationJobId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMigrationJobRequest actualRequest = (CreateMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)migrationJob, (Object)actualRequest.getMigrationJob());
        Assert.assertEquals((Object)migrationJobId, (Object)actualRequest.getMigrationJobId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMigrationJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            MigrationJob migrationJob = MigrationJob.newBuilder().build();
            String migrationJobId = "migrationJobId1870575242";
            this.client.createMigrationJobAsync(parent, migrationJob, migrationJobId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createMigrationJobTest2() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        MigrationJob migrationJob = MigrationJob.newBuilder().build();
        String migrationJobId = "migrationJobId1870575242";
        MigrationJob actualResponse = (MigrationJob)this.client.createMigrationJobAsync(parent, migrationJob, migrationJobId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMigrationJobRequest actualRequest = (CreateMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)migrationJob, (Object)actualRequest.getMigrationJob());
        Assert.assertEquals((Object)migrationJobId, (Object)actualRequest.getMigrationJobId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMigrationJobExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            MigrationJob migrationJob = MigrationJob.newBuilder().build();
            String migrationJobId = "migrationJobId1870575242";
            this.client.createMigrationJobAsync(parent, migrationJob, migrationJobId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateMigrationJobTest() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        MigrationJob migrationJob = MigrationJob.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        MigrationJob actualResponse = (MigrationJob)this.client.updateMigrationJobAsync(migrationJob, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateMigrationJobRequest actualRequest = (UpdateMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)migrationJob, (Object)actualRequest.getMigrationJob());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateMigrationJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            MigrationJob migrationJob = MigrationJob.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateMigrationJobAsync(migrationJob, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteMigrationJobTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        MigrationJobName name = MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]");
        this.client.deleteMigrationJobAsync(name).get();
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteMigrationJobRequest actualRequest = (DeleteMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteMigrationJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            MigrationJobName name = MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]");
            this.client.deleteMigrationJobAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteMigrationJobTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteMigrationJobAsync(name).get();
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteMigrationJobRequest actualRequest = (DeleteMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteMigrationJobExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteMigrationJobAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void startMigrationJobTest() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("startMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        StartMigrationJobRequest request = StartMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setSkipValidation(true).build();
        MigrationJob actualResponse = (MigrationJob)this.client.startMigrationJobAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StartMigrationJobRequest actualRequest = (StartMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getSkipValidation(), (Object)actualRequest.getSkipValidation());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void startMigrationJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            StartMigrationJobRequest request = StartMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setSkipValidation(true).build();
            this.client.startMigrationJobAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void stopMigrationJobTest() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("stopMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        StopMigrationJobRequest request = StopMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).build();
        MigrationJob actualResponse = (MigrationJob)this.client.stopMigrationJobAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StopMigrationJobRequest actualRequest = (StopMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void stopMigrationJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            StopMigrationJobRequest request = StopMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).build();
            this.client.stopMigrationJobAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void resumeMigrationJobTest() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("resumeMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        ResumeMigrationJobRequest request = ResumeMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).build();
        MigrationJob actualResponse = (MigrationJob)this.client.resumeMigrationJobAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ResumeMigrationJobRequest actualRequest = (ResumeMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void resumeMigrationJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ResumeMigrationJobRequest request = ResumeMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).build();
            this.client.resumeMigrationJobAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void promoteMigrationJobTest() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("promoteMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        PromoteMigrationJobRequest request = PromoteMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).build();
        MigrationJob actualResponse = (MigrationJob)this.client.promoteMigrationJobAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PromoteMigrationJobRequest actualRequest = (PromoteMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void promoteMigrationJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            PromoteMigrationJobRequest request = PromoteMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).build();
            this.client.promoteMigrationJobAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void verifyMigrationJobTest() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("verifyMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        VerifyMigrationJobRequest request = VerifyMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setUpdateMask(FieldMask.newBuilder().build()).setMigrationJob(MigrationJob.newBuilder().build()).build();
        MigrationJob actualResponse = (MigrationJob)this.client.verifyMigrationJobAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        VerifyMigrationJobRequest actualRequest = (VerifyMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertEquals((Object)request.getMigrationJob(), (Object)actualRequest.getMigrationJob());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void verifyMigrationJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            VerifyMigrationJobRequest request = VerifyMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setUpdateMask(FieldMask.newBuilder().build()).setMigrationJob(MigrationJob.newBuilder().build()).build();
            this.client.verifyMigrationJobAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void restartMigrationJobTest() throws Exception {
        MigrationJob expectedResponse = MigrationJob.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setDumpPath("dumpPath-2122385351").setDumpFlags(MigrationJob.DumpFlags.newBuilder().build()).setSource("source-896505829").setDestination("destination-1429847026").setDuration(Duration.newBuilder().build()).setError(com.google.rpc.Status.newBuilder().build()).setSourceDatabase(DatabaseType.newBuilder().build()).setDestinationDatabase(DatabaseType.newBuilder().build()).setEndTime(Timestamp.newBuilder().build()).setConversionWorkspace(ConversionWorkspaceInfo.newBuilder().build()).setFilter("filter-1274492040").setCmekKeyName("cmekKeyName-1267813158").setPerformanceConfig(MigrationJob.PerformanceConfig.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("restartMigrationJobTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        RestartMigrationJobRequest request = RestartMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setSkipValidation(true).build();
        MigrationJob actualResponse = (MigrationJob)this.client.restartMigrationJobAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RestartMigrationJobRequest actualRequest = (RestartMigrationJobRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getSkipValidation(), (Object)actualRequest.getSkipValidation());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void restartMigrationJobExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            RestartMigrationJobRequest request = RestartMigrationJobRequest.newBuilder().setName(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setSkipValidation(true).build();
            this.client.restartMigrationJobAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void generateSshScriptTest() throws Exception {
        SshScript expectedResponse = SshScript.newBuilder().setScript("script-907685685").build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        GenerateSshScriptRequest request = GenerateSshScriptRequest.newBuilder().setMigrationJob(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setVm("vm3767").setVmPort(563010825).build();
        SshScript actualResponse = this.client.generateSshScript(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GenerateSshScriptRequest actualRequest = (GenerateSshScriptRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getMigrationJob(), (Object)actualRequest.getMigrationJob());
        Assert.assertEquals((Object)request.getVm(), (Object)actualRequest.getVm());
        Assert.assertEquals((Object)request.getVmCreationConfig(), (Object)actualRequest.getVmCreationConfig());
        Assert.assertEquals((Object)request.getVmSelectionConfig(), (Object)actualRequest.getVmSelectionConfig());
        Assert.assertEquals((long)request.getVmPort(), (long)actualRequest.getVmPort());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void generateSshScriptExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            GenerateSshScriptRequest request = GenerateSshScriptRequest.newBuilder().setMigrationJob(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setVm("vm3767").setVmPort(563010825).build();
            this.client.generateSshScript(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void generateTcpProxyScriptTest() throws Exception {
        TcpProxyScript expectedResponse = TcpProxyScript.newBuilder().setScript("script-907685685").build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        GenerateTcpProxyScriptRequest request = GenerateTcpProxyScriptRequest.newBuilder().setMigrationJob(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setVmName("vmName-813643294").setVmMachineType("vmMachineType-1921917718").setVmZone("vmZone-813272317").setVmSubnet("vmSubnet-65857292").build();
        TcpProxyScript actualResponse = this.client.generateTcpProxyScript(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GenerateTcpProxyScriptRequest actualRequest = (GenerateTcpProxyScriptRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getMigrationJob(), (Object)actualRequest.getMigrationJob());
        Assert.assertEquals((Object)request.getVmName(), (Object)actualRequest.getVmName());
        Assert.assertEquals((Object)request.getVmMachineType(), (Object)actualRequest.getVmMachineType());
        Assert.assertEquals((Object)request.getVmZone(), (Object)actualRequest.getVmZone());
        Assert.assertEquals((Object)request.getVmSubnet(), (Object)actualRequest.getVmSubnet());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void generateTcpProxyScriptExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            GenerateTcpProxyScriptRequest request = GenerateTcpProxyScriptRequest.newBuilder().setMigrationJob(MigrationJobName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[MIGRATION_JOB]").toString()).setVmName("vmName-813643294").setVmMachineType("vmMachineType-1921917718").setVmZone("vmZone-813272317").setVmSubnet("vmSubnet-65857292").build();
            this.client.generateTcpProxyScript(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listConnectionProfilesTest() throws Exception {
        ConnectionProfile responsesElement = ConnectionProfile.newBuilder().build();
        ListConnectionProfilesResponse expectedResponse = ListConnectionProfilesResponse.newBuilder().setNextPageToken("").addAllConnectionProfiles(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        DataMigrationServiceClient.ListConnectionProfilesPagedResponse pagedListResponse = this.client.listConnectionProfiles(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getConnectionProfilesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListConnectionProfilesRequest actualRequest = (ListConnectionProfilesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listConnectionProfilesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listConnectionProfiles(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listConnectionProfilesTest2() throws Exception {
        ConnectionProfile responsesElement = ConnectionProfile.newBuilder().build();
        ListConnectionProfilesResponse expectedResponse = ListConnectionProfilesResponse.newBuilder().setNextPageToken("").addAllConnectionProfiles(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DataMigrationServiceClient.ListConnectionProfilesPagedResponse pagedListResponse = this.client.listConnectionProfiles(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getConnectionProfilesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListConnectionProfilesRequest actualRequest = (ListConnectionProfilesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listConnectionProfilesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listConnectionProfiles(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getConnectionProfileTest() throws Exception {
        ConnectionProfile expectedResponse = ConnectionProfile.newBuilder().setName(ConnectionProfileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONNECTION_PROFILE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setError(com.google.rpc.Status.newBuilder().build()).setProvider(DatabaseProvider.forNumber((int)0)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        ConnectionProfileName name = ConnectionProfileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONNECTION_PROFILE]");
        ConnectionProfile actualResponse = this.client.getConnectionProfile(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetConnectionProfileRequest actualRequest = (GetConnectionProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getConnectionProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ConnectionProfileName name = ConnectionProfileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONNECTION_PROFILE]");
            this.client.getConnectionProfile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getConnectionProfileTest2() throws Exception {
        ConnectionProfile expectedResponse = ConnectionProfile.newBuilder().setName(ConnectionProfileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONNECTION_PROFILE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setError(com.google.rpc.Status.newBuilder().build()).setProvider(DatabaseProvider.forNumber((int)0)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ConnectionProfile actualResponse = this.client.getConnectionProfile(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetConnectionProfileRequest actualRequest = (GetConnectionProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getConnectionProfileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getConnectionProfile(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createConnectionProfileTest() throws Exception {
        ConnectionProfile expectedResponse = ConnectionProfile.newBuilder().setName(ConnectionProfileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONNECTION_PROFILE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setError(com.google.rpc.Status.newBuilder().build()).setProvider(DatabaseProvider.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("createConnectionProfileTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ConnectionProfile connectionProfile = ConnectionProfile.newBuilder().build();
        String connectionProfileId = "connectionProfileId597575526";
        ConnectionProfile actualResponse = (ConnectionProfile)this.client.createConnectionProfileAsync(parent, connectionProfile, connectionProfileId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateConnectionProfileRequest actualRequest = (CreateConnectionProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)connectionProfile, (Object)actualRequest.getConnectionProfile());
        Assert.assertEquals((Object)connectionProfileId, (Object)actualRequest.getConnectionProfileId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createConnectionProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ConnectionProfile connectionProfile = ConnectionProfile.newBuilder().build();
            String connectionProfileId = "connectionProfileId597575526";
            this.client.createConnectionProfileAsync(parent, connectionProfile, connectionProfileId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createConnectionProfileTest2() throws Exception {
        ConnectionProfile expectedResponse = ConnectionProfile.newBuilder().setName(ConnectionProfileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONNECTION_PROFILE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setError(com.google.rpc.Status.newBuilder().build()).setProvider(DatabaseProvider.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("createConnectionProfileTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        ConnectionProfile connectionProfile = ConnectionProfile.newBuilder().build();
        String connectionProfileId = "connectionProfileId597575526";
        ConnectionProfile actualResponse = (ConnectionProfile)this.client.createConnectionProfileAsync(parent, connectionProfile, connectionProfileId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateConnectionProfileRequest actualRequest = (CreateConnectionProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)connectionProfile, (Object)actualRequest.getConnectionProfile());
        Assert.assertEquals((Object)connectionProfileId, (Object)actualRequest.getConnectionProfileId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createConnectionProfileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ConnectionProfile connectionProfile = ConnectionProfile.newBuilder().build();
            String connectionProfileId = "connectionProfileId597575526";
            this.client.createConnectionProfileAsync(parent, connectionProfile, connectionProfileId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateConnectionProfileTest() throws Exception {
        ConnectionProfile expectedResponse = ConnectionProfile.newBuilder().setName(ConnectionProfileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONNECTION_PROFILE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setError(com.google.rpc.Status.newBuilder().build()).setProvider(DatabaseProvider.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("updateConnectionProfileTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        ConnectionProfile connectionProfile = ConnectionProfile.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        ConnectionProfile actualResponse = (ConnectionProfile)this.client.updateConnectionProfileAsync(connectionProfile, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateConnectionProfileRequest actualRequest = (UpdateConnectionProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)connectionProfile, (Object)actualRequest.getConnectionProfile());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateConnectionProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ConnectionProfile connectionProfile = ConnectionProfile.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateConnectionProfileAsync(connectionProfile, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteConnectionProfileTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteConnectionProfileTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        ConnectionProfileName name = ConnectionProfileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONNECTION_PROFILE]");
        this.client.deleteConnectionProfileAsync(name).get();
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteConnectionProfileRequest actualRequest = (DeleteConnectionProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteConnectionProfileExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ConnectionProfileName name = ConnectionProfileName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONNECTION_PROFILE]");
            this.client.deleteConnectionProfileAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteConnectionProfileTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteConnectionProfileTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteConnectionProfileAsync(name).get();
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteConnectionProfileRequest actualRequest = (DeleteConnectionProfileRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteConnectionProfileExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteConnectionProfileAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createPrivateConnectionTest() throws Exception {
        PrivateConnection expectedResponse = PrivateConnection.newBuilder().setName(PrivateConnectionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRIVATE_CONNECTION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setError(com.google.rpc.Status.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPrivateConnectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        PrivateConnection privateConnection = PrivateConnection.newBuilder().build();
        String privateConnectionId = "privateConnectionId-1926654532";
        PrivateConnection actualResponse = (PrivateConnection)this.client.createPrivateConnectionAsync(parent, privateConnection, privateConnectionId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePrivateConnectionRequest actualRequest = (CreatePrivateConnectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)privateConnection, (Object)actualRequest.getPrivateConnection());
        Assert.assertEquals((Object)privateConnectionId, (Object)actualRequest.getPrivateConnectionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPrivateConnectionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            PrivateConnection privateConnection = PrivateConnection.newBuilder().build();
            String privateConnectionId = "privateConnectionId-1926654532";
            this.client.createPrivateConnectionAsync(parent, privateConnection, privateConnectionId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createPrivateConnectionTest2() throws Exception {
        PrivateConnection expectedResponse = PrivateConnection.newBuilder().setName(PrivateConnectionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRIVATE_CONNECTION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setError(com.google.rpc.Status.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createPrivateConnectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        PrivateConnection privateConnection = PrivateConnection.newBuilder().build();
        String privateConnectionId = "privateConnectionId-1926654532";
        PrivateConnection actualResponse = (PrivateConnection)this.client.createPrivateConnectionAsync(parent, privateConnection, privateConnectionId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreatePrivateConnectionRequest actualRequest = (CreatePrivateConnectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)privateConnection, (Object)actualRequest.getPrivateConnection());
        Assert.assertEquals((Object)privateConnectionId, (Object)actualRequest.getPrivateConnectionId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createPrivateConnectionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            PrivateConnection privateConnection = PrivateConnection.newBuilder().build();
            String privateConnectionId = "privateConnectionId-1926654532";
            this.client.createPrivateConnectionAsync(parent, privateConnection, privateConnectionId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getPrivateConnectionTest() throws Exception {
        PrivateConnection expectedResponse = PrivateConnection.newBuilder().setName(PrivateConnectionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRIVATE_CONNECTION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setError(com.google.rpc.Status.newBuilder().build()).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        PrivateConnectionName name = PrivateConnectionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRIVATE_CONNECTION]");
        PrivateConnection actualResponse = this.client.getPrivateConnection(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetPrivateConnectionRequest actualRequest = (GetPrivateConnectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getPrivateConnectionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            PrivateConnectionName name = PrivateConnectionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRIVATE_CONNECTION]");
            this.client.getPrivateConnection(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getPrivateConnectionTest2() throws Exception {
        PrivateConnection expectedResponse = PrivateConnection.newBuilder().setName(PrivateConnectionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRIVATE_CONNECTION]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDisplayName("displayName1714148973").setError(com.google.rpc.Status.newBuilder().build()).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        PrivateConnection actualResponse = this.client.getPrivateConnection(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetPrivateConnectionRequest actualRequest = (GetPrivateConnectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getPrivateConnectionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getPrivateConnection(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPrivateConnectionsTest() throws Exception {
        PrivateConnection responsesElement = PrivateConnection.newBuilder().build();
        ListPrivateConnectionsResponse expectedResponse = ListPrivateConnectionsResponse.newBuilder().setNextPageToken("").addAllPrivateConnections(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        DataMigrationServiceClient.ListPrivateConnectionsPagedResponse pagedListResponse = this.client.listPrivateConnections(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPrivateConnectionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPrivateConnectionsRequest actualRequest = (ListPrivateConnectionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPrivateConnectionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listPrivateConnections(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listPrivateConnectionsTest2() throws Exception {
        PrivateConnection responsesElement = PrivateConnection.newBuilder().build();
        ListPrivateConnectionsResponse expectedResponse = ListPrivateConnectionsResponse.newBuilder().setNextPageToken("").addAllPrivateConnections(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DataMigrationServiceClient.ListPrivateConnectionsPagedResponse pagedListResponse = this.client.listPrivateConnections(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getPrivateConnectionsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListPrivateConnectionsRequest actualRequest = (ListPrivateConnectionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listPrivateConnectionsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listPrivateConnections(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deletePrivateConnectionTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deletePrivateConnectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        PrivateConnectionName name = PrivateConnectionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRIVATE_CONNECTION]");
        this.client.deletePrivateConnectionAsync(name).get();
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeletePrivateConnectionRequest actualRequest = (DeletePrivateConnectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deletePrivateConnectionExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            PrivateConnectionName name = PrivateConnectionName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[PRIVATE_CONNECTION]");
            this.client.deletePrivateConnectionAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deletePrivateConnectionTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deletePrivateConnectionTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deletePrivateConnectionAsync(name).get();
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeletePrivateConnectionRequest actualRequest = (DeletePrivateConnectionRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deletePrivateConnectionExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deletePrivateConnectionAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getConversionWorkspaceTest() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        ConversionWorkspaceName name = ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]");
        ConversionWorkspace actualResponse = this.client.getConversionWorkspace(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetConversionWorkspaceRequest actualRequest = (GetConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getConversionWorkspaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ConversionWorkspaceName name = ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]");
            this.client.getConversionWorkspace(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getConversionWorkspaceTest2() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        ConversionWorkspace actualResponse = this.client.getConversionWorkspace(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetConversionWorkspaceRequest actualRequest = (GetConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getConversionWorkspaceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getConversionWorkspace(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listConversionWorkspacesTest() throws Exception {
        ConversionWorkspace responsesElement = ConversionWorkspace.newBuilder().build();
        ListConversionWorkspacesResponse expectedResponse = ListConversionWorkspacesResponse.newBuilder().setNextPageToken("").addAllConversionWorkspaces(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        DataMigrationServiceClient.ListConversionWorkspacesPagedResponse pagedListResponse = this.client.listConversionWorkspaces(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getConversionWorkspacesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListConversionWorkspacesRequest actualRequest = (ListConversionWorkspacesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listConversionWorkspacesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listConversionWorkspaces(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listConversionWorkspacesTest2() throws Exception {
        ConversionWorkspace responsesElement = ConversionWorkspace.newBuilder().build();
        ListConversionWorkspacesResponse expectedResponse = ListConversionWorkspacesResponse.newBuilder().setNextPageToken("").addAllConversionWorkspaces(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DataMigrationServiceClient.ListConversionWorkspacesPagedResponse pagedListResponse = this.client.listConversionWorkspaces(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getConversionWorkspacesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListConversionWorkspacesRequest actualRequest = (ListConversionWorkspacesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listConversionWorkspacesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listConversionWorkspaces(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createConversionWorkspaceTest() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("createConversionWorkspaceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        ConversionWorkspace conversionWorkspace = ConversionWorkspace.newBuilder().build();
        String conversionWorkspaceId = "conversionWorkspaceId-928604774";
        ConversionWorkspace actualResponse = (ConversionWorkspace)this.client.createConversionWorkspaceAsync(parent, conversionWorkspace, conversionWorkspaceId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateConversionWorkspaceRequest actualRequest = (CreateConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)conversionWorkspace, (Object)actualRequest.getConversionWorkspace());
        Assert.assertEquals((Object)conversionWorkspaceId, (Object)actualRequest.getConversionWorkspaceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createConversionWorkspaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            ConversionWorkspace conversionWorkspace = ConversionWorkspace.newBuilder().build();
            String conversionWorkspaceId = "conversionWorkspaceId-928604774";
            this.client.createConversionWorkspaceAsync(parent, conversionWorkspace, conversionWorkspaceId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createConversionWorkspaceTest2() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("createConversionWorkspaceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        ConversionWorkspace conversionWorkspace = ConversionWorkspace.newBuilder().build();
        String conversionWorkspaceId = "conversionWorkspaceId-928604774";
        ConversionWorkspace actualResponse = (ConversionWorkspace)this.client.createConversionWorkspaceAsync(parent, conversionWorkspace, conversionWorkspaceId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateConversionWorkspaceRequest actualRequest = (CreateConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)conversionWorkspace, (Object)actualRequest.getConversionWorkspace());
        Assert.assertEquals((Object)conversionWorkspaceId, (Object)actualRequest.getConversionWorkspaceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createConversionWorkspaceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            ConversionWorkspace conversionWorkspace = ConversionWorkspace.newBuilder().build();
            String conversionWorkspaceId = "conversionWorkspaceId-928604774";
            this.client.createConversionWorkspaceAsync(parent, conversionWorkspace, conversionWorkspaceId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateConversionWorkspaceTest() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("updateConversionWorkspaceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        ConversionWorkspace conversionWorkspace = ConversionWorkspace.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        ConversionWorkspace actualResponse = (ConversionWorkspace)this.client.updateConversionWorkspaceAsync(conversionWorkspace, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateConversionWorkspaceRequest actualRequest = (UpdateConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)conversionWorkspace, (Object)actualRequest.getConversionWorkspace());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateConversionWorkspaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ConversionWorkspace conversionWorkspace = ConversionWorkspace.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateConversionWorkspaceAsync(conversionWorkspace, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteConversionWorkspaceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteConversionWorkspaceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        ConversionWorkspaceName name = ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]");
        this.client.deleteConversionWorkspaceAsync(name).get();
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteConversionWorkspaceRequest actualRequest = (DeleteConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteConversionWorkspaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ConversionWorkspaceName name = ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]");
            this.client.deleteConversionWorkspaceAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteConversionWorkspaceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteConversionWorkspaceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteConversionWorkspaceAsync(name).get();
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteConversionWorkspaceRequest actualRequest = (DeleteConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteConversionWorkspaceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteConversionWorkspaceAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createMappingRuleTest() throws Exception {
        MappingRule expectedResponse = MappingRule.newBuilder().setName(MappingRuleName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]", (String)"[MAPPING_RULE]").toString()).setDisplayName("displayName1714148973").setRuleScope(DatabaseEntityType.forNumber((int)0)).setFilter(MappingRuleFilter.newBuilder().build()).setRuleOrder(-432188341L).setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        ConversionWorkspaceName parent = ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]");
        MappingRule mappingRule = MappingRule.newBuilder().build();
        String mappingRuleId = "mappingRuleId-900824155";
        MappingRule actualResponse = this.client.createMappingRule(parent, mappingRule, mappingRuleId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMappingRuleRequest actualRequest = (CreateMappingRuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)mappingRule, (Object)actualRequest.getMappingRule());
        Assert.assertEquals((Object)mappingRuleId, (Object)actualRequest.getMappingRuleId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMappingRuleExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ConversionWorkspaceName parent = ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]");
            MappingRule mappingRule = MappingRule.newBuilder().build();
            String mappingRuleId = "mappingRuleId-900824155";
            this.client.createMappingRule(parent, mappingRule, mappingRuleId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createMappingRuleTest2() throws Exception {
        MappingRule expectedResponse = MappingRule.newBuilder().setName(MappingRuleName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]", (String)"[MAPPING_RULE]").toString()).setDisplayName("displayName1714148973").setRuleScope(DatabaseEntityType.forNumber((int)0)).setFilter(MappingRuleFilter.newBuilder().build()).setRuleOrder(-432188341L).setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        MappingRule mappingRule = MappingRule.newBuilder().build();
        String mappingRuleId = "mappingRuleId-900824155";
        MappingRule actualResponse = this.client.createMappingRule(parent, mappingRule, mappingRuleId);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateMappingRuleRequest actualRequest = (CreateMappingRuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)mappingRule, (Object)actualRequest.getMappingRule());
        Assert.assertEquals((Object)mappingRuleId, (Object)actualRequest.getMappingRuleId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createMappingRuleExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            MappingRule mappingRule = MappingRule.newBuilder().build();
            String mappingRuleId = "mappingRuleId-900824155";
            this.client.createMappingRule(parent, mappingRule, mappingRuleId);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteMappingRuleTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        ConversionWorkspaceName name = ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]");
        this.client.deleteMappingRule(name);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteMappingRuleRequest actualRequest = (DeleteMappingRuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteMappingRuleExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ConversionWorkspaceName name = ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]");
            this.client.deleteMappingRule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteMappingRuleTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        this.client.deleteMappingRule(name);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteMappingRuleRequest actualRequest = (DeleteMappingRuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteMappingRuleExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteMappingRule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMappingRulesTest() throws Exception {
        MappingRule responsesElement = MappingRule.newBuilder().build();
        ListMappingRulesResponse expectedResponse = ListMappingRulesResponse.newBuilder().setNextPageToken("").addAllMappingRules(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        ConversionWorkspaceName parent = ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]");
        DataMigrationServiceClient.ListMappingRulesPagedResponse pagedListResponse = this.client.listMappingRules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMappingRulesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMappingRulesRequest actualRequest = (ListMappingRulesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMappingRulesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ConversionWorkspaceName parent = ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]");
            this.client.listMappingRules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listMappingRulesTest2() throws Exception {
        MappingRule responsesElement = MappingRule.newBuilder().build();
        ListMappingRulesResponse expectedResponse = ListMappingRulesResponse.newBuilder().setNextPageToken("").addAllMappingRules(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DataMigrationServiceClient.ListMappingRulesPagedResponse pagedListResponse = this.client.listMappingRules(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getMappingRulesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListMappingRulesRequest actualRequest = (ListMappingRulesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listMappingRulesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listMappingRules(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMappingRuleTest() throws Exception {
        MappingRule expectedResponse = MappingRule.newBuilder().setName(MappingRuleName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]", (String)"[MAPPING_RULE]").toString()).setDisplayName("displayName1714148973").setRuleScope(DatabaseEntityType.forNumber((int)0)).setFilter(MappingRuleFilter.newBuilder().build()).setRuleOrder(-432188341L).setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        MappingRuleName name = MappingRuleName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]", (String)"[MAPPING_RULE]");
        MappingRule actualResponse = this.client.getMappingRule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetMappingRuleRequest actualRequest = (GetMappingRuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getMappingRuleExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            MappingRuleName name = MappingRuleName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]", (String)"[MAPPING_RULE]");
            this.client.getMappingRule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getMappingRuleTest2() throws Exception {
        MappingRule expectedResponse = MappingRule.newBuilder().setName(MappingRuleName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]", (String)"[MAPPING_RULE]").toString()).setDisplayName("displayName1714148973").setRuleScope(DatabaseEntityType.forNumber((int)0)).setFilter(MappingRuleFilter.newBuilder().build()).setRuleOrder(-432188341L).setRevisionId("revisionId-1507445162").setRevisionCreateTime(Timestamp.newBuilder().build()).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        MappingRule actualResponse = this.client.getMappingRule(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetMappingRuleRequest actualRequest = (GetMappingRuleRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getMappingRuleExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getMappingRule(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void seedConversionWorkspaceTest() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("seedConversionWorkspaceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        SeedConversionWorkspaceRequest request = SeedConversionWorkspaceRequest.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setAutoCommit(true).build();
        ConversionWorkspace actualResponse = (ConversionWorkspace)this.client.seedConversionWorkspaceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SeedConversionWorkspaceRequest actualRequest = (SeedConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getAutoCommit(), (Object)actualRequest.getAutoCommit());
        Assert.assertEquals((Object)request.getSourceConnectionProfile(), (Object)actualRequest.getSourceConnectionProfile());
        Assert.assertEquals((Object)request.getDestinationConnectionProfile(), (Object)actualRequest.getDestinationConnectionProfile());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void seedConversionWorkspaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            SeedConversionWorkspaceRequest request = SeedConversionWorkspaceRequest.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setAutoCommit(true).build();
            this.client.seedConversionWorkspaceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void importMappingRulesTest() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("importMappingRulesTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        ImportMappingRulesRequest request = ImportMappingRulesRequest.newBuilder().setParent(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setRulesFormat(ImportRulesFileFormat.forNumber((int)0)).addAllRulesFiles(new ArrayList()).setAutoCommit(true).build();
        ConversionWorkspace actualResponse = (ConversionWorkspace)this.client.importMappingRulesAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ImportMappingRulesRequest actualRequest = (ImportMappingRulesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getRulesFormat(), (Object)actualRequest.getRulesFormat());
        Assert.assertEquals((Object)request.getRulesFilesList(), (Object)actualRequest.getRulesFilesList());
        Assert.assertEquals((Object)request.getAutoCommit(), (Object)actualRequest.getAutoCommit());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void importMappingRulesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ImportMappingRulesRequest request = ImportMappingRulesRequest.newBuilder().setParent(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setRulesFormat(ImportRulesFileFormat.forNumber((int)0)).addAllRulesFiles(new ArrayList()).setAutoCommit(true).build();
            this.client.importMappingRulesAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void convertConversionWorkspaceTest() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("convertConversionWorkspaceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        ConvertConversionWorkspaceRequest request = ConvertConversionWorkspaceRequest.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setAutoCommit(true).setFilter("filter-1274492040").setConvertFullPath(true).build();
        ConversionWorkspace actualResponse = (ConversionWorkspace)this.client.convertConversionWorkspaceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ConvertConversionWorkspaceRequest actualRequest = (ConvertConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getAutoCommit(), (Object)actualRequest.getAutoCommit());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)request.getConvertFullPath(), (Object)actualRequest.getConvertFullPath());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void convertConversionWorkspaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ConvertConversionWorkspaceRequest request = ConvertConversionWorkspaceRequest.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setAutoCommit(true).setFilter("filter-1274492040").setConvertFullPath(true).build();
            this.client.convertConversionWorkspaceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void commitConversionWorkspaceTest() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("commitConversionWorkspaceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        CommitConversionWorkspaceRequest request = CommitConversionWorkspaceRequest.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setCommitName("commitName1018078306").build();
        ConversionWorkspace actualResponse = (ConversionWorkspace)this.client.commitConversionWorkspaceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitConversionWorkspaceRequest actualRequest = (CommitConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getCommitName(), (Object)actualRequest.getCommitName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitConversionWorkspaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            CommitConversionWorkspaceRequest request = CommitConversionWorkspaceRequest.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setCommitName("commitName1018078306").build();
            this.client.commitConversionWorkspaceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void rollbackConversionWorkspaceTest() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("rollbackConversionWorkspaceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        RollbackConversionWorkspaceRequest request = RollbackConversionWorkspaceRequest.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).build();
        ConversionWorkspace actualResponse = (ConversionWorkspace)this.client.rollbackConversionWorkspaceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RollbackConversionWorkspaceRequest actualRequest = (RollbackConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void rollbackConversionWorkspaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            RollbackConversionWorkspaceRequest request = RollbackConversionWorkspaceRequest.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).build();
            this.client.rollbackConversionWorkspaceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void applyConversionWorkspaceTest() throws Exception {
        ConversionWorkspace expectedResponse = ConversionWorkspace.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setSource(DatabaseEngineInfo.newBuilder().build()).setDestination(DatabaseEngineInfo.newBuilder().build()).putAllGlobalSettings(new HashMap()).setHasUncommittedChanges(true).setLatestCommitId("latestCommitId-1343996583").setLatestCommitTime(Timestamp.newBuilder().build()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).setDisplayName("displayName1714148973").build();
        Operation resultOperation = Operation.newBuilder().setName("applyConversionWorkspaceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDataMigrationService.addResponse((AbstractMessage)resultOperation);
        ApplyConversionWorkspaceRequest request = ApplyConversionWorkspaceRequest.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setFilter("filter-1274492040").setDryRun(true).setAutoCommit(true).build();
        ConversionWorkspace actualResponse = (ConversionWorkspace)this.client.applyConversionWorkspaceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ApplyConversionWorkspaceRequest actualRequest = (ApplyConversionWorkspaceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)request.getDryRun(), (Object)actualRequest.getDryRun());
        Assert.assertEquals((Object)request.getAutoCommit(), (Object)actualRequest.getAutoCommit());
        Assert.assertEquals((Object)request.getConnectionProfile(), (Object)actualRequest.getConnectionProfile());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void applyConversionWorkspaceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            ApplyConversionWorkspaceRequest request = ApplyConversionWorkspaceRequest.newBuilder().setName(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setFilter("filter-1274492040").setDryRun(true).setAutoCommit(true).build();
            this.client.applyConversionWorkspaceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void describeDatabaseEntitiesTest() throws Exception {
        DatabaseEntity responsesElement = DatabaseEntity.newBuilder().build();
        DescribeDatabaseEntitiesResponse expectedResponse = DescribeDatabaseEntitiesResponse.newBuilder().setNextPageToken("").addAllDatabaseEntities(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        DescribeDatabaseEntitiesRequest request = DescribeDatabaseEntitiesRequest.newBuilder().setConversionWorkspace(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setPageSize(883849137).setPageToken("pageToken873572522").setUncommitted(true).setCommitId("commitId-602292046").setFilter("filter-1274492040").setView(DatabaseEntityView.forNumber((int)0)).build();
        DataMigrationServiceClient.DescribeDatabaseEntitiesPagedResponse pagedListResponse = this.client.describeDatabaseEntities(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getDatabaseEntitiesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DescribeDatabaseEntitiesRequest actualRequest = (DescribeDatabaseEntitiesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getConversionWorkspace(), (Object)actualRequest.getConversionWorkspace());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertEquals((Object)request.getTree(), (Object)actualRequest.getTree());
        Assert.assertEquals((Object)request.getUncommitted(), (Object)actualRequest.getUncommitted());
        Assert.assertEquals((Object)request.getCommitId(), (Object)actualRequest.getCommitId());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((Object)request.getView(), (Object)actualRequest.getView());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void describeDatabaseEntitiesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            DescribeDatabaseEntitiesRequest request = DescribeDatabaseEntitiesRequest.newBuilder().setConversionWorkspace(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setPageSize(883849137).setPageToken("pageToken873572522").setUncommitted(true).setCommitId("commitId-602292046").setFilter("filter-1274492040").setView(DatabaseEntityView.forNumber((int)0)).build();
            this.client.describeDatabaseEntities(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchBackgroundJobsTest() throws Exception {
        SearchBackgroundJobsResponse expectedResponse = SearchBackgroundJobsResponse.newBuilder().addAllJobs(new ArrayList()).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        SearchBackgroundJobsRequest request = SearchBackgroundJobsRequest.newBuilder().setConversionWorkspace(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setReturnMostRecentPerJobType(true).setMaxSize(408072700).setCompletedUntilTime(Timestamp.newBuilder().build()).build();
        SearchBackgroundJobsResponse actualResponse = this.client.searchBackgroundJobs(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchBackgroundJobsRequest actualRequest = (SearchBackgroundJobsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getConversionWorkspace(), (Object)actualRequest.getConversionWorkspace());
        Assert.assertEquals((Object)request.getReturnMostRecentPerJobType(), (Object)actualRequest.getReturnMostRecentPerJobType());
        Assert.assertEquals((long)request.getMaxSize(), (long)actualRequest.getMaxSize());
        Assert.assertEquals((Object)request.getCompletedUntilTime(), (Object)actualRequest.getCompletedUntilTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchBackgroundJobsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            SearchBackgroundJobsRequest request = SearchBackgroundJobsRequest.newBuilder().setConversionWorkspace(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setReturnMostRecentPerJobType(true).setMaxSize(408072700).setCompletedUntilTime(Timestamp.newBuilder().build()).build();
            this.client.searchBackgroundJobs(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void describeConversionWorkspaceRevisionsTest() throws Exception {
        DescribeConversionWorkspaceRevisionsResponse expectedResponse = DescribeConversionWorkspaceRevisionsResponse.newBuilder().addAllRevisions(new ArrayList()).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        DescribeConversionWorkspaceRevisionsRequest request = DescribeConversionWorkspaceRevisionsRequest.newBuilder().setConversionWorkspace(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setCommitId("commitId-602292046").build();
        DescribeConversionWorkspaceRevisionsResponse actualResponse = this.client.describeConversionWorkspaceRevisions(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DescribeConversionWorkspaceRevisionsRequest actualRequest = (DescribeConversionWorkspaceRevisionsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getConversionWorkspace(), (Object)actualRequest.getConversionWorkspace());
        Assert.assertEquals((Object)request.getCommitId(), (Object)actualRequest.getCommitId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void describeConversionWorkspaceRevisionsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            DescribeConversionWorkspaceRevisionsRequest request = DescribeConversionWorkspaceRevisionsRequest.newBuilder().setConversionWorkspace(ConversionWorkspaceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[CONVERSION_WORKSPACE]").toString()).setCommitId("commitId-602292046").build();
            this.client.describeConversionWorkspaceRevisions(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void fetchStaticIpsTest() throws Exception {
        String responsesElement = "responsesElement-318365110";
        FetchStaticIpsResponse expectedResponse = FetchStaticIpsResponse.newBuilder().setNextPageToken("").addAllStaticIps(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        LocationName name = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        DataMigrationServiceClient.FetchStaticIpsPagedResponse pagedListResponse = this.client.fetchStaticIps(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getStaticIpsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        FetchStaticIpsRequest actualRequest = (FetchStaticIpsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void fetchStaticIpsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            LocationName name = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.fetchStaticIps(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void fetchStaticIpsTest2() throws Exception {
        String responsesElement = "responsesElement-318365110";
        FetchStaticIpsResponse expectedResponse = FetchStaticIpsResponse.newBuilder().setNextPageToken("").addAllStaticIps(Arrays.asList(responsesElement)).build();
        mockDataMigrationService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        DataMigrationServiceClient.FetchStaticIpsPagedResponse pagedListResponse = this.client.fetchStaticIps(name);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals((Object)expectedResponse.getStaticIpsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDataMigrationService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        FetchStaticIpsRequest actualRequest = (FetchStaticIpsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void fetchStaticIpsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDataMigrationService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.fetchStaticIps(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

