/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.domains.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.domains.v1.AuthorizationCode;
import com.google.cloud.domains.v1.ConfigureContactSettingsRequest;
import com.google.cloud.domains.v1.ConfigureDnsSettingsRequest;
import com.google.cloud.domains.v1.ConfigureManagementSettingsRequest;
import com.google.cloud.domains.v1.ContactSettings;
import com.google.cloud.domains.v1.DeleteRegistrationRequest;
import com.google.cloud.domains.v1.DnsSettings;
import com.google.cloud.domains.v1.DomainsClient;
import com.google.cloud.domains.v1.DomainsSettings;
import com.google.cloud.domains.v1.ExportRegistrationRequest;
import com.google.cloud.domains.v1.GetRegistrationRequest;
import com.google.cloud.domains.v1.ListRegistrationsRequest;
import com.google.cloud.domains.v1.ListRegistrationsResponse;
import com.google.cloud.domains.v1.LocationName;
import com.google.cloud.domains.v1.ManagementSettings;
import com.google.cloud.domains.v1.MockDomains;
import com.google.cloud.domains.v1.RegisterDomainRequest;
import com.google.cloud.domains.v1.RegisterParameters;
import com.google.cloud.domains.v1.Registration;
import com.google.cloud.domains.v1.RegistrationName;
import com.google.cloud.domains.v1.ResetAuthorizationCodeRequest;
import com.google.cloud.domains.v1.RetrieveAuthorizationCodeRequest;
import com.google.cloud.domains.v1.RetrieveRegisterParametersRequest;
import com.google.cloud.domains.v1.RetrieveRegisterParametersResponse;
import com.google.cloud.domains.v1.RetrieveTransferParametersRequest;
import com.google.cloud.domains.v1.RetrieveTransferParametersResponse;
import com.google.cloud.domains.v1.SearchDomainsRequest;
import com.google.cloud.domains.v1.SearchDomainsResponse;
import com.google.cloud.domains.v1.TransferDomainRequest;
import com.google.cloud.domains.v1.TransferParameters;
import com.google.cloud.domains.v1.UpdateRegistrationRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.type.Money;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DomainsClientTest {
    private static MockDomains mockDomains;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private DomainsClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockDomains = new MockDomains();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockDomains));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        DomainsSettings settings = ((DomainsSettings.Builder)((DomainsSettings.Builder)DomainsSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = DomainsClient.create((DomainsSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void searchDomainsTest() throws Exception {
        SearchDomainsResponse expectedResponse = SearchDomainsResponse.newBuilder().addAllRegisterParameters(new ArrayList()).build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String query = "query107944136";
        SearchDomainsResponse actualResponse = this.client.searchDomains(location, query);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchDomainsRequest actualRequest = (SearchDomainsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)location.toString(), (Object)actualRequest.getLocation());
        Assert.assertEquals((Object)query, (Object)actualRequest.getQuery());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchDomainsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String query = "query107944136";
            this.client.searchDomains(location, query);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchDomainsTest2() throws Exception {
        SearchDomainsResponse expectedResponse = SearchDomainsResponse.newBuilder().addAllRegisterParameters(new ArrayList()).build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        String location = "location1901043637";
        String query = "query107944136";
        SearchDomainsResponse actualResponse = this.client.searchDomains(location, query);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SearchDomainsRequest actualRequest = (SearchDomainsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)location, (Object)actualRequest.getLocation());
        Assert.assertEquals((Object)query, (Object)actualRequest.getQuery());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void searchDomainsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String location = "location1901043637";
            String query = "query107944136";
            this.client.searchDomains(location, query);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void retrieveRegisterParametersTest() throws Exception {
        RetrieveRegisterParametersResponse expectedResponse = RetrieveRegisterParametersResponse.newBuilder().setRegisterParameters(RegisterParameters.newBuilder().build()).build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String domainName = "domainName-1244085905";
        RetrieveRegisterParametersResponse actualResponse = this.client.retrieveRegisterParameters(location, domainName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RetrieveRegisterParametersRequest actualRequest = (RetrieveRegisterParametersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)location.toString(), (Object)actualRequest.getLocation());
        Assert.assertEquals((Object)domainName, (Object)actualRequest.getDomainName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void retrieveRegisterParametersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String domainName = "domainName-1244085905";
            this.client.retrieveRegisterParameters(location, domainName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void retrieveRegisterParametersTest2() throws Exception {
        RetrieveRegisterParametersResponse expectedResponse = RetrieveRegisterParametersResponse.newBuilder().setRegisterParameters(RegisterParameters.newBuilder().build()).build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        String location = "location1901043637";
        String domainName = "domainName-1244085905";
        RetrieveRegisterParametersResponse actualResponse = this.client.retrieveRegisterParameters(location, domainName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RetrieveRegisterParametersRequest actualRequest = (RetrieveRegisterParametersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)location, (Object)actualRequest.getLocation());
        Assert.assertEquals((Object)domainName, (Object)actualRequest.getDomainName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void retrieveRegisterParametersExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String location = "location1901043637";
            String domainName = "domainName-1244085905";
            this.client.retrieveRegisterParameters(location, domainName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void registerDomainTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("registerDomainTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Registration registration = Registration.newBuilder().build();
        Money yearlyPrice = Money.newBuilder().build();
        Registration actualResponse = (Registration)this.client.registerDomainAsync(parent, registration, yearlyPrice).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RegisterDomainRequest actualRequest = (RegisterDomainRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)registration, (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)yearlyPrice, (Object)actualRequest.getYearlyPrice());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void registerDomainExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Registration registration = Registration.newBuilder().build();
            Money yearlyPrice = Money.newBuilder().build();
            this.client.registerDomainAsync(parent, registration, yearlyPrice).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void registerDomainTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("registerDomainTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Registration registration = Registration.newBuilder().build();
        Money yearlyPrice = Money.newBuilder().build();
        Registration actualResponse = (Registration)this.client.registerDomainAsync(parent, registration, yearlyPrice).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RegisterDomainRequest actualRequest = (RegisterDomainRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)registration, (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)yearlyPrice, (Object)actualRequest.getYearlyPrice());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void registerDomainExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Registration registration = Registration.newBuilder().build();
            Money yearlyPrice = Money.newBuilder().build();
            this.client.registerDomainAsync(parent, registration, yearlyPrice).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void retrieveTransferParametersTest() throws Exception {
        RetrieveTransferParametersResponse expectedResponse = RetrieveTransferParametersResponse.newBuilder().setTransferParameters(TransferParameters.newBuilder().build()).build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String domainName = "domainName-1244085905";
        RetrieveTransferParametersResponse actualResponse = this.client.retrieveTransferParameters(location, domainName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RetrieveTransferParametersRequest actualRequest = (RetrieveTransferParametersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)location.toString(), (Object)actualRequest.getLocation());
        Assert.assertEquals((Object)domainName, (Object)actualRequest.getDomainName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void retrieveTransferParametersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String domainName = "domainName-1244085905";
            this.client.retrieveTransferParameters(location, domainName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void retrieveTransferParametersTest2() throws Exception {
        RetrieveTransferParametersResponse expectedResponse = RetrieveTransferParametersResponse.newBuilder().setTransferParameters(TransferParameters.newBuilder().build()).build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        String location = "location1901043637";
        String domainName = "domainName-1244085905";
        RetrieveTransferParametersResponse actualResponse = this.client.retrieveTransferParameters(location, domainName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RetrieveTransferParametersRequest actualRequest = (RetrieveTransferParametersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)location, (Object)actualRequest.getLocation());
        Assert.assertEquals((Object)domainName, (Object)actualRequest.getDomainName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void retrieveTransferParametersExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String location = "location1901043637";
            String domainName = "domainName-1244085905";
            this.client.retrieveTransferParameters(location, domainName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void transferDomainTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("transferDomainTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Registration registration = Registration.newBuilder().build();
        Money yearlyPrice = Money.newBuilder().build();
        AuthorizationCode authorizationCode = AuthorizationCode.newBuilder().build();
        Registration actualResponse = (Registration)this.client.transferDomainAsync(parent, registration, yearlyPrice, authorizationCode).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TransferDomainRequest actualRequest = (TransferDomainRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)registration, (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)yearlyPrice, (Object)actualRequest.getYearlyPrice());
        Assert.assertEquals((Object)authorizationCode, (Object)actualRequest.getAuthorizationCode());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void transferDomainExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Registration registration = Registration.newBuilder().build();
            Money yearlyPrice = Money.newBuilder().build();
            AuthorizationCode authorizationCode = AuthorizationCode.newBuilder().build();
            this.client.transferDomainAsync(parent, registration, yearlyPrice, authorizationCode).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void transferDomainTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("transferDomainTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Registration registration = Registration.newBuilder().build();
        Money yearlyPrice = Money.newBuilder().build();
        AuthorizationCode authorizationCode = AuthorizationCode.newBuilder().build();
        Registration actualResponse = (Registration)this.client.transferDomainAsync(parent, registration, yearlyPrice, authorizationCode).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        TransferDomainRequest actualRequest = (TransferDomainRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)registration, (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)yearlyPrice, (Object)actualRequest.getYearlyPrice());
        Assert.assertEquals((Object)authorizationCode, (Object)actualRequest.getAuthorizationCode());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void transferDomainExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Registration registration = Registration.newBuilder().build();
            Money yearlyPrice = Money.newBuilder().build();
            AuthorizationCode authorizationCode = AuthorizationCode.newBuilder().build();
            this.client.transferDomainAsync(parent, registration, yearlyPrice, authorizationCode).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listRegistrationsTest() throws Exception {
        Registration responsesElement = Registration.newBuilder().build();
        ListRegistrationsResponse expectedResponse = ListRegistrationsResponse.newBuilder().setNextPageToken("").addAllRegistrations(Arrays.asList(responsesElement)).build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        DomainsClient.ListRegistrationsPagedResponse pagedListResponse = this.client.listRegistrations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRegistrationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRegistrationsRequest actualRequest = (ListRegistrationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRegistrationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listRegistrations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRegistrationsTest2() throws Exception {
        Registration responsesElement = Registration.newBuilder().build();
        ListRegistrationsResponse expectedResponse = ListRegistrationsResponse.newBuilder().setNextPageToken("").addAllRegistrations(Arrays.asList(responsesElement)).build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        DomainsClient.ListRegistrationsPagedResponse pagedListResponse = this.client.listRegistrations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRegistrationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRegistrationsRequest actualRequest = (ListRegistrationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRegistrationsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listRegistrations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRegistrationTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        Registration actualResponse = this.client.getRegistration(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRegistrationRequest actualRequest = (GetRegistrationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRegistrationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            this.client.getRegistration(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRegistrationTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Registration actualResponse = this.client.getRegistration(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRegistrationRequest actualRequest = (GetRegistrationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRegistrationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getRegistration(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateRegistrationTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateRegistrationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        Registration registration = Registration.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)this.client.updateRegistrationAsync(registration, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateRegistrationRequest actualRequest = (UpdateRegistrationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration, (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateRegistrationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            Registration registration = Registration.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateRegistrationAsync(registration, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void configureManagementSettingsTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureManagementSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        ManagementSettings managementSettings = ManagementSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)this.client.configureManagementSettingsAsync(registration, managementSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ConfigureManagementSettingsRequest actualRequest = (ConfigureManagementSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration.toString(), (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)managementSettings, (Object)actualRequest.getManagementSettings());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void configureManagementSettingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            ManagementSettings managementSettings = ManagementSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.configureManagementSettingsAsync(registration, managementSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void configureManagementSettingsTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureManagementSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        String registration = "registration-1350309703";
        ManagementSettings managementSettings = ManagementSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)this.client.configureManagementSettingsAsync(registration, managementSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ConfigureManagementSettingsRequest actualRequest = (ConfigureManagementSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration, (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)managementSettings, (Object)actualRequest.getManagementSettings());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void configureManagementSettingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String registration = "registration-1350309703";
            ManagementSettings managementSettings = ManagementSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.configureManagementSettingsAsync(registration, managementSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void configureDnsSettingsTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureDnsSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        DnsSettings dnsSettings = DnsSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)this.client.configureDnsSettingsAsync(registration, dnsSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ConfigureDnsSettingsRequest actualRequest = (ConfigureDnsSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration.toString(), (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)dnsSettings, (Object)actualRequest.getDnsSettings());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void configureDnsSettingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            DnsSettings dnsSettings = DnsSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.configureDnsSettingsAsync(registration, dnsSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void configureDnsSettingsTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureDnsSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        String registration = "registration-1350309703";
        DnsSettings dnsSettings = DnsSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)this.client.configureDnsSettingsAsync(registration, dnsSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ConfigureDnsSettingsRequest actualRequest = (ConfigureDnsSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration, (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)dnsSettings, (Object)actualRequest.getDnsSettings());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void configureDnsSettingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String registration = "registration-1350309703";
            DnsSettings dnsSettings = DnsSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.configureDnsSettingsAsync(registration, dnsSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void configureContactSettingsTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureContactSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        ContactSettings contactSettings = ContactSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)this.client.configureContactSettingsAsync(registration, contactSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ConfigureContactSettingsRequest actualRequest = (ConfigureContactSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration.toString(), (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)contactSettings, (Object)actualRequest.getContactSettings());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void configureContactSettingsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            ContactSettings contactSettings = ContactSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.configureContactSettingsAsync(registration, contactSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void configureContactSettingsTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureContactSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        String registration = "registration-1350309703";
        ContactSettings contactSettings = ContactSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)this.client.configureContactSettingsAsync(registration, contactSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ConfigureContactSettingsRequest actualRequest = (ConfigureContactSettingsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration, (Object)actualRequest.getRegistration());
        Assert.assertEquals((Object)contactSettings, (Object)actualRequest.getContactSettings());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void configureContactSettingsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String registration = "registration-1350309703";
            ContactSettings contactSettings = ContactSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.configureContactSettingsAsync(registration, contactSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void exportRegistrationTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("exportRegistrationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        Registration actualResponse = (Registration)this.client.exportRegistrationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ExportRegistrationRequest actualRequest = (ExportRegistrationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void exportRegistrationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            this.client.exportRegistrationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void exportRegistrationTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("exportRegistrationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        Registration actualResponse = (Registration)this.client.exportRegistrationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ExportRegistrationRequest actualRequest = (ExportRegistrationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void exportRegistrationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.exportRegistrationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteRegistrationTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRegistrationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        this.client.deleteRegistrationAsync(name).get();
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteRegistrationRequest actualRequest = (DeleteRegistrationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteRegistrationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            this.client.deleteRegistrationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteRegistrationTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRegistrationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockDomains.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteRegistrationAsync(name).get();
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteRegistrationRequest actualRequest = (DeleteRegistrationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteRegistrationExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteRegistrationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void retrieveAuthorizationCodeTest() throws Exception {
        AuthorizationCode expectedResponse = AuthorizationCode.newBuilder().setCode("code3059181").build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        AuthorizationCode actualResponse = this.client.retrieveAuthorizationCode(registration);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RetrieveAuthorizationCodeRequest actualRequest = (RetrieveAuthorizationCodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration.toString(), (Object)actualRequest.getRegistration());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void retrieveAuthorizationCodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            this.client.retrieveAuthorizationCode(registration);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void retrieveAuthorizationCodeTest2() throws Exception {
        AuthorizationCode expectedResponse = AuthorizationCode.newBuilder().setCode("code3059181").build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        String registration = "registration-1350309703";
        AuthorizationCode actualResponse = this.client.retrieveAuthorizationCode(registration);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RetrieveAuthorizationCodeRequest actualRequest = (RetrieveAuthorizationCodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration, (Object)actualRequest.getRegistration());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void retrieveAuthorizationCodeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String registration = "registration-1350309703";
            this.client.retrieveAuthorizationCode(registration);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void resetAuthorizationCodeTest() throws Exception {
        AuthorizationCode expectedResponse = AuthorizationCode.newBuilder().setCode("code3059181").build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        AuthorizationCode actualResponse = this.client.resetAuthorizationCode(registration);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ResetAuthorizationCodeRequest actualRequest = (ResetAuthorizationCodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration.toString(), (Object)actualRequest.getRegistration());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void resetAuthorizationCodeExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            this.client.resetAuthorizationCode(registration);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void resetAuthorizationCodeTest2() throws Exception {
        AuthorizationCode expectedResponse = AuthorizationCode.newBuilder().setCode("code3059181").build();
        mockDomains.addResponse((AbstractMessage)expectedResponse);
        String registration = "registration-1350309703";
        AuthorizationCode actualResponse = this.client.resetAuthorizationCode(registration);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockDomains.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ResetAuthorizationCodeRequest actualRequest = (ResetAuthorizationCodeRequest)actualRequests.get(0);
        Assert.assertEquals((Object)registration, (Object)actualRequest.getRegistration());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void resetAuthorizationCodeExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockDomains.addException((Exception)exception);
        try {
            String registration = "registration-1350309703";
            this.client.resetAuthorizationCode(registration);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

