/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.domains.v1beta1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.domains.v1beta1.AuthorizationCode;
import com.google.cloud.domains.v1beta1.ContactSettings;
import com.google.cloud.domains.v1beta1.DnsSettings;
import com.google.cloud.domains.v1beta1.DomainsClient;
import com.google.cloud.domains.v1beta1.DomainsSettings;
import com.google.cloud.domains.v1beta1.ListRegistrationsResponse;
import com.google.cloud.domains.v1beta1.LocationName;
import com.google.cloud.domains.v1beta1.ManagementSettings;
import com.google.cloud.domains.v1beta1.RegisterParameters;
import com.google.cloud.domains.v1beta1.Registration;
import com.google.cloud.domains.v1beta1.RegistrationName;
import com.google.cloud.domains.v1beta1.RetrieveRegisterParametersResponse;
import com.google.cloud.domains.v1beta1.RetrieveTransferParametersResponse;
import com.google.cloud.domains.v1beta1.SearchDomainsResponse;
import com.google.cloud.domains.v1beta1.TransferParameters;
import com.google.cloud.domains.v1beta1.stub.HttpJsonDomainsStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.type.Money;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DomainsClientHttpJsonTest {
    private static MockHttpService mockService;
    private static DomainsClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonDomainsStub.getMethodDescriptors(), DomainsSettings.getDefaultEndpoint());
        DomainsSettings settings = ((DomainsSettings.Builder)((DomainsSettings.Builder)DomainsSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)DomainsSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = DomainsClient.create((DomainsSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void searchDomainsTest() throws Exception {
        SearchDomainsResponse expectedResponse = SearchDomainsResponse.newBuilder().addAllRegisterParameters(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String query = "query107944136";
        SearchDomainsResponse actualResponse = client.searchDomains(location, query);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchDomainsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String query = "query107944136";
            client.searchDomains(location, query);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void searchDomainsTest2() throws Exception {
        SearchDomainsResponse expectedResponse = SearchDomainsResponse.newBuilder().addAllRegisterParameters(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String location = "projects/project-7132/locations/location-7132";
        String query = "query107944136";
        SearchDomainsResponse actualResponse = client.searchDomains(location, query);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void searchDomainsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String location = "projects/project-7132/locations/location-7132";
            String query = "query107944136";
            client.searchDomains(location, query);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void retrieveRegisterParametersTest() throws Exception {
        RetrieveRegisterParametersResponse expectedResponse = RetrieveRegisterParametersResponse.newBuilder().setRegisterParameters(RegisterParameters.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String domainName = "domainName-1244085905";
        RetrieveRegisterParametersResponse actualResponse = client.retrieveRegisterParameters(location, domainName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void retrieveRegisterParametersExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String domainName = "domainName-1244085905";
            client.retrieveRegisterParameters(location, domainName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void retrieveRegisterParametersTest2() throws Exception {
        RetrieveRegisterParametersResponse expectedResponse = RetrieveRegisterParametersResponse.newBuilder().setRegisterParameters(RegisterParameters.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String location = "projects/project-7132/locations/location-7132";
        String domainName = "domainName-1244085905";
        RetrieveRegisterParametersResponse actualResponse = client.retrieveRegisterParameters(location, domainName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void retrieveRegisterParametersExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String location = "projects/project-7132/locations/location-7132";
            String domainName = "domainName-1244085905";
            client.retrieveRegisterParameters(location, domainName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void registerDomainTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("registerDomainTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Registration registration = Registration.newBuilder().build();
        Money yearlyPrice = Money.newBuilder().build();
        Registration actualResponse = (Registration)client.registerDomainAsync(parent, registration, yearlyPrice).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void registerDomainExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Registration registration = Registration.newBuilder().build();
            Money yearlyPrice = Money.newBuilder().build();
            client.registerDomainAsync(parent, registration, yearlyPrice).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void registerDomainTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("registerDomainTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Registration registration = Registration.newBuilder().build();
        Money yearlyPrice = Money.newBuilder().build();
        Registration actualResponse = (Registration)client.registerDomainAsync(parent, registration, yearlyPrice).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void registerDomainExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Registration registration = Registration.newBuilder().build();
            Money yearlyPrice = Money.newBuilder().build();
            client.registerDomainAsync(parent, registration, yearlyPrice).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void retrieveTransferParametersTest() throws Exception {
        RetrieveTransferParametersResponse expectedResponse = RetrieveTransferParametersResponse.newBuilder().setTransferParameters(TransferParameters.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        String domainName = "domainName-1244085905";
        RetrieveTransferParametersResponse actualResponse = client.retrieveTransferParameters(location, domainName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void retrieveTransferParametersExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName location = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            String domainName = "domainName-1244085905";
            client.retrieveTransferParameters(location, domainName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void retrieveTransferParametersTest2() throws Exception {
        RetrieveTransferParametersResponse expectedResponse = RetrieveTransferParametersResponse.newBuilder().setTransferParameters(TransferParameters.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String location = "projects/project-7132/locations/location-7132";
        String domainName = "domainName-1244085905";
        RetrieveTransferParametersResponse actualResponse = client.retrieveTransferParameters(location, domainName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void retrieveTransferParametersExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String location = "projects/project-7132/locations/location-7132";
            String domainName = "domainName-1244085905";
            client.retrieveTransferParameters(location, domainName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void transferDomainTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("transferDomainTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Registration registration = Registration.newBuilder().build();
        Money yearlyPrice = Money.newBuilder().build();
        AuthorizationCode authorizationCode = AuthorizationCode.newBuilder().build();
        Registration actualResponse = (Registration)client.transferDomainAsync(parent, registration, yearlyPrice, authorizationCode).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void transferDomainExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Registration registration = Registration.newBuilder().build();
            Money yearlyPrice = Money.newBuilder().build();
            AuthorizationCode authorizationCode = AuthorizationCode.newBuilder().build();
            client.transferDomainAsync(parent, registration, yearlyPrice, authorizationCode).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void transferDomainTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("transferDomainTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Registration registration = Registration.newBuilder().build();
        Money yearlyPrice = Money.newBuilder().build();
        AuthorizationCode authorizationCode = AuthorizationCode.newBuilder().build();
        Registration actualResponse = (Registration)client.transferDomainAsync(parent, registration, yearlyPrice, authorizationCode).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void transferDomainExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Registration registration = Registration.newBuilder().build();
            Money yearlyPrice = Money.newBuilder().build();
            AuthorizationCode authorizationCode = AuthorizationCode.newBuilder().build();
            client.transferDomainAsync(parent, registration, yearlyPrice, authorizationCode).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listRegistrationsTest() throws Exception {
        Registration responsesElement = Registration.newBuilder().build();
        ListRegistrationsResponse expectedResponse = ListRegistrationsResponse.newBuilder().setNextPageToken("").addAllRegistrations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        DomainsClient.ListRegistrationsPagedResponse pagedListResponse = client.listRegistrations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRegistrationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listRegistrationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listRegistrations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRegistrationsTest2() throws Exception {
        Registration responsesElement = Registration.newBuilder().build();
        ListRegistrationsResponse expectedResponse = ListRegistrationsResponse.newBuilder().setNextPageToken("").addAllRegistrations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        DomainsClient.ListRegistrationsPagedResponse pagedListResponse = client.listRegistrations(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRegistrationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listRegistrationsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listRegistrations(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRegistrationTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        Registration actualResponse = client.getRegistration(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getRegistrationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            client.getRegistration(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRegistrationTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3120/locations/location-3120/registrations/registration-3120";
        Registration actualResponse = client.getRegistration(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getRegistrationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3120/locations/location-3120/registrations/registration-3120";
            client.getRegistration(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateRegistrationTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateRegistrationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Registration registration = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)client.updateRegistrationAsync(registration, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateRegistrationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Registration registration = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateRegistrationAsync(registration, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void configureManagementSettingsTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureManagementSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        ManagementSettings managementSettings = ManagementSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)client.configureManagementSettingsAsync(registration, managementSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void configureManagementSettingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            ManagementSettings managementSettings = ManagementSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.configureManagementSettingsAsync(registration, managementSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void configureManagementSettingsTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureManagementSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String registration = "projects/project-4210/locations/location-4210/registrations/registration-4210";
        ManagementSettings managementSettings = ManagementSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)client.configureManagementSettingsAsync(registration, managementSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void configureManagementSettingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String registration = "projects/project-4210/locations/location-4210/registrations/registration-4210";
            ManagementSettings managementSettings = ManagementSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.configureManagementSettingsAsync(registration, managementSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void configureDnsSettingsTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureDnsSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        DnsSettings dnsSettings = DnsSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)client.configureDnsSettingsAsync(registration, dnsSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void configureDnsSettingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            DnsSettings dnsSettings = DnsSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.configureDnsSettingsAsync(registration, dnsSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void configureDnsSettingsTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureDnsSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String registration = "projects/project-4210/locations/location-4210/registrations/registration-4210";
        DnsSettings dnsSettings = DnsSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)client.configureDnsSettingsAsync(registration, dnsSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void configureDnsSettingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String registration = "projects/project-4210/locations/location-4210/registrations/registration-4210";
            DnsSettings dnsSettings = DnsSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.configureDnsSettingsAsync(registration, dnsSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void configureContactSettingsTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureContactSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        ContactSettings contactSettings = ContactSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)client.configureContactSettingsAsync(registration, contactSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void configureContactSettingsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            ContactSettings contactSettings = ContactSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.configureContactSettingsAsync(registration, contactSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void configureContactSettingsTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("configureContactSettingsTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String registration = "projects/project-4210/locations/location-4210/registrations/registration-4210";
        ContactSettings contactSettings = ContactSettings.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Registration actualResponse = (Registration)client.configureContactSettingsAsync(registration, contactSettings, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void configureContactSettingsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String registration = "projects/project-4210/locations/location-4210/registrations/registration-4210";
            ContactSettings contactSettings = ContactSettings.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.configureContactSettingsAsync(registration, contactSettings, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void exportRegistrationTest() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("exportRegistrationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        Registration actualResponse = (Registration)client.exportRegistrationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void exportRegistrationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            client.exportRegistrationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void exportRegistrationTest2() throws Exception {
        Registration expectedResponse = Registration.newBuilder().setName(RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]").toString()).setDomainName("domainName-1244085905").setCreateTime(Timestamp.newBuilder().build()).setExpireTime(Timestamp.newBuilder().build()).addAllIssues(new ArrayList()).putAllLabels(new HashMap()).setManagementSettings(ManagementSettings.newBuilder().build()).setDnsSettings(DnsSettings.newBuilder().build()).setContactSettings(ContactSettings.newBuilder().build()).setPendingContactSettings(ContactSettings.newBuilder().build()).addAllSupportedPrivacy(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("exportRegistrationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-3120/locations/location-3120/registrations/registration-3120";
        Registration actualResponse = (Registration)client.exportRegistrationAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void exportRegistrationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3120/locations/location-3120/registrations/registration-3120";
            client.exportRegistrationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteRegistrationTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRegistrationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        client.deleteRegistrationAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteRegistrationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RegistrationName name = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            client.deleteRegistrationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteRegistrationTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRegistrationTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-3120/locations/location-3120/registrations/registration-3120";
        client.deleteRegistrationAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteRegistrationExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3120/locations/location-3120/registrations/registration-3120";
            client.deleteRegistrationAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void retrieveAuthorizationCodeTest() throws Exception {
        AuthorizationCode expectedResponse = AuthorizationCode.newBuilder().setCode("code3059181").build();
        mockService.addResponse((Object)expectedResponse);
        RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        AuthorizationCode actualResponse = client.retrieveAuthorizationCode(registration);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void retrieveAuthorizationCodeExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            client.retrieveAuthorizationCode(registration);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void retrieveAuthorizationCodeTest2() throws Exception {
        AuthorizationCode expectedResponse = AuthorizationCode.newBuilder().setCode("code3059181").build();
        mockService.addResponse((Object)expectedResponse);
        String registration = "projects/project-4210/locations/location-4210/registrations/registration-4210";
        AuthorizationCode actualResponse = client.retrieveAuthorizationCode(registration);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void retrieveAuthorizationCodeExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String registration = "projects/project-4210/locations/location-4210/registrations/registration-4210";
            client.retrieveAuthorizationCode(registration);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void resetAuthorizationCodeTest() throws Exception {
        AuthorizationCode expectedResponse = AuthorizationCode.newBuilder().setCode("code3059181").build();
        mockService.addResponse((Object)expectedResponse);
        RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
        AuthorizationCode actualResponse = client.resetAuthorizationCode(registration);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void resetAuthorizationCodeExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RegistrationName registration = RegistrationName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REGISTRATION]");
            client.resetAuthorizationCode(registration);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void resetAuthorizationCodeTest2() throws Exception {
        AuthorizationCode expectedResponse = AuthorizationCode.newBuilder().setCode("code3059181").build();
        mockService.addResponse((Object)expectedResponse);
        String registration = "projects/project-4210/locations/location-4210/registrations/registration-4210";
        AuthorizationCode actualResponse = client.resetAuthorizationCode(registration);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void resetAuthorizationCodeExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String registration = "projects/project-4210/locations/location-4210/registrations/registration-4210";
            client.resetAuthorizationCode(registration);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

