/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgenetwork.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.edgenetwork.v1.CreateInterconnectAttachmentRequest;
import com.google.cloud.edgenetwork.v1.CreateNetworkRequest;
import com.google.cloud.edgenetwork.v1.CreateRouterRequest;
import com.google.cloud.edgenetwork.v1.CreateSubnetRequest;
import com.google.cloud.edgenetwork.v1.DeleteInterconnectAttachmentRequest;
import com.google.cloud.edgenetwork.v1.DeleteNetworkRequest;
import com.google.cloud.edgenetwork.v1.DeleteRouterRequest;
import com.google.cloud.edgenetwork.v1.DeleteSubnetRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseInterconnectRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseInterconnectResponse;
import com.google.cloud.edgenetwork.v1.DiagnoseNetworkRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseNetworkResponse;
import com.google.cloud.edgenetwork.v1.DiagnoseRouterRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseRouterResponse;
import com.google.cloud.edgenetwork.v1.EdgeNetworkClient;
import com.google.cloud.edgenetwork.v1.EdgeNetworkSettings;
import com.google.cloud.edgenetwork.v1.GetInterconnectAttachmentRequest;
import com.google.cloud.edgenetwork.v1.GetInterconnectRequest;
import com.google.cloud.edgenetwork.v1.GetNetworkRequest;
import com.google.cloud.edgenetwork.v1.GetRouterRequest;
import com.google.cloud.edgenetwork.v1.GetSubnetRequest;
import com.google.cloud.edgenetwork.v1.GetZoneRequest;
import com.google.cloud.edgenetwork.v1.InitializeZoneRequest;
import com.google.cloud.edgenetwork.v1.InitializeZoneResponse;
import com.google.cloud.edgenetwork.v1.Interconnect;
import com.google.cloud.edgenetwork.v1.InterconnectAttachment;
import com.google.cloud.edgenetwork.v1.InterconnectAttachmentName;
import com.google.cloud.edgenetwork.v1.InterconnectDiagnostics;
import com.google.cloud.edgenetwork.v1.InterconnectName;
import com.google.cloud.edgenetwork.v1.ListInterconnectAttachmentsRequest;
import com.google.cloud.edgenetwork.v1.ListInterconnectAttachmentsResponse;
import com.google.cloud.edgenetwork.v1.ListInterconnectsRequest;
import com.google.cloud.edgenetwork.v1.ListInterconnectsResponse;
import com.google.cloud.edgenetwork.v1.ListNetworksRequest;
import com.google.cloud.edgenetwork.v1.ListNetworksResponse;
import com.google.cloud.edgenetwork.v1.ListRoutersRequest;
import com.google.cloud.edgenetwork.v1.ListRoutersResponse;
import com.google.cloud.edgenetwork.v1.ListSubnetsRequest;
import com.google.cloud.edgenetwork.v1.ListSubnetsResponse;
import com.google.cloud.edgenetwork.v1.ListZonesRequest;
import com.google.cloud.edgenetwork.v1.ListZonesResponse;
import com.google.cloud.edgenetwork.v1.LocationName;
import com.google.cloud.edgenetwork.v1.MockEdgeNetwork;
import com.google.cloud.edgenetwork.v1.MockLocations;
import com.google.cloud.edgenetwork.v1.Network;
import com.google.cloud.edgenetwork.v1.NetworkName;
import com.google.cloud.edgenetwork.v1.ResourceState;
import com.google.cloud.edgenetwork.v1.Router;
import com.google.cloud.edgenetwork.v1.RouterName;
import com.google.cloud.edgenetwork.v1.RouterStatus;
import com.google.cloud.edgenetwork.v1.Subnet;
import com.google.cloud.edgenetwork.v1.SubnetName;
import com.google.cloud.edgenetwork.v1.UpdateRouterRequest;
import com.google.cloud.edgenetwork.v1.UpdateSubnetRequest;
import com.google.cloud.edgenetwork.v1.Zone;
import com.google.cloud.edgenetwork.v1.ZoneName;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EdgeNetworkClientTest {
    private static MockEdgeNetwork mockEdgeNetwork;
    private static MockLocations mockLocations;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private EdgeNetworkClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockEdgeNetwork = new MockEdgeNetwork();
        mockLocations = new MockLocations();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockEdgeNetwork, mockLocations));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        EdgeNetworkSettings settings = ((EdgeNetworkSettings.Builder)((EdgeNetworkSettings.Builder)EdgeNetworkSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = EdgeNetworkClient.create((EdgeNetworkSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void initializeZoneTest() throws Exception {
        InitializeZoneResponse expectedResponse = InitializeZoneResponse.newBuilder().build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        ZoneName name = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        InitializeZoneResponse actualResponse = this.client.initializeZone(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        InitializeZoneRequest actualRequest = (InitializeZoneRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void initializeZoneExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName name = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            this.client.initializeZone(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void initializeZoneTest2() throws Exception {
        InitializeZoneResponse expectedResponse = InitializeZoneResponse.newBuilder().build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        InitializeZoneResponse actualResponse = this.client.initializeZone(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        InitializeZoneRequest actualRequest = (InitializeZoneRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void initializeZoneExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.initializeZone(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listZonesTest() throws Exception {
        Zone responsesElement = Zone.newBuilder().build();
        ListZonesResponse expectedResponse = ListZonesResponse.newBuilder().setNextPageToken("").addAllZones(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        EdgeNetworkClient.ListZonesPagedResponse pagedListResponse = this.client.listZones(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getZonesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListZonesRequest actualRequest = (ListZonesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listZonesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listZones(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listZonesTest2() throws Exception {
        Zone responsesElement = Zone.newBuilder().build();
        ListZonesResponse expectedResponse = ListZonesResponse.newBuilder().setNextPageToken("").addAllZones(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        EdgeNetworkClient.ListZonesPagedResponse pagedListResponse = this.client.listZones(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getZonesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListZonesRequest actualRequest = (ListZonesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listZonesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listZones(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getZoneTest() throws Exception {
        Zone expectedResponse = Zone.newBuilder().setName(ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLayoutName("layoutName341460181").build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        ZoneName name = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        Zone actualResponse = this.client.getZone(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetZoneRequest actualRequest = (GetZoneRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getZoneExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName name = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            this.client.getZone(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getZoneTest2() throws Exception {
        Zone expectedResponse = Zone.newBuilder().setName(ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLayoutName("layoutName341460181").build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Zone actualResponse = this.client.getZone(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetZoneRequest actualRequest = (GetZoneRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getZoneExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getZone(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNetworksTest() throws Exception {
        Network responsesElement = Network.newBuilder().build();
        ListNetworksResponse expectedResponse = ListNetworksResponse.newBuilder().setNextPageToken("").addAllNetworks(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        EdgeNetworkClient.ListNetworksPagedResponse pagedListResponse = this.client.listNetworks(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNetworksList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNetworksRequest actualRequest = (ListNetworksRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNetworksExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            this.client.listNetworks(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNetworksTest2() throws Exception {
        Network responsesElement = Network.newBuilder().build();
        ListNetworksResponse expectedResponse = ListNetworksResponse.newBuilder().setNextPageToken("").addAllNetworks(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        EdgeNetworkClient.ListNetworksPagedResponse pagedListResponse = this.client.listNetworks(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNetworksList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListNetworksRequest actualRequest = (ListNetworksRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listNetworksExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listNetworks(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNetworkTest() throws Exception {
        Network expectedResponse = Network.newBuilder().setName(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setMtu(108462).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
        Network actualResponse = this.client.getNetwork(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNetworkRequest actualRequest = (GetNetworkRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNetworkExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
            this.client.getNetwork(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNetworkTest2() throws Exception {
        Network expectedResponse = Network.newBuilder().setName(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setMtu(108462).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Network actualResponse = this.client.getNetwork(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetNetworkRequest actualRequest = (GetNetworkRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getNetworkExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getNetwork(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseNetworkTest() throws Exception {
        DiagnoseNetworkResponse expectedResponse = DiagnoseNetworkResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(DiagnoseNetworkResponse.NetworkStatus.newBuilder().build()).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
        DiagnoseNetworkResponse actualResponse = this.client.diagnoseNetwork(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DiagnoseNetworkRequest actualRequest = (DiagnoseNetworkRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void diagnoseNetworkExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
            this.client.diagnoseNetwork(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseNetworkTest2() throws Exception {
        DiagnoseNetworkResponse expectedResponse = DiagnoseNetworkResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(DiagnoseNetworkResponse.NetworkStatus.newBuilder().build()).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        DiagnoseNetworkResponse actualResponse = this.client.diagnoseNetwork(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DiagnoseNetworkRequest actualRequest = (DiagnoseNetworkRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void diagnoseNetworkExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.diagnoseNetwork(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNetworkTest() throws Exception {
        Network expectedResponse = Network.newBuilder().setName(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setMtu(108462).build();
        Operation resultOperation = Operation.newBuilder().setName("createNetworkTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        Network network = Network.newBuilder().build();
        String networkId = "networkId2062782441";
        Network actualResponse = (Network)this.client.createNetworkAsync(parent, network, networkId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNetworkRequest actualRequest = (CreateNetworkRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)network, (Object)actualRequest.getNetwork());
        Assert.assertEquals((Object)networkId, (Object)actualRequest.getNetworkId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNetworkExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            Network network = Network.newBuilder().build();
            String networkId = "networkId2062782441";
            this.client.createNetworkAsync(parent, network, networkId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createNetworkTest2() throws Exception {
        Network expectedResponse = Network.newBuilder().setName(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setMtu(108462).build();
        Operation resultOperation = Operation.newBuilder().setName("createNetworkTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Network network = Network.newBuilder().build();
        String networkId = "networkId2062782441";
        Network actualResponse = (Network)this.client.createNetworkAsync(parent, network, networkId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateNetworkRequest actualRequest = (CreateNetworkRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)network, (Object)actualRequest.getNetwork());
        Assert.assertEquals((Object)networkId, (Object)actualRequest.getNetworkId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createNetworkExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Network network = Network.newBuilder().build();
            String networkId = "networkId2062782441";
            this.client.createNetworkAsync(parent, network, networkId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteNetworkTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteNetworkTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
        this.client.deleteNetworkAsync(name).get();
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNetworkRequest actualRequest = (DeleteNetworkRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNetworkExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
            this.client.deleteNetworkAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteNetworkTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteNetworkTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteNetworkAsync(name).get();
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteNetworkRequest actualRequest = (DeleteNetworkRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteNetworkExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteNetworkAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listSubnetsTest() throws Exception {
        Subnet responsesElement = Subnet.newBuilder().build();
        ListSubnetsResponse expectedResponse = ListSubnetsResponse.newBuilder().setNextPageToken("").addAllSubnets(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        EdgeNetworkClient.ListSubnetsPagedResponse pagedListResponse = this.client.listSubnets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubnetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSubnetsRequest actualRequest = (ListSubnetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSubnetsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            this.client.listSubnets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSubnetsTest2() throws Exception {
        Subnet responsesElement = Subnet.newBuilder().build();
        ListSubnetsResponse expectedResponse = ListSubnetsResponse.newBuilder().setNextPageToken("").addAllSubnets(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        EdgeNetworkClient.ListSubnetsPagedResponse pagedListResponse = this.client.listSubnets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubnetsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSubnetsRequest actualRequest = (ListSubnetsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSubnetsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSubnets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubnetTest() throws Exception {
        Subnet expectedResponse = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        SubnetName name = SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]");
        Subnet actualResponse = this.client.getSubnet(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSubnetRequest actualRequest = (GetSubnetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSubnetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            SubnetName name = SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]");
            this.client.getSubnet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubnetTest2() throws Exception {
        Subnet expectedResponse = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Subnet actualResponse = this.client.getSubnet(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSubnetRequest actualRequest = (GetSubnetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSubnetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSubnet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSubnetTest() throws Exception {
        Subnet expectedResponse = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("createSubnetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        Subnet subnet = Subnet.newBuilder().build();
        String subnetId = "subnetId-2066159272";
        Subnet actualResponse = (Subnet)this.client.createSubnetAsync(parent, subnet, subnetId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSubnetRequest actualRequest = (CreateSubnetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)subnet, (Object)actualRequest.getSubnet());
        Assert.assertEquals((Object)subnetId, (Object)actualRequest.getSubnetId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSubnetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            Subnet subnet = Subnet.newBuilder().build();
            String subnetId = "subnetId-2066159272";
            this.client.createSubnetAsync(parent, subnet, subnetId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createSubnetTest2() throws Exception {
        Subnet expectedResponse = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("createSubnetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Subnet subnet = Subnet.newBuilder().build();
        String subnetId = "subnetId-2066159272";
        Subnet actualResponse = (Subnet)this.client.createSubnetAsync(parent, subnet, subnetId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSubnetRequest actualRequest = (CreateSubnetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)subnet, (Object)actualRequest.getSubnet());
        Assert.assertEquals((Object)subnetId, (Object)actualRequest.getSubnetId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSubnetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Subnet subnet = Subnet.newBuilder().build();
            String subnetId = "subnetId-2066159272";
            this.client.createSubnetAsync(parent, subnet, subnetId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateSubnetTest() throws Exception {
        Subnet expectedResponse = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("updateSubnetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        Subnet subnet = Subnet.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Subnet actualResponse = (Subnet)this.client.updateSubnetAsync(subnet, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSubnetRequest actualRequest = (UpdateSubnetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)subnet, (Object)actualRequest.getSubnet());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSubnetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            Subnet subnet = Subnet.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateSubnetAsync(subnet, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteSubnetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSubnetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        SubnetName name = SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]");
        this.client.deleteSubnetAsync(name).get();
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSubnetRequest actualRequest = (DeleteSubnetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSubnetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            SubnetName name = SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]");
            this.client.deleteSubnetAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteSubnetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSubnetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteSubnetAsync(name).get();
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSubnetRequest actualRequest = (DeleteSubnetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSubnetExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteSubnetAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listInterconnectsTest() throws Exception {
        Interconnect responsesElement = Interconnect.newBuilder().build();
        ListInterconnectsResponse expectedResponse = ListInterconnectsResponse.newBuilder().setNextPageToken("").addAllInterconnects(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        EdgeNetworkClient.ListInterconnectsPagedResponse pagedListResponse = this.client.listInterconnects(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInterconnectsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInterconnectsRequest actualRequest = (ListInterconnectsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInterconnectsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            this.client.listInterconnects(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInterconnectsTest2() throws Exception {
        Interconnect responsesElement = Interconnect.newBuilder().build();
        ListInterconnectsResponse expectedResponse = ListInterconnectsResponse.newBuilder().setNextPageToken("").addAllInterconnects(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        EdgeNetworkClient.ListInterconnectsPagedResponse pagedListResponse = this.client.listInterconnects(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInterconnectsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInterconnectsRequest actualRequest = (ListInterconnectsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInterconnectsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInterconnects(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInterconnectTest() throws Exception {
        Interconnect expectedResponse = Interconnect.newBuilder().setName(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setUuid("uuid3601339").setDeviceCloudResourceName("deviceCloudResourceName-1996267816").addAllPhysicalPorts(new ArrayList()).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        InterconnectName name = InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]");
        Interconnect actualResponse = this.client.getInterconnect(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInterconnectRequest actualRequest = (GetInterconnectRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInterconnectExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            InterconnectName name = InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]");
            this.client.getInterconnect(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInterconnectTest2() throws Exception {
        Interconnect expectedResponse = Interconnect.newBuilder().setName(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setUuid("uuid3601339").setDeviceCloudResourceName("deviceCloudResourceName-1996267816").addAllPhysicalPorts(new ArrayList()).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Interconnect actualResponse = this.client.getInterconnect(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInterconnectRequest actualRequest = (GetInterconnectRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInterconnectExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getInterconnect(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseInterconnectTest() throws Exception {
        DiagnoseInterconnectResponse expectedResponse = DiagnoseInterconnectResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(InterconnectDiagnostics.newBuilder().build()).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        InterconnectName name = InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]");
        DiagnoseInterconnectResponse actualResponse = this.client.diagnoseInterconnect(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DiagnoseInterconnectRequest actualRequest = (DiagnoseInterconnectRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void diagnoseInterconnectExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            InterconnectName name = InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]");
            this.client.diagnoseInterconnect(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseInterconnectTest2() throws Exception {
        DiagnoseInterconnectResponse expectedResponse = DiagnoseInterconnectResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(InterconnectDiagnostics.newBuilder().build()).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        DiagnoseInterconnectResponse actualResponse = this.client.diagnoseInterconnect(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DiagnoseInterconnectRequest actualRequest = (DiagnoseInterconnectRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void diagnoseInterconnectExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.diagnoseInterconnect(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInterconnectAttachmentsTest() throws Exception {
        InterconnectAttachment responsesElement = InterconnectAttachment.newBuilder().build();
        ListInterconnectAttachmentsResponse expectedResponse = ListInterconnectAttachmentsResponse.newBuilder().setNextPageToken("").addAllInterconnectAttachments(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse pagedListResponse = this.client.listInterconnectAttachments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInterconnectAttachmentsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInterconnectAttachmentsRequest actualRequest = (ListInterconnectAttachmentsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInterconnectAttachmentsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            this.client.listInterconnectAttachments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInterconnectAttachmentsTest2() throws Exception {
        InterconnectAttachment responsesElement = InterconnectAttachment.newBuilder().build();
        ListInterconnectAttachmentsResponse expectedResponse = ListInterconnectAttachmentsResponse.newBuilder().setNextPageToken("").addAllInterconnectAttachments(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse pagedListResponse = this.client.listInterconnectAttachments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInterconnectAttachmentsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInterconnectAttachmentsRequest actualRequest = (ListInterconnectAttachmentsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInterconnectAttachmentsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInterconnectAttachments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInterconnectAttachmentTest() throws Exception {
        InterconnectAttachment expectedResponse = InterconnectAttachment.newBuilder().setName(InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setInterconnect(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setVlanId(536153463).setMtu(108462).setState(ResourceState.forNumber((int)0)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        InterconnectAttachmentName name = InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]");
        InterconnectAttachment actualResponse = this.client.getInterconnectAttachment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInterconnectAttachmentRequest actualRequest = (GetInterconnectAttachmentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInterconnectAttachmentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            InterconnectAttachmentName name = InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]");
            this.client.getInterconnectAttachment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInterconnectAttachmentTest2() throws Exception {
        InterconnectAttachment expectedResponse = InterconnectAttachment.newBuilder().setName(InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setInterconnect(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setVlanId(536153463).setMtu(108462).setState(ResourceState.forNumber((int)0)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        InterconnectAttachment actualResponse = this.client.getInterconnectAttachment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInterconnectAttachmentRequest actualRequest = (GetInterconnectAttachmentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInterconnectAttachmentExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getInterconnectAttachment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInterconnectAttachmentTest() throws Exception {
        InterconnectAttachment expectedResponse = InterconnectAttachment.newBuilder().setName(InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setInterconnect(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setVlanId(536153463).setMtu(108462).setState(ResourceState.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("createInterconnectAttachmentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        InterconnectAttachment interconnectAttachment = InterconnectAttachment.newBuilder().build();
        String interconnectAttachmentId = "interconnectAttachmentId1053538636";
        InterconnectAttachment actualResponse = (InterconnectAttachment)this.client.createInterconnectAttachmentAsync(parent, interconnectAttachment, interconnectAttachmentId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInterconnectAttachmentRequest actualRequest = (CreateInterconnectAttachmentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)interconnectAttachment, (Object)actualRequest.getInterconnectAttachment());
        Assert.assertEquals((Object)interconnectAttachmentId, (Object)actualRequest.getInterconnectAttachmentId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInterconnectAttachmentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            InterconnectAttachment interconnectAttachment = InterconnectAttachment.newBuilder().build();
            String interconnectAttachmentId = "interconnectAttachmentId1053538636";
            this.client.createInterconnectAttachmentAsync(parent, interconnectAttachment, interconnectAttachmentId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createInterconnectAttachmentTest2() throws Exception {
        InterconnectAttachment expectedResponse = InterconnectAttachment.newBuilder().setName(InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setInterconnect(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setVlanId(536153463).setMtu(108462).setState(ResourceState.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("createInterconnectAttachmentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        InterconnectAttachment interconnectAttachment = InterconnectAttachment.newBuilder().build();
        String interconnectAttachmentId = "interconnectAttachmentId1053538636";
        InterconnectAttachment actualResponse = (InterconnectAttachment)this.client.createInterconnectAttachmentAsync(parent, interconnectAttachment, interconnectAttachmentId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInterconnectAttachmentRequest actualRequest = (CreateInterconnectAttachmentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)interconnectAttachment, (Object)actualRequest.getInterconnectAttachment());
        Assert.assertEquals((Object)interconnectAttachmentId, (Object)actualRequest.getInterconnectAttachmentId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInterconnectAttachmentExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            InterconnectAttachment interconnectAttachment = InterconnectAttachment.newBuilder().build();
            String interconnectAttachmentId = "interconnectAttachmentId1053538636";
            this.client.createInterconnectAttachmentAsync(parent, interconnectAttachment, interconnectAttachmentId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteInterconnectAttachmentTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteInterconnectAttachmentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        InterconnectAttachmentName name = InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]");
        this.client.deleteInterconnectAttachmentAsync(name).get();
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInterconnectAttachmentRequest actualRequest = (DeleteInterconnectAttachmentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInterconnectAttachmentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            InterconnectAttachmentName name = InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]");
            this.client.deleteInterconnectAttachmentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteInterconnectAttachmentTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteInterconnectAttachmentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteInterconnectAttachmentAsync(name).get();
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInterconnectAttachmentRequest actualRequest = (DeleteInterconnectAttachmentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInterconnectAttachmentExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteInterconnectAttachmentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listRoutersTest() throws Exception {
        Router responsesElement = Router.newBuilder().build();
        ListRoutersResponse expectedResponse = ListRoutersResponse.newBuilder().setNextPageToken("").addAllRouters(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        EdgeNetworkClient.ListRoutersPagedResponse pagedListResponse = this.client.listRouters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRoutersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRoutersRequest actualRequest = (ListRoutersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRoutersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            this.client.listRouters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRoutersTest2() throws Exception {
        Router responsesElement = Router.newBuilder().build();
        ListRoutersResponse expectedResponse = ListRoutersResponse.newBuilder().setNextPageToken("").addAllRouters(Arrays.asList(responsesElement)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        EdgeNetworkClient.ListRoutersPagedResponse pagedListResponse = this.client.listRouters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRoutersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRoutersRequest actualRequest = (ListRoutersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRoutersExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listRouters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRouterTest() throws Exception {
        Router expectedResponse = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
        Router actualResponse = this.client.getRouter(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRouterRequest actualRequest = (GetRouterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRouterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
            this.client.getRouter(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRouterTest2() throws Exception {
        Router expectedResponse = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Router actualResponse = this.client.getRouter(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRouterRequest actualRequest = (GetRouterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRouterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getRouter(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseRouterTest() throws Exception {
        DiagnoseRouterResponse expectedResponse = DiagnoseRouterResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(RouterStatus.newBuilder().build()).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
        DiagnoseRouterResponse actualResponse = this.client.diagnoseRouter(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DiagnoseRouterRequest actualRequest = (DiagnoseRouterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void diagnoseRouterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
            this.client.diagnoseRouter(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseRouterTest2() throws Exception {
        DiagnoseRouterResponse expectedResponse = DiagnoseRouterResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(RouterStatus.newBuilder().build()).build();
        mockEdgeNetwork.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        DiagnoseRouterResponse actualResponse = this.client.diagnoseRouter(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DiagnoseRouterRequest actualRequest = (DiagnoseRouterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void diagnoseRouterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.diagnoseRouter(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createRouterTest() throws Exception {
        Router expectedResponse = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createRouterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        Router router = Router.newBuilder().build();
        String routerId = "routerId5435972";
        Router actualResponse = (Router)this.client.createRouterAsync(parent, router, routerId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateRouterRequest actualRequest = (CreateRouterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)router, (Object)actualRequest.getRouter());
        Assert.assertEquals((Object)routerId, (Object)actualRequest.getRouterId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createRouterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            Router router = Router.newBuilder().build();
            String routerId = "routerId5435972";
            this.client.createRouterAsync(parent, router, routerId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createRouterTest2() throws Exception {
        Router expectedResponse = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createRouterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Router router = Router.newBuilder().build();
        String routerId = "routerId5435972";
        Router actualResponse = (Router)this.client.createRouterAsync(parent, router, routerId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateRouterRequest actualRequest = (CreateRouterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)router, (Object)actualRequest.getRouter());
        Assert.assertEquals((Object)routerId, (Object)actualRequest.getRouterId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createRouterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Router router = Router.newBuilder().build();
            String routerId = "routerId5435972";
            this.client.createRouterAsync(parent, router, routerId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateRouterTest() throws Exception {
        Router expectedResponse = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateRouterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        Router router = Router.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Router actualResponse = (Router)this.client.updateRouterAsync(router, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateRouterRequest actualRequest = (UpdateRouterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)router, (Object)actualRequest.getRouter());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateRouterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            Router router = Router.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateRouterAsync(router, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteRouterTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRouterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
        this.client.deleteRouterAsync(name).get();
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteRouterRequest actualRequest = (DeleteRouterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteRouterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
            this.client.deleteRouterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteRouterTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRouterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockEdgeNetwork.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteRouterAsync(name).get();
        List<AbstractMessage> actualRequests = mockEdgeNetwork.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteRouterRequest actualRequest = (DeleteRouterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteRouterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockEdgeNetwork.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteRouterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listLocationsTest() throws Exception {
        Location responsesElement = Location.newBuilder().build();
        ListLocationsResponse expectedResponse = ListLocationsResponse.newBuilder().setNextPageToken("").addAllLocations(Arrays.asList(responsesElement)).build();
        mockLocations.addResponse((AbstractMessage)expectedResponse);
        ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("name3373707").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
        EdgeNetworkClient.ListLocationsPagedResponse pagedListResponse = this.client.listLocations(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocationsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockLocations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListLocationsRequest actualRequest = (ListLocationsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getFilter(), (Object)actualRequest.getFilter());
        Assert.assertEquals((long)request.getPageSize(), (long)actualRequest.getPageSize());
        Assert.assertEquals((Object)request.getPageToken(), (Object)actualRequest.getPageToken());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listLocationsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLocations.addException((Exception)exception);
        try {
            ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("name3373707").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
            this.client.listLocations(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLocationTest() throws Exception {
        Location expectedResponse = Location.newBuilder().setName("name3373707").setLocationId("locationId1541836720").setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setMetadata(Any.newBuilder().build()).build();
        mockLocations.addResponse((AbstractMessage)expectedResponse);
        GetLocationRequest request = GetLocationRequest.newBuilder().setName("name3373707").build();
        Location actualResponse = this.client.getLocation(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockLocations.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetLocationRequest actualRequest = (GetLocationRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getLocationExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockLocations.addException((Exception)exception);
        try {
            GetLocationRequest request = GetLocationRequest.newBuilder().setName("name3373707").build();
            this.client.getLocation(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

