/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgenetwork.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.edgenetwork.v1.DiagnoseInterconnectResponse;
import com.google.cloud.edgenetwork.v1.DiagnoseNetworkResponse;
import com.google.cloud.edgenetwork.v1.DiagnoseRouterResponse;
import com.google.cloud.edgenetwork.v1.EdgeNetworkClient;
import com.google.cloud.edgenetwork.v1.EdgeNetworkSettings;
import com.google.cloud.edgenetwork.v1.InitializeZoneResponse;
import com.google.cloud.edgenetwork.v1.Interconnect;
import com.google.cloud.edgenetwork.v1.InterconnectAttachment;
import com.google.cloud.edgenetwork.v1.InterconnectAttachmentName;
import com.google.cloud.edgenetwork.v1.InterconnectDiagnostics;
import com.google.cloud.edgenetwork.v1.InterconnectName;
import com.google.cloud.edgenetwork.v1.ListInterconnectAttachmentsResponse;
import com.google.cloud.edgenetwork.v1.ListInterconnectsResponse;
import com.google.cloud.edgenetwork.v1.ListNetworksResponse;
import com.google.cloud.edgenetwork.v1.ListRoutersResponse;
import com.google.cloud.edgenetwork.v1.ListSubnetsResponse;
import com.google.cloud.edgenetwork.v1.ListZonesResponse;
import com.google.cloud.edgenetwork.v1.LocationName;
import com.google.cloud.edgenetwork.v1.Network;
import com.google.cloud.edgenetwork.v1.NetworkName;
import com.google.cloud.edgenetwork.v1.ResourceState;
import com.google.cloud.edgenetwork.v1.Router;
import com.google.cloud.edgenetwork.v1.RouterName;
import com.google.cloud.edgenetwork.v1.RouterStatus;
import com.google.cloud.edgenetwork.v1.Subnet;
import com.google.cloud.edgenetwork.v1.SubnetName;
import com.google.cloud.edgenetwork.v1.Zone;
import com.google.cloud.edgenetwork.v1.ZoneName;
import com.google.cloud.edgenetwork.v1.stub.HttpJsonEdgeNetworkStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class EdgeNetworkClientHttpJsonTest {
    private static MockHttpService mockService;
    private static EdgeNetworkClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonEdgeNetworkStub.getMethodDescriptors(), EdgeNetworkSettings.getDefaultEndpoint());
        EdgeNetworkSettings settings = ((EdgeNetworkSettings.Builder)((EdgeNetworkSettings.Builder)EdgeNetworkSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)EdgeNetworkSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = EdgeNetworkClient.create((EdgeNetworkSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void initializeZoneTest() throws Exception {
        InitializeZoneResponse expectedResponse = InitializeZoneResponse.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        ZoneName name = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        InitializeZoneResponse actualResponse = client.initializeZone(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void initializeZoneExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName name = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            client.initializeZone(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void initializeZoneTest2() throws Exception {
        InitializeZoneResponse expectedResponse = InitializeZoneResponse.newBuilder().build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4499/locations/location-4499/zones/zone-4499";
        InitializeZoneResponse actualResponse = client.initializeZone(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void initializeZoneExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4499/locations/location-4499/zones/zone-4499";
            client.initializeZone(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listZonesTest() throws Exception {
        Zone responsesElement = Zone.newBuilder().build();
        ListZonesResponse expectedResponse = ListZonesResponse.newBuilder().setNextPageToken("").addAllZones(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        EdgeNetworkClient.ListZonesPagedResponse pagedListResponse = client.listZones(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getZonesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listZonesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listZones(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listZonesTest2() throws Exception {
        Zone responsesElement = Zone.newBuilder().build();
        ListZonesResponse expectedResponse = ListZonesResponse.newBuilder().setNextPageToken("").addAllZones(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        EdgeNetworkClient.ListZonesPagedResponse pagedListResponse = client.listZones(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getZonesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listZonesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listZones(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getZoneTest() throws Exception {
        Zone expectedResponse = Zone.newBuilder().setName(ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLayoutName("layoutName341460181").build();
        mockService.addResponse((Object)expectedResponse);
        ZoneName name = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        Zone actualResponse = client.getZone(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getZoneExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName name = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            client.getZone(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getZoneTest2() throws Exception {
        Zone expectedResponse = Zone.newBuilder().setName(ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setLayoutName("layoutName341460181").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4499/locations/location-4499/zones/zone-4499";
        Zone actualResponse = client.getZone(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getZoneExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4499/locations/location-4499/zones/zone-4499";
            client.getZone(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNetworksTest() throws Exception {
        Network responsesElement = Network.newBuilder().build();
        ListNetworksResponse expectedResponse = ListNetworksResponse.newBuilder().setNextPageToken("").addAllNetworks(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        EdgeNetworkClient.ListNetworksPagedResponse pagedListResponse = client.listNetworks(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNetworksList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listNetworksExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            client.listNetworks(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listNetworksTest2() throws Exception {
        Network responsesElement = Network.newBuilder().build();
        ListNetworksResponse expectedResponse = ListNetworksResponse.newBuilder().setNextPageToken("").addAllNetworks(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
        EdgeNetworkClient.ListNetworksPagedResponse pagedListResponse = client.listNetworks(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getNetworksList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listNetworksExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
            client.listNetworks(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNetworkTest() throws Exception {
        Network expectedResponse = Network.newBuilder().setName(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setMtu(108462).build();
        mockService.addResponse((Object)expectedResponse);
        NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
        Network actualResponse = client.getNetwork(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getNetworkExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
            client.getNetwork(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getNetworkTest2() throws Exception {
        Network expectedResponse = Network.newBuilder().setName(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setMtu(108462).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-6162/locations/location-6162/zones/zone-6162/networks/network-6162";
        Network actualResponse = client.getNetwork(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getNetworkExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-6162/locations/location-6162/zones/zone-6162/networks/network-6162";
            client.getNetwork(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseNetworkTest() throws Exception {
        DiagnoseNetworkResponse expectedResponse = DiagnoseNetworkResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(DiagnoseNetworkResponse.NetworkStatus.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
        DiagnoseNetworkResponse actualResponse = client.diagnoseNetwork(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void diagnoseNetworkExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
            client.diagnoseNetwork(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseNetworkTest2() throws Exception {
        DiagnoseNetworkResponse expectedResponse = DiagnoseNetworkResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(DiagnoseNetworkResponse.NetworkStatus.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-6162/locations/location-6162/zones/zone-6162/networks/network-6162";
        DiagnoseNetworkResponse actualResponse = client.diagnoseNetwork(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void diagnoseNetworkExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-6162/locations/location-6162/zones/zone-6162/networks/network-6162";
            client.diagnoseNetwork(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createNetworkTest() throws Exception {
        Network expectedResponse = Network.newBuilder().setName(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setMtu(108462).build();
        Operation resultOperation = Operation.newBuilder().setName("createNetworkTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        Network network = Network.newBuilder().build();
        String networkId = "networkId2062782441";
        Network actualResponse = (Network)client.createNetworkAsync(parent, network, networkId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNetworkExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            Network network = Network.newBuilder().build();
            String networkId = "networkId2062782441";
            client.createNetworkAsync(parent, network, networkId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createNetworkTest2() throws Exception {
        Network expectedResponse = Network.newBuilder().setName(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setMtu(108462).build();
        Operation resultOperation = Operation.newBuilder().setName("createNetworkTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
        Network network = Network.newBuilder().build();
        String networkId = "networkId2062782441";
        Network actualResponse = (Network)client.createNetworkAsync(parent, network, networkId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createNetworkExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
            Network network = Network.newBuilder().build();
            String networkId = "networkId2062782441";
            client.createNetworkAsync(parent, network, networkId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNetworkTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteNetworkTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
        client.deleteNetworkAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteNetworkExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            NetworkName name = NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]");
            client.deleteNetworkAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteNetworkTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteNetworkTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-6162/locations/location-6162/zones/zone-6162/networks/network-6162";
        client.deleteNetworkAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteNetworkExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-6162/locations/location-6162/zones/zone-6162/networks/network-6162";
            client.deleteNetworkAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listSubnetsTest() throws Exception {
        Subnet responsesElement = Subnet.newBuilder().build();
        ListSubnetsResponse expectedResponse = ListSubnetsResponse.newBuilder().setNextPageToken("").addAllSubnets(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        EdgeNetworkClient.ListSubnetsPagedResponse pagedListResponse = client.listSubnets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubnetsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSubnetsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            client.listSubnets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSubnetsTest2() throws Exception {
        Subnet responsesElement = Subnet.newBuilder().build();
        ListSubnetsResponse expectedResponse = ListSubnetsResponse.newBuilder().setNextPageToken("").addAllSubnets(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
        EdgeNetworkClient.ListSubnetsPagedResponse pagedListResponse = client.listSubnets(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSubnetsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSubnetsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
            client.listSubnets(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubnetTest() throws Exception {
        Subnet expectedResponse = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        mockService.addResponse((Object)expectedResponse);
        SubnetName name = SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]");
        Subnet actualResponse = client.getSubnet(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSubnetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubnetName name = SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]");
            client.getSubnet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSubnetTest2() throws Exception {
        Subnet expectedResponse = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-3631/locations/location-3631/zones/zone-3631/subnets/subnet-3631";
        Subnet actualResponse = client.getSubnet(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSubnetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3631/locations/location-3631/zones/zone-3631/subnets/subnet-3631";
            client.getSubnet(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSubnetTest() throws Exception {
        Subnet expectedResponse = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("createSubnetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        Subnet subnet = Subnet.newBuilder().build();
        String subnetId = "subnetId-2066159272";
        Subnet actualResponse = (Subnet)client.createSubnetAsync(parent, subnet, subnetId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSubnetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            Subnet subnet = Subnet.newBuilder().build();
            String subnetId = "subnetId-2066159272";
            client.createSubnetAsync(parent, subnet, subnetId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createSubnetTest2() throws Exception {
        Subnet expectedResponse = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("createSubnetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
        Subnet subnet = Subnet.newBuilder().build();
        String subnetId = "subnetId-2066159272";
        Subnet actualResponse = (Subnet)client.createSubnetAsync(parent, subnet, subnetId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSubnetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
            Subnet subnet = Subnet.newBuilder().build();
            String subnetId = "subnetId-2066159272";
            client.createSubnetAsync(parent, subnet, subnetId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateSubnetTest() throws Exception {
        Subnet expectedResponse = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("updateSubnetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Subnet subnet = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Subnet actualResponse = (Subnet)client.updateSubnetAsync(subnet, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSubnetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Subnet subnet = Subnet.newBuilder().setName(SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllIpv4Cidr(new ArrayList()).addAllIpv6Cidr(new ArrayList()).setVlanId(536153463).setState(ResourceState.forNumber((int)0)).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateSubnetAsync(subnet, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSubnetTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSubnetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        SubnetName name = SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]");
        client.deleteSubnetAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSubnetExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SubnetName name = SubnetName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[SUBNET]");
            client.deleteSubnetAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSubnetTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSubnetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-3631/locations/location-3631/zones/zone-3631/subnets/subnet-3631";
        client.deleteSubnetAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSubnetExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-3631/locations/location-3631/zones/zone-3631/subnets/subnet-3631";
            client.deleteSubnetAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listInterconnectsTest() throws Exception {
        Interconnect responsesElement = Interconnect.newBuilder().build();
        ListInterconnectsResponse expectedResponse = ListInterconnectsResponse.newBuilder().setNextPageToken("").addAllInterconnects(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        EdgeNetworkClient.ListInterconnectsPagedResponse pagedListResponse = client.listInterconnects(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInterconnectsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInterconnectsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            client.listInterconnects(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInterconnectsTest2() throws Exception {
        Interconnect responsesElement = Interconnect.newBuilder().build();
        ListInterconnectsResponse expectedResponse = ListInterconnectsResponse.newBuilder().setNextPageToken("").addAllInterconnects(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
        EdgeNetworkClient.ListInterconnectsPagedResponse pagedListResponse = client.listInterconnects(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInterconnectsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInterconnectsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
            client.listInterconnects(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInterconnectTest() throws Exception {
        Interconnect expectedResponse = Interconnect.newBuilder().setName(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setUuid("uuid3601339").setDeviceCloudResourceName("deviceCloudResourceName-1996267816").addAllPhysicalPorts(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        InterconnectName name = InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]");
        Interconnect actualResponse = client.getInterconnect(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInterconnectExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InterconnectName name = InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]");
            client.getInterconnect(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInterconnectTest2() throws Exception {
        Interconnect expectedResponse = Interconnect.newBuilder().setName(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setUuid("uuid3601339").setDeviceCloudResourceName("deviceCloudResourceName-1996267816").addAllPhysicalPorts(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8178/locations/location-8178/zones/zone-8178/interconnects/interconnect-8178";
        Interconnect actualResponse = client.getInterconnect(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInterconnectExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8178/locations/location-8178/zones/zone-8178/interconnects/interconnect-8178";
            client.getInterconnect(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseInterconnectTest() throws Exception {
        DiagnoseInterconnectResponse expectedResponse = DiagnoseInterconnectResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(InterconnectDiagnostics.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        InterconnectName name = InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]");
        DiagnoseInterconnectResponse actualResponse = client.diagnoseInterconnect(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void diagnoseInterconnectExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InterconnectName name = InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]");
            client.diagnoseInterconnect(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseInterconnectTest2() throws Exception {
        DiagnoseInterconnectResponse expectedResponse = DiagnoseInterconnectResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(InterconnectDiagnostics.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-8178/locations/location-8178/zones/zone-8178/interconnects/interconnect-8178";
        DiagnoseInterconnectResponse actualResponse = client.diagnoseInterconnect(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void diagnoseInterconnectExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-8178/locations/location-8178/zones/zone-8178/interconnects/interconnect-8178";
            client.diagnoseInterconnect(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInterconnectAttachmentsTest() throws Exception {
        InterconnectAttachment responsesElement = InterconnectAttachment.newBuilder().build();
        ListInterconnectAttachmentsResponse expectedResponse = ListInterconnectAttachmentsResponse.newBuilder().setNextPageToken("").addAllInterconnectAttachments(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse pagedListResponse = client.listInterconnectAttachments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInterconnectAttachmentsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInterconnectAttachmentsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            client.listInterconnectAttachments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInterconnectAttachmentsTest2() throws Exception {
        InterconnectAttachment responsesElement = InterconnectAttachment.newBuilder().build();
        ListInterconnectAttachmentsResponse expectedResponse = ListInterconnectAttachmentsResponse.newBuilder().setNextPageToken("").addAllInterconnectAttachments(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
        EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse pagedListResponse = client.listInterconnectAttachments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInterconnectAttachmentsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInterconnectAttachmentsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
            client.listInterconnectAttachments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInterconnectAttachmentTest() throws Exception {
        InterconnectAttachment expectedResponse = InterconnectAttachment.newBuilder().setName(InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setInterconnect(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setVlanId(536153463).setMtu(108462).setState(ResourceState.forNumber((int)0)).build();
        mockService.addResponse((Object)expectedResponse);
        InterconnectAttachmentName name = InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]");
        InterconnectAttachment actualResponse = client.getInterconnectAttachment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInterconnectAttachmentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InterconnectAttachmentName name = InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]");
            client.getInterconnectAttachment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInterconnectAttachmentTest2() throws Exception {
        InterconnectAttachment expectedResponse = InterconnectAttachment.newBuilder().setName(InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setInterconnect(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setVlanId(536153463).setMtu(108462).setState(ResourceState.forNumber((int)0)).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-5355/locations/location-5355/zones/zone-5355/interconnectAttachments/interconnectAttachment-5355";
        InterconnectAttachment actualResponse = client.getInterconnectAttachment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInterconnectAttachmentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5355/locations/location-5355/zones/zone-5355/interconnectAttachments/interconnectAttachment-5355";
            client.getInterconnectAttachment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInterconnectAttachmentTest() throws Exception {
        InterconnectAttachment expectedResponse = InterconnectAttachment.newBuilder().setName(InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setInterconnect(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setVlanId(536153463).setMtu(108462).setState(ResourceState.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("createInterconnectAttachmentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        InterconnectAttachment interconnectAttachment = InterconnectAttachment.newBuilder().build();
        String interconnectAttachmentId = "interconnectAttachmentId1053538636";
        InterconnectAttachment actualResponse = (InterconnectAttachment)client.createInterconnectAttachmentAsync(parent, interconnectAttachment, interconnectAttachmentId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createInterconnectAttachmentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            InterconnectAttachment interconnectAttachment = InterconnectAttachment.newBuilder().build();
            String interconnectAttachmentId = "interconnectAttachmentId1053538636";
            client.createInterconnectAttachmentAsync(parent, interconnectAttachment, interconnectAttachmentId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createInterconnectAttachmentTest2() throws Exception {
        InterconnectAttachment expectedResponse = InterconnectAttachment.newBuilder().setName(InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setInterconnect(InterconnectName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT]").toString()).setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).setVlanId(536153463).setMtu(108462).setState(ResourceState.forNumber((int)0)).build();
        Operation resultOperation = Operation.newBuilder().setName("createInterconnectAttachmentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
        InterconnectAttachment interconnectAttachment = InterconnectAttachment.newBuilder().build();
        String interconnectAttachmentId = "interconnectAttachmentId1053538636";
        InterconnectAttachment actualResponse = (InterconnectAttachment)client.createInterconnectAttachmentAsync(parent, interconnectAttachment, interconnectAttachmentId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createInterconnectAttachmentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
            InterconnectAttachment interconnectAttachment = InterconnectAttachment.newBuilder().build();
            String interconnectAttachmentId = "interconnectAttachmentId1053538636";
            client.createInterconnectAttachmentAsync(parent, interconnectAttachment, interconnectAttachmentId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInterconnectAttachmentTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteInterconnectAttachmentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InterconnectAttachmentName name = InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]");
        client.deleteInterconnectAttachmentAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteInterconnectAttachmentExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InterconnectAttachmentName name = InterconnectAttachmentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[INTERCONNECT_ATTACHMENT]");
            client.deleteInterconnectAttachmentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInterconnectAttachmentTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteInterconnectAttachmentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-5355/locations/location-5355/zones/zone-5355/interconnectAttachments/interconnectAttachment-5355";
        client.deleteInterconnectAttachmentAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteInterconnectAttachmentExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-5355/locations/location-5355/zones/zone-5355/interconnectAttachments/interconnectAttachment-5355";
            client.deleteInterconnectAttachmentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listRoutersTest() throws Exception {
        Router responsesElement = Router.newBuilder().build();
        ListRoutersResponse expectedResponse = ListRoutersResponse.newBuilder().setNextPageToken("").addAllRouters(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        EdgeNetworkClient.ListRoutersPagedResponse pagedListResponse = client.listRouters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRoutersList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listRoutersExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            client.listRouters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listRoutersTest2() throws Exception {
        Router responsesElement = Router.newBuilder().build();
        ListRoutersResponse expectedResponse = ListRoutersResponse.newBuilder().setNextPageToken("").addAllRouters(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
        EdgeNetworkClient.ListRoutersPagedResponse pagedListResponse = client.listRouters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRoutersList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listRoutersExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
            client.listRouters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRouterTest() throws Exception {
        Router expectedResponse = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
        Router actualResponse = client.getRouter(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getRouterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
            client.getRouter(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRouterTest2() throws Exception {
        Router expectedResponse = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-6755/locations/location-6755/zones/zone-6755/routers/router-6755";
        Router actualResponse = client.getRouter(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getRouterExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-6755/locations/location-6755/zones/zone-6755/routers/router-6755";
            client.getRouter(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseRouterTest() throws Exception {
        DiagnoseRouterResponse expectedResponse = DiagnoseRouterResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(RouterStatus.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
        DiagnoseRouterResponse actualResponse = client.diagnoseRouter(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void diagnoseRouterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
            client.diagnoseRouter(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void diagnoseRouterTest2() throws Exception {
        DiagnoseRouterResponse expectedResponse = DiagnoseRouterResponse.newBuilder().setUpdateTime(Timestamp.newBuilder().build()).setResult(RouterStatus.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-6755/locations/location-6755/zones/zone-6755/routers/router-6755";
        DiagnoseRouterResponse actualResponse = client.diagnoseRouter(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void diagnoseRouterExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-6755/locations/location-6755/zones/zone-6755/routers/router-6755";
            client.diagnoseRouter(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createRouterTest() throws Exception {
        Router expectedResponse = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createRouterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
        Router router = Router.newBuilder().build();
        String routerId = "routerId5435972";
        Router actualResponse = (Router)client.createRouterAsync(parent, router, routerId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createRouterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ZoneName parent = ZoneName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]");
            Router router = Router.newBuilder().build();
            String routerId = "routerId5435972";
            client.createRouterAsync(parent, router, routerId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createRouterTest2() throws Exception {
        Router expectedResponse = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createRouterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
        Router router = Router.newBuilder().build();
        String routerId = "routerId5435972";
        Router actualResponse = (Router)client.createRouterAsync(parent, router, routerId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createRouterExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-7228/locations/location-7228/zones/zone-7228";
            Router router = Router.newBuilder().build();
            String routerId = "routerId5435972";
            client.createRouterAsync(parent, router, routerId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateRouterTest() throws Exception {
        Router expectedResponse = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateRouterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Router router = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Router actualResponse = (Router)client.updateRouterAsync(router, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateRouterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Router router = Router.newBuilder().setName(RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setDescription("description-1724546052").setNetwork(NetworkName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[NETWORK]").toString()).addAllInterface(new ArrayList()).addAllBgpPeer(new ArrayList()).setBgp(Router.Bgp.newBuilder().build()).setState(ResourceState.forNumber((int)0)).addAllRouteAdvertisements(new ArrayList()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateRouterAsync(router, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteRouterTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRouterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
        client.deleteRouterAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteRouterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RouterName name = RouterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ZONE]", (String)"[ROUTER]");
            client.deleteRouterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteRouterTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRouterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-6755/locations/location-6755/zones/zone-6755/routers/router-6755";
        client.deleteRouterAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteRouterExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-6755/locations/location-6755/zones/zone-6755/routers/router-6755";
            client.deleteRouterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listLocationsTest() throws Exception {
        Location responsesElement = Location.newBuilder().build();
        ListLocationsResponse expectedResponse = ListLocationsResponse.newBuilder().setNextPageToken("").addAllLocations(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("projects/project-3664").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
        EdgeNetworkClient.ListLocationsPagedResponse pagedListResponse = client.listLocations(request);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getLocationsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listLocationsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            ListLocationsRequest request = ListLocationsRequest.newBuilder().setName("projects/project-3664").setFilter("filter-1274492040").setPageSize(883849137).setPageToken("pageToken873572522").build();
            client.listLocations(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getLocationTest() throws Exception {
        Location expectedResponse = Location.newBuilder().setName("name3373707").setLocationId("locationId1541836720").setDisplayName("displayName1714148973").putAllLabels(new HashMap()).setMetadata(Any.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        GetLocationRequest request = GetLocationRequest.newBuilder().setName("projects/project-9062/locations/location-9062").build();
        Location actualResponse = client.getLocation(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getLocationExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GetLocationRequest request = GetLocationRequest.newBuilder().setName("projects/project-9062/locations/location-9062").build();
            client.getLocation(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

