/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.publishing.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.publishing.v1.PublishChannelConnectionEventsRequest;
import com.google.cloud.eventarc.publishing.v1.PublishChannelConnectionEventsResponse;
import com.google.cloud.eventarc.publishing.v1.PublishEventsRequest;
import com.google.cloud.eventarc.publishing.v1.PublishEventsResponse;
import com.google.cloud.eventarc.publishing.v1.PublishRequest;
import com.google.cloud.eventarc.publishing.v1.PublishResponse;
import com.google.cloud.eventarc.publishing.v1.stub.GrpcPublisherCallableFactory;
import com.google.cloud.eventarc.publishing.v1.stub.PublisherStub;
import com.google.cloud.eventarc.publishing.v1.stub.PublisherStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcPublisherStub
extends PublisherStub {
    private static final MethodDescriptor<PublishChannelConnectionEventsRequest, PublishChannelConnectionEventsResponse> publishChannelConnectionEventsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.publishing.v1.Publisher/PublishChannelConnectionEvents").setRequestMarshaller(ProtoUtils.marshaller((Message)PublishChannelConnectionEventsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PublishChannelConnectionEventsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<PublishEventsRequest, PublishEventsResponse> publishEventsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.publishing.v1.Publisher/PublishEvents").setRequestMarshaller(ProtoUtils.marshaller((Message)PublishEventsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PublishEventsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<PublishRequest, PublishResponse> publishMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.eventarc.publishing.v1.Publisher/Publish").setRequestMarshaller(ProtoUtils.marshaller((Message)PublishRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PublishResponse.getDefaultInstance())).build();
    private final UnaryCallable<PublishChannelConnectionEventsRequest, PublishChannelConnectionEventsResponse> publishChannelConnectionEventsCallable;
    private final UnaryCallable<PublishEventsRequest, PublishEventsResponse> publishEventsCallable;
    private final UnaryCallable<PublishRequest, PublishResponse> publishCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPublisherStub create(PublisherStubSettings settings) throws IOException {
        return new GrpcPublisherStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPublisherStub create(ClientContext clientContext) throws IOException {
        return new GrpcPublisherStub(PublisherStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPublisherStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPublisherStub(PublisherStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPublisherStub(PublisherStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPublisherCallableFactory());
    }

    protected GrpcPublisherStub(PublisherStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings publishChannelConnectionEventsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(publishChannelConnectionEventsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("channel_connection", String.valueOf(request.getChannelConnection()));
            return builder.build();
        }).build();
        GrpcCallSettings publishEventsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(publishEventsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("channel", String.valueOf(request.getChannel()));
            return builder.build();
        }).build();
        GrpcCallSettings publishTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(publishMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("message_bus", String.valueOf(request.getMessageBus()));
            return builder.build();
        }).build();
        this.publishChannelConnectionEventsCallable = callableFactory.createUnaryCallable(publishChannelConnectionEventsTransportSettings, settings.publishChannelConnectionEventsSettings(), clientContext);
        this.publishEventsCallable = callableFactory.createUnaryCallable(publishEventsTransportSettings, settings.publishEventsSettings(), clientContext);
        this.publishCallable = callableFactory.createUnaryCallable(publishTransportSettings, settings.publishSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<PublishChannelConnectionEventsRequest, PublishChannelConnectionEventsResponse> publishChannelConnectionEventsCallable() {
        return this.publishChannelConnectionEventsCallable;
    }

    @Override
    public UnaryCallable<PublishEventsRequest, PublishEventsResponse> publishEventsCallable() {
        return this.publishEventsCallable;
    }

    @Override
    public UnaryCallable<PublishRequest, PublishResponse> publishCallable() {
        return this.publishCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

