/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.filestore.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.filestore.v1.Backup;
import com.google.cloud.filestore.v1.BackupName;
import com.google.cloud.filestore.v1.CloudFilestoreManagerClient;
import com.google.cloud.filestore.v1.CloudFilestoreManagerSettings;
import com.google.cloud.filestore.v1.Instance;
import com.google.cloud.filestore.v1.InstanceName;
import com.google.cloud.filestore.v1.ListBackupsResponse;
import com.google.cloud.filestore.v1.ListInstancesResponse;
import com.google.cloud.filestore.v1.ListSnapshotsResponse;
import com.google.cloud.filestore.v1.LocationName;
import com.google.cloud.filestore.v1.RestoreInstanceRequest;
import com.google.cloud.filestore.v1.RevertInstanceRequest;
import com.google.cloud.filestore.v1.Snapshot;
import com.google.cloud.filestore.v1.SnapshotName;
import com.google.cloud.filestore.v1.stub.HttpJsonCloudFilestoreManagerStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CloudFilestoreManagerClientHttpJsonTest {
    private static MockHttpService mockService;
    private static CloudFilestoreManagerClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonCloudFilestoreManagerStub.getMethodDescriptors(), CloudFilestoreManagerSettings.getDefaultEndpoint());
        CloudFilestoreManagerSettings settings = ((CloudFilestoreManagerSettings.Builder)((CloudFilestoreManagerSettings.Builder)CloudFilestoreManagerSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)CloudFilestoreManagerSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = CloudFilestoreManagerClient.create((CloudFilestoreManagerSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listInstancesTest() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        CloudFilestoreManagerClient.ListInstancesPagedResponse pagedListResponse = client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstancesExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest2() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        CloudFilestoreManagerClient.ListInstancesPagedResponse pagedListResponse = client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listInstancesExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
        Instance actualResponse = client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
            client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-9412/locations/location-9412/instances/instance-9412";
        Instance actualResponse = client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getInstanceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9412/locations/location-9412/instances/instance-9412";
            client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Instance instance = Instance.newBuilder().build();
        String instanceId = "instanceId902024336";
        Instance actualResponse = (Instance)client.createInstanceAsync(parent, instance, instanceId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Instance instance = Instance.newBuilder().build();
            String instanceId = "instanceId902024336";
            client.createInstanceAsync(parent, instance, instanceId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Instance instance = Instance.newBuilder().build();
        String instanceId = "instanceId902024336";
        Instance actualResponse = (Instance)client.createInstanceAsync(parent, instance, instanceId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createInstanceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Instance instance = Instance.newBuilder().build();
            String instanceId = "instanceId902024336";
            client.createInstanceAsync(parent, instance, instanceId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Instance instance = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Instance actualResponse = (Instance)client.updateInstanceAsync(instance, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Instance instance = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateInstanceAsync(instance, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void restoreInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("restoreInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RestoreInstanceRequest request = RestoreInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setFileShare("fileShare-1327728701").build();
        Instance actualResponse = (Instance)client.restoreInstanceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void restoreInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RestoreInstanceRequest request = RestoreInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setFileShare("fileShare-1327728701").build();
            client.restoreInstanceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void revertInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).build();
        Operation resultOperation = Operation.newBuilder().setName("revertInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RevertInstanceRequest request = RevertInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setTargetSnapshotId("targetSnapshotId-2099459472").build();
        Instance actualResponse = (Instance)client.revertInstanceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void revertInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RevertInstanceRequest request = RevertInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setTargetSnapshotId("targetSnapshotId-2099459472").build();
            client.revertInstanceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstanceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
        client.deleteInstanceAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteInstanceExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
            client.deleteInstanceAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteInstanceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-9412/locations/location-9412/instances/instance-9412";
        client.deleteInstanceAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteInstanceExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-9412/locations/location-9412/instances/instance-9412";
            client.deleteInstanceAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listSnapshotsTest() throws Exception {
        Snapshot responsesElement = Snapshot.newBuilder().build();
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
        CloudFilestoreManagerClient.ListSnapshotsPagedResponse pagedListResponse = client.listSnapshots(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSnapshotsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
            client.listSnapshots(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnapshotsTest2() throws Exception {
        Snapshot responsesElement = Snapshot.newBuilder().build();
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5197/locations/location-5197/instances/instance-5197";
        CloudFilestoreManagerClient.ListSnapshotsPagedResponse pagedListResponse = client.listSnapshots(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listSnapshotsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5197/locations/location-5197/instances/instance-5197";
            client.listSnapshots(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).build();
        mockService.addResponse((Object)expectedResponse);
        SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]");
        Snapshot actualResponse = client.getSnapshot(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSnapshotExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]");
            client.getSnapshot(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnapshotTest2() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-2497/locations/location-2497/instances/instance-2497/snapshots/snapshot-2497";
        Snapshot actualResponse = client.getSnapshot(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getSnapshotExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2497/locations/location-2497/instances/instance-2497/snapshots/snapshot-2497";
            client.getSnapshot(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).build();
        Operation resultOperation = Operation.newBuilder().setName("createSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
        Snapshot snapshot = Snapshot.newBuilder().build();
        String snapshotId = "snapshotId-1113817601";
        Snapshot actualResponse = (Snapshot)client.createSnapshotAsync(parent, snapshot, snapshotId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSnapshotExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
            Snapshot snapshot = Snapshot.newBuilder().build();
            String snapshotId = "snapshotId-1113817601";
            client.createSnapshotAsync(parent, snapshot, snapshotId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest2() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).build();
        Operation resultOperation = Operation.newBuilder().setName("createSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5197/locations/location-5197/instances/instance-5197";
        Snapshot snapshot = Snapshot.newBuilder().build();
        String snapshotId = "snapshotId-1113817601";
        Snapshot actualResponse = (Snapshot)client.createSnapshotAsync(parent, snapshot, snapshotId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createSnapshotExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5197/locations/location-5197/instances/instance-5197";
            Snapshot snapshot = Snapshot.newBuilder().build();
            String snapshotId = "snapshotId-1113817601";
            client.createSnapshotAsync(parent, snapshot, snapshotId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSnapshotTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]");
        client.deleteSnapshotAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSnapshotExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]");
            client.deleteSnapshotAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteSnapshotTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-2497/locations/location-2497/instances/instance-2497/snapshots/snapshot-2497";
        client.deleteSnapshotAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteSnapshotExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-2497/locations/location-2497/instances/instance-2497/snapshots/snapshot-2497";
            client.deleteSnapshotAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).build();
        Operation resultOperation = Operation.newBuilder().setName("updateSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Snapshot snapshot = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Snapshot actualResponse = (Snapshot)client.updateSnapshotAsync(snapshot, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateSnapshotExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Snapshot snapshot = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateSnapshotAsync(snapshot, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupsTest() throws Exception {
        Backup responsesElement = Backup.newBuilder().build();
        ListBackupsResponse expectedResponse = ListBackupsResponse.newBuilder().setNextPageToken("").addAllBackups(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        CloudFilestoreManagerClient.ListBackupsPagedResponse pagedListResponse = client.listBackups(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBackupsExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            client.listBackups(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupsTest2() throws Exception {
        Backup responsesElement = Backup.newBuilder().build();
        ListBackupsResponse expectedResponse = ListBackupsResponse.newBuilder().setNextPageToken("").addAllBackups(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-5833/locations/location-5833";
        CloudFilestoreManagerClient.ListBackupsPagedResponse pagedListResponse = client.listBackups(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupsList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listBackupsExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            client.listBackups(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").build();
        mockService.addResponse((Object)expectedResponse);
        BackupName name = BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]");
        Backup actualResponse = client.getBackup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getBackupExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BackupName name = BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]");
            client.getBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-1607/locations/location-1607/backups/backup-1607";
        Backup actualResponse = client.getBackup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getBackupExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1607/locations/location-1607/backups/backup-1607";
            client.getBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").build();
        Operation resultOperation = Operation.newBuilder().setName("createBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Backup backup = Backup.newBuilder().build();
        String backupId = "backupId2121930365";
        Backup actualResponse = (Backup)client.createBackupAsync(parent, backup, backupId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBackupExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Backup backup = Backup.newBuilder().build();
            String backupId = "backupId2121930365";
            client.createBackupAsync(parent, backup, backupId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").build();
        Operation resultOperation = Operation.newBuilder().setName("createBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-5833/locations/location-5833";
        Backup backup = Backup.newBuilder().build();
        String backupId = "backupId2121930365";
        Backup actualResponse = (Backup)client.createBackupAsync(parent, backup, backupId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createBackupExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-5833/locations/location-5833";
            Backup backup = Backup.newBuilder().build();
            String backupId = "backupId2121930365";
            client.createBackupAsync(parent, backup, backupId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBackupTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        BackupName name = BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]");
        client.deleteBackupAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteBackupExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            BackupName name = BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]");
            client.deleteBackupAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteBackupTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-1607/locations/location-1607/backups/backup-1607";
        client.deleteBackupAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteBackupExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-1607/locations/location-1607/backups/backup-1607";
            client.deleteBackupAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void updateBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").build();
        Operation resultOperation = Operation.newBuilder().setName("updateBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        Backup backup = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Backup actualResponse = (Backup)client.updateBackupAsync(backup, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateBackupExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            Backup backup = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateBackupAsync(backup, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }
}

