/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.filestore.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.filestore.v1.Backup;
import com.google.cloud.filestore.v1.BackupName;
import com.google.cloud.filestore.v1.CloudFilestoreManagerClient;
import com.google.cloud.filestore.v1.CloudFilestoreManagerSettings;
import com.google.cloud.filestore.v1.CreateBackupRequest;
import com.google.cloud.filestore.v1.CreateInstanceRequest;
import com.google.cloud.filestore.v1.CreateSnapshotRequest;
import com.google.cloud.filestore.v1.DeleteBackupRequest;
import com.google.cloud.filestore.v1.DeleteInstanceRequest;
import com.google.cloud.filestore.v1.DeleteSnapshotRequest;
import com.google.cloud.filestore.v1.GetBackupRequest;
import com.google.cloud.filestore.v1.GetInstanceRequest;
import com.google.cloud.filestore.v1.GetSnapshotRequest;
import com.google.cloud.filestore.v1.Instance;
import com.google.cloud.filestore.v1.InstanceName;
import com.google.cloud.filestore.v1.ListBackupsRequest;
import com.google.cloud.filestore.v1.ListBackupsResponse;
import com.google.cloud.filestore.v1.ListInstancesRequest;
import com.google.cloud.filestore.v1.ListInstancesResponse;
import com.google.cloud.filestore.v1.ListSnapshotsRequest;
import com.google.cloud.filestore.v1.ListSnapshotsResponse;
import com.google.cloud.filestore.v1.LocationName;
import com.google.cloud.filestore.v1.MockCloudFilestoreManager;
import com.google.cloud.filestore.v1.PromoteReplicaRequest;
import com.google.cloud.filestore.v1.Replication;
import com.google.cloud.filestore.v1.RestoreInstanceRequest;
import com.google.cloud.filestore.v1.RevertInstanceRequest;
import com.google.cloud.filestore.v1.Snapshot;
import com.google.cloud.filestore.v1.SnapshotName;
import com.google.cloud.filestore.v1.UpdateBackupRequest;
import com.google.cloud.filestore.v1.UpdateInstanceRequest;
import com.google.cloud.filestore.v1.UpdateSnapshotRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CloudFilestoreManagerClientTest {
    private static MockCloudFilestoreManager mockCloudFilestoreManager;
    private static MockServiceHelper mockServiceHelper;
    private LocalChannelProvider channelProvider;
    private CloudFilestoreManagerClient client;

    @BeforeClass
    public static void startStaticServer() {
        mockCloudFilestoreManager = new MockCloudFilestoreManager();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockCloudFilestoreManager));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        CloudFilestoreManagerSettings settings = ((CloudFilestoreManagerSettings.Builder)((CloudFilestoreManagerSettings.Builder)CloudFilestoreManagerSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = CloudFilestoreManagerClient.create((CloudFilestoreManagerSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listInstancesTest() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        CloudFilestoreManagerClient.ListInstancesPagedResponse pagedListResponse = this.client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listInstancesTest2() throws Exception {
        Instance responsesElement = Instance.newBuilder().build();
        ListInstancesResponse expectedResponse = ListInstancesResponse.newBuilder().setNextPageToken("").addAllInstances(Arrays.asList(responsesElement)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        CloudFilestoreManagerClient.ListInstancesPagedResponse pagedListResponse = this.client.listInstances(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getInstancesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListInstancesRequest actualRequest = (ListInstancesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listInstancesExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listInstances(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).setReplication(Replication.newBuilder().build()).putAllTags(new HashMap()).setCustomPerformanceSupported(true).setPerformanceConfig(Instance.PerformanceConfig.newBuilder().build()).setPerformanceLimits(Instance.PerformanceLimits.newBuilder().build()).setDeletionProtectionEnabled(true).setDeletionProtectionReason("deletionProtectionReason-1655366037").build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).setReplication(Replication.newBuilder().build()).putAllTags(new HashMap()).setCustomPerformanceSupported(true).setPerformanceConfig(Instance.PerformanceConfig.newBuilder().build()).setPerformanceLimits(Instance.PerformanceLimits.newBuilder().build()).setDeletionProtectionEnabled(true).setDeletionProtectionReason("deletionProtectionReason-1655366037").build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Instance actualResponse = this.client.getInstance(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetInstanceRequest actualRequest = (GetInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getInstance(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).setReplication(Replication.newBuilder().build()).putAllTags(new HashMap()).setCustomPerformanceSupported(true).setPerformanceConfig(Instance.PerformanceConfig.newBuilder().build()).setPerformanceLimits(Instance.PerformanceLimits.newBuilder().build()).setDeletionProtectionEnabled(true).setDeletionProtectionReason("deletionProtectionReason-1655366037").build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Instance instance = Instance.newBuilder().build();
        String instanceId = "instanceId902024336";
        Instance actualResponse = (Instance)this.client.createInstanceAsync(parent, instance, instanceId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceRequest actualRequest = (CreateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertEquals((Object)instanceId, (Object)actualRequest.getInstanceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Instance instance = Instance.newBuilder().build();
            String instanceId = "instanceId902024336";
            this.client.createInstanceAsync(parent, instance, instanceId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createInstanceTest2() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).setReplication(Replication.newBuilder().build()).putAllTags(new HashMap()).setCustomPerformanceSupported(true).setPerformanceConfig(Instance.PerformanceConfig.newBuilder().build()).setPerformanceLimits(Instance.PerformanceLimits.newBuilder().build()).setDeletionProtectionEnabled(true).setDeletionProtectionReason("deletionProtectionReason-1655366037").build();
        Operation resultOperation = Operation.newBuilder().setName("createInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Instance instance = Instance.newBuilder().build();
        String instanceId = "instanceId902024336";
        Instance actualResponse = (Instance)this.client.createInstanceAsync(parent, instance, instanceId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateInstanceRequest actualRequest = (CreateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertEquals((Object)instanceId, (Object)actualRequest.getInstanceId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Instance instance = Instance.newBuilder().build();
            String instanceId = "instanceId902024336";
            this.client.createInstanceAsync(parent, instance, instanceId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).setReplication(Replication.newBuilder().build()).putAllTags(new HashMap()).setCustomPerformanceSupported(true).setPerformanceConfig(Instance.PerformanceConfig.newBuilder().build()).setPerformanceLimits(Instance.PerformanceLimits.newBuilder().build()).setDeletionProtectionEnabled(true).setDeletionProtectionReason("deletionProtectionReason-1655366037").build();
        Operation resultOperation = Operation.newBuilder().setName("updateInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        Instance instance = Instance.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Instance actualResponse = (Instance)this.client.updateInstanceAsync(instance, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateInstanceRequest actualRequest = (UpdateInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)instance, (Object)actualRequest.getInstance());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            Instance instance = Instance.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateInstanceAsync(instance, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void restoreInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).setReplication(Replication.newBuilder().build()).putAllTags(new HashMap()).setCustomPerformanceSupported(true).setPerformanceConfig(Instance.PerformanceConfig.newBuilder().build()).setPerformanceLimits(Instance.PerformanceLimits.newBuilder().build()).setDeletionProtectionEnabled(true).setDeletionProtectionReason("deletionProtectionReason-1655366037").build();
        Operation resultOperation = Operation.newBuilder().setName("restoreInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        RestoreInstanceRequest request = RestoreInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setFileShare("fileShare-1327728701").build();
        Instance actualResponse = (Instance)this.client.restoreInstanceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RestoreInstanceRequest actualRequest = (RestoreInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getFileShare(), (Object)actualRequest.getFileShare());
        Assert.assertEquals((Object)request.getSourceBackup(), (Object)actualRequest.getSourceBackup());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void restoreInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            RestoreInstanceRequest request = RestoreInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setFileShare("fileShare-1327728701").build();
            this.client.restoreInstanceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void revertInstanceTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).setReplication(Replication.newBuilder().build()).putAllTags(new HashMap()).setCustomPerformanceSupported(true).setPerformanceConfig(Instance.PerformanceConfig.newBuilder().build()).setPerformanceLimits(Instance.PerformanceLimits.newBuilder().build()).setDeletionProtectionEnabled(true).setDeletionProtectionReason("deletionProtectionReason-1655366037").build();
        Operation resultOperation = Operation.newBuilder().setName("revertInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        RevertInstanceRequest request = RevertInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setTargetSnapshotId("targetSnapshotId-2099459472").build();
        Instance actualResponse = (Instance)this.client.revertInstanceAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RevertInstanceRequest actualRequest = (RevertInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getTargetSnapshotId(), (Object)actualRequest.getTargetSnapshotId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void revertInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            RevertInstanceRequest request = RevertInstanceRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setTargetSnapshotId("targetSnapshotId-2099459472").build();
            this.client.revertInstanceAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteInstanceTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
        this.client.deleteInstanceAsync(name).get();
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceRequest actualRequest = (DeleteInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            InstanceName name = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
            this.client.deleteInstanceAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteInstanceTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteInstanceTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteInstanceAsync(name).get();
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteInstanceRequest actualRequest = (DeleteInstanceRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteInstanceExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteInstanceAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listSnapshotsTest() throws Exception {
        Snapshot responsesElement = Snapshot.newBuilder().build();
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
        CloudFilestoreManagerClient.ListSnapshotsPagedResponse pagedListResponse = this.client.listSnapshots(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSnapshotsRequest actualRequest = (ListSnapshotsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSnapshotsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
            this.client.listSnapshots(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listSnapshotsTest2() throws Exception {
        Snapshot responsesElement = Snapshot.newBuilder().build();
        ListSnapshotsResponse expectedResponse = ListSnapshotsResponse.newBuilder().setNextPageToken("").addAllSnapshots(Arrays.asList(responsesElement)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        CloudFilestoreManagerClient.ListSnapshotsPagedResponse pagedListResponse = this.client.listSnapshots(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getSnapshotsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListSnapshotsRequest actualRequest = (ListSnapshotsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listSnapshotsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listSnapshots(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).putAllTags(new HashMap()).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]");
        Snapshot actualResponse = this.client.getSnapshot(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSnapshotRequest actualRequest = (GetSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]");
            this.client.getSnapshot(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getSnapshotTest2() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).putAllTags(new HashMap()).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Snapshot actualResponse = this.client.getSnapshot(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetSnapshotRequest actualRequest = (GetSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getSnapshotExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getSnapshot(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).putAllTags(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
        Snapshot snapshot = Snapshot.newBuilder().build();
        String snapshotId = "snapshotId-1113817601";
        Snapshot actualResponse = (Snapshot)this.client.createSnapshotAsync(parent, snapshot, snapshotId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSnapshotRequest actualRequest = (CreateSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)snapshot, (Object)actualRequest.getSnapshot());
        Assert.assertEquals((Object)snapshotId, (Object)actualRequest.getSnapshotId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            InstanceName parent = InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]");
            Snapshot snapshot = Snapshot.newBuilder().build();
            String snapshotId = "snapshotId-1113817601";
            this.client.createSnapshotAsync(parent, snapshot, snapshotId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createSnapshotTest2() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).putAllTags(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Snapshot snapshot = Snapshot.newBuilder().build();
        String snapshotId = "snapshotId-1113817601";
        Snapshot actualResponse = (Snapshot)this.client.createSnapshotAsync(parent, snapshot, snapshotId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateSnapshotRequest actualRequest = (CreateSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)snapshot, (Object)actualRequest.getSnapshot());
        Assert.assertEquals((Object)snapshotId, (Object)actualRequest.getSnapshotId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createSnapshotExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Snapshot snapshot = Snapshot.newBuilder().build();
            String snapshotId = "snapshotId-1113817601";
            this.client.createSnapshotAsync(parent, snapshot, snapshotId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteSnapshotTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]");
        this.client.deleteSnapshotAsync(name).get();
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSnapshotRequest actualRequest = (DeleteSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            SnapshotName name = SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]");
            this.client.deleteSnapshotAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteSnapshotTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteSnapshotAsync(name).get();
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteSnapshotRequest actualRequest = (DeleteSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteSnapshotExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteSnapshotAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateSnapshotTest() throws Exception {
        Snapshot expectedResponse = Snapshot.newBuilder().setName(SnapshotName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]", (String)"[SNAPSHOT]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setFilesystemUsedBytes(387235709L).putAllTags(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateSnapshotTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        Snapshot snapshot = Snapshot.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Snapshot actualResponse = (Snapshot)this.client.updateSnapshotAsync(snapshot, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateSnapshotRequest actualRequest = (UpdateSnapshotRequest)actualRequests.get(0);
        Assert.assertEquals((Object)snapshot, (Object)actualRequest.getSnapshot());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateSnapshotExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            Snapshot snapshot = Snapshot.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateSnapshotAsync(snapshot, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void listBackupsTest() throws Exception {
        Backup responsesElement = Backup.newBuilder().build();
        ListBackupsResponse expectedResponse = ListBackupsResponse.newBuilder().setNextPageToken("").addAllBackups(Arrays.asList(responsesElement)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        CloudFilestoreManagerClient.ListBackupsPagedResponse pagedListResponse = this.client.listBackups(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBackupsRequest actualRequest = (ListBackupsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBackupsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listBackups(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listBackupsTest2() throws Exception {
        Backup responsesElement = Backup.newBuilder().build();
        ListBackupsResponse expectedResponse = ListBackupsResponse.newBuilder().setNextPageToken("").addAllBackups(Arrays.asList(responsesElement)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        CloudFilestoreManagerClient.ListBackupsPagedResponse pagedListResponse = this.client.listBackups(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getBackupsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListBackupsRequest actualRequest = (ListBackupsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listBackupsExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listBackups(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").putAllTags(new HashMap()).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        BackupName name = BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]");
        Backup actualResponse = this.client.getBackup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetBackupRequest actualRequest = (GetBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            BackupName name = BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]");
            this.client.getBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").putAllTags(new HashMap()).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        Backup actualResponse = this.client.getBackup(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetBackupRequest actualRequest = (GetBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getBackupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getBackup(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").putAllTags(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Backup backup = Backup.newBuilder().build();
        String backupId = "backupId2121930365";
        Backup actualResponse = (Backup)this.client.createBackupAsync(parent, backup, backupId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBackupRequest actualRequest = (CreateBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertEquals((Object)backupId, (Object)actualRequest.getBackupId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Backup backup = Backup.newBuilder().build();
            String backupId = "backupId2121930365";
            this.client.createBackupAsync(parent, backup, backupId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createBackupTest2() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").putAllTags(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("createBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        Backup backup = Backup.newBuilder().build();
        String backupId = "backupId2121930365";
        Backup actualResponse = (Backup)this.client.createBackupAsync(parent, backup, backupId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateBackupRequest actualRequest = (CreateBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertEquals((Object)backupId, (Object)actualRequest.getBackupId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createBackupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            Backup backup = Backup.newBuilder().build();
            String backupId = "backupId2121930365";
            this.client.createBackupAsync(parent, backup, backupId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteBackupTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        BackupName name = BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]");
        this.client.deleteBackupAsync(name).get();
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteBackupRequest actualRequest = (DeleteBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            BackupName name = BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]");
            this.client.deleteBackupAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteBackupTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteBackupAsync(name).get();
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteBackupRequest actualRequest = (DeleteBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteBackupExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteBackupAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateBackupTest() throws Exception {
        Backup expectedResponse = Backup.newBuilder().setName(BackupName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[BACKUP]").toString()).setDescription("description-1724546052").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setCapacityGb(-1923585408L).setStorageBytes(2035244455L).setSourceInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setSourceFileShare("sourceFileShare-646832664").setDownloadBytes(971924980L).setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKey("kmsKey-1127483058").putAllTags(new HashMap()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateBackupTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        Backup backup = Backup.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Backup actualResponse = (Backup)this.client.updateBackupAsync(backup, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateBackupRequest actualRequest = (UpdateBackupRequest)actualRequests.get(0);
        Assert.assertEquals((Object)backup, (Object)actualRequest.getBackup());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateBackupExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            Backup backup = Backup.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateBackupAsync(backup, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void promoteReplicaTest() throws Exception {
        Instance expectedResponse = Instance.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setDescription("description-1724546052").setStatusMessage("statusMessage-958704715").setCreateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).addAllFileShares(new ArrayList()).addAllNetworks(new ArrayList()).setEtag("etag3123477").setSatisfiesPzs(BoolValue.newBuilder().build()).setSatisfiesPzi(true).setKmsKeyName("kmsKeyName412586233").addAllSuspensionReasons(new ArrayList()).setReplication(Replication.newBuilder().build()).putAllTags(new HashMap()).setCustomPerformanceSupported(true).setPerformanceConfig(Instance.PerformanceConfig.newBuilder().build()).setPerformanceLimits(Instance.PerformanceLimits.newBuilder().build()).setDeletionProtectionEnabled(true).setDeletionProtectionReason("deletionProtectionReason-1655366037").build();
        Operation resultOperation = Operation.newBuilder().setName("promoteReplicaTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockCloudFilestoreManager.addResponse((AbstractMessage)resultOperation);
        PromoteReplicaRequest request = PromoteReplicaRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setPeerInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).build();
        Instance actualResponse = (Instance)this.client.promoteReplicaAsync(request).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockCloudFilestoreManager.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PromoteReplicaRequest actualRequest = (PromoteReplicaRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getPeerInstance(), (Object)actualRequest.getPeerInstance());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void promoteReplicaExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockCloudFilestoreManager.addException((Exception)exception);
        try {
            PromoteReplicaRequest request = PromoteReplicaRequest.newBuilder().setName(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).setPeerInstance(InstanceName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[INSTANCE]").toString()).build();
            this.client.promoteReplicaAsync(request).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

