/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1alpha.AllocationPoliciesServiceClient;
import com.google.cloud.gaming.v1alpha.AllocationPoliciesServiceSettings;
import com.google.cloud.gaming.v1alpha.AllocationPolicy;
import com.google.cloud.gaming.v1alpha.CreateAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.DeleteAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.GetAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.ListAllocationPoliciesRequest;
import com.google.cloud.gaming.v1alpha.ListAllocationPoliciesResponse;
import com.google.cloud.gaming.v1alpha.MockAllocationPoliciesService;
import com.google.cloud.gaming.v1alpha.MockGameServerClustersService;
import com.google.cloud.gaming.v1alpha.MockGameServerDeploymentsService;
import com.google.cloud.gaming.v1alpha.MockRealmsService;
import com.google.cloud.gaming.v1alpha.MockScalingPoliciesService;
import com.google.cloud.gaming.v1alpha.UpdateAllocationPolicyRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AllocationPoliciesServiceClientTest {
    private static MockAllocationPoliciesService mockAllocationPoliciesService;
    private static MockGameServerClustersService mockGameServerClustersService;
    private static MockGameServerDeploymentsService mockGameServerDeploymentsService;
    private static MockRealmsService mockRealmsService;
    private static MockScalingPoliciesService mockScalingPoliciesService;
    private static MockServiceHelper serviceHelper;
    private AllocationPoliciesServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockAllocationPoliciesService = new MockAllocationPoliciesService();
        mockGameServerClustersService = new MockGameServerClustersService();
        mockGameServerDeploymentsService = new MockGameServerDeploymentsService();
        mockRealmsService = new MockRealmsService();
        mockScalingPoliciesService = new MockScalingPoliciesService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockAllocationPoliciesService, mockGameServerClustersService, mockGameServerDeploymentsService, mockRealmsService, mockScalingPoliciesService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        AllocationPoliciesServiceSettings settings = ((AllocationPoliciesServiceSettings.Builder)((AllocationPoliciesServiceSettings.Builder)AllocationPoliciesServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = AllocationPoliciesServiceClient.create((AllocationPoliciesServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listAllocationPoliciesTest() {
        String nextPageToken = "";
        AllocationPolicy allocationPoliciesElement = AllocationPolicy.newBuilder().build();
        List<AllocationPolicy> allocationPolicies = Arrays.asList(allocationPoliciesElement);
        ListAllocationPoliciesResponse expectedResponse = ListAllocationPoliciesResponse.newBuilder().setNextPageToken(nextPageToken).addAllAllocationPolicies(allocationPolicies).build();
        mockAllocationPoliciesService.addResponse((AbstractMessage)expectedResponse);
        String formattedParent = AllocationPoliciesServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
        AllocationPoliciesServiceClient.ListAllocationPoliciesPagedResponse pagedListResponse = this.client.listAllocationPolicies(formattedParent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getAllocationPoliciesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockAllocationPoliciesService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListAllocationPoliciesRequest actualRequest = (ListAllocationPoliciesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedParent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listAllocationPoliciesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAllocationPoliciesService.addException((Exception)exception);
        try {
            String formattedParent = AllocationPoliciesServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listAllocationPolicies(formattedParent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getAllocationPolicyTest() {
        String name2 = "name2-1052831874";
        int weight = 791592328;
        AllocationPolicy expectedResponse = AllocationPolicy.newBuilder().setName(name2).setWeight(weight).build();
        mockAllocationPoliciesService.addResponse((AbstractMessage)expectedResponse);
        String formattedName = AllocationPoliciesServiceClient.formatAllocationPolicyName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ALLOCATION_POLICY]");
        AllocationPolicy actualResponse = this.client.getAllocationPolicy(formattedName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAllocationPoliciesService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetAllocationPolicyRequest actualRequest = (GetAllocationPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getAllocationPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAllocationPoliciesService.addException((Exception)exception);
        try {
            String formattedName = AllocationPoliciesServiceClient.formatAllocationPolicyName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ALLOCATION_POLICY]");
            this.client.getAllocationPolicy(formattedName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createAllocationPolicyTest() throws Exception {
        String name = "name3373707";
        int weight = 791592328;
        AllocationPolicy expectedResponse = AllocationPolicy.newBuilder().setName(name).setWeight(weight).build();
        Operation resultOperation = Operation.newBuilder().setName("createAllocationPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAllocationPoliciesService.addResponse((AbstractMessage)resultOperation);
        String formattedParent = AllocationPoliciesServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
        String allocationPolicyId = "allocationPolicyId-850912599";
        AllocationPolicy allocationPolicy = AllocationPolicy.newBuilder().build();
        AllocationPolicy actualResponse = (AllocationPolicy)this.client.createAllocationPolicyAsync(formattedParent, allocationPolicyId, allocationPolicy).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAllocationPoliciesService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateAllocationPolicyRequest actualRequest = (CreateAllocationPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedParent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)allocationPolicyId, (Object)actualRequest.getAllocationPolicyId());
        Assert.assertEquals((Object)allocationPolicy, (Object)actualRequest.getAllocationPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createAllocationPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAllocationPoliciesService.addException((Exception)exception);
        try {
            String formattedParent = AllocationPoliciesServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
            String allocationPolicyId = "allocationPolicyId-850912599";
            AllocationPolicy allocationPolicy = AllocationPolicy.newBuilder().build();
            this.client.createAllocationPolicyAsync(formattedParent, allocationPolicyId, allocationPolicy).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteAllocationPolicyTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteAllocationPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAllocationPoliciesService.addResponse((AbstractMessage)resultOperation);
        String formattedName = AllocationPoliciesServiceClient.formatAllocationPolicyName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ALLOCATION_POLICY]");
        Empty actualResponse = (Empty)this.client.deleteAllocationPolicyAsync(formattedName).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAllocationPoliciesService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteAllocationPolicyRequest actualRequest = (DeleteAllocationPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteAllocationPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAllocationPoliciesService.addException((Exception)exception);
        try {
            String formattedName = AllocationPoliciesServiceClient.formatAllocationPolicyName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[ALLOCATION_POLICY]");
            this.client.deleteAllocationPolicyAsync(formattedName).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateAllocationPolicyTest() throws Exception {
        String name = "name3373707";
        int weight = 791592328;
        AllocationPolicy expectedResponse = AllocationPolicy.newBuilder().setName(name).setWeight(weight).build();
        Operation resultOperation = Operation.newBuilder().setName("updateAllocationPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockAllocationPoliciesService.addResponse((AbstractMessage)resultOperation);
        AllocationPolicy allocationPolicy = AllocationPolicy.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        AllocationPolicy actualResponse = (AllocationPolicy)this.client.updateAllocationPolicyAsync(allocationPolicy, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockAllocationPoliciesService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateAllocationPolicyRequest actualRequest = (UpdateAllocationPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)allocationPolicy, (Object)actualRequest.getAllocationPolicy());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateAllocationPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockAllocationPoliciesService.addException((Exception)exception);
        try {
            AllocationPolicy allocationPolicy = AllocationPolicy.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateAllocationPolicyAsync(allocationPolicy, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

