/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1alpha.CreateGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.DeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.GameServerCluster;
import com.google.cloud.gaming.v1alpha.GameServerClustersServiceClient;
import com.google.cloud.gaming.v1alpha.GameServerClustersServiceSettings;
import com.google.cloud.gaming.v1alpha.GetGameServerClusterRequest;
import com.google.cloud.gaming.v1alpha.ListGameServerClustersRequest;
import com.google.cloud.gaming.v1alpha.ListGameServerClustersResponse;
import com.google.cloud.gaming.v1alpha.MockAllocationPoliciesService;
import com.google.cloud.gaming.v1alpha.MockGameServerClustersService;
import com.google.cloud.gaming.v1alpha.MockGameServerDeploymentsService;
import com.google.cloud.gaming.v1alpha.MockRealmsService;
import com.google.cloud.gaming.v1alpha.MockScalingPoliciesService;
import com.google.cloud.gaming.v1alpha.UpdateGameServerClusterRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GameServerClustersServiceClientTest {
    private static MockAllocationPoliciesService mockAllocationPoliciesService;
    private static MockGameServerClustersService mockGameServerClustersService;
    private static MockGameServerDeploymentsService mockGameServerDeploymentsService;
    private static MockRealmsService mockRealmsService;
    private static MockScalingPoliciesService mockScalingPoliciesService;
    private static MockServiceHelper serviceHelper;
    private GameServerClustersServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockAllocationPoliciesService = new MockAllocationPoliciesService();
        mockGameServerClustersService = new MockGameServerClustersService();
        mockGameServerDeploymentsService = new MockGameServerDeploymentsService();
        mockRealmsService = new MockRealmsService();
        mockScalingPoliciesService = new MockScalingPoliciesService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockAllocationPoliciesService, mockGameServerClustersService, mockGameServerDeploymentsService, mockRealmsService, mockScalingPoliciesService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        GameServerClustersServiceSettings settings = ((GameServerClustersServiceSettings.Builder)((GameServerClustersServiceSettings.Builder)GameServerClustersServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = GameServerClustersServiceClient.create((GameServerClustersServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listGameServerClustersTest() {
        String nextPageToken = "";
        GameServerCluster gameServerClustersElement = GameServerCluster.newBuilder().build();
        List<GameServerCluster> gameServerClusters = Arrays.asList(gameServerClustersElement);
        ListGameServerClustersResponse expectedResponse = ListGameServerClustersResponse.newBuilder().setNextPageToken(nextPageToken).addAllGameServerClusters(gameServerClusters).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        String formattedParent = GameServerClustersServiceClient.formatRealmName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        GameServerClustersServiceClient.ListGameServerClustersPagedResponse pagedListResponse = this.client.listGameServerClusters(formattedParent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerClustersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGameServerClustersRequest actualRequest = (ListGameServerClustersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedParent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGameServerClustersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            String formattedParent = GameServerClustersServiceClient.formatRealmName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            this.client.listGameServerClusters(formattedParent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerClusterTest() {
        String name2 = "name2-1052831874";
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(name2).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        String formattedName = GameServerClustersServiceClient.formatGameServerClusterName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[GAME_SERVER_CLUSTER]");
        GameServerCluster actualResponse = this.client.getGameServerCluster(formattedName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGameServerClusterRequest actualRequest = (GetGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            String formattedName = GameServerClustersServiceClient.formatGameServerClusterName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[GAME_SERVER_CLUSTER]");
            this.client.getGameServerCluster(formattedName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerClusterTest() throws Exception {
        String name = "name3373707";
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(name).build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        String formattedParent = GameServerClustersServiceClient.formatRealmName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        String gameServerClusterId = "gameServerClusterId-858763025";
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        GameServerCluster actualResponse = (GameServerCluster)this.client.createGameServerClusterAsync(formattedParent, gameServerClusterId, gameServerCluster).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGameServerClusterRequest actualRequest = (CreateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedParent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)gameServerClusterId, (Object)actualRequest.getGameServerClusterId());
        Assert.assertEquals((Object)gameServerCluster, (Object)actualRequest.getGameServerCluster());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            String formattedParent = GameServerClustersServiceClient.formatRealmName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            String gameServerClusterId = "gameServerClusterId-858763025";
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            this.client.createGameServerClusterAsync(formattedParent, gameServerClusterId, gameServerCluster).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteGameServerClusterTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        String formattedName = GameServerClustersServiceClient.formatGameServerClusterName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[GAME_SERVER_CLUSTER]");
        Empty actualResponse = (Empty)this.client.deleteGameServerClusterAsync(formattedName).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGameServerClusterRequest actualRequest = (DeleteGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            String formattedName = GameServerClustersServiceClient.formatGameServerClusterName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[GAME_SERVER_CLUSTER]");
            this.client.deleteGameServerClusterAsync(formattedName).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateGameServerClusterTest() throws Exception {
        String name = "name3373707";
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(name).build();
        Operation resultOperation = Operation.newBuilder().setName("updateGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        GameServerCluster actualResponse = (GameServerCluster)this.client.updateGameServerClusterAsync(gameServerCluster, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateGameServerClusterRequest actualRequest = (UpdateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)gameServerCluster, (Object)actualRequest.getGameServerCluster());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateGameServerClusterAsync(gameServerCluster, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

