/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1alpha.CommitRolloutRequest;
import com.google.cloud.gaming.v1alpha.CreateGameServerDeploymentRequest;
import com.google.cloud.gaming.v1alpha.DeleteGameServerDeploymentRequest;
import com.google.cloud.gaming.v1alpha.DeploymentTarget;
import com.google.cloud.gaming.v1alpha.GameServerDeployment;
import com.google.cloud.gaming.v1alpha.GameServerDeploymentsServiceClient;
import com.google.cloud.gaming.v1alpha.GameServerDeploymentsServiceSettings;
import com.google.cloud.gaming.v1alpha.GameServerTemplate;
import com.google.cloud.gaming.v1alpha.GetDeploymentTargetRequest;
import com.google.cloud.gaming.v1alpha.GetGameServerDeploymentRequest;
import com.google.cloud.gaming.v1alpha.ListGameServerDeploymentsRequest;
import com.google.cloud.gaming.v1alpha.ListGameServerDeploymentsResponse;
import com.google.cloud.gaming.v1alpha.MockAllocationPoliciesService;
import com.google.cloud.gaming.v1alpha.MockGameServerClustersService;
import com.google.cloud.gaming.v1alpha.MockGameServerDeploymentsService;
import com.google.cloud.gaming.v1alpha.MockRealmsService;
import com.google.cloud.gaming.v1alpha.MockScalingPoliciesService;
import com.google.cloud.gaming.v1alpha.RevertRolloutRequest;
import com.google.cloud.gaming.v1alpha.SetRolloutTargetRequest;
import com.google.cloud.gaming.v1alpha.StartRolloutRequest;
import com.google.cloud.gaming.v1alpha.UpdateGameServerDeploymentRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GameServerDeploymentsServiceClientTest {
    private static MockAllocationPoliciesService mockAllocationPoliciesService;
    private static MockGameServerClustersService mockGameServerClustersService;
    private static MockGameServerDeploymentsService mockGameServerDeploymentsService;
    private static MockRealmsService mockRealmsService;
    private static MockScalingPoliciesService mockScalingPoliciesService;
    private static MockServiceHelper serviceHelper;
    private GameServerDeploymentsServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockAllocationPoliciesService = new MockAllocationPoliciesService();
        mockGameServerClustersService = new MockGameServerClustersService();
        mockGameServerDeploymentsService = new MockGameServerDeploymentsService();
        mockRealmsService = new MockRealmsService();
        mockScalingPoliciesService = new MockScalingPoliciesService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockAllocationPoliciesService, mockGameServerClustersService, mockGameServerDeploymentsService, mockRealmsService, mockScalingPoliciesService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        GameServerDeploymentsServiceSettings settings = ((GameServerDeploymentsServiceSettings.Builder)((GameServerDeploymentsServiceSettings.Builder)GameServerDeploymentsServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = GameServerDeploymentsServiceClient.create((GameServerDeploymentsServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listGameServerDeploymentsTest() {
        String nextPageToken = "";
        GameServerDeployment gameServerDeploymentsElement = GameServerDeployment.newBuilder().build();
        List<GameServerDeployment> gameServerDeployments = Arrays.asList(gameServerDeploymentsElement);
        ListGameServerDeploymentsResponse expectedResponse = ListGameServerDeploymentsResponse.newBuilder().setNextPageToken(nextPageToken).addAllGameServerDeployments(gameServerDeployments).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)expectedResponse);
        String formattedParent = GameServerDeploymentsServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
        GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse pagedListResponse = this.client.listGameServerDeployments(formattedParent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerDeploymentsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGameServerDeploymentsRequest actualRequest = (ListGameServerDeploymentsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedParent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGameServerDeploymentsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            String formattedParent = GameServerDeploymentsServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listGameServerDeployments(formattedParent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerDeploymentTest() {
        String name2 = "name2-1052831874";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name2).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)expectedResponse);
        String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
        GameServerDeployment actualResponse = this.client.getGameServerDeployment(formattedName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGameServerDeploymentRequest actualRequest = (GetGameServerDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGameServerDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
            this.client.getGameServerDeployment(formattedName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerDeploymentTest() throws Exception {
        String name = "name3373707";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name).build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        String formattedParent = GameServerDeploymentsServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
        String deploymentId = "deploymentId51250389";
        GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
        GameServerDeployment actualResponse = (GameServerDeployment)this.client.createGameServerDeploymentAsync(formattedParent, deploymentId, gameServerDeployment).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGameServerDeploymentRequest actualRequest = (CreateGameServerDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedParent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)deploymentId, (Object)actualRequest.getDeploymentId());
        Assert.assertEquals((Object)gameServerDeployment, (Object)actualRequest.getGameServerDeployment());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGameServerDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            String formattedParent = GameServerDeploymentsServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
            String deploymentId = "deploymentId51250389";
            GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
            this.client.createGameServerDeploymentAsync(formattedParent, deploymentId, gameServerDeployment).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteGameServerDeploymentTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
        Empty actualResponse = (Empty)this.client.deleteGameServerDeploymentAsync(formattedName).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGameServerDeploymentRequest actualRequest = (DeleteGameServerDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGameServerDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
            this.client.deleteGameServerDeploymentAsync(formattedName).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateGameServerDeploymentTest() throws Exception {
        String name = "name3373707";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name).build();
        Operation resultOperation = Operation.newBuilder().setName("updateGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        GameServerDeployment actualResponse = (GameServerDeployment)this.client.updateGameServerDeploymentAsync(gameServerDeployment, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateGameServerDeploymentRequest actualRequest = (UpdateGameServerDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)gameServerDeployment, (Object)actualRequest.getGameServerDeployment());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateGameServerDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateGameServerDeploymentAsync(gameServerDeployment, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void startRolloutTest() throws Exception {
        String name2 = "name2-1052831874";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name2).build();
        Operation resultOperation = Operation.newBuilder().setName("startRolloutTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
        GameServerTemplate newGameServerTemplate = GameServerTemplate.newBuilder().build();
        GameServerDeployment actualResponse = (GameServerDeployment)this.client.startRolloutAsync(formattedName, newGameServerTemplate).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        StartRolloutRequest actualRequest = (StartRolloutRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertEquals((Object)newGameServerTemplate, (Object)actualRequest.getNewGameServerTemplate());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void startRolloutExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
            GameServerTemplate newGameServerTemplate = GameServerTemplate.newBuilder().build();
            this.client.startRolloutAsync(formattedName, newGameServerTemplate).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void setRolloutTargetTest() throws Exception {
        String name2 = "name2-1052831874";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name2).build();
        Operation resultOperation = Operation.newBuilder().setName("setRolloutTargetTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
        ArrayList clusterPercentageSelector = new ArrayList();
        GameServerDeployment actualResponse = (GameServerDeployment)this.client.setRolloutTargetAsync(formattedName, clusterPercentageSelector).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        SetRolloutTargetRequest actualRequest = (SetRolloutTargetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertEquals(clusterPercentageSelector, (Object)actualRequest.getClusterPercentageSelectorList());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void setRolloutTargetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
            ArrayList clusterPercentageSelector = new ArrayList();
            this.client.setRolloutTargetAsync(formattedName, clusterPercentageSelector).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void commitRolloutTest() throws Exception {
        String name2 = "name2-1052831874";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name2).build();
        Operation resultOperation = Operation.newBuilder().setName("commitRolloutTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
        GameServerDeployment actualResponse = (GameServerDeployment)this.client.commitRolloutAsync(formattedName).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CommitRolloutRequest actualRequest = (CommitRolloutRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void commitRolloutExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
            this.client.commitRolloutAsync(formattedName).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void revertRolloutTest() throws Exception {
        String name2 = "name2-1052831874";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name2).build();
        Operation resultOperation = Operation.newBuilder().setName("revertRolloutTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
        GameServerDeployment actualResponse = (GameServerDeployment)this.client.revertRolloutAsync(formattedName).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        RevertRolloutRequest actualRequest = (RevertRolloutRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void revertRolloutExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
            this.client.revertRolloutAsync(formattedName).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getDeploymentTargetTest() {
        DeploymentTarget expectedResponse = DeploymentTarget.newBuilder().build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)expectedResponse);
        String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
        DeploymentTarget actualResponse = this.client.getDeploymentTarget(formattedName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetDeploymentTargetRequest actualRequest = (GetDeploymentTargetRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getDeploymentTargetExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            String formattedName = GameServerDeploymentsServiceClient.formatGameServerDeploymentName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[GAME_SERVER_DEPLOYMENT]");
            this.client.getDeploymentTarget(formattedName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

