/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1alpha.CreateRealmRequest;
import com.google.cloud.gaming.v1alpha.DeleteRealmRequest;
import com.google.cloud.gaming.v1alpha.GetRealmRequest;
import com.google.cloud.gaming.v1alpha.ListRealmsRequest;
import com.google.cloud.gaming.v1alpha.ListRealmsResponse;
import com.google.cloud.gaming.v1alpha.MockAllocationPoliciesService;
import com.google.cloud.gaming.v1alpha.MockGameServerClustersService;
import com.google.cloud.gaming.v1alpha.MockGameServerDeploymentsService;
import com.google.cloud.gaming.v1alpha.MockRealmsService;
import com.google.cloud.gaming.v1alpha.MockScalingPoliciesService;
import com.google.cloud.gaming.v1alpha.Realm;
import com.google.cloud.gaming.v1alpha.RealmsServiceClient;
import com.google.cloud.gaming.v1alpha.RealmsServiceSettings;
import com.google.cloud.gaming.v1alpha.UpdateRealmRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RealmsServiceClientTest {
    private static MockAllocationPoliciesService mockAllocationPoliciesService;
    private static MockGameServerClustersService mockGameServerClustersService;
    private static MockGameServerDeploymentsService mockGameServerDeploymentsService;
    private static MockRealmsService mockRealmsService;
    private static MockScalingPoliciesService mockScalingPoliciesService;
    private static MockServiceHelper serviceHelper;
    private RealmsServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockAllocationPoliciesService = new MockAllocationPoliciesService();
        mockGameServerClustersService = new MockGameServerClustersService();
        mockGameServerDeploymentsService = new MockGameServerDeploymentsService();
        mockRealmsService = new MockRealmsService();
        mockScalingPoliciesService = new MockScalingPoliciesService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockAllocationPoliciesService, mockGameServerClustersService, mockGameServerDeploymentsService, mockRealmsService, mockScalingPoliciesService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        RealmsServiceSettings settings = ((RealmsServiceSettings.Builder)((RealmsServiceSettings.Builder)RealmsServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = RealmsServiceClient.create((RealmsServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listRealmsTest() {
        String nextPageToken = "";
        Realm realmsElement = Realm.newBuilder().build();
        List<Realm> realms = Arrays.asList(realmsElement);
        ListRealmsResponse expectedResponse = ListRealmsResponse.newBuilder().setNextPageToken(nextPageToken).addAllRealms(realms).build();
        mockRealmsService.addResponse((AbstractMessage)expectedResponse);
        String formattedParent = RealmsServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
        RealmsServiceClient.ListRealmsPagedResponse pagedListResponse = this.client.listRealms(formattedParent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRealmsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRealmsRequest actualRequest = (ListRealmsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedParent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRealmsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            String formattedParent = RealmsServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listRealms(formattedParent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRealmTest() {
        String name2 = "name2-1052831874";
        String timeZone = "timeZone36848094";
        Realm expectedResponse = Realm.newBuilder().setName(name2).setTimeZone(timeZone).build();
        mockRealmsService.addResponse((AbstractMessage)expectedResponse);
        String formattedName = RealmsServiceClient.formatRealmName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        Realm actualResponse = this.client.getRealm(formattedName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRealmRequest actualRequest = (GetRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            String formattedName = RealmsServiceClient.formatRealmName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            this.client.getRealm(formattedName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createRealmTest() throws Exception {
        String name = "name3373707";
        String timeZone = "timeZone36848094";
        Realm expectedResponse = Realm.newBuilder().setName(name).setTimeZone(timeZone).build();
        Operation resultOperation = Operation.newBuilder().setName("createRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        String formattedParent = RealmsServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
        String realmId = "realmId-859416373";
        Realm realm = Realm.newBuilder().build();
        Realm actualResponse = (Realm)this.client.createRealmAsync(formattedParent, realmId, realm).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateRealmRequest actualRequest = (CreateRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedParent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)realmId, (Object)actualRequest.getRealmId());
        Assert.assertEquals((Object)realm, (Object)actualRequest.getRealm());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            String formattedParent = RealmsServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
            String realmId = "realmId-859416373";
            Realm realm = Realm.newBuilder().build();
            this.client.createRealmAsync(formattedParent, realmId, realm).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteRealmTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        String formattedName = RealmsServiceClient.formatRealmName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        Empty actualResponse = (Empty)this.client.deleteRealmAsync(formattedName).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteRealmRequest actualRequest = (DeleteRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            String formattedName = RealmsServiceClient.formatRealmName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            this.client.deleteRealmAsync(formattedName).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateRealmTest() throws Exception {
        String name = "name3373707";
        String timeZone = "timeZone36848094";
        Realm expectedResponse = Realm.newBuilder().setName(name).setTimeZone(timeZone).build();
        Operation resultOperation = Operation.newBuilder().setName("updateRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        Realm realm = Realm.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Realm actualResponse = (Realm)this.client.updateRealmAsync(realm, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateRealmRequest actualRequest = (UpdateRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)realm, (Object)actualRequest.getRealm());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            Realm realm = Realm.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateRealmAsync(realm, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

