/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1alpha.CreateScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.DeleteScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.GetScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.ListScalingPoliciesRequest;
import com.google.cloud.gaming.v1alpha.ListScalingPoliciesResponse;
import com.google.cloud.gaming.v1alpha.MockAllocationPoliciesService;
import com.google.cloud.gaming.v1alpha.MockGameServerClustersService;
import com.google.cloud.gaming.v1alpha.MockGameServerDeploymentsService;
import com.google.cloud.gaming.v1alpha.MockRealmsService;
import com.google.cloud.gaming.v1alpha.MockScalingPoliciesService;
import com.google.cloud.gaming.v1alpha.ScalingPoliciesServiceClient;
import com.google.cloud.gaming.v1alpha.ScalingPoliciesServiceSettings;
import com.google.cloud.gaming.v1alpha.ScalingPolicy;
import com.google.cloud.gaming.v1alpha.UpdateScalingPolicyRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class ScalingPoliciesServiceClientTest {
    private static MockAllocationPoliciesService mockAllocationPoliciesService;
    private static MockGameServerClustersService mockGameServerClustersService;
    private static MockGameServerDeploymentsService mockGameServerDeploymentsService;
    private static MockRealmsService mockRealmsService;
    private static MockScalingPoliciesService mockScalingPoliciesService;
    private static MockServiceHelper serviceHelper;
    private ScalingPoliciesServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockAllocationPoliciesService = new MockAllocationPoliciesService();
        mockGameServerClustersService = new MockGameServerClustersService();
        mockGameServerDeploymentsService = new MockGameServerDeploymentsService();
        mockRealmsService = new MockRealmsService();
        mockScalingPoliciesService = new MockScalingPoliciesService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockAllocationPoliciesService, mockGameServerClustersService, mockGameServerDeploymentsService, mockRealmsService, mockScalingPoliciesService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        ScalingPoliciesServiceSettings settings = ((ScalingPoliciesServiceSettings.Builder)((ScalingPoliciesServiceSettings.Builder)ScalingPoliciesServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = ScalingPoliciesServiceClient.create((ScalingPoliciesServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listScalingPoliciesTest() {
        String nextPageToken = "";
        ScalingPolicy scalingPoliciesElement = ScalingPolicy.newBuilder().build();
        List<ScalingPolicy> scalingPolicies = Arrays.asList(scalingPoliciesElement);
        ListScalingPoliciesResponse expectedResponse = ListScalingPoliciesResponse.newBuilder().setNextPageToken(nextPageToken).addAllScalingPolicies(scalingPolicies).build();
        mockScalingPoliciesService.addResponse((AbstractMessage)expectedResponse);
        String formattedParent = ScalingPoliciesServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
        ScalingPoliciesServiceClient.ListScalingPoliciesPagedResponse pagedListResponse = this.client.listScalingPolicies(formattedParent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getScalingPoliciesList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockScalingPoliciesService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListScalingPoliciesRequest actualRequest = (ListScalingPoliciesRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedParent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listScalingPoliciesExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockScalingPoliciesService.addException((Exception)exception);
        try {
            String formattedParent = ScalingPoliciesServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listScalingPolicies(formattedParent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getScalingPolicyTest() {
        String name2 = "name2-1052831874";
        String gameServerDeployment = "gameServerDeployment840476212";
        ScalingPolicy expectedResponse = ScalingPolicy.newBuilder().setName(name2).setGameServerDeployment(gameServerDeployment).build();
        mockScalingPoliciesService.addResponse((AbstractMessage)expectedResponse);
        String formattedName = ScalingPoliciesServiceClient.formatScalingPolicyName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SCALING_POLICY]");
        ScalingPolicy actualResponse = this.client.getScalingPolicy(formattedName);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockScalingPoliciesService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetScalingPolicyRequest actualRequest = (GetScalingPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getScalingPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockScalingPoliciesService.addException((Exception)exception);
        try {
            String formattedName = ScalingPoliciesServiceClient.formatScalingPolicyName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SCALING_POLICY]");
            this.client.getScalingPolicy(formattedName);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createScalingPolicyTest() throws Exception {
        String name = "name3373707";
        String gameServerDeployment = "gameServerDeployment840476212";
        ScalingPolicy expectedResponse = ScalingPolicy.newBuilder().setName(name).setGameServerDeployment(gameServerDeployment).build();
        Operation resultOperation = Operation.newBuilder().setName("createScalingPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockScalingPoliciesService.addResponse((AbstractMessage)resultOperation);
        String formattedParent = ScalingPoliciesServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
        String scalingPolicyId = "scalingPolicyId1901060240";
        ScalingPolicy scalingPolicy = ScalingPolicy.newBuilder().build();
        ScalingPolicy actualResponse = (ScalingPolicy)this.client.createScalingPolicyAsync(formattedParent, scalingPolicyId, scalingPolicy).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockScalingPoliciesService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateScalingPolicyRequest actualRequest = (CreateScalingPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedParent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)scalingPolicyId, (Object)actualRequest.getScalingPolicyId());
        Assert.assertEquals((Object)scalingPolicy, (Object)actualRequest.getScalingPolicy());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createScalingPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockScalingPoliciesService.addException((Exception)exception);
        try {
            String formattedParent = ScalingPoliciesServiceClient.formatLocationName((String)"[PROJECT]", (String)"[LOCATION]");
            String scalingPolicyId = "scalingPolicyId1901060240";
            ScalingPolicy scalingPolicy = ScalingPolicy.newBuilder().build();
            this.client.createScalingPolicyAsync(formattedParent, scalingPolicyId, scalingPolicy).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteScalingPolicyTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteScalingPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockScalingPoliciesService.addResponse((AbstractMessage)resultOperation);
        String formattedName = ScalingPoliciesServiceClient.formatScalingPolicyName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SCALING_POLICY]");
        Empty actualResponse = (Empty)this.client.deleteScalingPolicyAsync(formattedName).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockScalingPoliciesService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteScalingPolicyRequest actualRequest = (DeleteScalingPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)formattedName, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteScalingPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockScalingPoliciesService.addException((Exception)exception);
        try {
            String formattedName = ScalingPoliciesServiceClient.formatScalingPolicyName((String)"[PROJECT]", (String)"[LOCATION]", (String)"[SCALING_POLICY]");
            this.client.deleteScalingPolicyAsync(formattedName).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateScalingPolicyTest() throws Exception {
        String name = "name3373707";
        String gameServerDeployment = "gameServerDeployment840476212";
        ScalingPolicy expectedResponse = ScalingPolicy.newBuilder().setName(name).setGameServerDeployment(gameServerDeployment).build();
        Operation resultOperation = Operation.newBuilder().setName("updateScalingPolicyTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockScalingPoliciesService.addResponse((AbstractMessage)resultOperation);
        ScalingPolicy scalingPolicy = ScalingPolicy.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        ScalingPolicy actualResponse = (ScalingPolicy)this.client.updateScalingPolicyAsync(scalingPolicy, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockScalingPoliciesService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateScalingPolicyRequest actualRequest = (UpdateScalingPolicyRequest)actualRequests.get(0);
        Assert.assertEquals((Object)scalingPolicy, (Object)actualRequest.getScalingPolicy());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateScalingPolicyExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockScalingPoliciesService.addException((Exception)exception);
        try {
            ScalingPolicy scalingPolicy = ScalingPolicy.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateScalingPolicyAsync(scalingPolicy, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

