/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.gaming.v1alpha.AllocationPoliciesServiceSettings;
import com.google.cloud.gaming.v1alpha.AllocationPolicy;
import com.google.cloud.gaming.v1alpha.CreateAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.DeleteAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.GetAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.ListAllocationPoliciesRequest;
import com.google.cloud.gaming.v1alpha.ListAllocationPoliciesResponse;
import com.google.cloud.gaming.v1alpha.UpdateAllocationPolicyRequest;
import com.google.cloud.gaming.v1alpha.stub.AllocationPoliciesServiceStub;
import com.google.cloud.gaming.v1alpha.stub.AllocationPoliciesServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AllocationPoliciesServiceClient
implements BackgroundResource {
    private final AllocationPoliciesServiceSettings settings;
    private final AllocationPoliciesServiceStub stub;
    private final OperationsClient operationsClient;
    private static final PathTemplate ALLOCATION_POLICY_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/allocationPolicies/{allocation_policy}");
    private static final PathTemplate LOCATION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");

    @Deprecated
    public static final String formatAllocationPolicyName(String project, String location, String allocationPolicy) {
        return ALLOCATION_POLICY_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "allocation_policy", allocationPolicy});
    }

    @Deprecated
    public static final String formatLocationName(String project, String location) {
        return LOCATION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location});
    }

    @Deprecated
    public static final String parseProjectFromAllocationPolicyName(String allocationPolicyName) {
        return ALLOCATION_POLICY_PATH_TEMPLATE.parse(allocationPolicyName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromAllocationPolicyName(String allocationPolicyName) {
        return ALLOCATION_POLICY_PATH_TEMPLATE.parse(allocationPolicyName).get((Object)"location");
    }

    @Deprecated
    public static final String parseAllocationPolicyFromAllocationPolicyName(String allocationPolicyName) {
        return ALLOCATION_POLICY_PATH_TEMPLATE.parse(allocationPolicyName).get((Object)"allocation_policy");
    }

    @Deprecated
    public static final String parseProjectFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"location");
    }

    public static final AllocationPoliciesServiceClient create() throws IOException {
        return AllocationPoliciesServiceClient.create(AllocationPoliciesServiceSettings.newBuilder().build());
    }

    public static final AllocationPoliciesServiceClient create(AllocationPoliciesServiceSettings settings) throws IOException {
        return new AllocationPoliciesServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AllocationPoliciesServiceClient create(AllocationPoliciesServiceStub stub) {
        return new AllocationPoliciesServiceClient(stub);
    }

    protected AllocationPoliciesServiceClient(AllocationPoliciesServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AllocationPoliciesServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AllocationPoliciesServiceClient(AllocationPoliciesServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AllocationPoliciesServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AllocationPoliciesServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListAllocationPoliciesPagedResponse listAllocationPolicies(String parent) {
        LOCATION_PATH_TEMPLATE.validate(parent, "listAllocationPolicies");
        ListAllocationPoliciesRequest request = ListAllocationPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listAllocationPolicies(request);
    }

    public final ListAllocationPoliciesPagedResponse listAllocationPolicies(ListAllocationPoliciesRequest request) {
        return (ListAllocationPoliciesPagedResponse)((Object)this.listAllocationPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAllocationPoliciesRequest, ListAllocationPoliciesPagedResponse> listAllocationPoliciesPagedCallable() {
        return this.stub.listAllocationPoliciesPagedCallable();
    }

    public final UnaryCallable<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse> listAllocationPoliciesCallable() {
        return this.stub.listAllocationPoliciesCallable();
    }

    public final AllocationPolicy getAllocationPolicy(String name) {
        ALLOCATION_POLICY_PATH_TEMPLATE.validate(name, "getAllocationPolicy");
        GetAllocationPolicyRequest request = GetAllocationPolicyRequest.newBuilder().setName(name).build();
        return this.getAllocationPolicy(request);
    }

    public final AllocationPolicy getAllocationPolicy(GetAllocationPolicyRequest request) {
        return (AllocationPolicy)this.getAllocationPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetAllocationPolicyRequest, AllocationPolicy> getAllocationPolicyCallable() {
        return this.stub.getAllocationPolicyCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<AllocationPolicy, Empty> createAllocationPolicyAsync(String parent, String allocationPolicyId, AllocationPolicy allocationPolicy) {
        LOCATION_PATH_TEMPLATE.validate(parent, "createAllocationPolicy");
        CreateAllocationPolicyRequest request = CreateAllocationPolicyRequest.newBuilder().setParent(parent).setAllocationPolicyId(allocationPolicyId).setAllocationPolicy(allocationPolicy).build();
        return this.createAllocationPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<AllocationPolicy, Empty> createAllocationPolicyAsync(CreateAllocationPolicyRequest request) {
        return this.createAllocationPolicyOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateAllocationPolicyRequest, AllocationPolicy, Empty> createAllocationPolicyOperationCallable() {
        return this.stub.createAllocationPolicyOperationCallable();
    }

    public final UnaryCallable<CreateAllocationPolicyRequest, Operation> createAllocationPolicyCallable() {
        return this.stub.createAllocationPolicyCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> deleteAllocationPolicyAsync(String name) {
        ALLOCATION_POLICY_PATH_TEMPLATE.validate(name, "deleteAllocationPolicy");
        DeleteAllocationPolicyRequest request = DeleteAllocationPolicyRequest.newBuilder().setName(name).build();
        return this.deleteAllocationPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> deleteAllocationPolicyAsync(DeleteAllocationPolicyRequest request) {
        return this.deleteAllocationPolicyOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteAllocationPolicyRequest, Empty, Empty> deleteAllocationPolicyOperationCallable() {
        return this.stub.deleteAllocationPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteAllocationPolicyRequest, Operation> deleteAllocationPolicyCallable() {
        return this.stub.deleteAllocationPolicyCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<AllocationPolicy, Empty> updateAllocationPolicyAsync(AllocationPolicy allocationPolicy, FieldMask updateMask) {
        UpdateAllocationPolicyRequest request = UpdateAllocationPolicyRequest.newBuilder().setAllocationPolicy(allocationPolicy).setUpdateMask(updateMask).build();
        return this.updateAllocationPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<AllocationPolicy, Empty> updateAllocationPolicyAsync(UpdateAllocationPolicyRequest request) {
        return this.updateAllocationPolicyOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateAllocationPolicyRequest, AllocationPolicy, Empty> updateAllocationPolicyOperationCallable() {
        return this.stub.updateAllocationPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateAllocationPolicyRequest, Operation> updateAllocationPolicyCallable() {
        return this.stub.updateAllocationPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAllocationPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPolicy, ListAllocationPoliciesPage, ListAllocationPoliciesFixedSizeCollection> {
        private ListAllocationPoliciesFixedSizeCollection(List<ListAllocationPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAllocationPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListAllocationPoliciesFixedSizeCollection(null, 0);
        }

        protected ListAllocationPoliciesFixedSizeCollection createCollection(List<ListAllocationPoliciesPage> pages, int collectionSize) {
            return new ListAllocationPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAllocationPoliciesPage
    extends AbstractPage<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPolicy, ListAllocationPoliciesPage> {
        private ListAllocationPoliciesPage(PageContext<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPolicy> context, ListAllocationPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListAllocationPoliciesPage createEmptyPage() {
            return new ListAllocationPoliciesPage(null, null);
        }

        protected ListAllocationPoliciesPage createPage(PageContext<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPolicy> context, ListAllocationPoliciesResponse response) {
            return new ListAllocationPoliciesPage(context, response);
        }

        public ApiFuture<ListAllocationPoliciesPage> createPageAsync(PageContext<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPolicy> context, ApiFuture<ListAllocationPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAllocationPoliciesPagedResponse
    extends AbstractPagedListResponse<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPolicy, ListAllocationPoliciesPage, ListAllocationPoliciesFixedSizeCollection> {
        public static ApiFuture<ListAllocationPoliciesPagedResponse> createAsync(PageContext<ListAllocationPoliciesRequest, ListAllocationPoliciesResponse, AllocationPolicy> context, ApiFuture<ListAllocationPoliciesResponse> futureResponse) {
            ApiFuture<ListAllocationPoliciesPage> futurePage = ListAllocationPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListAllocationPoliciesPage, ListAllocationPoliciesPagedResponse>(){

                public ListAllocationPoliciesPagedResponse apply(ListAllocationPoliciesPage input) {
                    return new ListAllocationPoliciesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListAllocationPoliciesPagedResponse(ListAllocationPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAllocationPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

