/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1alpha;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.gaming.v1alpha.CreateScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.DeleteScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.GetScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.ListScalingPoliciesRequest;
import com.google.cloud.gaming.v1alpha.ListScalingPoliciesResponse;
import com.google.cloud.gaming.v1alpha.ScalingPoliciesServiceSettings;
import com.google.cloud.gaming.v1alpha.ScalingPolicy;
import com.google.cloud.gaming.v1alpha.UpdateScalingPolicyRequest;
import com.google.cloud.gaming.v1alpha.stub.ScalingPoliciesServiceStub;
import com.google.cloud.gaming.v1alpha.stub.ScalingPoliciesServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ScalingPoliciesServiceClient
implements BackgroundResource {
    private final ScalingPoliciesServiceSettings settings;
    private final ScalingPoliciesServiceStub stub;
    private final OperationsClient operationsClient;
    private static final PathTemplate LOCATION_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");
    private static final PathTemplate SCALING_POLICY_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/scalingPolicies/{scaling_policy}");

    @Deprecated
    public static final String formatLocationName(String project, String location) {
        return LOCATION_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location});
    }

    @Deprecated
    public static final String formatScalingPolicyName(String project, String location, String scalingPolicy) {
        return SCALING_POLICY_PATH_TEMPLATE.instantiate(new String[]{"project", project, "location", location, "scaling_policy", scalingPolicy});
    }

    @Deprecated
    public static final String parseProjectFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromLocationName(String locationName) {
        return LOCATION_PATH_TEMPLATE.parse(locationName).get((Object)"location");
    }

    @Deprecated
    public static final String parseProjectFromScalingPolicyName(String scalingPolicyName) {
        return SCALING_POLICY_PATH_TEMPLATE.parse(scalingPolicyName).get((Object)"project");
    }

    @Deprecated
    public static final String parseLocationFromScalingPolicyName(String scalingPolicyName) {
        return SCALING_POLICY_PATH_TEMPLATE.parse(scalingPolicyName).get((Object)"location");
    }

    @Deprecated
    public static final String parseScalingPolicyFromScalingPolicyName(String scalingPolicyName) {
        return SCALING_POLICY_PATH_TEMPLATE.parse(scalingPolicyName).get((Object)"scaling_policy");
    }

    public static final ScalingPoliciesServiceClient create() throws IOException {
        return ScalingPoliciesServiceClient.create(ScalingPoliciesServiceSettings.newBuilder().build());
    }

    public static final ScalingPoliciesServiceClient create(ScalingPoliciesServiceSettings settings) throws IOException {
        return new ScalingPoliciesServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ScalingPoliciesServiceClient create(ScalingPoliciesServiceStub stub) {
        return new ScalingPoliciesServiceClient(stub);
    }

    protected ScalingPoliciesServiceClient(ScalingPoliciesServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ScalingPoliciesServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ScalingPoliciesServiceClient(ScalingPoliciesServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ScalingPoliciesServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ScalingPoliciesServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListScalingPoliciesPagedResponse listScalingPolicies(String parent) {
        LOCATION_PATH_TEMPLATE.validate(parent, "listScalingPolicies");
        ListScalingPoliciesRequest request = ListScalingPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listScalingPolicies(request);
    }

    public final ListScalingPoliciesPagedResponse listScalingPolicies(ListScalingPoliciesRequest request) {
        return (ListScalingPoliciesPagedResponse)((Object)this.listScalingPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListScalingPoliciesRequest, ListScalingPoliciesPagedResponse> listScalingPoliciesPagedCallable() {
        return this.stub.listScalingPoliciesPagedCallable();
    }

    public final UnaryCallable<ListScalingPoliciesRequest, ListScalingPoliciesResponse> listScalingPoliciesCallable() {
        return this.stub.listScalingPoliciesCallable();
    }

    public final ScalingPolicy getScalingPolicy(String name) {
        SCALING_POLICY_PATH_TEMPLATE.validate(name, "getScalingPolicy");
        GetScalingPolicyRequest request = GetScalingPolicyRequest.newBuilder().setName(name).build();
        return this.getScalingPolicy(request);
    }

    public final ScalingPolicy getScalingPolicy(GetScalingPolicyRequest request) {
        return (ScalingPolicy)this.getScalingPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetScalingPolicyRequest, ScalingPolicy> getScalingPolicyCallable() {
        return this.stub.getScalingPolicyCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ScalingPolicy, Empty> createScalingPolicyAsync(String parent, String scalingPolicyId, ScalingPolicy scalingPolicy) {
        LOCATION_PATH_TEMPLATE.validate(parent, "createScalingPolicy");
        CreateScalingPolicyRequest request = CreateScalingPolicyRequest.newBuilder().setParent(parent).setScalingPolicyId(scalingPolicyId).setScalingPolicy(scalingPolicy).build();
        return this.createScalingPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ScalingPolicy, Empty> createScalingPolicyAsync(CreateScalingPolicyRequest request) {
        return this.createScalingPolicyOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateScalingPolicyRequest, ScalingPolicy, Empty> createScalingPolicyOperationCallable() {
        return this.stub.createScalingPolicyOperationCallable();
    }

    public final UnaryCallable<CreateScalingPolicyRequest, Operation> createScalingPolicyCallable() {
        return this.stub.createScalingPolicyCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> deleteScalingPolicyAsync(String name) {
        SCALING_POLICY_PATH_TEMPLATE.validate(name, "deleteScalingPolicy");
        DeleteScalingPolicyRequest request = DeleteScalingPolicyRequest.newBuilder().setName(name).build();
        return this.deleteScalingPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> deleteScalingPolicyAsync(DeleteScalingPolicyRequest request) {
        return this.deleteScalingPolicyOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteScalingPolicyRequest, Empty, Empty> deleteScalingPolicyOperationCallable() {
        return this.stub.deleteScalingPolicyOperationCallable();
    }

    public final UnaryCallable<DeleteScalingPolicyRequest, Operation> deleteScalingPolicyCallable() {
        return this.stub.deleteScalingPolicyCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ScalingPolicy, Empty> updateScalingPolicyAsync(ScalingPolicy scalingPolicy, FieldMask updateMask) {
        UpdateScalingPolicyRequest request = UpdateScalingPolicyRequest.newBuilder().setScalingPolicy(scalingPolicy).setUpdateMask(updateMask).build();
        return this.updateScalingPolicyAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<ScalingPolicy, Empty> updateScalingPolicyAsync(UpdateScalingPolicyRequest request) {
        return this.updateScalingPolicyOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateScalingPolicyRequest, ScalingPolicy, Empty> updateScalingPolicyOperationCallable() {
        return this.stub.updateScalingPolicyOperationCallable();
    }

    public final UnaryCallable<UpdateScalingPolicyRequest, Operation> updateScalingPolicyCallable() {
        return this.stub.updateScalingPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListScalingPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPolicy, ListScalingPoliciesPage, ListScalingPoliciesFixedSizeCollection> {
        private ListScalingPoliciesFixedSizeCollection(List<ListScalingPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListScalingPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListScalingPoliciesFixedSizeCollection(null, 0);
        }

        protected ListScalingPoliciesFixedSizeCollection createCollection(List<ListScalingPoliciesPage> pages, int collectionSize) {
            return new ListScalingPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListScalingPoliciesPage
    extends AbstractPage<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPolicy, ListScalingPoliciesPage> {
        private ListScalingPoliciesPage(PageContext<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPolicy> context, ListScalingPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListScalingPoliciesPage createEmptyPage() {
            return new ListScalingPoliciesPage(null, null);
        }

        protected ListScalingPoliciesPage createPage(PageContext<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPolicy> context, ListScalingPoliciesResponse response) {
            return new ListScalingPoliciesPage(context, response);
        }

        public ApiFuture<ListScalingPoliciesPage> createPageAsync(PageContext<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPolicy> context, ApiFuture<ListScalingPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListScalingPoliciesPagedResponse
    extends AbstractPagedListResponse<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPolicy, ListScalingPoliciesPage, ListScalingPoliciesFixedSizeCollection> {
        public static ApiFuture<ListScalingPoliciesPagedResponse> createAsync(PageContext<ListScalingPoliciesRequest, ListScalingPoliciesResponse, ScalingPolicy> context, ApiFuture<ListScalingPoliciesResponse> futureResponse) {
            ApiFuture<ListScalingPoliciesPage> futurePage = ListScalingPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListScalingPoliciesPage, ListScalingPoliciesPagedResponse>(){

                public ListScalingPoliciesPagedResponse apply(ListScalingPoliciesPage input) {
                    return new ListScalingPoliciesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListScalingPoliciesPagedResponse(ListScalingPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListScalingPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

